/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import java.util.List;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.XPathParts;

public class CheckAltOnly
extends FactoryCheckCLDR {
    private static final String message = "A path with alt is present but the corresponding path without alt is missing; a solution might be to confirm the non-alt path";

    public CheckAltOnly(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (path == null || fullPath == null || path.indexOf("[@alt=") <= 0) {
            return this;
        }
        CLDRFile file = this.getCldrFileToCheck();
        String localeId = file.getLocaleID();
        if ("root".equals(localeId)) {
            return this;
        }
        if (!file.isHere(path)) {
            return this;
        }
        String nonAltPath = XPathParts.getPathWithoutAlt(path);
        if (file.isHere(nonAltPath)) {
            return this;
        }
        if (file.getConstructedValue(nonAltPath) != null) {
            return this;
        }
        String sourceLocaleId = file.getSourceLocaleIdExtended(nonAltPath, null, false);
        if (!"code-fallback".equals(sourceLocaleId)) {
            return this;
        }
        if (path.startsWith("//ldml/numbers/currencies/currency")) {
            CLDRFile rootCldrFile = this.getFactory().make("root", true);
            if (value != null && value.equals(rootCldrFile.getStringValue(path))) {
                return this;
            }
        }
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingNonAltPath).setMessage(message);
        result.add(item);
        return this;
    }
}

