/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.unicode.cldr.tool.ToolConstants;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.FileReaders;

public class CLDRPaths {
    public static final String COMMON_SUBDIR = "common/";
    public static final String CASING_SUBDIR = "casing/";
    public static final String VALIDITY_SUBDIR = "validity/";
    public static final String ANNOTATIONS_DERIVED_SUBDIR = "annotationsDerived/";
    public static final String COLLATION_SUBDIR = "collation/";
    public static final String RBNF_SUBDIR = "rbnf/";
    public static final String TRANSFORMS_SUBDIR = "transforms/";
    public static final String MAIN_SUBDIR = "main/";
    public static final String SUBDIVISIONS_SUBDIR = "subdivisions/";
    public static final String ANNOTATIONS_SUBDIR = "annotations/";
    public static final String BASE_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_DIR", null));
    public static final String COMMON_DIRECTORY = CldrUtility.getPath(BASE_DIRECTORY, "common/");
    public static final String COLLATION_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "collation/");
    public static final String CASING_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "casing/");
    public static final String MAIN_DIRECTORY = CldrUtility.getProperty("CLDR_MAIN", CldrUtility.getPath(COMMON_DIRECTORY, "main/"));
    public static final String RBNF_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "rbnf/");
    public static final String TRANSFORMS_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "transforms/");
    public static final String ANNOTATIONS_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "annotations/");
    public static final String SUBDIVISIONS_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "subdivisions/");
    public static final String ANNOTATIONS_DERIVED_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "annotationsDerived/");
    public static final String VALIDITY_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "validity/");
    public static final String STAGING_DIRECTORY = CldrUtility.getPath(BASE_DIRECTORY, "../cldr-staging/");
    public static final String TEST_DATA = COMMON_DIRECTORY + "testData/";
    public static final String SEED_DIRECTORY1 = CldrUtility.getProperty("CLDR_SEED", CldrUtility.getPath(COMMON_DIRECTORY, "../seed/"));
    public static final String SEED_DIRECTORY = CldrUtility.getPath(SEED_DIRECTORY1, "main/");
    public static final String SEED_COLLATION_DIRECTORY = CldrUtility.getPath(SEED_DIRECTORY1, "collation/");
    public static final String SEED_CASING_DIRECTORY = CldrUtility.getPath(SEED_DIRECTORY1, "casing/");
    public static final String SEED_ANNOTATIONS_DIRECTORY = CldrUtility.getPath(SEED_DIRECTORY1, "annotations/");
    public static final String EXEMPLARS_DIRECTORY = CldrUtility.getPath(BASE_DIRECTORY, "exemplars/main/");
    public static final String BIRTH_DATA_DIR = CldrUtility.getPath(BASE_DIRECTORY, "tools/cldr-code/src/main/resources/org/unicode/cldr/util/data/births");
    public static final String UNITTEST_DATA_DIR = CldrUtility.getPath(BASE_DIRECTORY, "tools/cldr-code/src/test/resources/org/unicode/cldr/unittest/data");
    public static final String CHART_DIRECTORY = CldrUtility.getPath(STAGING_DIRECTORY + "docs/charts/", ToolConstants.CHART_VERSION);
    public static final String VERIFY_DIR = CHART_DIRECTORY + "verify/";
    public static final String APPS_EMOJI_DIRECTORY = BASE_DIRECTORY + "/tools/cldr-apps/src/main/webapp/images/emoji";
    public static final String AUX_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_TMP_DIR", "cldr-aux/"));
    public static final String LOCAL_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("LOCAL_DIR", BASE_DIRECTORY + "/../"));
    public static final String ARCHIVE_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("ARCHIVE", CldrUtility.getPath(LOCAL_DIRECTORY, "cldr-archive/")));
    public static final String LAST_RELEASE_DIRECTORY = ARCHIVE_DIRECTORY + "cldr-" + ToolConstants.LAST_RELEASE_VERSION_WITH0 + "/";
    public static final String LAST_COMMON_DIRECTORY = CldrUtility.getPath(LAST_RELEASE_DIRECTORY, "common/");
    public static final String LAST_TRANSFORMS_DIRECTORY = CldrUtility.getPath(LAST_COMMON_DIRECTORY, "transforms/");
    public static final String GEN_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_GEN_DIR", CldrUtility.getPath(LOCAL_DIRECTORY, "Generated/cldr/")));
    public static final String DATA_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_EXT_DATA_DIR", CldrUtility.getPath(LOCAL_DIRECTORY, "Data/")));
    public static final String CLDR_PRIVATE_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_PRIVATE_DATA", CldrUtility.getPath(LOCAL_DIRECTORY, "../cldr-private/")));
    public static final String TMP_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_TMP_DIR", CldrUtility.getPath(LOCAL_DIRECTORY, "../cldr-tmp/")));
    public static final String TMP2_DIRECTORY = CldrUtility.getPath(CldrUtility.getProperty("CLDR_TMP_DIR", CldrUtility.getPath(LOCAL_DIRECTORY, "../cldr-tmp2/")));
    @Deprecated
    public static final String SUPPLEMENTAL_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "supplemental/");
    public static final String DEFAULT_SUPPLEMENTAL_DIRECTORY = CldrUtility.getPath(COMMON_DIRECTORY, "supplemental/");
    public static final String LOG_DIRECTORY = CldrUtility.getPath(TMP_DIRECTORY, "logs/");
    public static final String TEST_DIR = CldrUtility.getPath(TMP_DIRECTORY, "test/");
    public static final String COMPARE_PROGRAM = "\"C:\\Program Files (x86)\\Compare It!\\wincmp3.exe\"";
    @Deprecated
    public static final String UTIL_DATA_DIR = FileReaders.getRelativeFileName(CldrUtility.class, "data/");

    public static enum DIRECTORIES {
        common_dtd(new DtdType[0]),
        common_properties(new DtdType[0]),
        common_uca(new DtdType[0]),
        common_bcp47(DtdType.ldmlBCP47),
        common_annotations(DtdType.ldml),
        common_casing(DtdType.ldml),
        common_collation(DtdType.ldml),
        common_main(DtdType.ldml),
        common_rbnf(DtdType.ldml),
        common_segments(DtdType.ldml),
        common_subdivisions(DtdType.ldml),
        common_supplemental(DtdType.supplementalData),
        common_transforms(DtdType.supplementalData),
        common_validity(DtdType.supplementalData),
        keyboards_android(DtdType.keyboard, DtdType.platform),
        keyboards_chromeos(DtdType.keyboard, DtdType.platform),
        keyboards_dtd(DtdType.keyboard, DtdType.platform),
        keyboards_osx(DtdType.keyboard, DtdType.platform),
        keyboards_und(DtdType.keyboard, DtdType.platform),
        keyboards_windows(DtdType.keyboard, DtdType.platform);

        public final List<DtdType> dtdType;

        private DIRECTORIES(DtdType ... dtdType) {
            this.dtdType = ImmutableList.copyOf(dtdType);
        }
    }
}

