/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PatternCache;

public enum DtdType {
    ldml("common/dtd/ldml.dtd", null, null, "main", "annotations", "annotationsDerived", "casing", "collation", "rbnf", "segments", "subdivisions"),
    ldmlICU("common/dtd/ldmlICU.dtd", ldml),
    supplementalData("common/dtd/ldmlSupplemental.dtd", null, null, "supplemental", "supplemental-temp", "transforms", "validity"),
    ldmlBCP47("common/dtd/ldmlBCP47.dtd", "1.7.2", null, "bcp47"),
    keyboard("keyboards/dtd/ldmlKeyboard.dtd", "22.1", null, "../keyboards"),
    platform("keyboards/dtd/ldmlPlatform.dtd", "22.1", null, "../keyboards");

    public static final Set<DtdType> STANDARD_SET;
    static Pattern FIRST_ELEMENT;
    public final String dtdPath;
    public final DtdType rootType;
    public final String firstVersion;
    public final Set<String> directories;

    private DtdType(String dtdPath) {
        this(dtdPath, null, null, new String[0]);
    }

    private DtdType(String dtdPath, DtdType realType) {
        this(dtdPath, null, realType, new String[0]);
    }

    private DtdType(String dtdPath, String firstVersion, DtdType realType, String ... directories) {
        this.dtdPath = dtdPath;
        this.rootType = realType == null ? this : realType;
        this.firstVersion = firstVersion;
        this.directories = ImmutableSet.copyOf(directories);
    }

    public static DtdType fromPath(String elementOrPath) {
        Matcher m3 = FIRST_ELEMENT.matcher(elementOrPath);
        m3.lookingAt();
        return DtdType.valueOf(m3.group(1));
    }

    public String header(Class<?> generatedBy) {
        Object gline = "";
        if (generatedBy != null) {
            gline = "\n\tGENERATED DATA \u2014 do not manually update!\n\t\tGenerated by tool:\t" + generatedBy.getSimpleName() + "\n";
            for (Annotation annotation : generatedBy.getAnnotations()) {
                if (!(annotation instanceof CLDRTool)) continue;
                gline = (String)gline + "\t\tTool documented on:\t" + ((CLDRTool)annotation).url() + "\n";
                break;
            }
        }
        return "<?xml version='1.0' encoding='UTF-8' ?>\n<!DOCTYPE " + this + " SYSTEM '../../" + this.dtdPath + "'>\n<!--\n" + CldrUtility.getCopyrightString("\t") + (String)gline + " -->\n<" + this + ">\n";
    }

    static {
        STANDARD_SET = ImmutableSet.of(ldmlBCP47, supplementalData, ldml, keyboard, platform);
        FIRST_ELEMENT = PatternCache.get("//([^/\\[]*)");
    }
}

