/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import org.unicode.cldr.util.TransliteratorUtilities;

public enum NotificationCategory {
    error('E', "Error", "The Survey Tool detected an error in the winning value."),
    missingCoverage('M', "Missing", "Your current coverage level requires the item to be present. (During the vetting phase, this is informational: you can\u2019t add new values.)"),
    notApproved('P', "Provisional", "There are not enough votes for this item to be approved (and used)."),
    hasDispute('D', "Disputed", "Different organizations are choosing different values. Please review to approve or reach consensus."),
    weLost('L', "Losing", "The value that your organization chose (overall) is either not the winning value, or doesn\u2019t have enough votes to be approved. This might be due to a dispute between members of your organization."),
    warning('W', "Warning", "The Survey Tool detected a warning about the winning value."),
    englishChanged('U', "English Changed", "The English value has changed in CLDR, but the corresponding value for your language has not. Check if any changes are needed in your language."),
    changedOldValue('C', "Changed", "The winning value was altered from the baseline value. (Informational)"),
    inheritedChanged('I', "Inherited Changed", "The winning inherited value was altered from its baseline value. (Informational)"),
    abstained('A', "Abstained", "You have abstained, or not yet voted for any value.");

    public final char abbreviation;
    public final String buttonLabel;
    public final String jsonLabel;
    public final String description;

    private NotificationCategory(char abbreviation, String label, String description) {
        this.abbreviation = abbreviation;
        this.jsonLabel = label.replace(' ', '_');
        this.buttonLabel = TransliteratorUtilities.toHTML.transform(label);
        this.description = TransliteratorUtilities.toHTML.transform(description);
    }
}

