/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrDraftStatus;
import org.unicode.cldr.api.CldrPaths;
import org.unicode.cldr.api.CldrValue;

public final class CldrPath
implements AttributeKey.AttributeSupplier,
Comparable<CldrPath> {
    private static final CharMatcher NAME_CHARACTERS = CharMatcher.inRange('a', 'z').or(CharMatcher.inRange('A', 'Z')).or(CharMatcher.inRange('0', '9')).or(CharMatcher.anyOf(":-_"));
    private final CldrPath parent;
    private final int length;
    private final String elementName;
    private final ImmutableList<String> attributeKeyValuePairs;
    private final Optional<CldrDraftStatus> draftStatus;
    private final int sortIndex;
    private final CldrDataType dtdType;
    private final Comparator<CldrPath> ordering;
    private final int hashCode;
    private String localToString = null;

    public static CldrPath parseDistinguishingPath(String path) {
        return CldrPaths.processXPath(path, ImmutableList.of(), (k, v) -> {
            throw new IllegalArgumentException(String.format("unexpected value attribute '%s' in distinguishing path: %s", k, path));
        });
    }

    static int getCommonPrefixLength(CldrPath a, CldrPath b) {
        if (a == null || b == null) {
            return 0;
        }
        int minLength = Math.min(a.getLength(), b.getLength());
        while (a.getLength() > minLength) {
            a = a.getParent();
        }
        while (b.getLength() > minLength) {
            b = b.getParent();
        }
        int commonLength = minLength;
        for (int length = minLength; length > 0; --length) {
            if (!a.localEquals(b)) {
                commonLength = length - 1;
            }
            a = a.getParent();
            b = b.getParent();
        }
        return commonLength;
    }

    CldrPath(CldrPath parent, String name, List<String> attributeKeyValuePairs, CldrDataType dtdType, CldrDraftStatus localDraftStatus, int sortIndex) {
        Preconditions.checkState(parent != null || dtdType.getLdmlName().equals(name), "unexpected root element: expected %s, but got %s", (Object)dtdType.getLdmlName(), (Object)name);
        this.parent = parent;
        this.length = (parent != null ? parent.getLength() : 0) + 1;
        this.elementName = CldrPath.checkValidName(name, "element");
        this.attributeKeyValuePairs = CldrPath.checkKeyValuePairs(attributeKeyValuePairs);
        this.draftStatus = CldrPath.resolveDraftStatus(parent, localDraftStatus);
        if (CldrPaths.isOrdered(dtdType, this.elementName)) {
            Preconditions.checkArgument(sortIndex >= 0, "missing or invalid sort index '%s' for element: %s", sortIndex, (Object)this.elementName);
        } else {
            Preconditions.checkArgument(sortIndex == -1, "unexpected sort index '%s' for element: %s", sortIndex, (Object)this.elementName);
        }
        this.sortIndex = sortIndex;
        this.dtdType = Preconditions.checkNotNull(dtdType);
        this.ordering = CldrPaths.getPathComparator(dtdType);
        this.hashCode = Objects.hash(this.length, name, this.attributeKeyValuePairs, parent);
    }

    private static String checkValidName(String value, String description) {
        Preconditions.checkArgument(!value.isEmpty(), "%s name cannot be empty", (Object)description);
        Preconditions.checkArgument(NAME_CHARACTERS.matchesAllOf(value), "invalid character in %s name: %s", (Object)description, (Object)value);
        return value;
    }

    private static ImmutableList<String> checkKeyValuePairs(List<String> keyValuePairs) {
        Preconditions.checkArgument((keyValuePairs.size() & 1) == 0, "key/value pairs must have an even number of elements: %s", keyValuePairs);
        for (int n = 0; n < keyValuePairs.size(); n += 2) {
            CldrPath.checkValidName(keyValuePairs.get(n), "attribute");
            String v = keyValuePairs.get(n + 1);
            Preconditions.checkArgument(!v.contains("\""), "unsupported '\"' in attribute value: %s", (Object)v);
        }
        return ImmutableList.copyOf(keyValuePairs);
    }

    boolean matchesContent(String name, int sortIndex, List<String> keyValuePairs, CldrDraftStatus draftStatus) {
        return this.elementName.equals(name) && this.sortIndex == sortIndex && this.attributeKeyValuePairs.equals(keyValuePairs) && this.draftStatus.equals(CldrPath.resolveDraftStatus(this.parent, draftStatus));
    }

    private static Optional<CldrDraftStatus> resolveDraftStatus(CldrPath parent, CldrDraftStatus localStatus) {
        if (parent != null && parent.draftStatus.isPresent()) {
            return parent.draftStatus;
        }
        return localStatus != null ? localStatus.asOptional() : Optional.empty();
    }

    public CldrPath getParent() {
        return this.parent;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.elementName;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    @Override
    public String get(AttributeKey key) {
        Preconditions.checkArgument(!this.getDataType().isValueAttribute(key), "cannot get 'value attribute' values from a distinguishing path: %s", (Object)key);
        String v = null;
        for (CldrPath p = this; v == null && p != null; p = p.getParent()) {
            if (!p.getName().equals(key.getElementName())) continue;
            v = p.getLocalAttributeValue(key.getAttributeName());
        }
        return v;
    }

    @Override
    public CldrDataType getDataType() {
        return this.dtdType;
    }

    boolean containsElement(String elementName) {
        return this.getName().equals(elementName) || this.parent != null && this.parent.containsElement(elementName);
    }

    int getAttributeCount() {
        return this.attributeKeyValuePairs.size() / 2;
    }

    String getLocalAttributeName(int n) {
        Preconditions.checkElementIndex(n, this.getAttributeCount());
        return (String)this.attributeKeyValuePairs.get(2 * n);
    }

    String getLocalAttributeValue(int n) {
        Preconditions.checkElementIndex(n, this.getAttributeCount());
        return (String)this.attributeKeyValuePairs.get(2 * n + 1);
    }

    private String getLocalAttributeValue(String attributeName) {
        Preconditions.checkNotNull(attributeName);
        for (int i = 0; i < this.attributeKeyValuePairs.size(); i += 2) {
            if (!attributeName.equals(this.attributeKeyValuePairs.get(i))) continue;
            return (String)this.attributeKeyValuePairs.get(i + 1);
        }
        return null;
    }

    Optional<CldrDraftStatus> getDraftStatus() {
        return this.draftStatus;
    }

    String getFullPath(CldrValue value) {
        Preconditions.checkNotNull(value);
        return this.appendToString(new StringBuilder(), value.getValueAttributes()).toString();
    }

    @Override
    public int compareTo(CldrPath other) {
        if (this.dtdType == other.dtdType) {
            return this.ordering.compare(this, other);
        }
        return this.dtdType.compareTo(other.dtdType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CldrPath)) {
            return false;
        }
        CldrPath other = (CldrPath)obj;
        if (!this.getDataType().equals((Object)other.getDataType()) || this.length != other.length) {
            return false;
        }
        CldrPath pthis = this;
        for (int n = this.length - 1; n > 0; --n) {
            if (!pthis.localEquals(other)) {
                return false;
            }
            pthis = pthis.getParent();
            other = other.getParent();
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.appendToString(new StringBuilder(), ImmutableMap.of()).toString();
    }

    private boolean localEquals(CldrPath other) {
        return this.elementName.equals(other.elementName) && this.sortIndex == other.sortIndex && this.attributeKeyValuePairs.equals(other.attributeKeyValuePairs);
    }

    private String getLocalToString() {
        if (this.localToString == null) {
            Object str = this.getName();
            if (this.sortIndex != -1) {
                str = (String)str + "#" + this.sortIndex;
            }
            if (this.getAttributeCount() > 0) {
                str = IntStream.range(0, this.getAttributeCount()).mapToObj(n -> String.format("[@%s=\"%s\"]", this.getLocalAttributeName(n), this.getLocalAttributeValue(n))).collect(Collectors.joining("", (CharSequence)str, ""));
            }
            this.localToString = str;
        }
        return this.localToString;
    }

    private StringBuilder appendToString(StringBuilder out, ImmutableMap<AttributeKey, String> valueAttributes) {
        CldrPath parent = this.getParent();
        if (parent != null) {
            parent.appendToString(out, valueAttributes).append('/');
        } else {
            out.append("//");
        }
        if (valueAttributes.isEmpty()) {
            return out.append(this.getLocalToString());
        }
        List attributeNames = valueAttributes.keySet().stream().filter(k -> k.getElementName().equals(this.getName())).map(AttributeKey::getAttributeName).collect(Collectors.toCollection(ArrayList::new));
        if (attributeNames.isEmpty()) {
            return out.append(this.getLocalToString());
        }
        if (this.getAttributeCount() > 0) {
            String lastPathAttributeName = this.getLocalAttributeName(this.getAttributeCount() - 1);
            if (this.dtdType.getAttributeComparator().compare(lastPathAttributeName, (String)attributeNames.get(0)) > 0) {
                this.appendResortedValueAttributesTo(out, attributeNames, valueAttributes);
                return out;
            }
        }
        return this.appendValueAttributesTo(out.append(this.getLocalToString()), attributeNames, valueAttributes);
    }

    private void appendResortedValueAttributesTo(StringBuilder out, List<String> attributeNames, ImmutableMap<AttributeKey, String> valueAttributes) {
        out.append(this.elementName);
        for (int n = 0; n < this.attributeKeyValuePairs.size(); n += 2) {
            attributeNames.add((String)this.attributeKeyValuePairs.get(n));
        }
        attributeNames.sort(this.dtdType.getAttributeComparator());
        for (String attrName : attributeNames) {
            String value = this.getLocalAttributeValue(attrName);
            if (value == null) {
                value = valueAttributes.get(AttributeKey.keyOf(this.elementName, attrName));
                Preconditions.checkState(value != null, "missing value %s:%s", (Object)this.elementName, (Object)attrName);
            }
            out.append(String.format("[@%s=\"%s\"]", attrName, value));
        }
    }

    private StringBuilder appendValueAttributesTo(StringBuilder out, List<String> attributeNames, ImmutableMap<AttributeKey, String> valueAttributes) {
        for (String attrName : attributeNames) {
            String value = valueAttributes.get(AttributeKey.keyOf(this.elementName, attrName));
            Preconditions.checkState(value != null, "missing value %s:%s", (Object)this.elementName, (Object)attrName);
            out.append(String.format("[@%s=\"%s\"]", attrName, value));
        }
        return out;
    }
}

