/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.dev.util.UnicodeMap;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SemiFileReader;

public class Typology {
    private static final Set<String> NOLABELS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("NOLABEL")));
    public static final UnicodeSet SKIP = new UnicodeSet("[[:C:]-[:Cf:]-[:Cc:]]").freeze();
    public static Map<String, UnicodeSet> label_to_uset = new TreeMap<String, UnicodeSet>();
    public static UnicodeMap<Set<String>> char2labels = new UnicodeMap();
    static Set<String> skiplabels = new HashSet<String>(Arrays.asList("", "Symbol", "Punctuation", "Letter", "S", "L", "M", "N", "C", "Z", "P"));
    public static Map<String, UnicodeSet> full_path_to_uset = new TreeMap<String, UnicodeSet>();
    public static Map<String, UnicodeSet> path_to_uset = new TreeMap<String, UnicodeSet>();
    public static Relation<String, String> labelToPaths = Relation.of(new TreeMap(), TreeSet.class);
    public static Map<String, Map<String, UnicodeSet>> label_parent_uset = new TreeMap<String, Map<String, UnicodeSet>>();

    private static Map<String, UnicodeSet> freezeMapping(Map<String, UnicodeSet> map) {
        for (String key : map.keySet()) {
            UnicodeSet uset = map.get(key);
            uset.freeze();
        }
        return Collections.unmodifiableMap(map);
    }

    public static Set<String> addLabelsToOutput(UnicodeSet source, Set<String> output) {
        for (String it : source) {
            Typology.addLabelsToOutput(it, output);
        }
        return output;
    }

    public static Set<String> addLabelsToOutput(String s2, Set<String> output) {
        Set<String> value = Typology.getLabels(s2.codePointAt(0));
        output.addAll(value);
        return output;
    }

    public static Set<String> getLabels(int codepoint) {
        return char2labels.getValue(codepoint);
    }

    public static UnicodeSet getSet(String label) {
        return label_to_uset.get(label);
    }

    public static Set<String> getLabels() {
        return label_to_uset.keySet();
    }

    public static Set<Map.Entry<String, UnicodeSet>> getLabelAndSet() {
        return label_to_uset.entrySet();
    }

    public static void main(String[] args) {
        for (Map.Entry<String, UnicodeSet> s2 : Typology.getLabelAndSet()) {
            System.out.println(s2.getKey() + "\t" + s2.getValue().toPattern(false));
        }
    }

    static {
        new MyReader().process(Typology.class, "Categories.txt");
        TreeMap<String, UnicodeSet> temp = new TreeMap<String, UnicodeSet>();
        for (int i = 0; i < 30; ++i) {
            UnicodeSet same = new UnicodeSet().applyIntPropertyValue(4101, i);
            String gcName = UCharacter.getPropertyValueName(4101, i, 0);
            String prefix = gcName.substring(0, 1);
            for (String path : path_to_uset.keySet()) {
                UnicodeSet uset = path_to_uset.get(path);
                if (!same.containsSome(uset)) continue;
                String path2 = prefix + path;
                temp.put(path2, new UnicodeSet(uset).retainAll(same));
                String[] labels = path2.split("/");
                Object parent = "";
                for (int j = 0; j < labels.length; ++j) {
                    UnicodeSet uset2;
                    labelToPaths.put(labels[j], path2);
                    if (j == 0) continue;
                    Map<String, UnicodeSet> map = label_parent_uset.get(labels[j]);
                    if (map == null) {
                        map = new TreeMap<String, UnicodeSet>();
                        label_parent_uset.put(labels[j], map);
                    }
                    if ((uset2 = map.get(parent)) == null) {
                        uset2 = new UnicodeSet();
                        map.put((String)parent, uset2);
                    }
                    uset2.addAll(uset);
                    parent = (String)parent + labels[j] + "/";
                }
            }
        }
        UnicodeSet nolabels = char2labels.getSet(null);
        nolabels.removeAll(SKIP);
        char2labels.putAll(nolabels, NOLABELS);
        char2labels.freeze();
        label_to_uset.put(NOLABELS.iterator().next(), nolabels);
        label_to_uset = Typology.freezeMapping(label_to_uset);
        path_to_uset = Typology.freezeMapping(temp);
        labelToPaths.freeze();
    }

    static class MyReader
    extends SemiFileReader {
        public static final Pattern SPLIT = PatternCache.get("\\s*\t\\s*");
        public static final Pattern NON_ALPHANUM = PatternCache.get("[^0-9A-Za-z]+");
        StringBuilder temp_path = new StringBuilder();
        Map<List<String>, List<String>> listCache = new HashMap<List<String>, List<String>>();
        Map<Set<String>, Set<String>> setCache = new HashMap<Set<String>, Set<String>>();

        MyReader() {
        }

        @Override
        protected String[] splitLine(String line) {
            return SPLIT.split(line);
        }

        @Override
        protected boolean handleLine(int lineCount, int startRaw, int endRaw, String[] items) {
            this.temp_path.setLength(0);
            this.temp_path.append('/');
            for (int i = 2; i < items.length - 1; ++i) {
                String item = items[i];
                if (item.length() == 0) continue;
                item = NON_ALPHANUM.matcher(item).replaceAll("_");
                this.temp_path.append('/').append(item);
            }
            String fullPath = this.temp_path.toString();
            UnicodeSet uset = full_path_to_uset.get(fullPath = fullPath.intern());
            if (uset == null) {
                uset = new UnicodeSet();
                full_path_to_uset.put(fullPath, uset);
            }
            uset.addAll(startRaw, endRaw);
            String[] labels = fullPath.split("/");
            String path = "";
            TreeSet<String> labelSet = new TreeSet<String>();
            for (String item : labels) {
                if (skiplabels.contains(item)) continue;
                labelSet.add(item);
                UnicodeSet uset2 = label_to_uset.get(item);
                if (uset2 == null) {
                    uset2 = new UnicodeSet();
                    label_to_uset.put(item, uset2);
                }
                uset2.add(startRaw, endRaw);
                path = (path + "/" + item).intern();
                uset2 = path_to_uset.get(path);
                if (uset2 == null) {
                    uset2 = new UnicodeSet();
                    path_to_uset.put(path, uset2);
                }
                uset2.addAll(startRaw, endRaw);
            }
            char2labels.putAll(startRaw, endRaw, Collections.unmodifiableSet(labelSet));
            return true;
        }

        private <T> T intern(Map<T, T> cache, T list) {
            T old = cache.get(list);
            if (old != null) {
                return old;
            }
            cache.put(list, list);
            return list;
        }
    }
}

