/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Formatter;
import java.util.Locale;
import org.unicode.cldr.util.InputStreamFactory;

public class ListNumbers {
    private static final double[][] RANGES = new double[][]{{-1.0, 0.0}, {0.23, 0.23}, {1.0, 31.0}, {98.0, 102.0}, {998.0, 1002.0}, {1998.0, 2002.0}, {9998.0, 10002.0}, {100000.0, 100001.0}, {1000000.0, 1000001.0}, {1.0E7, 1.0000001E7}, {1.0E8, 1.00000001E8}, {1.0E9, 1.000000001E9}};

    private static String getRulePrefix(String currRuleName) {
        try {
            return currRuleName.substring(1, currRuleName.indexOf(45));
        }
        catch (StringIndexOutOfBoundsException e) {
            return currRuleName;
        }
    }

    private static String getDisplayName(RuleBasedNumberFormat spellout, String currRuleName) {
        try {
            String prefix = currRuleName.substring(1, currRuleName.indexOf(45));
            if (prefix.equals("spellout") || prefix.equals("digits") || prefix.equals("duration")) {
                String suffix = currRuleName.substring(currRuleName.indexOf(45) + 1);
                return suffix;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return currRuleName;
    }

    private static String fileToString(String file) {
        String str = "";
        try (InputStream is = InputStreamFactory.createInputStream(new File(file));
             InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            char[] buffer = new char[is.available() + 1];
            int i = reader.read(buffer);
            if (i >= buffer.length) {
                throw new IOException("File encoding expanded when converting to UTF-16");
            }
            if (i > 0) {
                str = new String(buffer, 0, i);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return str;
    }

    private static String getNumberStyle(String ruleName, double val, boolean isRTL) {
        String bidiStyle = "";
        if (isRTL) {
            bidiStyle = " rtl";
        }
        if ((val < 1.0 || val != (double)((long)val)) && (ruleName.contains("ordinal") || ruleName.contains("year"))) {
            return " class=\"nonsense" + bidiStyle + "\"";
        }
        if (ruleName.contains("@noparse")) {
            return " class=\"noparse" + bidiStyle + "\"";
        }
        if (isRTL) {
            return " class=\"rtl\"";
        }
        return "";
    }

    private static void printLine(RuleBasedNumberFormat[] rbnfs, double num, boolean isRTL) {
        String numStr;
        long longVal = (long)num;
        if ((double)longVal != num) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.US);
            formatter.format("%.3f", num);
            numStr = sb.toString();
            formatter.close();
        } else {
            numStr = Long.toString(longVal);
        }
        System.out.print("<tr><td>" + numStr + "</td>");
        for (RuleBasedNumberFormat rbnf : rbnfs) {
            for (String name : rbnf.getRuleSetNames()) {
                System.out.print("<td" + ListNumbers.getNumberStyle(name, num, isRTL) + ">" + rbnf.format(num, name) + "</td>");
            }
        }
        System.out.println("</tr>");
    }

    private static void printSkipLine(RuleBasedNumberFormat[] rbnfs) {
        System.out.print("<tr><td>...</td>");
        for (RuleBasedNumberFormat rbnf : rbnfs) {
            for (String name : rbnf.getRuleSetNames()) {
                System.out.print("<th class=\"thead\"><b>" + ListNumbers.getDisplayName(rbnf, name) + "</b></th>");
            }
        }
        System.out.println("</tr>");
    }

    private static void printTable(ULocale loc, RuleBasedNumberFormat[] rbnfs) {
        System.out.println("<h2 style=\"margin-top: 3em\"><a name=\"" + loc + "\"></a>" + loc + " - " + loc.getDisplayName() + "</h2>");
        System.out.println("<table border=\"1\" cellspacing=\"0\" cellpadding=\"2\">");
        System.out.println("<tr><th rowspan=\"2\" class=\"thead\"><b>Number</b></th>");
        for (RuleBasedNumberFormat rbnf : rbnfs) {
            int numColumns = rbnf.getRuleSetNames().length;
            System.out.print("<th colspan=\"" + numColumns + "\" style=\"text-align:center;\">" + ListNumbers.getRulePrefix(rbnf.getDefaultRuleSetName()));
            System.out.print("<br/><span style=\"color: gray\">Default = " + ListNumbers.getDisplayName(rbnf, rbnf.getDefaultRuleSetName()));
            System.out.println("</span></th>");
        }
        System.out.println("</tr>");
        System.out.print("<tr>");
        for (RuleBasedNumberFormat rbnf : rbnfs) {
            for (String name : rbnf.getRuleSetNames()) {
                System.out.print("<th class=\"thead\"><b>" + ListNumbers.getDisplayName(rbnf, name) + "</b></th>");
            }
        }
        System.out.println("</tr>");
        byte direction = Character.getDirectionality(rbnfs[0].format(1L).charAt(0));
        boolean isRTL = direction == 1 || direction == 2;
        for (int rangeIdx = 0; rangeIdx < RANGES.length; ++rangeIdx) {
            double end = RANGES[rangeIdx][1];
            if (end == (double)((long)end) && rangeIdx != 0) {
                ListNumbers.printSkipLine(rbnfs);
            }
            for (double num = RANGES[rangeIdx][0]; num <= end; num += 1.0) {
                ListNumbers.printLine(rbnfs, num, isRTL);
            }
        }
        System.out.println("</table>");
    }

    public static void main(String[] args) {
        System.out.println("<html>");
        System.out.println("<head>");
        System.out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        System.out.println("<title>RBNF output</title>");
        System.out.println("</head>");
        System.out.println("<body>");
        System.out.println("<p>Generated from: ICU4J " + VersionInfo.ICU_VERSION + "</p>");
        System.out.println("<style type=\"text/css\">");
        System.out.println(".rtl {text-align:right}");
        System.out.println(".noparse {background-color:lightgray}");
        System.out.println(".nonsense {color:gray; background-color:lightgray}");
        System.out.println(".thead {text-align:center; font-weight:bold;}");
        System.out.println("</style>");
        if (args.length > 1) {
            RuleBasedNumberFormat[] rbnfs = new RuleBasedNumberFormat[]{new RuleBasedNumberFormat(ListNumbers.fileToString(args[1]), new ULocale(args[0]))};
            ListNumbers.printTable(new ULocale(args[0]), rbnfs);
        } else {
            for (ULocale loc : NumberFormat.getAvailableULocales()) {
                RuleBasedNumberFormat[] rbnfs = new RuleBasedNumberFormat[]{new RuleBasedNumberFormat(loc, 1), new RuleBasedNumberFormat(loc, 2)};
                if (!rbnfs[0].getLocale(ULocale.ACTUAL_LOCALE).equals(loc)) continue;
                try {
                    UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt74b/rbnf", loc);
                    if (bundle.getSize() == 2) {
                        UResourceBundle parent = bundle.get("%%Parent");
                        System.out.println("<p>" + loc + " is an alias to " + parent.getString() + " - " + new ULocale(parent.getString()).getDisplayName() + "</p>");
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ListNumbers.printTable(loc, rbnfs);
            }
            RuleBasedNumberFormat[] rbnfNumbering = new RuleBasedNumberFormat[]{new RuleBasedNumberFormat(new ULocale(""), 4), new RuleBasedNumberFormat(new ULocale(""), 1), new RuleBasedNumberFormat(new ULocale(""), 2)};
            ListNumbers.printTable(new ULocale(""), rbnfNumbering);
        }
        System.out.println("</body>");
        System.out.println("</html>");
    }
}

