/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.dev.tool.shared.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.icu.SimpleConverter;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.util.CldrUtility;

public class GenerateCharmap {
    private static final int DESTDIR = 2;
    private static final int UNICODESET = 3;
    private static final int CHARSET = 4;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("destdir", 'd', 1).setDefault("."), UOption.create("unicodeset", 'u', 1).setDefault("[\\u0000-\\U0010FFFF]"), UOption.create("charset", 'c', 1).setDefault("UTF-8")};
    UnicodeSet chars;
    Charset cs;
    String codeset;

    public static void main(String[] args) throws IOException {
        UOption.parseArgs(args, options);
        String codeset = GenerateCharmap.options[4].value;
        GenerateCharmap gp = new GenerateCharmap(new UnicodeSet(GenerateCharmap.options[3].value), Charset.forName(codeset), codeset);
        PrintWriter out = FileUtilities.openUTF8Writer(GenerateCharmap.options[2].value + File.separator, codeset + ".cm");
        gp.write(out);
        out.close();
    }

    public GenerateCharmap(UnicodeSet chars, Charset cs, String codeset) {
        this.cs = cs;
        if (cs != null && !cs.name().equals("UTF-8")) {
            UnicodeSet csset = new SimpleConverter(cs).getCharset();
            chars = new UnicodeSet(chars).retainAll(csset);
        }
        this.chars = chars;
        this.codeset = codeset;
    }

    public void write(PrintWriter out) {
        out.println("######################");
        out.println("# POSIX charmap ");
        out.println("# Generated automatically from the Unicode Character Database and Common Locale Data Repository");
        out.println("# see http://www.opengroup.org/onlinepubs/009695399/basedefs/xbd_chap07.html");
        out.println("# charset:\t" + this.codeset);
        out.println("######################");
        out.println("#################################################################################################");
        out.println(CldrUtility.getCopyrightString("# "));
        out.println();
        this.doCharmap(out, this.cs);
        out.println("######################");
        out.println();
    }

    private void doCharmap(PrintWriter out, Charset cs) {
        CharmapLine current;
        int LongestCharNameLength = 0;
        int LongestCharValueLength = 0;
        UnicodeSet us = new UnicodeSet("[^[:Noncharacter_Code_Point:][:Cn:][:Cs:]]").retainAll(this.chars);
        ArrayList<CharmapLine> cml = new ArrayList<CharmapLine>();
        UnicodeSetIterator it = new UnicodeSetIterator(us);
        while (it.next()) {
            String Name2 = POSIXUtilities.POSIXCharFullName(it.getString());
            String AltName = POSIXUtilities.POSIXCharName(it.getString());
            String Value2 = this.getCodepointValue(it.getString(), cs);
            current = new CharmapLine(Name2, AltName, Value2);
            cml.add(current);
            if (current.CharacterName.length() > LongestCharNameLength) {
                LongestCharNameLength = current.CharacterName.length();
            }
            if (current.CharacterValue.length() <= LongestCharValueLength) continue;
            LongestCharValueLength = current.CharacterValue.length();
        }
        Collections.sort(cml);
        out.print("<code_set_name> \"");
        out.print(this.codeset);
        out.println("\"");
        out.println("<mb_cur_min>    1");
        out.print("<mb_cur_max>    ");
        out.print(LongestCharValueLength / 4);
        out.println();
        out.println();
        out.println("CHARMAP");
        ListIterator li = cml.listIterator();
        while (li.hasNext()) {
            int i;
            current = (CharmapLine)li.next();
            out.print(current.CharacterName);
            for (i = LongestCharNameLength + 1; i > current.CharacterName.length(); --i) {
                out.print(" ");
            }
            out.println(current.CharacterValue);
            if (current.CharacterAltName.length() <= 0) continue;
            out.print(current.CharacterAltName);
            for (i = LongestCharNameLength + 1; i > current.CharacterAltName.length(); --i) {
                out.print(" ");
            }
            out.println(current.CharacterValue);
        }
        out.println();
        out.println("END CHARMAP");
        out.println();
    }

    private String getCodepointValue(String cp, Charset cs) {
        StringBuffer result = new StringBuffer();
        ByteBuffer bb = cs.encode(cp);
        while (bb.hasRemaining()) {
            result.append("\\x");
            int b = bb.get();
            int i = b < 0 ? b + 256 : b;
            result.append(Utility.hex(i, 2));
        }
        return result.toString();
    }

    public class CharmapLine
    implements Comparable<Object> {
        public String CharacterValue;
        public String CharacterName;
        public String CharacterAltName;

        public CharmapLine(String Name2, String AltName, String Value2) {
            this.CharacterName = Name2;
            this.CharacterAltName = AltName;
            this.CharacterValue = Value2;
            if (Name2.equals(AltName)) {
                this.CharacterAltName = "";
            }
        }

        @Override
        public int compareTo(Object o) {
            CharmapLine c = (CharmapLine)o;
            return this.CharacterValue.compareTo(c.CharacterValue);
        }
    }
}

