/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import java.io.PrintWriter;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.util.CLDRFile;

public class POSIX_LCNumeric {
    String decimal_point;
    String thousands_sep;
    String numsys;
    String grouping;

    public POSIX_LCNumeric(CLDRFile doc) {
        this.numsys = doc.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        this.decimal_point = POSIXUtilities.POSIXCharName(doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/decimal"));
        this.thousands_sep = POSIXUtilities.POSIXCharName(doc.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + this.numsys + "']/group"));
        String grouping_pattern = doc.getWinningValue("//ldml/numbers/decimalFormats/decimalFormatLength/decimalFormat[@type='standard']/pattern[@type='standard']");
        this.grouping = POSIXUtilities.POSIXGrouping(grouping_pattern);
    }

    public void write(PrintWriter out) {
        out.println("*************");
        out.println("LC_NUMERIC");
        out.println("*************");
        out.println();
        out.println("decimal_point     \"" + this.decimal_point + "\"");
        out.println("thousands_sep     \"" + this.thousands_sep + "\"");
        out.println("grouping          " + this.grouping);
        out.println();
        out.println("END LC_NUMERIC");
        out.println();
        out.println();
    }
}

