/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Output;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckAccessor;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;

public class CheckPlaceHolders
extends CheckCLDR {
    private static final Pattern PLACEHOLDER_PATTERN = PatternCache.get("([0-9]|[1-9][0-9]+)");
    private static final Splitter SPLIT_SPACE = Splitter.on(' ').trimResults();
    private static final Joiner JOIN_SPACE = Joiner.on(' ');
    private static final Pattern SKIP_PATH_LIST = Pattern.compile("//ldml/characters/(exemplarCharacters|parseLenient).*");
    private static final Set<String> CLDR_LOCALES_FOR_NAME_ORDER;
    private static final ImmutableSet<PersonNameFormatter.Modifier> SINGLE_CORE;
    private static final ImmutableSet<PersonNameFormatter.Modifier> SINGLE_PREFIX;
    private static final ImmutableSet<PersonNameFormatter.Modifier> CORE_AND_PREFIX;
    private Set<PersonNameFormatter.Modifier> allowedModifiers = null;
    static final ImmutableSet<Object> givenFirstSortingLocales;
    static final UnicodeSet allowedForeignSpaceReplacements;

    @Override
    public CheckCLDR setCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        super.setCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.allowedModifiers = PersonNameFormatter.Modifier.getAllowedModifiers(cldrFileToCheck.getLocaleID());
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (value == null || path.endsWith("/alias") || SKIP_PATH_LIST.matcher(path).matches()) {
            return this;
        }
        if (path.contains("/personNames")) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            switch (parts.getElement(2)) {
                default: {
                    break;
                }
                case "initialPattern": {
                    CheckPlaceHolders.checkInitialPattern(this, path, value, result);
                    break;
                }
                case "nativeSpaceReplacement": 
                case "foreignSpaceReplacement": {
                    CheckPlaceHolders.checkForeignSpaceReplacement(this, value, result);
                    return this;
                }
                case "nameOrderLocales": {
                    CheckPlaceHolders.checkNameOrder(this, path, value, result);
                    return this;
                }
                case "sampleName": {
                    CheckPlaceHolders.checkSampleNames(this, parts, value, result);
                    return this;
                }
                case "personName": {
                    CheckPlaceHolders.checkPersonNamePatterns(this, this.allowedModifiers, this.getLocaleID(), path, parts, value, result);
                    return this;
                }
            }
        }
        this.checkBasicPlaceholders(value, result);
        this.checkListPatterns(path, value, result);
        return this;
    }

    public static void checkNameOrder(CheckAccessor checkAccessor, String path, String value, List<CheckCLDR.CheckStatus> result) {
        String myLanguage;
        String otherPath;
        String otherValue;
        TreeSet<String> items;
        String localeID = checkAccessor.getLocaleID();
        Set<String> orderErrors = CheckPlaceHolders.checkForErrorsAndGetLocales(localeID, value, items = new TreeSet<String>());
        if (orderErrors != null) {
            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidLocale).setMessage("Invalid locales: " + JOIN_SPACE.join(orderErrors)));
            return;
        }
        String unresolvedValue = checkAccessor.getUnresolvedStringValue(path);
        if (unresolvedValue != null && (otherValue = checkAccessor.getStringValue(otherPath = path.contains("givenFirst") ? path.replace("givenFirst", "surnameFirst") : path.replace("surnameFirst", "givenFirst"))) != null && !(myLanguage = localeID).equals("root")) {
            TreeSet<String> items2 = new TreeSet<String>();
            orderErrors = CheckPlaceHolders.checkForErrorsAndGetLocales(localeID, otherValue, items2);
            if (!Collections.disjoint(items, items2)) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidLocale).setMessage("Locale codes can occur only once: " + JOIN_SPACE.join(Sets.intersection(items, items2))));
            }
            items.addAll(items2);
            myLanguage = new LocaleIDParser().set(myLanguage).getLanguage();
            if (!items.contains(myLanguage)) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingLanguage).setMessage("Your locale code (" + myLanguage + ") must be explicitly listed in one of the nameOrderLocales: either in givenFirst or in surnameFirst."));
            }
            if (!items.contains("und")) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingLanguage).setMessage("The special code \u2018und\u2019 must be explicitly listed in one of the nameOrderLocales: either givenFirst or surnameFirst."));
            }
        }
    }

    public static void checkSampleNames(CheckAccessor checkAccessor, XPathParts pathParts, String value, List<CheckCLDR.CheckStatus> result) {
        block11: {
            Set<PersonNameFormatter.Modifier> modifiers;
            PersonNameFormatter.Field field;
            block10: {
                CheckCLDR.CheckStatus.Type mainType;
                PersonNameFormatter.ModifiedField fieldType = PersonNameFormatter.ModifiedField.from(pathParts.getAttributeValue(-1, "type"));
                field = fieldType.getField();
                modifiers = fieldType.getModifiers();
                Output<String> errorMessage = new Output<String>();
                PersonNameFormatter.Modifier.getCleanSet(modifiers, errorMessage);
                CheckCLDR.CheckStatus.Type type = mainType = checkAccessor.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
                if (errorMessage.value != null) {
                    result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage((String)errorMessage.value));
                    return;
                }
                if (!value.equals("\u2205\u2205\u2205")) break block10;
                switch (field) {
                    case given: {
                        if (fieldType.getModifiers().isEmpty()) {
                            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(mainType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Names must have a value for the \u2018given\u2018 field. Mononyms (like \u2018Zendaya\u2019) use given, not surname"));
                            break;
                        }
                        break block11;
                    }
                    case surname: {
                        XPathParts thawedPathParts = pathParts.cloneAsThawed();
                        String modPath = thawedPathParts.setAttribute(-1, "type", PersonNameFormatter.Field.surname2.toString()).toString();
                        String surname2Value = checkAccessor.getStringValue(modPath);
                        String modPathcore = thawedPathParts.setAttribute(-1, "type", "surname-core").toString();
                        String surnameCoreValue = checkAccessor.getStringValue(modPathcore);
                        if (surname2Value != null && !surname2Value.equals("\u2205\u2205\u2205") && (surnameCoreValue == null || surnameCoreValue.equals("\u2205\u2205\u2205"))) {
                            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Names must have a value for the \u2018surname\u2019 field if they have a \u2018surname2\u2019 field."));
                            break;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            if (value.equals("zxx")) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Illegal name field; zxx is only appropriate for NameOrder locales"));
            } else {
                String plainValue;
                String coreValue;
                String prefixValue;
                String errorMessage2;
                boolean hasPrefix = modifiers.contains((Object)PersonNameFormatter.Modifier.prefix);
                boolean hasCore = modifiers.contains((Object)PersonNameFormatter.Modifier.core);
                if ((hasPrefix || hasCore) && (errorMessage2 = PersonNameFormatter.Modifier.inconsistentPrefixCorePlainValues(prefixValue = hasPrefix ? value : CheckPlaceHolders.modifiedFieldValue(checkAccessor, pathParts, field, modifiers, PersonNameFormatter.Modifier.prefix), coreValue = hasCore ? value : CheckPlaceHolders.modifiedFieldValue(checkAccessor, pathParts, field, modifiers, PersonNameFormatter.Modifier.core), plainValue = CheckPlaceHolders.modifiedFieldValue(checkAccessor, pathParts, field, modifiers, null))) != null) {
                    result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage(errorMessage2));
                }
            }
        }
    }

    @Deprecated
    public static void checkPersonNamePatterns(CheckAccessor checkAccessor, Set<PersonNameFormatter.Modifier> allowedModifiers, String path, XPathParts pathParts, String value, List<CheckCLDR.CheckStatus> result) {
        CheckPlaceHolders.checkPersonNamePatterns(checkAccessor, allowedModifiers, "fr", path, pathParts, value, result);
    }

    /*
     * WARNING - void declaration
     */
    public static void checkPersonNamePatterns(CheckAccessor checkAccessor, Set<PersonNameFormatter.Modifier> allowedModifiers, String locale, String path, XPathParts pathParts, String value, List<CheckCLDR.CheckStatus> result) {
        Pair<PersonNameFormatter.FormatParameters, PersonNameFormatter.NamePattern> pair = null;
        try {
            pair = PersonNameFormatter.fromPathValue(pathParts, value);
        }
        catch (Exception e) {
            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid placeholder in value: \u00ab" + value + "\u00bb"));
            return;
        }
        PersonNameFormatter.FormatParameters parameterMatcher = pair.getFirst();
        PersonNameFormatter.NamePattern namePattern = pair.getSecond();
        Multimap<PersonNameFormatter.Field, Integer> fieldToPositions = namePattern.getFieldPositions();
        boolean usageIsMonogram = parameterMatcher.matches(new PersonNameFormatter.FormatParameters(null, null, PersonNameFormatter.Usage.monogram, null));
        PersonNameFormatter.ModifiedField lastModifiedField = null;
        for (int i = 0; i < namePattern.getElementCount(); ++i) {
            PersonNameFormatter.ModifiedField modifiedField = namePattern.getModifiedField(i);
            if (modifiedField == null) {
                String literal = namePattern.getLiteral(i);
                if (literal.contains(".")) {
                    Set<PersonNameFormatter.Modifier> set;
                    if (lastModifiedField != null && (set = lastModifiedField.getModifiers()).contains((Object)PersonNameFormatter.Modifier.initial) && set.contains((Object)PersonNameFormatter.Modifier.initialCap)) {
                        result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.namePlaceholderProblem).setMessage("\u201c.\u201d is strongly discouraged after an -initial or -initialCap placeholder in {" + lastModifiedField + "}"));
                        continue;
                    }
                    if (usageIsMonogram) {
                        result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.namePlaceholderProblem).setMessage("\u201c.\u201d is discouraged when usage=monogram, in " + namePattern));
                    }
                }
            } else {
                lastModifiedField = modifiedField;
                Set<PersonNameFormatter.Modifier> modifiers = modifiedField.getModifiers();
                PersonNameFormatter.Field field = modifiedField.getField();
                if (!allowedModifiers.containsAll(modifiers)) {
                    result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Illegal grammatical case modifiers for {0}: {1}", locale, Sets.difference(modifiers, allowedModifiers)));
                }
                switch (field) {
                    case title: 
                    case credentials: 
                    case generation: {
                        if (!usageIsMonogram) break;
                        result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Disallowed when usage=monogram: {" + field + "\u2026}"));
                        break;
                    }
                    default: {
                        boolean monogramModifier = modifiers.contains((Object)PersonNameFormatter.Modifier.monogram);
                        boolean allCapsModifier = modifiers.contains((Object)PersonNameFormatter.Modifier.allCaps);
                        if (!usageIsMonogram) {
                            if (!monogramModifier) break;
                            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("-monogram is strongly discouraged when usage\u2260monogram, in {" + modifiedField + "}"));
                            break;
                        }
                        if (!usageIsMonogram) break;
                        if (!monogramModifier) {
                            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("-monogram is required when usage=monogram, in {" + modifiedField + "}"));
                            break;
                        }
                        if (allCapsModifier) break;
                        result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("-allCaps is strongly encouraged with -monogram, in {" + modifiedField + "}"));
                    }
                }
            }
            lastModifiedField = modifiedField;
        }
        int firstSurname = Integer.MAX_VALUE;
        int firstGiven = Integer.MAX_VALUE;
        for (Map.Entry entry : fieldToPositions.asMap().entrySet()) {
            Collection positions = (Collection)entry.getValue();
            if (positions.size() > 1) {
                boolean skip = false;
                if (entry.getKey() == PersonNameFormatter.Field.surname) {
                    Iterator it = positions.iterator();
                    Set<PersonNameFormatter.Modifier> m1 = namePattern.getModifiedField((Integer)it.next()).getModifiers();
                    Set<PersonNameFormatter.Modifier> m22 = namePattern.getModifiedField((Integer)it.next()).getModifiers();
                    boolean bl = skip = m1.contains((Object)PersonNameFormatter.Modifier.core) && m22.contains((Object)PersonNameFormatter.Modifier.prefix) || m1.contains((Object)PersonNameFormatter.Modifier.prefix) && m22.contains((Object)PersonNameFormatter.Modifier.core);
                }
                if (!skip) {
                    result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Duplicate fields: " + entry));
                }
            }
            Integer leastPosition = (Integer)positions.iterator().next();
            switch ((PersonNameFormatter.Field)((Object)entry.getKey())) {
                case given: 
                case given2: {
                    firstGiven = Math.min(leastPosition, firstGiven);
                    break;
                }
                case surname: 
                case surname2: {
                    firstSurname = Math.min(leastPosition, firstSurname);
                    break;
                }
            }
        }
        if (firstGiven < Integer.MAX_VALUE && firstSurname < Integer.MAX_VALUE && checkAccessor.getUnresolvedStringValue(path) != null) {
            void var16_27;
            void var16_25;
            Set<PersonNameFormatter.Order> set;
            PersonNameFormatter.Order orderRaw = parameterMatcher.getOrder();
            Set<PersonNameFormatter.Order> set2 = set = orderRaw == null ? PersonNameFormatter.Order.ALL : ImmutableSet.of(orderRaw);
            if (set.contains((Object)PersonNameFormatter.Order.sorting)) {
                EnumSet<PersonNameFormatter.Order> temp = EnumSet.noneOf(PersonNameFormatter.Order.class);
                temp.addAll(set);
                temp.remove((Object)PersonNameFormatter.Order.sorting);
                if (givenFirstSortingLocales.contains(checkAccessor.getLocaleID())) {
                    temp.add(PersonNameFormatter.Order.givenFirst);
                } else {
                    temp.add(PersonNameFormatter.Order.surnameFirst);
                }
                EnumSet<PersonNameFormatter.Order> enumSet = temp;
            }
            if (var16_25.isEmpty()) {
                Set<PersonNameFormatter.Order> set3 = PersonNameFormatter.Order.ALL;
            }
            if (var16_27.contains((Object)PersonNameFormatter.Order.givenFirst) && var16_27.contains((Object)PersonNameFormatter.Order.surnameFirst)) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Conflicting Order values: " + (Set)var16_27));
            }
            PersonNameFormatter.Order foundOrder = firstGiven < firstSurname ? PersonNameFormatter.Order.givenFirst : PersonNameFormatter.Order.surnameFirst;
            PersonNameFormatter.Order first = (PersonNameFormatter.Order)((Object)var16_27.iterator().next());
            if (first != foundOrder) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Pattern order {0} is inconsistent with code order {1}", new Object[]{foundOrder, first}));
            }
        }
    }

    private void checkBasicPlaceholders(String value, List<CheckCLDR.CheckStatus> result) {
        int startPlaceHolder = 0;
        while (startPlaceHolder != -1 && startPlaceHolder < value.length()) {
            if ((startPlaceHolder = value.indexOf(123, startPlaceHolder + 1)) == -1) continue;
            int endPlaceHolder = value.indexOf(125, startPlaceHolder + 1);
            if (endPlaceHolder == -1) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid placeholder (missing terminator) in value \u00ab" + value + "\u00bb"));
                continue;
            }
            String placeHolderString = value.substring(startPlaceHolder + 1, endPlaceHolder);
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(placeHolderString);
            if (!matcher.matches()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid placeholder (contents \"" + placeHolderString + "\") in value \"" + value + "\""));
            }
            startPlaceHolder = endPlaceHolder;
        }
    }

    private void checkListPatterns(String path, String value, List<CheckCLDR.CheckStatus> result) {
        if (path.startsWith("//ldml/listPatterns/listPattern")) {
            XPathParts parts = XPathParts.getFrozenInstance(path);
            switch (parts.getAttributeValue(-1, "type")) {
                case "start": {
                    this.checkNothingAfter1(value, result);
                    break;
                }
                case "middle": {
                    this.checkNothingBefore0(value, result);
                    this.checkNothingAfter1(value, result);
                    break;
                }
                case "end": {
                    this.checkNothingBefore0(value, result);
                    break;
                }
                case "2": {
                    int pos1 = value.indexOf("{0}");
                    int pos2 = value.indexOf("{1}");
                    if (pos1 <= pos2) break;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb: the placeholder {0} must be before {1}."));
                    break;
                }
                case "3": {
                    int pos1 = value.indexOf("{0}");
                    int pos2 = value.indexOf("{1}");
                    int pos3 = value.indexOf("{2}");
                    if (pos1 <= pos2 && pos2 <= pos3) break;
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb: the placeholders {0}, {1}, {2} must appear in that order."));
                }
            }
        }
    }

    public static void checkInitialPattern(CheckAccessor checkAccessor, String path, String value, List<CheckCLDR.CheckStatus> result) {
        String valueLiterals;
        if (path.contains("initialSequence") && !(valueLiterals = value.replace("{0}", "").replace("{1}", "")).isBlank()) {
            String literals;
            String otherPath = path.replace("initialSequence", "initial");
            String otherValue = checkAccessor.getStringValue(otherPath);
            if (otherValue != null && !(literals = otherValue.replace("{0}", "")).isBlank() && value.contains(literals)) {
                result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.namePlaceholderProblem).setMessage("The initialSequence pattern must not contain initial pattern literals: \u00ab" + literals + "\u00bb"));
                return;
            }
            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.namePlaceholderProblem).setMessage("Non-space characters are discouraged in the initialSequence pattern: \u00ab" + valueLiterals.replace(" ", "") + "\u00bb"));
        }
    }

    public static void checkForeignSpaceReplacement(CheckAccessor checkAccessor, String value, List<CheckCLDR.CheckStatus> result) {
        if (!allowedForeignSpaceReplacements.containsAll(value) && !value.equals("\u2191\u2191\u2191")) {
            result.add(new CheckCLDR.CheckStatus().setCause(checkAccessor).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidLocale).setMessage("Invalid choice, must be punctuation or a space: \u00ab" + value + "\u00bb"));
        }
    }

    private static String modifiedFieldValue(CheckAccessor checkAccessor, XPathParts parts, PersonNameFormatter.Field field, Set<PersonNameFormatter.Modifier> modifiers, PersonNameFormatter.Modifier toAdd) {
        String modPath;
        String value;
        Sets.SetView<PersonNameFormatter.Modifier> adjustedModifiers = Sets.difference(modifiers, CORE_AND_PREFIX);
        if (toAdd != null) {
            switch (toAdd) {
                case core: {
                    adjustedModifiers = Sets.union(adjustedModifiers, SINGLE_CORE);
                    break;
                }
                case prefix: {
                    adjustedModifiers = Sets.union(adjustedModifiers, SINGLE_PREFIX);
                    break;
                }
            }
        }
        return "\u2205\u2205\u2205".equals(value = checkAccessor.getStringValue(modPath = parts.cloneAsThawed().setAttribute(-1, "type", new PersonNameFormatter.ModifiedField(field, adjustedModifiers).toString()).toString())) ? null : value;
    }

    public static Set<String> checkForErrorsAndGetLocales(String locale, String value, Set<String> items) {
        if (value.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> orderErrors = null;
        for (String item : SPLIT_SPACE.split(value)) {
            boolean mv;
            boolean bl = mv = item.equals(locale) || CLDR_LOCALES_FOR_NAME_ORDER.contains(item);
            if (!mv) {
                if (orderErrors == null) {
                    orderErrors = new LinkedHashSet<String>();
                }
                orderErrors.add(item);
                continue;
            }
            items.add(item);
        }
        return orderErrors;
    }

    private void checkNothingAfter1(String value, List<CheckCLDR.CheckStatus> result) {
        if (!value.endsWith("{1}")) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb, no text can come after {1}."));
        }
    }

    private void checkNothingBefore0(String value, List<CheckCLDR.CheckStatus> result) {
        if (!value.startsWith("{0}")) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.invalidPlaceHolder).setMessage("Invalid list pattern \u00ab" + value + "\u00bb, no text can come before {0}."));
        }
    }

    static {
        HashSet<String> valid = new HashSet<String>();
        valid.addAll(CLDRConfig.getInstance().getCldrFactory().getAvailable());
        valid.add("zxx");
        valid.add("und");
        CLDR_LOCALES_FOR_NAME_ORDER = ImmutableSet.copyOf(valid);
        SINGLE_CORE = ImmutableSet.of(PersonNameFormatter.Modifier.core);
        SINGLE_PREFIX = ImmutableSet.of(PersonNameFormatter.Modifier.prefix);
        CORE_AND_PREFIX = ImmutableSet.of(PersonNameFormatter.Modifier.prefix, PersonNameFormatter.Modifier.core);
        givenFirstSortingLocales = ImmutableSet.of("is", "ta", "si");
        allowedForeignSpaceReplacements = new UnicodeSet("[[:whitespace:][:punctuation:]]");
    }
}

