/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.ibm.icu.dev.tool.shared.UOption;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.test.CLDRTest;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.test.QuickCheck;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.tool.VettingAdder;
import org.unicode.cldr.util.Annotations;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DateTimeCanonicalizer;
import org.unicode.cldr.util.DowngradePaths;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.FileProcessor;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.PathChecker;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.RegexLookup;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.SimpleFactory;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.XPathParts;

@CLDRTool(alias="modify", description="Tool for applying modifications to the CLDR files. Use -h to see the options.")
public class CLDRModify {
    static final String DEBUG_PATHS = null;
    static final boolean COMMENT_REMOVALS = false;
    static final UnicodeSet whitespace = new UnicodeSet("[:whitespace:]").freeze();
    static final UnicodeSet HEX = new UnicodeSet("[a-fA-F0-9]").freeze();
    private static final DtdData dtdData = DtdData.getInstance(DtdType.ldml);
    static FixList fixList = new FixList();
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int SOURCEDIR = 2;
    private static final int DESTDIR = 3;
    private static final int MATCH = 4;
    private static final int JOIN = 5;
    private static final int MINIMIZE = 6;
    private static final int FIX = 7;
    private static final int JOIN_ARGS = 8;
    private static final int VET_ADD = 9;
    private static final int RESOLVE = 10;
    private static final int PATH = 11;
    private static final int USER = 12;
    private static final int ALL_DIRS = 13;
    private static final int CHECK = 14;
    private static final int KONFIG = 15;
    private static final int RETAIN = 16;
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.SOURCEDIR().setDefault(CLDRPaths.MAIN_DIRECTORY), UOption.DESTDIR().setDefault(CLDRPaths.GEN_DIRECTORY + "cldrModify/"), UOption.create("match", 'm', 1).setDefault(".*"), UOption.create("join", 'j', 2), UOption.create("minimize", 'r', 0), UOption.create("fix", 'f', 2), UOption.create("join-args", 'i', 2), UOption.create("vet", 'v', 2), UOption.create("resolve", 'z', 2), UOption.create("path", 'p', 1), UOption.create("user", 'u', 1), UOption.create("all", 'a', 1), UOption.create("check", 'c', 0), UOption.create("konfig", 'k', 2).setDefault("modify_config.txt"), UOption.create("Retain", 'R', 0)};
    private static final UnicodeSet allMergeOptions = new UnicodeSet("[rcd]");
    static final String HELP_TEXT1 = "Use the following options\n-h or -?\t for this message\n-" + CLDRModify.options[2].shortName + "\t source directory. Default = -s" + CldrUtility.getCanonicalName(CLDRPaths.MAIN_DIRECTORY) + "\n\tExample:-sC:\\Unicode-CVS2\\cldr\\common\\gen\\source\\\n-" + CLDRModify.options[3].shortName + "\t destination directory. Default = -d" + CldrUtility.getCanonicalName(CLDRPaths.GEN_DIRECTORY + "main/") + "\n-m<regex>\t to restrict the locales to what matches <regex>\n-j<merge_dir>/X'\t to merge two sets of files together (from <source_dir>/X and <merge_dir>/X', \n\twhere * in X' is replaced by X).\n\tExample:-jC:\\Unicode-CVS2\\cldr\\dropbox\\to_be_merged\\missing\\missing_*\n-i\t merge arguments:\n\tr\t replace contents (otherwise new data will be draft=\"unconfirmed\")\n\tc\t ignore comments in <merge_dir> files\n-v\t incorporate vetting information, and generate diff files.\n-z\t generate resolved files\n-p\t set path for -fx\n-u\t set user for -fb\n-a\t pattern: recurse over all subdirectories that match pattern\n-c\t check that resulting xml files are valid. Requires that a dtd directory be copied to the output directory, in the appropriate location.\n-k\t config_file\twith -fk perform modifications according to what is in the config file. For format details, see:\n\t\thttp://cldr.unicode.org/development/cldr-big-red-switch/cldrmodify-passes/cldrmodify-config.\n-R\t retain unchanged files\n-f\t to perform various fixes on the files (add following arguments to specify which ones, eg -fxi)\n";
    static final String HELP_TEXT2 = "Note: A set of bat files are also generated in <dest_dir>/diff. They will invoke a comparison program on the results.\n";
    private static final boolean SHOW_DETAILS = false;
    private static boolean SHOW_PROCESSING = false;
    static String sourceInput;
    static final Splitter COMMA_SEMI;
    protected static final boolean NUMBER_SYSTEM_HACK = true;
    static PathChecker pathChecker;
    static Set<String> totalSkeletons;
    static Map<String, String> rootUnitMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        UOption.parseArgs(args, options);
        if (CLDRModify.options[0].doesOccur || CLDRModify.options[1].doesOccur) {
            System.out.println(HELP_TEXT1 + fixList.showHelp() + HELP_TEXT2);
            return;
        }
        CLDRModify.checkSuboptions(options[7], fixList.getOptions());
        CLDRModify.checkSuboptions(options[8], allMergeOptions);
        String recurseOnDirectories = CLDRModify.options[13].value;
        boolean makeResolved = CLDRModify.options[10].doesOccur;
        sourceInput = CLDRModify.options[2].value;
        String destInput = CLDRModify.options[3].value;
        if (recurseOnDirectories != null) {
            sourceInput = CLDRModify.removeSuffix(sourceInput, "main/", "main");
            destInput = CLDRModify.removeSuffix(destInput, "main/", "main");
        }
        String sourceDirBase = CldrUtility.checkValidDirectory(sourceInput);
        String targetDirBase = CldrUtility.checkValidDirectory(destInput);
        System.out.format("Source:\t%s\n", sourceDirBase);
        System.out.format("Target:\t%s\n", targetDirBase);
        boolean retainUnchangedFiles = CLDRModify.options[16].doesOccur;
        TreeSet<Object> dirSet = new TreeSet<Object>();
        if (recurseOnDirectories == null) {
            dirSet.add("");
        } else {
            String[] subdirs = new File(sourceDirBase).list();
            Matcher matcher = PatternCache.get(recurseOnDirectories).matcher("");
            for (String subdir : subdirs) {
                if (!matcher.reset(subdir).find()) continue;
                dirSet.add(subdir + "/");
            }
        }
        for (String string : dirSet) {
            String sourceDir = sourceDirBase + string;
            if (!new File(sourceDir).isDirectory()) continue;
            String targetDir = targetDirBase + string;
            try {
                Serializable temp;
                File[] paths;
                Factory cldrFactoryForAvailable;
                Factory cldrFactory = cldrFactoryForAvailable = Factory.make(sourceDir, ".*");
                if (sourceDir.endsWith("/seed/annotations/") && "Q".equals(CLDRModify.options[7].value)) {
                    System.err.println("Correcting factory so that annotations can load, including " + CLDRPaths.ANNOTATIONS_DIRECTORY);
                    paths = new File[]{new File(sourceDir), new File(CLDRPaths.ANNOTATIONS_DIRECTORY)};
                    cldrFactory = SimpleFactory.make(paths, ".*");
                } else if (sourceDir.contains("/seed/") && "p".equals(CLDRModify.options[7].value)) {
                    System.err.println("Correcting factory to enable getting root");
                    paths = new File[]{new File(sourceDir), new File(CLDRPaths.ANNOTATIONS_DIRECTORY), new File(CLDRPaths.MAIN_DIRECTORY)};
                    cldrFactory = SimpleFactory.make(paths, ".*");
                } else {
                    System.err.println("!!! " + sourceDir);
                }
                if (CLDRModify.options[9].doesOccur) {
                    VettingAdder va = new VettingAdder(CLDRModify.options[9].value);
                    va.showFiles(cldrFactory, targetDir);
                    return;
                }
                Factory mergeFactory = null;
                String join_prefix = "";
                String join_postfix = "";
                if (CLDRModify.options[5].doesOccur) {
                    String mergeDir = CLDRModify.options[5].value;
                    temp = new File(mergeDir);
                    mergeDir = CldrUtility.checkValidDirectory(((File)temp).getParent() + File.separator);
                    String filename = ((File)temp).getName();
                    join_postfix = "";
                    join_prefix = "";
                    int pos = filename.indexOf("*");
                    if (pos >= 0) {
                        join_prefix = filename.substring(0, pos);
                        join_postfix = filename.substring(pos + 1);
                    }
                    mergeFactory = Factory.make(mergeDir, ".*");
                }
                TreeSet<String> locales = new TreeSet<String>(cldrFactoryForAvailable.getAvailable());
                if (mergeFactory != null) {
                    temp = new TreeSet<String>(mergeFactory.getAvailable());
                    TreeSet<String> locales3 = new TreeSet<String>();
                    Iterator pos = temp.iterator();
                    while (pos.hasNext()) {
                        String locale = (String)pos.next();
                        if (!locale.startsWith(join_prefix) || !locale.endsWith(join_postfix)) continue;
                        locales3.add(locale.substring(join_prefix.length(), locale.length() - join_postfix.length()));
                    }
                    locales.retainAll(locales3);
                    System.out.println("Merging: " + locales3);
                }
                new CldrUtility.MatcherFilter(CLDRModify.options[4].value).retainAll(locales);
                fixList.handleSetup();
                long lastTime = System.currentTimeMillis();
                int spin = 0;
                System.out.format(locales.size() + " Locales:\t%s\n", ((Object)locales).toString());
                int totalRemoved = 0;
                for (String test : locales) {
                    long now;
                    ++spin;
                    if (SHOW_PROCESSING && (now = System.currentTimeMillis()) - lastTime > 5000L) {
                        System.out.println(" .. still processing " + test + " [" + spin + "/" + locales.size() + "]");
                        lastTime = now;
                    }
                    CLDRFile originalCldrFile = cldrFactory.make(test, makeResolved);
                    CLDRFile k = originalCldrFile.cloneAsThawed();
                    if (DEBUG_PATHS != null) {
                        System.out.println("Debug1 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                    }
                    if (mergeFactory != null) {
                        int mergeOption = 2;
                        CLDRFile toMergeIn = mergeFactory.make(join_prefix + test + join_postfix, false).cloneAsThawed();
                        if (toMergeIn != null) {
                            if (CLDRModify.options[8].doesOccur) {
                                if (CLDRModify.options[8].value.indexOf("r") >= 0) {
                                    mergeOption = 3;
                                }
                                if (CLDRModify.options[8].value.indexOf("d") >= 0) {
                                    mergeOption = 1;
                                }
                                if (CLDRModify.options[8].value.indexOf("c") >= 0) {
                                    toMergeIn.clearComments();
                                }
                                if (CLDRModify.options[8].value.indexOf("x") >= 0) {
                                    CLDRModify.removePosix(toMergeIn);
                                }
                            }
                            toMergeIn.makeDraft(CLDRFile.DraftStatus.contributed);
                            k.putAll(toMergeIn, mergeOption);
                        }
                        k.removeComment(" The following are strings that are not found in the locale (currently), but need valid translations for localizing timezones. ");
                    }
                    if (DEBUG_PATHS != null) {
                        System.out.println("Debug2 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                    }
                    if (CLDRModify.options[7].doesOccur) {
                        CLDRModify.fix(k, CLDRModify.options[7].value, CLDRModify.options[15].value, cldrFactory);
                        System.out.println("#TOTAL\tItems changed: " + CLDRModify.fixList.totalChanged);
                    }
                    if (DEBUG_PATHS != null) {
                        System.out.println("Debug3 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                    }
                    if (DEBUG_PATHS != null) {
                        System.out.println("Debug4 (" + test + "):\t" + k.toString(DEBUG_PATHS));
                    }
                    PrintWriter pw = FileUtilities.openUTF8Writer(targetDir, test + ".xml");
                    String testPath = "//ldml/dates/calendars/calendar[@type=\"persian\"]/months/monthContext[@type=\"format\"]/monthWidth[@type=\"abbreviated\"]/month[@type=\"1\"]";
                    k.write(pw);
                    pw.close();
                    File oldFile = new File(sourceDir, test + ".xml");
                    File newFile = new File(targetDir, test + ".xml");
                    if (!retainUnchangedFiles && !oldFile.equals(newFile) && CLDRModify.equalsSkippingCopyright(oldFile, newFile)) {
                        newFile.delete();
                        continue;
                    }
                    if (!CLDRModify.options[14].doesOccur) continue;
                    QuickCheck.check(new File(targetDir, test + ".xml"));
                }
                if (totalSkeletons.size() != 0) {
                    System.out.println("Total Skeletons" + totalSkeletons);
                }
                if (totalRemoved <= 0) continue;
                System.out.println("# Removed:\t" + totalRemoved);
            }
            finally {
                fixList.handleCleanup();
                System.out.println("Done -- Elapsed time: " + (double)(System.currentTimeMillis() - startTime) / 60000.0 + " minutes");
            }
        }
    }

    public static boolean equalsSkippingCopyright(File oldFile, File newFile) {
        String newLine;
        String oldLine;
        Iterator<String> oldIterator = FileUtilities.in(oldFile).iterator();
        Iterator<String> newIterator = FileUtilities.in(newFile).iterator();
        do {
            boolean newHasNext;
            boolean oldHasNext;
            if ((oldHasNext = oldIterator.hasNext()) != (newHasNext = newIterator.hasNext())) {
                return false;
            }
            if (oldHasNext) continue;
            return true;
        } while ((oldLine = oldIterator.next()).equals(newLine = newIterator.next()) || oldLine.startsWith("<!-- Copyright \u00a9") && newLine.startsWith("<!-- Copyright \u00a9"));
        return false;
    }

    private static String removeSuffix(String value, String ... suffices) {
        for (String suffix : suffices) {
            if (!value.endsWith(suffix)) continue;
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static void checkSuboptions(UOption givenOptions, UnicodeSet allowedOptions) {
        if (givenOptions.doesOccur && !allowedOptions.containsAll(givenOptions.value)) {
            throw new IllegalArgumentException("Illegal sub-options for " + givenOptions.shortName + ": " + new UnicodeSet().addAll(givenOptions.value).removeAll(allowedOptions) + "\nUse -? for help.");
        }
    }

    private static void removePosix(CLDRFile toMergeIn) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String xpath : toMergeIn) {
            if (!xpath.startsWith("//ldml/posix")) continue;
            toRemove.add(xpath);
        }
        toMergeIn.removeAll(toRemove, false);
    }

    public static String getLast2Dirs(File sourceDir1) {
        String[] pathElements = sourceDir1.toString().split("/");
        return pathElements[pathElements.length - 2] + "/" + pathElements[pathElements.length - 1] + "/";
    }

    static void fixIdenticalChildren(Factory cldrFactory, CLDRFile k, CLDRFile replacements) {
        String key = k.getLocaleID();
        if (key.equals("root")) {
            return;
        }
        Set<String> availableChildren = cldrFactory.getAvailableWithParent(key, true);
        if (availableChildren.size() == 0) {
            return;
        }
        HashSet<String> skipPaths = new HashSet<String>();
        TreeMap<String, ValuePair> haveSameValues = new TreeMap<String, ValuePair>();
        CLDRFile resolvedFile = cldrFactory.make(key, true);
        resolvedFile.forEach(skipPaths::add);
        for (String locale : availableChildren) {
            if (locale.indexOf("POSIX") >= 0) continue;
            CLDRFile item = cldrFactory.make(locale, false);
            for (String xpath : item) {
                if (skipPaths.contains(xpath) || xpath.indexOf("/identity") >= 0 || xpath.startsWith("//ldml/numbers/currencies/currency") || xpath.startsWith("//ldml/dates/timeZoneNames/metazone[") || xpath.indexOf("[@alt") >= 0 || xpath.indexOf("/alias") >= 0) continue;
                ValuePair v1 = new ValuePair();
                v1.value = item.getStringValue(xpath);
                v1.fullxpath = item.getFullXPath(xpath);
                ValuePair vAlready = (ValuePair)haveSameValues.get(xpath);
                if (vAlready == null) {
                    haveSameValues.put(xpath, v1);
                    continue;
                }
                if (v1.value.equals(vAlready.value) && v1.fullxpath.equals(vAlready.fullxpath)) continue;
                skipPaths.add(xpath);
                haveSameValues.remove(xpath);
            }
        }
        for (String xpath : haveSameValues.keySet()) {
            ValuePair v = (ValuePair)haveSameValues.get(xpath);
            replacements.add(v.fullxpath, v.value);
        }
    }

    static void fixAltProposed() {
        throw new IllegalArgumentException();
    }

    private static void fix(CLDRFile k, String inputOptions, String config, Factory cldrFactory) {
        TreeSet<String> removal = new TreeSet<String>(k.getComparator());
        CLDRFile replacements = SimpleFactory.makeFile("temp");
        fixList.setFile(k, inputOptions, cldrFactory, removal, replacements);
        for (String xpath : k) {
            fixList.handlePath(xpath);
        }
        fixList.handleEnd();
        if (inputOptions.indexOf(118) >= 0) {
            CLDRTest.checkAttributeValidity(k, null, removal);
        }
        if (inputOptions.indexOf(105) >= 0) {
            CLDRModify.fixIdenticalChildren(cldrFactory, k, replacements);
        }
        if (removal.size() != 0) {
            k.removeAll(removal, false);
        }
        k.putAll(replacements, 1);
    }

    private static int stepsFromRoot(String origLoc) {
        int steps = 0;
        String loc = origLoc;
        while (!"root".equals(loc)) {
            if ((loc = LocaleIDParser.getParent(loc)) == null) {
                throw new IllegalArgumentException("Missing root in inheritance chain");
            }
            ++steps;
        }
        System.out.println("stepsFromRoot = " + steps + " for " + origLoc);
        return steps;
    }

    public static void testJavaSemantics() {
        Collator caseInsensitive = Collator.getInstance(ULocale.ROOT);
        caseInsensitive.setStrength(1);
        TreeSet<Object> setWithCaseInsensitive = new TreeSet<Object>(caseInsensitive);
        setWithCaseInsensitive.addAll(Arrays.asList("a", "b", "c"));
        TreeSet<String> plainSet = new TreeSet<String>();
        plainSet.addAll(Arrays.asList("a", "b", "B"));
        System.out.println("S1 equals S2?\t" + setWithCaseInsensitive.equals(plainSet));
        System.out.println("S2 equals S1?\t" + plainSet.equals(setWithCaseInsensitive));
        setWithCaseInsensitive.removeAll(plainSet);
        System.out.println("S1 removeAll S2 is empty?\t" + setWithCaseInsensitive.isEmpty());
    }

    static {
        COMMA_SEMI = Splitter.on(Pattern.compile("[,;|]")).trimResults().omitEmptyStrings();
        pathChecker = new PathChecker();
        totalSkeletons = new HashSet<String>();
        rootUnitMap = new HashMap<String, String>();
        rootUnitMap.put("second", "s");
        rootUnitMap.put("minute", "min");
        rootUnitMap.put("hour", "h");
        rootUnitMap.put("day", "d");
        rootUnitMap.put("week", "w");
        rootUnitMap.put("month", "m");
        rootUnitMap.put("year", "y");
        fixList.add('z', "Remove deprecated elements", new CLDRFilter(){

            public boolean isDeprecated(DtdType type, String element, String attribute, String value) {
                return DtdData.getInstance(type).isDeprecated(element, attribute, value);
            }

            public boolean isDeprecated(DtdType type, String path) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                for (int i = 0; i < parts.size(); ++i) {
                    String element = parts.getElement(i);
                    if (this.isDeprecated(type, element, "*", "*")) {
                        return true;
                    }
                    for (Map.Entry<String, String> entry : parts.getAttributes(i).entrySet()) {
                        String value;
                        String attribute = entry.getKey();
                        if (!this.isDeprecated(type, element, attribute, value = entry.getValue())) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void handlePath(String xpath) {
                String fullPath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullPath);
                for (int i = 0; i < parts.size(); ++i) {
                    String element = parts.getElement(i);
                    if (dtdData.isDeprecated(element, "*", "*")) {
                        this.remove(fullPath, "Deprecated element");
                        return;
                    }
                    for (Map.Entry<String, String> entry : parts.getAttributes(i).entrySet()) {
                        String value;
                        String attribute = entry.getKey();
                        if (!dtdData.isDeprecated(element, attribute, value = entry.getValue())) continue;
                        this.remove(fullPath, "Element with deprecated attribute(s)");
                    }
                }
            }
        });
        fixList.add('e', "fix Interindic", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                if (xpath.indexOf("=\"InterIndic\"") < 0) {
                    return;
                }
                String v = this.cldrFileToFilter.getStringValue(xpath);
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts fullparts = XPathParts.getFrozenInstance(fullXPath);
                Map<String, String> attributes = fullparts.findAttributes("transform");
                String oldValue = attributes.get("direction");
                if ("both".equals(oldValue)) {
                    attributes.put("direction", "forward");
                    this.replace(xpath, fullparts.toString(), v);
                }
            }
        });
        fixList.add('B', "fix bogus values", new CLDRFilter(){
            RegexLookup<Integer> paths = RegexLookup.of().setPatternTransform(RegexLookup.RegexFinderTransformPath2).add("//ldml/localeDisplayNames/languages/language[@type='([^']*)']", Integer.valueOf(0)).add("//ldml/localeDisplayNames/scripts/script[@type='([^']*)']", (Integer)0).add("//ldml/localeDisplayNames/territories/territory[@type='([^']*)']", (Integer)0).add("//ldml/dates/timeZoneNames/metazone[@type='([^']*)']", (Integer)0).add("//ldml/dates/timeZoneNames/zone[@type='([^']*)']/exemplarCity", (Integer)0).add("//ldml/numbers/currencies/currency[@type='([^']*)']/displayName", (Integer)0);
            Output<String[]> arguments = new Output();
            CLDRFile english = CLDRConfig.getInstance().getEnglish();
            boolean skip;

            @Override
            public void handleStart() {
                CLDRFile resolved = this.factory.make(this.cldrFileToFilter.getLocaleID(), true);
                UnicodeSet exemplars = resolved.getExemplarSet(CLDRFile.ExemplarType.main, CLDRFile.WinningChoice.WINNING);
                this.skip = exemplars.containsSome(97, 122);
            }

            @Override
            public void handlePath(String xpath) {
                if (this.skip) {
                    return;
                }
                Integer lookupValue = this.paths.get(xpath, null, this.arguments);
                if (lookupValue == null) {
                    return;
                }
                String type = ((String[])this.arguments.value)[1];
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(type)) {
                    this.remove(xpath, "Matches code");
                    return;
                }
                String evalue = this.english.getStringValue(xpath);
                if (value.equals(evalue)) {
                    this.remove(xpath, "Matches English");
                    return;
                }
            }
        });
        fixList.add('s', "fix alt accounting", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                if (!parts.containsAttributeValue("alt", "accounting")) {
                    return;
                }
                String oldFullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                String value = this.cldrFileToFilter.getStringValue(xpath);
                XPathParts fullparts = XPathParts.getFrozenInstance(oldFullXPath).cloneAsThawed();
                fullparts.removeAttribute("pattern", "alt");
                fullparts.setAttribute("currencyFormat", "type", "accounting");
                String newFullXPath = fullparts.toString();
                this.replace(oldFullXPath, newFullXPath, value, "Move alt=accounting value to new path");
            }
        });
        fixList.add('n', "add unit displayName", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                if (xpath.indexOf("/units/unitLength[@type=\"long\"]") < 0 || xpath.indexOf("/unitPattern[@count=\"other\"]") < 0 || xpath.indexOf("[@draft=\"unconfirmed\"]") >= 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String newValue = null;
                if (value.startsWith("{0}")) {
                    newValue = value.substring(3).trim();
                } else if (value.endsWith("{0}")) {
                    newValue = value.substring(0, value.length() - 3).trim();
                } else {
                    System.out.println("unitPattern-other does not start or end with \"{0}\": \"" + value + "\"");
                    return;
                }
                String oldFullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                String newFullXPath = oldFullXPath.substring(0, oldFullXPath.indexOf("unitPattern")).concat("displayName[@draft=\"provisional\"]");
                this.add(newFullXPath, newValue, "create unit displayName-long from unitPattern-long-other");
                String newFullXPathShort = newFullXPath.replace("[@type=\"long\"]", "[@type=\"short\"]");
                this.add(newFullXPathShort, newValue, "create unit displayName-short from unitPattern-long-other");
            }
        });
        fixList.add('x', "retain paths", new CLDRFilter(){
            Matcher m = null;

            @Override
            public void handlePath(String xpath) {
                String fullXPath;
                if (this.m == null) {
                    this.m = PatternCache.get(CLDRModify.options[11].value).matcher("");
                }
                if (!this.m.reset(fullXPath = this.cldrFileToFilter.getFullXPath(xpath)).matches()) {
                    this.remove(xpath);
                }
            }
        });
        fixList.add('l', "change language code", new CLDRFilter(){
            private CLDRFile resolved;

            @Override
            public void handleStart() {
                this.resolved = this.factory.make(this.cldrFileToFilter.getLocaleID(), true);
            }

            @Override
            public void handlePath(String xpath) {
                if (!xpath.contains("/language")) {
                    return;
                }
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                String languageCode = parts.findAttributeValue("language", "type");
                String v = this.resolved.getStringValue(xpath);
                if (!languageCode.equals("swc")) {
                    return;
                }
                parts = parts.cloneAsThawed();
                parts.setAttribute("language", "type", "sw_CD");
                this.replace(xpath, parts.toString(), v);
            }
        });
        fixList.add('g', "Swap alt/non-alt values for Czechia", new CLDRFilter(){

            @Override
            public void handleStart() {
            }

            @Override
            public void handlePath(String xpath) {
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                if (!parts.containsAttributeValue("alt", "variant") || !parts.containsAttributeValue("type", "CZ")) {
                    return;
                }
                String variantValue = this.cldrFileToFilter.getStringValue(xpath);
                String nonVariantXpath = xpath.replaceAll("\\[\\@alt=\"variant\"\\]", "");
                String nonVariantValue = this.cldrFileToFilter.getStringValue(nonVariantXpath);
                this.replace(xpath, xpath, nonVariantValue);
                this.replace(nonVariantXpath, nonVariantXpath, variantValue);
            }
        });
        fixList.add('u', "fix duration unit patterns", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                if (!xpath.contains("/units")) {
                    return;
                }
                if (!xpath.contains("/durationUnitPattern")) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullXPath);
                String unittype = parts.findAttributeValue("durationUnit", "type");
                String newFullXpath = "//ldml/units/durationUnit[@type=\"" + unittype + "\"]/durationUnitPattern";
                this.replace(fullXPath, newFullXpath, value, "converting to new duration unit structure");
            }
        });
        fixList.add('a', "Fix 0/1", new CLDRFilter(){
            final UnicodeSet DIGITS = new UnicodeSet("[0-9]").freeze();
            SupplementalDataInfo.PluralInfo info;

            @Override
            public void handleStart() {
                this.info = SupplementalDataInfo.getInstance().getPlurals(this.localeID);
            }

            @Override
            public void handlePath(String xpath) {
                if (xpath.indexOf("count") < 0) {
                    return;
                }
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullpath).cloneAsThawed();
                String countValue = parts.getAttributeValue(-1, "count");
                if (!this.DIGITS.containsAll(countValue)) {
                    return;
                }
                int intValue = Integer.parseInt(countValue);
                SupplementalDataInfo.PluralInfo.Count count = this.info.getCount(intValue);
                parts.setAttribute(-1, "count", count.toString());
                String newPath = parts.toString();
                String oldValue = this.cldrFileToFilter.getStringValue(newPath);
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (oldValue != null) {
                    String fixed = oldValue.replace("{0}", countValue);
                    if (value.equals(oldValue) || value.equals(fixed)) {
                        this.remove(fullpath, "Superfluous given: " + count + "\u2192\u00ab" + oldValue + "\u00bb");
                    } else {
                        this.remove(fullpath, "Can\u2019t replace: " + count + "\u2192\u00ab" + oldValue + "\u00bb");
                    }
                    return;
                }
                this.replace(fullpath, newPath, value, "Moving 0/1");
            }
        });
        fixList.add('b', "Prep for bulk import", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                if (!CLDRModify.options[12].doesOccur) {
                    return;
                }
                String userID = CLDRModify.options[12].value;
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                String value = this.cldrFileToFilter.getStringValue(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullpath).cloneAsThawed();
                parts.addAttribute("draft", "unconfirmed");
                parts.addAttribute("alt", "proposed-u" + userID + "-implicit1.8");
                String newPath = parts.toString();
                this.replace(fullpath, newPath, value);
            }
        });
        fixList.add('c', "Fix transiton from an old currency code to a new one", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                String oldCurrencyCode = "VEF";
                String newCurrencyCode = "VES";
                int fromDate = 2008;
                int toDate = 2018;
                String leadingParenString = " (";
                String trailingParenString = ")";
                String separator = "\u2013";
                String languageTag = "root";
                if (xpath.indexOf("/currency[@type=\"" + oldCurrencyCode + "\"]/displayName") < 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                String newFullXPath = fullXPath.replace(oldCurrencyCode, newCurrencyCode);
                this.cldrFileToFilter.add(newFullXPath, value);
                String localeID = this.cldrFileToFilter.getLocaleID();
                if (localeID.equals("ne")) {
                    languageTag = "root-u-nu-deva";
                } else if (localeID.equals("bn")) {
                    languageTag = "root-u-nu-beng";
                } else if (localeID.equals("ar")) {
                    leadingParenString = " - ";
                    trailingParenString = "";
                } else if (localeID.equals("fa")) {
                    languageTag = "root-u-nu-arabext";
                    separator = Utility.unescape(" \\u062A\\u0627 ");
                }
                NumberFormat nf = NumberFormat.getInstance(ULocale.forLanguageTag(languageTag));
                nf.setGroupingUsed(false);
                String tagString = leadingParenString + nf.format(fromDate) + separator + nf.format(toDate) + trailingParenString;
                this.replace(fullXPath, fullXPath, value + tagString);
            }
        });
        fixList.add('p', "input-processor", new CLDRFilter(){
            private DisplayAndInputProcessor inputProcessor;

            @Override
            public void handleStart() {
                this.inputProcessor = new DisplayAndInputProcessor(this.cldrFileToFilter, true);
                this.inputProcessor.enableInheritanceReplacement(this.getResolved());
            }

            @Override
            public void handleEnd() {
                this.inputProcessor = null;
            }

            @Override
            public void handlePath(String xpath) {
                String newValue;
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(newValue = this.inputProcessor.processInput(xpath, value, null))) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, newValue);
            }
        });
        fixList.add('P', "input-Processor-no-inheritance-replacement", new CLDRFilter(){
            private DisplayAndInputProcessor inputProcessor;

            @Override
            public void handleStart() {
                this.inputProcessor = new DisplayAndInputProcessor(this.cldrFileToFilter, true);
            }

            @Override
            public void handleEnd() {
                this.inputProcessor = null;
            }

            @Override
            public void handlePath(String xpath) {
                String newValue;
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(newValue = this.inputProcessor.processInput(xpath, value, null))) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, newValue);
            }
        });
        fixList.add('I', "Inheritance-substitution", new CLDRFilter(){
            private DisplayAndInputProcessor inputProcessor;
            private final int STEPS_FROM_ROOT = 1;

            @Override
            public void handleStart() {
                int steps = CLDRModify.stepsFromRoot(this.cldrFileToFilter.getLocaleID());
                if (steps == 1) {
                    this.inputProcessor = new DisplayAndInputProcessor(this.cldrFileToFilter, true);
                    this.inputProcessor.enableInheritanceReplacement(this.getResolved());
                } else {
                    this.inputProcessor = null;
                }
            }

            @Override
            public void handleEnd() {
                this.inputProcessor = null;
            }

            @Override
            public void handlePath(String xpath) {
                String newValue;
                if (this.inputProcessor == null) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(newValue = this.inputProcessor.replaceBaileyWithInheritanceMarker(xpath, value))) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, newValue);
            }
        });
        fixList.add('U', "Un-drop inheritance", new CLDRFilter(){
            private final String baseDir = "../2022_10_07_pre/";
            private final File[] list = new File[]{new File("../2022_10_07_pre/common/main/"), new File("../2022_10_07_pre/common/annotations/")};
            private Factory preFactory = null;
            private CLDRFile preFile = null;

            @Override
            public void handleStart() {
                if (this.preFactory == null) {
                    this.preFactory = SimpleFactory.make(this.list, ".*");
                }
                String localeID = this.cldrFileToFilter.getLocaleID();
                try {
                    this.preFile = this.preFactory.make(localeID, false);
                }
                catch (Exception e) {
                    System.out.println("Skipping " + localeID + " due to " + e);
                    this.preFile = null;
                }
            }

            @Override
            public void handlePath(String xpath) {
                String preValue;
                if (this.preFile == null) {
                    return;
                }
                if (xpath.contains("personName")) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (CldrUtility.INHERITANCE_MARKER.equals(value) && !CldrUtility.INHERITANCE_MARKER.equals(preValue = this.preFile.getStringValue(xpath))) {
                    String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                    this.replace(fullXPath, fullXPath, preValue);
                }
            }
        });
        fixList.add('t', "Fix missing count values groups", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                String[] missingCounts;
                if (xpath.indexOf("@count=\"other\"") < 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                for (String count : missingCounts = new String[]{"one"}) {
                    String newFullXPath = fullXPath.replace("other", count);
                    if (this.cldrFileToFilter.getWinningValue(newFullXPath) != null) continue;
                    this.add(newFullXPath, value, "Adding missing plural form");
                }
            }
        });
        fixList.add('f', "NFC (all but transforms, exemplarCharacters, pc, sc, tc, qc, ic)", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                String nfcValue;
                if (xpath.indexOf("/segmentation") >= 0 || xpath.indexOf("/transforms") >= 0 || xpath.indexOf("/exemplarCharacters") >= 0 || xpath.indexOf("/pc") >= 0 || xpath.indexOf("/sc") >= 0 || xpath.indexOf("/tc") >= 0 || xpath.indexOf("/qc") >= 0 || xpath.indexOf("/ic") >= 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value.equals(nfcValue = Normalizer.compose(value, false))) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, nfcValue);
            }
        });
        fixList.add('v', "remove illegal codes", new CLDRFilter(){
            StandardCodes sc = StandardCodes.make();
            String[] codeTypes = new String[]{"language", "script", "territory", "currency"};

            @Override
            public void handlePath(String xpath) {
                String code;
                if (xpath.indexOf("/currency") < 0 && xpath.indexOf("/timeZoneNames") < 0 && xpath.indexOf("/localeDisplayNames") < 0) {
                    return;
                }
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                for (int i = 0; i < this.codeTypes.length; ++i) {
                    code = parts.findAttributeValue(this.codeTypes[i], "type");
                    if (code == null) continue;
                    if (!this.sc.getGoodAvailableCodes(this.codeTypes[i]).contains(code)) {
                        this.remove(xpath);
                    }
                    return;
                }
                code = parts.findAttributeValue("zone", "type");
                if (code != null && code.indexOf("/GMT") >= 0) {
                    this.remove(xpath);
                }
            }
        });
        fixList.add('w', "fix alt='...proposed' when there is no alternative", new CLDRFilter(){
            private Set<String> newFullXPathSoFar = new HashSet<String>();

            @Override
            public void handlePath(String xpath) {
                if (xpath.indexOf("proposed") < 0) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullXPath).cloneAsThawed();
                String newFullXPath = parts.removeProposed().toString();
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String baseValue = this.cldrFileToFilter.getStringValue(newFullXPath);
                if (baseValue != null) {
                    String baseFullXPath;
                    if (value.equals(baseValue) && (baseFullXPath = this.cldrFileToFilter.getFullXPath(newFullXPath)).equals(newFullXPath)) {
                        this.remove(xpath, "alt=base");
                    }
                    return;
                }
                if (!this.newFullXPathSoFar.contains(newFullXPath)) {
                    this.replace(fullXPath, newFullXPath, value);
                    this.newFullXPathSoFar.add(newFullXPath);
                }
            }
        });
        fixList.add('S', "add datetimeSkeleton to dateFormat,timeFormat", new CLDRFilter(){
            DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getEmptyInstance();

            @Override
            public void handlePath(String xpath) {
                String patternValue;
                if (xpath.indexOf("/dateFormat[@type=\"standard\"]/pattern") < 0 && xpath.indexOf("/timeFormat[@type=\"standard\"]/pattern") < 0) {
                    return;
                }
                String skeletonValue = patternValue = this.cldrFileToFilter.getStringValue(xpath);
                if (!(patternValue.equals("\u2191\u2191\u2191") || (skeletonValue = this.dateTimePatternGenerator.getSkeleton(patternValue)) != null && skeletonValue.length() >= 1)) {
                    this.show("empty skeleton for datetime pattern \"" + patternValue + "\"", "path " + xpath);
                    return;
                }
                String patternFullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                String skeletonFullXPath = patternFullXPath.replace("/pattern[@type=\"standard\"]", "/datetimeSkeleton");
                this.add(skeletonFullXPath, skeletonValue, "create datetimeSkeleton from dateFormat/pattern or timeFormat/pattern");
            }
        });
        fixList.add('d', "fix dates", new CLDRFilter(){
            DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getEmptyInstance();
            DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
            Map<String, Set<String>> seenSoFar = new HashMap<String, Set<String>>();

            @Override
            public void handleStart() {
                this.seenSoFar.clear();
            }

            @Override
            public void handlePath(String xpath) {
                String id;
                if (xpath.contains("timeFormatLength") && xpath.contains("full")) {
                    String newValue;
                    String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                    String value = this.cldrFileToFilter.getStringValue(xpath);
                    boolean gotChange = false;
                    List<Object> list = this.formatParser.set(value).getItems();
                    for (int i = 0; i < list.size(); ++i) {
                        String itemString;
                        Object item = list.get(i);
                        if (!(item instanceof DateTimePatternGenerator.VariableField) || (itemString = item.toString()).charAt(0) != 'z') continue;
                        list.set(i, new DateTimePatternGenerator.VariableField(Utility.repeat("v", itemString.length())));
                        gotChange = true;
                    }
                    if (gotChange && value != (newValue = this.toStringWorkaround())) {
                        this.replace(xpath, fullpath, newValue);
                    }
                }
                if (xpath.indexOf("/availableFormats") < 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (value == null) {
                    return;
                }
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts fullparts = XPathParts.getFrozenInstance(fullpath);
                Map<String, String> attributes = fullparts.findAttributes("dateFormatItem");
                String oldID = id = attributes.get("id");
                try {
                    id = this.dateTimePatternGenerator.getBaseSkeleton(id);
                    if (id.equals(oldID)) {
                        return;
                    }
                    System.out.println(oldID + " => " + id);
                }
                catch (RuntimeException e) {
                    id = "[error]";
                    return;
                }
                attributes.put("id", id);
                totalSkeletons.add(id);
                this.replace(xpath, fullparts.toString(), value);
            }

            private String toStringWorkaround() {
                StringBuffer result = new StringBuffer();
                List<Object> items = this.formatParser.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (item instanceof String) {
                        result.append(this.formatParser.quoteLiteral((String)items.get(i)));
                        continue;
                    }
                    result.append(items.get(i).toString());
                }
                return result.toString();
            }
        });
        fixList.add('y', "fix years to be y (with exceptions)", new CLDRFilter(){
            DateTimeCanonicalizer dtc = new DateTimeCanonicalizer(true);
            Map<String, Set<String>> seenSoFar = new HashMap<String, Set<String>>();

            @Override
            public void handleStart() {
                this.seenSoFar.clear();
            }

            @Override
            public void handlePath(String xpath) {
                DateTimeCanonicalizer.DateTimePatternType datetimePatternType = DateTimeCanonicalizer.DateTimePatternType.fromPath(xpath);
                if (!DateTimeCanonicalizer.DateTimePatternType.STOCK_AVAILABLE_INTERVAL_PATTERNS.contains((Object)datetimePatternType)) {
                    return;
                }
                String oldValue = this.cldrFileToFilter.getStringValue(xpath);
                String value = this.dtc.getCanonicalDatePattern(xpath, oldValue, datetimePatternType);
                String fullPath = this.cldrFileToFilter.getFullXPath(xpath);
                if (value.equals(oldValue)) {
                    return;
                }
                this.replace(xpath, fullPath, value);
            }
        });
        fixList.add('j', "add year ranges from root to Japanese calendar eras", new CLDRFilter(){
            private CLDRFile rootFile;

            @Override
            public void handleStart() {
                this.rootFile = this.factory.make("root", false);
            }

            @Override
            public void handlePath(String xpath) {
                if (xpath.indexOf("/calendar[@type=\"japanese\"]/eras/era") < 0) {
                    return;
                }
                String rootEraValue = this.rootFile.getStringValue(xpath);
                int rootEraIndex = rootEraValue.indexOf(" (");
                if (rootEraIndex < 0) {
                    return;
                }
                String yearIntervalFormat = this.cldrFileToFilter.getStringValue("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"y\"]/greatestDifference[@id=\"y\"]");
                if (yearIntervalFormat == null) {
                    return;
                }
                String rangeMarker = yearIntervalFormat.replaceAll("[.y\u5e74\ub144]", "");
                String eraValue = this.cldrFileToFilter.getStringValue(xpath);
                if (eraValue.indexOf(40) >= 0 && eraValue.indexOf(rangeMarker) >= 0) {
                    return;
                }
                String rootYearRange = rootEraValue.substring(rootEraIndex);
                String appendYearRange = rootYearRange.replaceAll("[-\u2013]", rangeMarker);
                String newEraValue = eraValue.concat(appendYearRange);
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(xpath, fullpath, newEraValue);
            }
        });
        fixList.add('r', "fix references and standards", new CLDRFilter(){
            int currentRef = 500;
            Map<String, TreeMap<String, String>> locale_oldref_newref = new TreeMap<String, TreeMap<String, String>>();
            TreeMap<String, String> oldref_newref;

            @Override
            public void handleStart() {
                String locale = this.cldrFileToFilter.getLocaleID();
                this.oldref_newref = this.locale_oldref_newref.get(locale);
                if (this.oldref_newref == null) {
                    this.oldref_newref = new TreeMap();
                    this.locale_oldref_newref.put(locale, this.oldref_newref);
                }
            }

            @Override
            public void handlePath(String xpath) {
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                if (!fullpath.contains("reference")) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                XPathParts fullparts = XPathParts.getFrozenInstance(fullpath).cloneAsThawed();
                if ("reference".equals(fullparts.getElement(-1))) {
                    this.fixType(value, "type", fullpath, fullparts);
                } else if (fullparts.getAttributeValue(-1, "references") != null) {
                    this.fixType(value, "references", fullpath, fullparts);
                } else {
                    System.out.println("CLDRModify: Skipping: " + xpath);
                }
            }

            private void fixType(String value, String type, String oldFullPath, XPathParts fullparts) {
                String ref = fullparts.getAttributeValue(-1, type);
                if (whitespace.containsSome(ref)) {
                    throw new IllegalArgumentException("Whitespace in references");
                }
                String newRef = this.getNewRef(ref);
                fullparts.addAttribute(type, newRef);
                this.replace(oldFullPath, fullparts.toString(), value);
            }

            private String getNewRef(String ref) {
                Object newRef = this.oldref_newref.get(ref);
                if (newRef == null) {
                    newRef = String.valueOf(this.currentRef++);
                    newRef = "R" + Utility.repeat("0", 3 - ((String)newRef).length()) + (String)newRef;
                    this.oldref_newref.put(ref, (String)newRef);
                }
                return newRef;
            }
        });
        fixList.add('q', "fix annotation punctuation", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                if (!xpath.contains("/annotation")) {
                    return;
                }
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullpath);
                String cp = parts.getAttributeValue(2, "cp");
                String tts = parts.getAttributeValue(2, "tts");
                String type = parts.getAttributeValue(2, "type");
                if ("tts".equals(type)) {
                    return;
                }
                parts = parts.cloneAsThawed();
                String hex = "1F600";
                if (cp.startsWith("[")) {
                    UnicodeSet us = new UnicodeSet(cp);
                    if (us.size() == 1) {
                        cp = us.iterator().next();
                        hex = Utility.hex(cp);
                    } else {
                        hex = us.toString();
                    }
                    parts.putAttributeValue(2, "cp", cp);
                }
                parts.removeAttribute(2, "tts");
                if (tts != null) {
                    String newTts = CldrUtility.join(COMMA_SEMI.splitToList(tts), ", ");
                    XPathParts parts2 = parts.cloneAsThawed();
                    parts2.putAttributeValue(2, "type", "tts");
                    this.add(parts2.toString(), newTts, "separate tts");
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String newValue = CldrUtility.join(COMMA_SEMI.splitToList(value), " | ");
                String newFullPath = parts.toString();
                XPathParts.Comments comments = this.cldrFileToFilter.getXpath_comments();
                Object comment = comments.removeComment(XPathParts.Comments.CommentType.PREBLOCK, xpath);
                comment = hex + (String)(comment == null ? "" : " " + (String)comment);
                comments.addComment(XPathParts.Comments.CommentType.PREBLOCK, newFullPath, (String)comment);
                if (!fullpath.equals(newFullPath) || !value.equals(newValue)) {
                    this.replace(fullpath, newFullPath, newValue);
                }
            }
        });
        fixList.add('Q', "add annotation names to keywords", new CLDRFilter(){
            Set<String> available = Annotations.getAllAvailable();
            TreeSet<String> sorted = new TreeSet<Object>(Collator.getInstance(ULocale.ROOT));
            CLDRFile resolved;
            final Map<String, String> keywordPaths = new HashMap<String, String>();

            @Override
            public void handleStart() {
                String localeID = this.cldrFileToFilter.getLocaleID();
                if (!this.available.contains(localeID)) {
                    throw new IllegalArgumentException("no annotations available, probably wrong directory");
                }
                this.resolved = this.factory.make(localeID, true);
                for (String xpath : this.cldrFileToFilter) {
                    this.rememberKeywordPaths(xpath);
                }
            }

            private void rememberKeywordPaths(String xpath) {
                String fullpath;
                XPathParts parts;
                String type;
                if (xpath.contains("/annotation") && (type = (parts = XPathParts.getFrozenInstance(fullpath = this.cldrFileToFilter.getFullXPath(xpath))).getAttributeValue(2, "type")) == null) {
                    String cp = parts.getAttributeValue(2, "cp");
                    this.keywordPaths.put(cp, fullpath);
                }
            }

            @Override
            public void handlePath(String xpath) {
                String rawName;
                if (!xpath.contains("/annotation")) {
                    return;
                }
                String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts parts = XPathParts.getFrozenInstance(fullpath);
                String type = parts.getAttributeValue(2, "type");
                if (type == null) {
                    return;
                }
                String cp = parts.getAttributeValue(2, "cp");
                String keywordPath = this.keywordPaths.get(cp);
                String distinguishingKeywordPath = CLDRFile.getDistinguishingXPath(keywordPath, null);
                String rawKeywordValue = this.cldrFileToFilter.getStringValue(keywordPath);
                if ((rawKeywordValue == null || rawKeywordValue.equals(CldrUtility.INHERITANCE_MARKER)) && ((rawName = this.cldrFileToFilter.getStringValue(xpath)) == null || rawName.equals(CldrUtility.INHERITANCE_MARKER))) {
                    return;
                }
                String nameSourceLocale = this.resolved.getSourceLocaleID(xpath, null);
                if ("root".equals(nameSourceLocale) || "code-fallback".equals(nameSourceLocale)) {
                    return;
                }
                String name = this.resolved.getStringValue(xpath);
                String keywordValue = this.resolved.getStringValue(keywordPath);
                String sourceLocaleId = this.resolved.getSourceLocaleID(distinguishingKeywordPath, null);
                this.sorted.clear();
                this.sorted.add(name);
                if (!sourceLocaleId.equals("root") && !sourceLocaleId.equals("code-fallback")) {
                    List<String> items = Annotations.splitter.splitToList(keywordValue);
                    this.sorted.addAll(items);
                }
                DisplayAndInputProcessor.filterCoveredKeywords(this.sorted);
                DisplayAndInputProcessor.filterKeywordsDifferingOnlyInCase(this.sorted);
                String newKeywordValue = Joiner.on(" | ").join(this.sorted);
                if (!newKeywordValue.equals(keywordValue)) {
                    this.replace(keywordPath, keywordPath, newKeywordValue);
                }
            }
        });
        fixList.add('N', "add number symbols to exemplars", new CLDRFilter(){
            CLDRFile resolved;
            UnicodeSet numberStuff = new UnicodeSet();
            Set<String> seen = new HashSet<String>();
            Set<String> hackAllowOnly = new HashSet<String>();
            boolean skip = false;

            @Override
            public void handleStart() {
                String localeID = this.cldrFileToFilter.getLocaleID();
                this.resolved = this.factory.make(localeID, true);
                this.numberStuff.clear();
                this.seen.clear();
                this.skip = localeID.equals("root");
                this.hackAllowOnly.clear();
                for (CLDRFile.NumberingSystem system : CLDRFile.NumberingSystem.values()) {
                    String numberingSystem;
                    String string = numberingSystem = system.path == null ? "latn" : this.cldrFileToFilter.getStringValue(system.path);
                    if (numberingSystem == null) continue;
                    this.hackAllowOnly.add(numberingSystem);
                }
            }

            @Override
            public void handlePath(String xpath) {
                if (this.skip || !xpath.startsWith("//ldml/numbers/symbols")) {
                    return;
                }
                XPathParts parts = XPathParts.getFrozenInstance(xpath);
                String system = parts.getAttributeValue(2, "numberSystem");
                if (system == null) {
                    System.err.println("Bogus numberSystem:\t" + this.cldrFileToFilter.getLocaleID() + " \t" + xpath);
                    return;
                }
                if (this.seen.contains(system) || !this.hackAllowOnly.contains(system)) {
                    return;
                }
                this.seen.add(system);
                UnicodeSet exemplars = this.resolved.getExemplarsNumeric(system);
                System.out.println("# " + system + " ==> " + exemplars.toPattern(false));
                for (String s2 : exemplars) {
                    this.numberStuff.addAll(s2);
                }
            }

            @Override
            public void handleEnd() {
                UnicodeSet current;
                if (!this.numberStuff.isEmpty() && !this.numberStuff.equals(current = this.cldrFileToFilter.getExemplarSet(CLDRFile.ExemplarType.numbers, CLDRFile.WinningChoice.WINNING))) {
                    DisplayAndInputProcessor daip = new DisplayAndInputProcessor(this.cldrFileToFilter);
                    if (current != null && !current.isEmpty()) {
                        this.numberStuff.addAll(current);
                    }
                    String path = CLDRFile.getExemplarPath(CLDRFile.ExemplarType.numbers);
                    String value = daip.getPrettyPrinter().format(this.numberStuff);
                    this.replace(path, path, value);
                }
            }
        });
        fixList.add('k', "fix according to -k config file. Details on http://cldr.unicode.org/development/cldr-big-red-switch/cldrmodify-passes/cldrmodify-config", new CLDRFilter(){
            private Map<ConfigMatch, LinkedHashSet<Map<ConfigKeys, ConfigMatch>>> locale2keyValues;
            private LinkedHashSet<Map<ConfigKeys, ConfigMatch>> keyValues = new LinkedHashSet();
            static final String DEBUG_PATH = "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"formal\"]/namePattern";

            @Override
            public void handleStart() {
                super.handleStart();
                if (!CLDRModify.options[7].doesOccur || !CLDRModify.options[7].value.equals("k")) {
                    return;
                }
                if (this.locale2keyValues == null) {
                    this.fillCache();
                }
                String localeId = this.getLocaleID();
                this.keyValues.clear();
                for (Map.Entry<ConfigMatch, LinkedHashSet<Map<ConfigKeys, ConfigMatch>>> entry : this.locale2keyValues.entrySet()) {
                    if (!entry.getKey().matches(localeId)) continue;
                    this.keyValues.addAll((Collection<Map<ConfigKeys, ConfigMatch>>)entry.getValue());
                }
                System.out.println("# Checking entries & changing:\t" + this.keyValues.size());
                block6: for (Map map : this.keyValues) {
                    ConfigMatch action = (ConfigMatch)map.get((Object)ConfigKeys.action);
                    ConfigMatch pathMatch = (ConfigMatch)map.get((Object)ConfigKeys.path);
                    ConfigMatch valueMatch = (ConfigMatch)map.get((Object)ConfigKeys.value);
                    ConfigMatch newPath = (ConfigMatch)map.get((Object)ConfigKeys.new_path);
                    ConfigMatch newValue = (ConfigMatch)map.get((Object)ConfigKeys.new_value);
                    switch (action.action) {
                        case addNew: 
                        case add: {
                            if (pathMatch != null || valueMatch != null || newPath == null || newValue == null) {
                                throw new IllegalArgumentException("Bad arguments, must have non-null for one of:path, value, new_path, new_value :\n\t" + map);
                            }
                            String newPathString = newPath.getPath(this.getResolved());
                            if (action.action != ConfigAction.add && this.cldrFileToFilter.getStringValue(newPathString) != null) continue block6;
                            this.replace(newPathString, newPathString, newValue.exactMatch, "config");
                            continue block6;
                        }
                        case replace: {
                            if ((pathMatch != null || valueMatch != null) && (newPath != null || newValue != null)) continue block6;
                            throw new IllegalArgumentException("Bad arguments, must have (path!=null OR value=null) AND (new_path!=null OR new_value!=null):\n\t" + map);
                        }
                        case delete: {
                            if (newPath == null && newValue == null) continue block6;
                            throw new IllegalArgumentException("Bad arguments, must have newPath=null, newValue=null" + map);
                        }
                    }
                    throw new IllegalArgumentException("Internal Error");
                }
            }

            private void fillCache() {
                this.locale2keyValues = new LinkedHashMap<ConfigMatch, LinkedHashSet<Map<ConfigKeys, ConfigMatch>>>();
                String configFileName = CLDRModify.options[15].value;
                FileProcessor myReader = new FileProcessor(){
                    {
                        this.doHash = false;
                    }

                    @Override
                    protected boolean handleLine(int lineCount, String line) {
                        line = line.trim();
                        String[] lineParts = line.split("\\s*;\\s*");
                        EnumMap<ConfigKeys, ConfigMatch> keyValue = new EnumMap<ConfigKeys, ConfigMatch>(ConfigKeys.class);
                        for (String linePart : lineParts) {
                            int pos = linePart.indexOf(61);
                            if (pos < 0) {
                                throw new IllegalArgumentException(lineCount + ":\t No = in command: \u00ab" + linePart + "\u00bb in " + line);
                            }
                            ConfigKeys key = ConfigKeys.valueOf(linePart.substring(0, pos).trim());
                            if (keyValue.containsKey((Object)key)) {
                                throw new IllegalArgumentException("Must not have multiple keys: " + key);
                            }
                            String match = linePart.substring(pos + 1).trim();
                            keyValue.put(key, new ConfigMatch(key, match));
                        }
                        ConfigMatch locale = (ConfigMatch)keyValue.get((Object)ConfigKeys.locale);
                        if (locale == null || keyValue.get((Object)ConfigKeys.action) == null) {
                            throw new IllegalArgumentException();
                        }
                        LinkedHashSet<Map<ConfigKeys, ConfigMatch>> keyValues = locale2keyValues.get(locale);
                        if (keyValues == null) {
                            keyValues = new LinkedHashSet();
                            locale2keyValues.put(locale, keyValues);
                        }
                        keyValues.add(keyValue);
                        return true;
                    }
                };
                myReader.process(CLDRModify.class, configFileName);
            }

            @Override
            public void handlePath(String xpath) {
                if (DEBUG_PATH != null && DEBUG_PATH.equals(xpath)) {
                    System.out.println(xpath);
                }
                for (Map map : this.keyValues) {
                    ConfigMatch pathMatch = (ConfigMatch)map.get((Object)ConfigKeys.path);
                    if (pathMatch != null && !pathMatch.matches(xpath)) {
                        if (DEBUG_PATH == null || pathMatch == null || pathMatch.regexMatch == null) continue;
                        System.out.println(RegexUtilities.showMismatch(pathMatch.regexMatch, (CharSequence)xpath));
                        continue;
                    }
                    ConfigMatch valueMatch = (ConfigMatch)map.get((Object)ConfigKeys.value);
                    String value = this.cldrFileToFilter.getStringValue(xpath);
                    if (valueMatch != null && !valueMatch.matches(value)) continue;
                    ConfigMatch action = (ConfigMatch)map.get((Object)ConfigKeys.action);
                    switch (action.action) {
                        case delete: {
                            this.remove(xpath, "config");
                            break;
                        }
                        case replace: {
                            ConfigMatch newPath = (ConfigMatch)map.get((Object)ConfigKeys.new_path);
                            ConfigMatch newValue = (ConfigMatch)map.get((Object)ConfigKeys.new_value);
                            String fullpath = this.cldrFileToFilter.getFullXPath(xpath);
                            String draft = "";
                            int loc = fullpath.indexOf("[@draft=");
                            if (loc >= 0) {
                                int loc2 = fullpath.indexOf(93, loc + 7);
                                draft = fullpath.substring(loc, loc2 + 1);
                            }
                            String modPath = ConfigMatch.getModified(pathMatch, xpath, newPath) + draft;
                            String modValue = ConfigMatch.getModified(valueMatch, value, newValue);
                            this.replace(xpath, modPath, modValue, "config");
                        }
                    }
                }
            }
        });
        fixList.add('i', "fix Identical Children");
        fixList.add('o', "check attribute validity");
        fixList.add('^', "add inheritance-marked items from vxml to trunk", new CLDRFilter(){
            Factory VxmlFactory;
            final ArrayList<File> fileList = new ArrayList();

            @Override
            public void handleStart() {
                CLDRFile vxmlCommonMainFile;
                if (this.fileList.isEmpty()) {
                    for (String top : Arrays.asList("common/", "seed/")) {
                        String leaf = sourceInput.contains("annotations") ? "annotations/" : "main/";
                        String key = top + leaf;
                        this.fileList.add(new File(CLDRPaths.AUX_DIRECTORY + "voting/44/vxml/" + key));
                    }
                    this.VxmlFactory = SimpleFactory.make(this.fileList.toArray(new File[this.fileList.size()]), ".*");
                }
                String localeID = this.cldrFileToFilter.getLocaleID();
                try {
                    vxmlCommonMainFile = this.VxmlFactory.make(localeID, false);
                }
                catch (Exception e) {
                    System.out.println("#ERROR: VXML file not found for " + localeID + " in " + this.fileList);
                    return;
                }
                CLDRFile resolved = this.cldrFileToFilter;
                if (!this.cldrFileToFilter.isResolved()) {
                    resolved = this.factory.make(this.cldrFileToFilter.getLocaleID(), true);
                }
                for (String xpath : vxmlCommonMainFile) {
                    String baileyValue;
                    String trunkValue;
                    String vxmlValue = vxmlCommonMainFile.getStringValue(xpath);
                    if (vxmlValue == null || !CldrUtility.INHERITANCE_MARKER.equals(vxmlValue) || (trunkValue = resolved.getStringValue(xpath)) != null && !trunkValue.equals(baileyValue = resolved.getBaileyValue(xpath, null, null))) continue;
                    String fullPath = resolved.getFullXPath(xpath);
                    if (fullPath == null && (fullPath = vxmlCommonMainFile.getFullXPath(xpath)) == null) {
                        throw new ICUException("getFullXPath not working for " + localeID + ", " + xpath);
                    }
                    this.add(fullPath, vxmlValue, "Add or replace by " + CldrUtility.INHERITANCE_MARKER);
                }
            }

            @Override
            public void handlePath(String xpath) {
            }
        });
        fixList.add('L', "fix logical groups by adding all the bailey values", new CLDRFilter(){
            Set<String> seen = new HashSet<String>();
            CLDRFile resolved;
            boolean skip;
            CoverageLevel2 coverageLeveler;

            @Override
            public void handleStart() {
                this.seen.clear();
                this.resolved = this.getResolved();
                this.skip = false;
                this.coverageLeveler = null;
                String localeID = this.cldrFileToFilter.getLocaleID();
                LanguageTagParser ltp = new LanguageTagParser().set(localeID);
                if (!ltp.getRegion().isEmpty() || !ltp.getVariants().isEmpty()) {
                    this.skip = true;
                } else {
                    this.coverageLeveler = CoverageLevel2.getInstance(localeID);
                }
            }

            @Override
            public void handlePath(String xpath) {
                if (this.skip || this.seen.contains(xpath) || this.coverageLeveler.getLevel(xpath) == Level.COMPREHENSIVE) {
                    return;
                }
                Set<String> paths = LogicalGrouping.getPaths(this.cldrFileToFilter, xpath);
                if (paths == null || paths.size() < 2) {
                    return;
                }
                LinkedHashSet<String> needed = new LinkedHashSet<String>();
                for (String path2 : paths) {
                    if (path2.equals(xpath) || this.cldrFileToFilter.isHere(path2) || LogicalGrouping.isOptional(this.cldrFileToFilter, path2)) continue;
                    needed.add(path2);
                }
                if (needed.isEmpty()) {
                    return;
                }
                CLDRFile.DraftStatus worstStatus = CLDRFile.DraftStatus.contributed;
                for (String path2 : paths) {
                    CLDRFile.DraftStatus df;
                    XPathParts parts = XPathParts.getFrozenInstance(path2);
                    String rawStatus = parts.getAttributeValue(-1, "draft");
                    if (rawStatus == null || (df = CLDRFile.DraftStatus.forString(rawStatus)).compareTo(worstStatus) >= 0) continue;
                    worstStatus = df;
                }
                for (String path2 : paths) {
                    String fullPath = this.resolved.getFullXPath(path2);
                    String value = this.resolved.getStringValue(path2);
                    if (LogicalGrouping.isOptional(this.cldrFileToFilter, path2) && !this.cldrFileToFilter.isHere(path2)) continue;
                    XPathParts fullparts = XPathParts.getFrozenInstance(fullPath).cloneAsThawed();
                    fullparts.setAttribute(-1, "draft", worstStatus.toString());
                    this.replace(fullPath, fullparts.toString(), value, "Fleshing out bailey to " + worstStatus);
                }
                this.seen.addAll(paths);
            }
        });
        fixList.add('R', "Revert under certain conditions", new CLDRFilter(){
            private final String vxmlDir = "../vetdata-2023-01-23-plain-dropfalse/vxml/";
            private Factory vxmlFactory = null;
            private CLDRFile vxmlFile = null;
            private CLDRFile baselineFileUnresolved = null;
            private CLDRFile baselineFileResolved = null;
            private File[] list = null;
            private final String[] ERR_LOCALES_PATHS = new String[]{"ja", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-prefix\"]", "nl_BE", "//ldml/personNames/sampleName[@item=\"nativeFull\"]/nameField[@type=\"surname\"]", "yue", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"title\"]", "yue", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-prefix\"]", "yue", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-core\"]", "zh", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"title\"]", "zh", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-prefix\"]", "zh", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-core\"]", "zh_Hant", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"title\"]", "zh_Hant", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-prefix\"]", "zh_Hant", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-core\"]"};

            @Override
            public void handleSetup() {
                String vxmlSubPath = "../vetdata-2023-01-23-plain-dropfalse/vxml/common/" + new File(CLDRModify.options[2].value).getName();
                this.list = new File[]{new File(vxmlSubPath)};
            }

            @Override
            public void handleStart() {
                if (this.vxmlFactory == null) {
                    this.vxmlFactory = SimpleFactory.make(this.list, ".*");
                    if (!this.pathHasError("zh_Hant", "//ldml/personNames/sampleName[@item=\"foreignFull\"]/nameField[@type=\"surname-core\"]")) {
                        throw new RuntimeException("pathHasError wrong?");
                    }
                }
                String localeID = this.cldrFileToFilter.getLocaleID();
                if (this.cldrFileToFilter.isResolved()) {
                    this.baselineFileResolved = this.cldrFileToFilter;
                    this.baselineFileUnresolved = this.cldrFileToFilter.getUnresolved();
                } else {
                    this.baselineFileResolved = this.getResolved();
                    this.baselineFileUnresolved = this.cldrFileToFilter;
                }
                try {
                    this.vxmlFile = this.vxmlFactory.make(localeID, false);
                }
                catch (Exception e) {
                    System.out.println("Skipping " + localeID + " due to " + e);
                    this.vxmlFile = null;
                }
            }

            @Override
            public void handlePath(String xpath) {
                boolean debugging = false;
                if (debugging) {
                    System.out.println("handlePath: got Ciudad_Juarez");
                }
                if (this.vxmlFile == null) {
                    if (debugging) {
                        System.out.println("handlePath: vxmlFile is null");
                    }
                    return;
                }
                String vxmlValue = this.vxmlFile.getStringValue(xpath);
                if (vxmlValue == null) {
                    throw new RuntimeException(this.getLocaleID() + ":" + xpath + ": vxmlValue == null");
                }
                if (!this.wantRevertToBaseline(xpath, vxmlValue)) {
                    if (debugging) {
                        System.out.println("handlePath: wantRevertToBaseline false");
                    }
                    String fullXPath = this.vxmlFile.getFullXPath(xpath);
                    this.replace(fullXPath, fullXPath, vxmlValue);
                } else if (debugging) {
                    System.out.println("handlePath: wantRevertToBaseline true");
                }
            }

            private boolean wantRevertToBaseline(String xpath, String vxmlValue) {
                String fullXPath;
                String localeID = this.cldrFileToFilter.getLocaleID();
                boolean debugging = false;
                if (debugging) {
                    System.out.println("wantRevertToBaseline: got Ciudad_Juarez");
                }
                if (!this.changesWereAllowed(localeID, xpath, fullXPath = this.vxmlFile.getFullXPath(xpath))) {
                    if (debugging) {
                        System.out.println("wantRevertToBaseline: return true since changes not allowed");
                    }
                    return true;
                }
                if (!CldrUtility.INHERITANCE_MARKER.equals(vxmlValue)) {
                    if (debugging) {
                        System.out.println("wantRevertToBaseline: return for 0");
                    }
                    return false;
                }
                String baselineValue = this.baselineFileUnresolved.getStringValue(xpath);
                if (baselineValue == null || CldrUtility.INHERITANCE_MARKER.equals(baselineValue)) {
                    if (debugging) {
                        System.out.println("wantRevertToBaseline: return for 1; baselineValue = " + baselineValue);
                    }
                    return false;
                }
                Output<String> inheritancePathWhereFound = new Output<String>();
                Output<String> localeWhereFound = new Output<String>();
                this.baselineFileResolved.getBaileyValue(xpath, inheritancePathWhereFound, localeWhereFound);
                if (localeID.equals(localeWhereFound.value) || xpath.equals(inheritancePathWhereFound.value)) {
                    if (debugging) {
                        System.out.println("wantRevertToBaseline: found at " + (String)localeWhereFound.value + " " + (String)inheritancePathWhereFound.value);
                        System.out.println("wantRevertToBaseline: return for 3");
                    }
                    return false;
                }
                if (debugging) {
                    System.out.println("wantRevertToBaseline: return true");
                }
                return true;
            }

            private boolean changesWereAllowed(String localeID, String xpath, String fullXPath) {
                boolean isError = this.pathHasError(localeID, xpath);
                String oldValue = this.baselineFileUnresolved.getWinningValue(xpath);
                boolean isMissing = oldValue == null || CLDRFile.DraftStatus.forXpath(fullXPath).ordinal() <= CLDRFile.DraftStatus.provisional.ordinal();
                String locOrAncestor = localeID;
                while (!"root".equals(locOrAncestor)) {
                    if (SubmissionLocales.allowEvenIfLimited(locOrAncestor, xpath, isError, isMissing)) {
                        return true;
                    }
                    locOrAncestor = LocaleIDParser.getParent(locOrAncestor);
                }
                return false;
            }

            private boolean pathHasError(String localeID, String xpath) {
                for (int i = 0; i < this.ERR_LOCALES_PATHS.length; i += 2) {
                    String errLoc = this.ERR_LOCALES_PATHS[i];
                    String errPath = this.ERR_LOCALES_PATHS[i + 1];
                    if (!localeID.equals(errLoc) || !xpath.equals(errPath)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void handleEnd() {
                HashSet<String> vPaths = new HashSet<String>();
                HashSet<String> bPaths = new HashSet<String>();
                this.vxmlFile.getPaths("", null, vPaths);
                this.baselineFileUnresolved.getPaths("", null, bPaths);
                vPaths.removeAll(bPaths);
                for (String dPath : vPaths) {
                    String fPath = this.vxmlFile.getFullXPath(dPath);
                    this.add(fPath, this.vxmlFile.getWinningValue(fPath), "in vxmlFile, missing from baseline");
                }
            }
        });
        fixList.add('V', "Fix values that would inherit laterally", new CLDRFilter(){
            boolean skip = false;
            boolean isL1 = false;
            String parentId = null;
            CLDRFile parentFile = null;
            Set<String> pathsHandled = new HashSet<String>();
            String onlyValues = null;
            String message = null;

            @Override
            public void handleStart() {
                this.skip = this.getLocaleID().equals("root");
                if (!this.skip) {
                    this.parentId = LocaleIDParser.getParent(this.getLocaleID());
                    this.isL1 = this.parentId.equals("root");
                    this.parentFile = null;
                }
                this.pathsHandled.clear();
                this.onlyValues = CldrUtility.INHERITANCE_MARKER;
                this.message = "fix \u2191\u2191\u2191 lateral";
            }

            @Override
            public void handlePath(String xpath) {
                if (this.skip) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (!Objects.equals(this.onlyValues, value)) {
                    return;
                }
                this.pathsHandled.add(xpath);
                Output<String> pathWhereFound = new Output<String>();
                Output<String> localeWhereFound = new Output<String>();
                String baileyValue = this.getResolved().getBaileyValue(xpath, pathWhereFound, localeWhereFound);
                if (baileyValue != null && !xpath.equals(pathWhereFound.value) && !"constructed".equals(pathWhereFound.value)) {
                    boolean harden = false;
                    String message2 = "";
                    if (this.isL1) {
                        harden = true;
                        message2 = "; L1";
                    } else {
                        String parentValue;
                        if (this.parentFile == null) {
                            this.parentFile = this.factory.make(this.parentId, true);
                        }
                        if (!baileyValue.equals(parentValue = this.parentFile.getStringValueWithBailey(xpath))) {
                            harden = true;
                        }
                        message2 = "; L2+";
                    }
                    if (harden) {
                        String fullPath = this.cldrFileToFilter.getFullXPath(xpath);
                        this.replace(fullPath, fullPath, baileyValue, this.message + message2);
                    }
                }
            }

            @Override
            public void handleEnd() {
                if (this.skip || this.isL1) {
                    return;
                }
                this.onlyValues = null;
                this.message = "fix null lateral";
                List<String> parentChain = LocaleIDParser.getParentChain(this.getLocaleID());
                String localeL1 = parentChain.get(parentChain.size() - 2);
                CLDRFile fileL1 = this.factory.make(localeL1, false);
                for (String path : fileL1) {
                    if (this.pathsHandled.contains(path)) continue;
                    this.handlePath(path);
                }
            }
        });
        fixList.add('D', "Downgrade paths", new CLDRFilter(){
            boolean skipLocale = false;

            @Override
            public void handleStart() {
                super.handleSetup();
                String locale = this.getLocaleID();
                this.skipLocale = locale.equals("en") || locale.equals("root") || !DowngradePaths.lookingAt(locale);
            }

            @Override
            public void handlePath(String xpath) {
                CLDRFile.DraftStatus oldDraftEnum;
                if (this.skipLocale) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (!DowngradePaths.lookingAt(this.getLocaleID(), xpath, value)) {
                    return;
                }
                String fullPath = this.cldrFileToFilter.getFullXPath(xpath);
                XPathParts fullParts = XPathParts.getFrozenInstance(fullPath);
                String oldDraft = fullParts.getAttributeValue(-1, "draft");
                if (oldDraft != null && ((oldDraftEnum = CLDRFile.DraftStatus.forString(oldDraft)) == CLDRFile.DraftStatus.provisional || oldDraftEnum == CLDRFile.DraftStatus.unconfirmed)) {
                    return;
                }
                fullParts = fullParts.cloneAsThawed();
                fullParts.setAttribute(-1, "draft", "provisional");
                this.replace(fullPath, fullParts.toString(), value, "Downgrade to provisional");
            }
        });
        fixList.add('G', "upGrade basic paths to contributed", new CLDRFilter(){
            CoverageLevel2 coverageLeveler;
            final CLDRFile.DraftStatus TARGET_STATUS = CLDRFile.DraftStatus.contributed;
            final Level TARGET_LEVEL = Level.BASIC;

            @Override
            public void handleStart() {
                super.handleSetup();
                String locale = this.getLocaleID();
                CLDRConfig config = CLDRConfig.getInstance();
                this.coverageLeveler = CoverageLevel2.getInstance(config.getSupplementalDataInfo(), locale);
            }

            @Override
            public void handlePath(String xpath) {
                if (!this.TARGET_LEVEL.isAtLeast(this.coverageLeveler.getLevel(xpath))) {
                    return;
                }
                String fullPath = this.cldrFileToFilter.getFullXPath(xpath);
                CLDRFile.DraftStatus oldDraft = CLDRFile.DraftStatus.forXpath(fullPath);
                if (oldDraft.compareTo(this.TARGET_STATUS) > 0) {
                    return;
                }
                String value = this.cldrFileToFilter.getStringValue(xpath);
                String newPath = this.TARGET_STATUS.updateXPath(fullPath);
                this.replace(fullPath, newPath, value, "Upgrade to " + this.TARGET_STATUS.name());
            }
        });
        fixList.add('Z', "Zero lateral: convert inheritance marker to specific value if inheritance would be lateral/problematic", new CLDRFilter(){

            @Override
            public void handlePath(String xpath) {
                String value = this.cldrFileToFilter.getStringValue(xpath);
                if (!CldrUtility.INHERITANCE_MARKER.equals(value)) {
                    return;
                }
                String newValue = VoteResolver.reviseInheritanceAsNeeded(xpath, value, this.getResolved());
                if (value.equals(newValue)) {
                    return;
                }
                String fullXPath = this.cldrFileToFilter.getFullXPath(xpath);
                this.replace(fullXPath, fullXPath, newValue);
            }
        });
    }

    private static class ValuePair {
        String value;
        String fullxpath;

        private ValuePair() {
        }
    }

    static class FixList {
        CLDRFilter[] filters = new CLDRFilter[128];
        String[] helps = new String[128];
        UnicodeSet options = new UnicodeSet();
        String inputOptions = null;
        int totalChanged = 0;

        FixList() {
        }

        void add(char letter, String help) {
            this.add(letter, help, null);
        }

        public void handleSetup() {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].handleSetup();
            }
        }

        public void handleCleanup() {
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                this.filters[i].handleCleanup();
            }
        }

        public UnicodeSet getOptions() {
            return this.options;
        }

        void add(char letter, String help, CLDRFilter filter) {
            if (this.helps[letter] != null) {
                throw new IllegalArgumentException("Duplicate letter: " + letter);
            }
            this.filters[letter] = filter;
            this.helps[letter] = help;
            this.options.add(letter);
        }

        void setFile(CLDRFile file, String inputOptions, Factory factory, Set<String> removal, CLDRFile replacements) {
            this.inputOptions = inputOptions;
            for (int i = 0; i < inputOptions.length(); ++i) {
                char c = inputOptions.charAt(i);
                if (this.filters[c] == null) continue;
                try {
                    this.filters[c].setFile(file, factory, removal, replacements);
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Failure in " + this.filters[c].localeID + "\t START");
                    throw e;
                }
            }
        }

        void handleStart() {
            for (int i = 0; i < this.inputOptions.length(); ++i) {
                char c = this.inputOptions.charAt(i);
                if (this.filters[c] == null) continue;
                try {
                    this.filters[c].handleStart();
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Failure in " + this.filters[c].localeID + "\t START");
                    throw e;
                }
            }
        }

        void handlePath(String xpath) {
            for (int i = 0; i < this.inputOptions.length(); ++i) {
                char c = this.inputOptions.charAt(i);
                if (this.filters[c] == null) continue;
                try {
                    this.filters[c].handlePath(xpath);
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Failure in " + this.filters[c].localeID + "\t " + xpath);
                    throw e;
                }
            }
        }

        void handleEnd() {
            for (int i = 0; i < this.inputOptions.length(); ++i) {
                char c = this.inputOptions.charAt(i);
                if (this.filters[c] == null) continue;
                try {
                    this.filters[c].handleEnd();
                    if (this.filters[c].countChanges == 0) continue;
                    this.totalChanged += this.filters[c].countChanges;
                    System.out.println("#" + this.filters[c].localeID + "\tItems changed: " + this.filters[c].countChanges);
                    continue;
                }
                catch (RuntimeException e) {
                    System.err.println("Failure in " + this.filters[c].localeID + "\t START");
                    throw e;
                }
            }
        }

        String showHelp() {
            Object result = "";
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.helps[i] == null) continue;
                result = (String)result + "\t" + (char)i + "\t " + this.helps[i] + "\n";
            }
            return result;
        }
    }

    static abstract class CLDRFilter {
        protected CLDRFile cldrFileToFilter;
        protected CLDRFile cldrFileToFilterResolved;
        private String localeID;
        protected Set<String> availableChildren;
        private Set<String> toBeRemoved;
        private CLDRFile toBeReplaced;
        protected Factory factory;
        protected int countChanges;

        CLDRFilter() {
        }

        public final void setFile(CLDRFile k, Factory factory, Set<String> removal, CLDRFile replacements) {
            this.cldrFileToFilter = k;
            this.cldrFileToFilterResolved = null;
            this.factory = factory;
            this.localeID = k.getLocaleID();
            this.toBeRemoved = removal;
            this.toBeReplaced = replacements;
            this.countChanges = 0;
            this.handleStart();
        }

        public void handleStart() {
        }

        public abstract void handlePath(String var1);

        public void handleEnd() {
        }

        public CLDRFile getResolved() {
            if (this.cldrFileToFilterResolved == null) {
                this.cldrFileToFilterResolved = this.cldrFileToFilter.isResolved() ? this.cldrFileToFilter : this.factory.make(this.cldrFileToFilter.getLocaleID(), true);
            }
            return this.cldrFileToFilterResolved;
        }

        public void show(String reason, String detail) {
            System.out.println("%" + this.localeID + "\t" + reason + "\tConsidering " + detail);
        }

        public void retain(String path, String reason) {
            System.out.println("%" + this.localeID + "\t" + reason + "\tRetaining: " + this.cldrFileToFilter.getStringValue(path) + "\t at: " + path);
        }

        public void remove(String path) {
            this.remove(path, "-");
        }

        public void remove(String path, String reason) {
            if (this.toBeRemoved.contains(path)) {
                return;
            }
            this.toBeRemoved.add(path);
            String oldValueOldPath = this.cldrFileToFilter.getStringValue(path);
            this.showAction(reason, "Removing", oldValueOldPath, null, null, path, path);
        }

        public void replace(String oldFullPath, String newFullPath, String newValue) {
            this.replace(oldFullPath, newFullPath, newValue, "-");
        }

        public void showAction(String reason, String action, String oldValueOldPath, String oldValueNewPath, String newValue, String oldFullPath, String newFullPath) {
            System.out.println("%" + this.localeID + "\t" + action + "\t" + reason + "\t\u00ab" + oldValueOldPath + "\u00bb" + (String)(newFullPath.equals(oldFullPath) || oldValueNewPath == null ? "" : (oldValueNewPath.equals(oldValueOldPath) ? "/=" : "/\u00ab" + oldValueNewPath + "\u00bb")) + "\t\u2192\t" + (String)(newValue == null ? "\u2205" : (newValue.equals(oldValueOldPath) ? "\u2261" : "\u00ab" + newValue + "\u00bb")) + "\t" + oldFullPath + (String)(newFullPath.equals(oldFullPath) ? "" : "\t\u2192\t" + newFullPath));
            ++this.countChanges;
        }

        public void replace(String oldFullPath, String newFullPath, String newValue, String reason) {
            String oldValueOldPath = this.cldrFileToFilter.getStringValue(oldFullPath);
            String temp = this.cldrFileToFilter.getFullXPath(oldFullPath);
            if (temp != null) {
                oldFullPath = temp;
            }
            boolean pathSame = oldFullPath.equals(newFullPath);
            if (!pathChecker.checkPath(newFullPath)) {
                throw new IllegalArgumentException("Bad path: " + newFullPath);
            }
            if (pathSame) {
                if (newValue == null) {
                    this.remove(oldFullPath, reason);
                } else if (oldValueOldPath == null) {
                    this.toBeReplaced.add(oldFullPath, newValue);
                    this.showAction(reason, "Adding", oldValueOldPath, null, newValue, oldFullPath, newFullPath);
                } else {
                    this.toBeReplaced.add(oldFullPath, newValue);
                    this.showAction(reason, "Replacing", oldValueOldPath, null, newValue, oldFullPath, newFullPath);
                }
                return;
            }
            String oldValueNewPath = this.cldrFileToFilter.getStringValue(newFullPath);
            this.toBeRemoved.add(oldFullPath);
            this.toBeReplaced.add(newFullPath, newValue);
            if (oldValueNewPath == null) {
                this.showAction(reason, "Moving", oldValueOldPath, oldValueNewPath, newValue, oldFullPath, newFullPath);
            } else if (oldValueNewPath.equals(newValue)) {
                this.showAction(reason, "Unchanged Value", oldValueOldPath, oldValueNewPath, newValue, oldFullPath, newFullPath);
            } else {
                this.showAction(reason, "Overriding", oldValueOldPath, oldValueNewPath, newValue, oldFullPath, newFullPath);
            }
        }

        public void add(String path, String value, String reason) {
            String oldValueOldPath = this.cldrFileToFilter.getStringValue(path);
            if (oldValueOldPath == null) {
                this.toBeRemoved.remove(path);
                this.toBeReplaced.add(path, value);
                this.showAction(reason, "Adding", oldValueOldPath, null, value, path, path);
            } else {
                this.replace(path, path, value);
            }
        }

        public CLDRFile getReplacementFile() {
            return this.toBeReplaced;
        }

        public void handleSetup() {
        }

        public void handleCleanup() {
        }

        public String getLocaleID() {
            return this.localeID;
        }
    }

    static class RetainWhenMinimizing
    implements CLDRFile.RetentionTest {
        private CLDRFile file;
        private CLDRLocale c;
        private boolean isArabicSublocale;

        RetainWhenMinimizing() {
        }

        public RetainWhenMinimizing setParentFile(CLDRFile file) {
            this.file = file;
            this.c = CLDRLocale.getInstance(file.getLocaleIDFromIdentity());
            this.isArabicSublocale = "ar".equals(this.c.getLanguage()) && !"001".equals(this.c.getCountry());
            return this;
        }

        @Override
        public CLDRFile.RetentionTest.Retention getRetention(String path) {
            if (path.startsWith("//ldml/identity/")) {
                return CLDRFile.RetentionTest.Retention.RETAIN;
            }
            if (this.isArabicSublocale && path.startsWith("//ldml/numbers/defaultNumberingSystem")) {
                return CLDRFile.RetentionTest.Retention.RETAIN;
            }
            String localeId = this.file.getSourceLocaleID(path, null);
            if ((this.c.isLanguageLocale() || this.c.equals(CLDRLocale.getInstance("pt_PT"))) && ("root".equals(localeId) || "code-fallback".equals(localeId))) {
                return CLDRFile.RetentionTest.Retention.RETAIN;
            }
            return CLDRFile.RetentionTest.Retention.RETAIN_IF_DIFFERENT;
        }
    }

    static final class ConfigMatch {
        final String exactMatch;
        final Matcher regexMatch;
        final ConfigAction action;
        final boolean hexPath;

        public ConfigMatch(ConfigKeys key, String match) {
            if (key == ConfigKeys.action) {
                this.exactMatch = null;
                this.regexMatch = null;
                this.action = ConfigAction.valueOf(match);
                this.hexPath = false;
            } else if (match.startsWith("/") && match.endsWith("/")) {
                if (key != ConfigKeys.locale && key != ConfigKeys.path && key != ConfigKeys.value) {
                    throw new IllegalArgumentException("Regex only allowed for old path/value.");
                }
                this.exactMatch = null;
                this.regexMatch = PatternCache.get(match.substring(1, match.length() - 1).replace("[@", "\\[@")).matcher("");
                this.action = null;
                this.hexPath = false;
            } else {
                this.exactMatch = match;
                this.regexMatch = null;
                this.action = null;
                this.hexPath = (key == ConfigKeys.new_path || key == ConfigKeys.path) && HEX.containsAll(match);
            }
        }

        public boolean matches(String other) {
            if (this.exactMatch == null) {
                return this.regexMatch.reset(other).find();
            }
            if (this.hexPath) {
                return this.exactMatch.equals(StringId.getHexId(other));
            }
            return this.exactMatch.equals(other);
        }

        public String toString() {
            return this.action != null ? this.action.toString() : (this.exactMatch == null ? this.regexMatch.toString() : (this.hexPath ? "*" + this.exactMatch + "*" : this.exactMatch));
        }

        public String getPath(CLDRFile cldrFileToFilter) {
            if (!this.hexPath) {
                return this.exactMatch;
            }
            String path = StringId.getStringFromHexId(this.exactMatch);
            if (path == null) {
                for (String eachPath : cldrFileToFilter.fullIterable()) {
                    StringId.getHexId(eachPath);
                }
                path = StringId.getStringFromHexId(this.exactMatch);
                if (path == null) {
                    throw new IllegalArgumentException("No path for hex id: " + this.exactMatch);
                }
            }
            return path;
        }

        public static String getModified(ConfigMatch valueMatch, String value, ConfigMatch newValue) {
            if (valueMatch == null) {
                if (newValue != null && newValue.exactMatch != null) {
                    return newValue.exactMatch;
                }
                if (value != null) {
                    return value;
                }
                throw new IllegalArgumentException("Can't have both old and new be null.");
            }
            if (valueMatch.exactMatch == null) {
                if (newValue == null || newValue.exactMatch == null) {
                    throw new IllegalArgumentException("Can't have regex without replacement.");
                }
                StringBuffer buffer = new StringBuffer();
                valueMatch.regexMatch.appendReplacement(buffer, newValue.exactMatch);
                return buffer.toString();
            }
            return newValue.exactMatch != null ? newValue.exactMatch : value;
        }
    }

    static enum ConfigAction {
        delete,
        add,
        replace,
        addNew;

    }

    static enum ConfigKeys {
        action,
        locale,
        path,
        value,
        new_path,
        new_value;

    }
}

