/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.Validity;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class DiffLanguageGroups {
    static final String OLD = "OLD";
    static final String NEW = "NEW";
    private static final String IN = " \u27a1\ufe0e ";
    static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    static final SupplementalDataInfo SDI = CONFIG.getSupplementalDataInfo();
    static final CLDRFile ENGLISH = CONFIG.getEnglish();
    static final Set<String> CLDR_ORG_LANGUAGES = StandardCodes.make().getLocaleCoverageLocales(Organization.cldr).stream().filter(x -> !x.contains("_")).collect(Collectors.toUnmodifiableSet());
    static final Set<String> OTHER_CLDR_LANGUAGES = Sets.difference(CONFIG.getCldrFactory().getAvailableLanguages().stream().filter(x -> !x.contains("_") && !x.equals("root")).collect(Collectors.toUnmodifiableSet()), CLDR_ORG_LANGUAGES);

    public static void main(String[] args) {
        List<String> newChain;
        List<String> oldChain;
        Object newPath = CLDRPaths.COMMON_DIRECTORY + "supplemental/languageGroup.xml";
        Object oldPath = CLDRPaths.COMMON_DIRECTORY + "supplemental-temp/languageGroup43.xml";
        if (args.length > 0) {
            newPath = args[0];
            if (args.length > 1) {
                oldPath = args[1];
            }
        }
        Sets.SetView<String> validRegular = Sets.union(Validity.getInstance().getStatusToCodes(StandardCodes.LstrType.language).get((Object)Validity.Status.regular), Set.of("mul"));
        System.out.println("* OLD = v43\t\t");
        TreeMultimap<String, String> oldErrors = TreeMultimap.create();
        SortedMap<String, String> oldChildToParent = DiffLanguageGroups.invertToMap(DiffLanguageGroups.loadLanguageGroups((String)oldPath), oldErrors);
        if (!oldErrors.isEmpty()) {
            DiffLanguageGroups.showErrors(OLD, oldErrors);
        }
        Set<String> oldSet = DiffLanguageGroups.getAllKeysAndValues(oldChildToParent);
        DiffLanguageGroups.checkAgainstReference("OLD Missing", "\u2209 CLDR_ORG", CLDR_ORG_LANGUAGES, oldSet);
        DiffLanguageGroups.checkAgainstReference("OLD Missing", "\u2209 CLDR_Other", OTHER_CLDR_LANGUAGES, oldSet);
        DiffLanguageGroups.checkAgainstReference("OLD Invalid", "", oldSet, validRegular);
        System.out.println("* NEW = PR\t\t");
        TreeMultimap<String, String> newErrors = TreeMultimap.create();
        SortedMap<String, String> newChildToParent = DiffLanguageGroups.invertToMap(DiffLanguageGroups.loadLanguageGroups((String)newPath), newErrors);
        if (!newErrors.isEmpty()) {
            DiffLanguageGroups.showErrors(NEW, newErrors);
        }
        Set<String> newSet = DiffLanguageGroups.getAllKeysAndValues(newChildToParent);
        DiffLanguageGroups.checkAgainstReference("NEW Missing", "\u2209 CLDR_ORG", CLDR_ORG_LANGUAGES, newSet);
        DiffLanguageGroups.checkAgainstReference("NEW Missing", "\u2209 CLDR_Other", OTHER_CLDR_LANGUAGES, newSet);
        DiffLanguageGroups.checkAgainstReference("NEW Invalid", "", newSet, validRegular);
        DiffLanguageGroups.showDiff("\u0394 Removing (OLD-NEW)", Sets.difference(oldSet, newSet));
        DiffLanguageGroups.showDiff("\u0394 Adding (NEW-OLD)", Sets.difference(newSet, oldSet));
        for (String joint : Sets.difference(newSet, oldSet)) {
            List<String> newChain2 = DiffLanguageGroups.getChain(joint, newChildToParent, new ArrayList<String>());
            System.out.println("NEW Added\t" + DiffLanguageGroups.show(joint) + "\t \u27a1\ufe0e " + newChain2.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN)));
        }
        TreeSet<String> changed = new TreeSet<String>();
        for (String joint : Sets.intersection(oldSet, newSet)) {
            oldChain = DiffLanguageGroups.getChain(joint, oldChildToParent, new ArrayList<String>());
            if (oldChain.equals(newChain = DiffLanguageGroups.getChain(joint, newChildToParent, new ArrayList<String>()))) continue;
            changed.add(joint);
        }
        DiffLanguageGroups.showDiff("\u0394 Moving (OLD to NEW)", changed);
        for (String joint : changed) {
            oldChain = DiffLanguageGroups.getChain(joint, oldChildToParent, new ArrayList<String>());
            newChain = DiffLanguageGroups.getChain(joint, newChildToParent, new ArrayList<String>());
            System.out.println("OLD Removed \t" + DiffLanguageGroups.show(joint) + "\t \u27a1\ufe0e " + oldChain.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN)));
            System.out.println("NEW Moved to \t" + DiffLanguageGroups.show(joint) + "\t \u27a1\ufe0e " + newChain.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(IN)));
        }
    }

    private static void checkAgainstReference(String col1, String col2, Set<String> cldrLanguages, Set<String> oldSet) {
        Sets.SetView<String> missing = Sets.difference(cldrLanguages, oldSet);
        if (!missing.isEmpty()) {
            System.out.println(col1 + "\t" + col2 + "\t" + missing.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(", ")));
        }
    }

    public static void showDiff(String title, Set<String> oldMinusOther) {
        if (!oldMinusOther.isEmpty()) {
            System.out.println(title + "\t" + oldMinusOther.size() + ":\t" + oldMinusOther.stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(", ")));
        }
    }

    static String show(String languageCode) {
        return languageCode.equals("mul") ? "\u03a9" : ENGLISH.getName(0, languageCode) + " \u2045" + languageCode + "\u2046";
    }

    public static void showErrors(String title, Multimap<String, String> oldErrors) {
        for (Map.Entry<String, Collection<String>> entry : oldErrors.asMap().entrySet()) {
            System.out.println(title + " Multiple parents\t" + DiffLanguageGroups.show(entry.getKey()) + "\t" + entry.getValue().stream().map(x -> DiffLanguageGroups.show(x)).collect(Collectors.joining(" \ud835\udc2f\ud835\udc2c ")));
        }
    }

    private static List<String> getChain(String joint, Map<String, String> childToParent, List<String> result) {
        String parent = childToParent.get(joint);
        if (parent == null) {
            return result;
        }
        result.add(parent);
        return DiffLanguageGroups.getChain(parent, childToParent, result);
    }

    public static Multimap<String, String> loadLanguageGroups(String filename) {
        TreeMultimap<String, String> newParentToChildren = TreeMultimap.create();
        for (Pair<String, String> item : XMLFileReader.loadPathValues(filename, new ArrayList<Pair<String, String>>(), false)) {
            DiffLanguageGroups.handleLanguageGroups(item.getSecond(), XPathParts.getFrozenInstance(item.getFirst()), newParentToChildren);
        }
        newParentToChildren = ImmutableSetMultimap.copyOf(newParentToChildren);
        return newParentToChildren;
    }

    public static SortedMap<String, String> invertToMap(Multimap<String, String> oldParentToChildren, Multimap<String, String> childToParents) {
        TreeMap<String, String> childToParent = new TreeMap<String, String>();
        for (Map.Entry<String, String> parentToChildren : oldParentToChildren.entries()) {
            String parent = parentToChildren.getKey();
            String child = parentToChildren.getValue();
            String old = childToParent.put(child, parent);
            if (old == null) continue;
            childToParents.put(child, old);
            childToParents.put(child, parent);
        }
        return ImmutableSortedMap.copyOf(childToParent);
    }

    public static Set<String> getAllKeysAndValues(Map<String, String> newItems) {
        TreeSet<String> newSet = new TreeSet<String>(newItems.values());
        newSet.addAll(newItems.keySet());
        return ImmutableSet.copyOf(newSet);
    }

    private static boolean handleLanguageGroups(String value, XPathParts parts, Multimap<String, String> languageGroups) {
        String parent = parts.getAttributeValue(-1, "parent");
        List<String> children = SupplementalDataInfo.WHITESPACE_SPLTTER.splitToList(value);
        languageGroups.putAll(parent, children);
        return true;
    }
}

