/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Row;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.XPathParts;

public class PathChecker {
    private static final Map<XPathParts, Boolean> seen = new ConcurrentHashMap<XPathParts, Boolean>();
    private static Map<DtdType, Map<String, Map<String, Map<String, DtdData.ValueStatus>>>> seenEAV = new ConcurrentHashMap<DtdType, Map<String, Map<String, Map<String, DtdData.ValueStatus>>>>();

    public boolean checkPath(String path) {
        XPathParts parts = XPathParts.getFrozenInstance(path);
        return this.checkPath(parts, null);
    }

    public boolean checkPath(String path, Map<Row.R3<String, String, String>, DtdData.ValueStatus> errors) {
        XPathParts parts = XPathParts.getFrozenInstance(path);
        return this.checkPath(parts, errors);
    }

    public boolean checkPath(XPathParts parts, Map<Row.R3<String, String, String>, DtdData.ValueStatus> errors) {
        Boolean seenAlready = seen.get(parts);
        if (seenAlready != null) {
            return seenAlready;
        }
        DtdData dtdData = parts.getDtdData();
        boolean ok = true;
        if (errors != null) {
            errors.clear();
        }
        for (int elementIndex = 0; elementIndex < parts.size(); ++elementIndex) {
            String element = parts.getElement(elementIndex);
            for (Map.Entry<String, String> entry : parts.getAttributes(elementIndex).entrySet()) {
                String attribute = entry.getKey();
                String attrValue = entry.getValue();
                ok &= this.checkAttribute(dtdData, element, attribute, attrValue, errors);
            }
        }
        seen.put(parts, ok);
        return ok;
    }

    private boolean checkAttribute(DtdData dtdData, String element, String attribute, String attrValue, Map<Row.R3<String, String, String>, DtdData.ValueStatus> errors) {
        DtdData.ValueStatus valueStatus;
        Map setAlready;
        Map attrValueToStatus;
        Map subAlready;
        Map attrToAttrValueToStatus;
        Map subAlready2;
        Map elementToAttrToAttrValueToStatus = seenEAV.get((Object)dtdData.dtdType);
        if (elementToAttrToAttrValueToStatus == null && (subAlready2 = (Map)seenEAV.putIfAbsent(dtdData.dtdType, elementToAttrToAttrValueToStatus = new ConcurrentHashMap<String, Map<String, Map<String, DtdData.ValueStatus>>>())) != null) {
            elementToAttrToAttrValueToStatus = subAlready2;
        }
        if ((attrToAttrValueToStatus = elementToAttrToAttrValueToStatus.get(element)) == null && (subAlready = (Map)elementToAttrToAttrValueToStatus.putIfAbsent(element, attrToAttrValueToStatus = new ConcurrentHashMap<String, Map<String, DtdData.ValueStatus>>())) != null) {
            attrToAttrValueToStatus = subAlready;
        }
        if ((attrValueToStatus = attrToAttrValueToStatus.get(attribute)) == null && (setAlready = (Map)attrToAttrValueToStatus.putIfAbsent(attribute, attrValueToStatus = new ConcurrentHashMap<String, DtdData.ValueStatus>())) != null) {
            attrValueToStatus = setAlready;
        }
        if ((valueStatus = attrValueToStatus.get(attrValue)) == null) {
            valueStatus = dtdData.getValueStatus(element, attribute, attrValue);
            if (valueStatus != DtdData.ValueStatus.valid) {
                dtdData.getValueStatus(element, attribute, attrValue);
            }
            attrValueToStatus.putIfAbsent(attrValue, valueStatus);
        }
        if (errors != null && valueStatus != DtdData.ValueStatus.valid) {
            errors.put(Row.of(element, attribute, attrValue), valueStatus);
        }
        return valueStatus != null;
    }
}

