/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Row;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUUncheckedIOException;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RecursiveAction;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CheckCoverage;
import org.unicode.cldr.test.CheckNew;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.OutdatedPaths;
import org.unicode.cldr.test.SubmissionLocales;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CompletionPercent;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleCompletionData;
import org.unicode.cldr.util.NotificationCategory;
import org.unicode.cldr.util.Organization;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.Predicate;
import org.unicode.cldr.util.SpecialLocales;
import org.unicode.cldr.util.StandardCodes;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.ValuePathStatus;
import org.unicode.cldr.util.VettingParameters;
import org.unicode.cldr.util.VoteResolver;
import org.unicode.cldr.util.VoteType;
import org.unicode.cldr.util.VoterProgress;

public class VettingViewer<T> {
    private static final boolean DEBUG = false;
    private static final boolean SHOW_SUBTYPES = false;
    private static final String CONNECT_PREFIX = "\u208d_";
    private static final String CONNECT_SUFFIX = "\u208e";
    private static final String TH_AND_STYLES = "<th class='tv-th' style='text-align:left'>";
    private static final String SPLIT_CHAR = "\ufffe";
    private static final boolean DEBUG_THREADS = false;
    private static final Set<CheckCLDR.CheckStatus.Subtype> OK_IF_VOTED = EnumSet.of(CheckCLDR.CheckStatus.Subtype.sameAsEnglish);
    private LocaleBaselineCount localeBaselineCount = null;
    private static PathHeader.Factory pathTransform;
    private static final OutdatedPaths outdatedPaths;
    private final Factory cldrFactory;
    private final CLDRFile englishFile;
    private final UsersChoice<T> userVoteStatus;
    private final SupplementalDataInfo supplementalDataInfo;
    private final Set<String> defaultContentLocales;
    private final boolean USE_FORKJOIN = false;
    public static final UnicodeSet LATIN;
    static final NumberFormat nf;
    private final Relation<String, String> reasonsToPaths;
    private ProgressCallback progressCallback = new ProgressCallback();
    private static final EnumSet<NotificationCategory> localeCompletionCategories;
    private boolean summarizeAllLocales = false;

    public static Organization getNeutralOrgForSummary() {
        return Organization.surveytool;
    }

    private static boolean orgIsNeutralForSummary(Organization org) {
        return org.equals((Object)VettingViewer.getNeutralOrgForSummary());
    }

    public void setLocaleBaselineCount(LocaleBaselineCount localeBaselineCount) {
        this.localeBaselineCount = localeBaselineCount;
    }

    public static OutdatedPaths getOutdatedPaths() {
        return outdatedPaths;
    }

    public VettingViewer(SupplementalDataInfo supplementalDataInfo, Factory cldrFactory, UsersChoice<T> userVoteStatus) {
        this.cldrFactory = cldrFactory;
        this.englishFile = cldrFactory.make("en", true);
        if (pathTransform == null) {
            pathTransform = PathHeader.getFactory(this.englishFile);
        }
        this.userVoteStatus = userVoteStatus;
        this.supplementalDataInfo = supplementalDataInfo;
        this.defaultContentLocales = supplementalDataInfo.getDefaultContentLocales();
        this.reasonsToPaths = Relation.of(new HashMap(), HashSet.class);
    }

    public DashboardData generateDashboard(VettingParameters args) {
        DashboardData dd = new DashboardData();
        FileInfo fileInfo = new FileInfo(args.locale.getBaseName(), args.coverageLevel, args.choices, args.organization);
        if (args.specificSinglePath != null) {
            fileInfo.setSinglePath(args.specificSinglePath);
        }
        fileInfo.setFiles(args.sourceFile, args.baselineFile);
        fileInfo.setSorted(dd.sorted);
        fileInfo.setVoterProgressAndId(dd.voterProgress, args.userId);
        fileInfo.getFileInfo();
        return dd;
    }

    public LocaleCompletionData generateLocaleCompletion(VettingParameters args) {
        if (!args.sourceFile.isResolved()) {
            throw new IllegalArgumentException("File must be resolved for locale completion");
        }
        FileInfo fileInfo = new FileInfo(args.locale.getBaseName(), args.coverageLevel, args.choices, args.organization);
        fileInfo.setFiles(args.sourceFile, args.baselineFile);
        fileInfo.getFileInfo();
        return new LocaleCompletionData(fileInfo.vc.problemCounter);
    }

    public int getLocaleCount(Organization org) {
        int localeCount = 0;
        for (Level lv : Level.values()) {
            Map<String, String> sortedNames = this.getSortedNames(org, lv);
            localeCount += sortedNames.size();
        }
        return localeCount;
    }

    public ArrayList<String> getLocaleList(Organization org) {
        ArrayList<String> list = new ArrayList<String>();
        for (Level lv : Level.values()) {
            Map<String, String> sortedNames = this.getSortedNames(org, lv);
            for (Map.Entry<String, String> entry : sortedNames.entrySet()) {
                list.add(entry.getValue());
            }
        }
        return list;
    }

    public void generatePriorityItemsSummary(Appendable output, EnumSet<NotificationCategory> choices, T organization) throws ExecutionException {
        try {
            String header = this.makeSummaryHeader(choices);
            for (Level level : Level.values()) {
                this.writeSummaryTable(output, header, level, choices, organization);
            }
        }
        catch (IOException e) {
            throw new ICUUncheckedIOException(e);
        }
    }

    private void appendDisplay(StringBuilder target, NotificationCategory category) throws IOException {
        target.append("<span title='").append(category.description);
        target.append("'>").append(category.buttonLabel).append("*</span>");
    }

    private void writeSummaryTable(Appendable output, String header, Level desiredLevel, EnumSet<NotificationCategory> choices, T organization) throws IOException, ExecutionException {
        Map<String, String> sortedNames = this.getSortedNames((Organization)((Object)organization), desiredLevel);
        if (sortedNames.isEmpty()) {
            return;
        }
        output.append("<h2>Level: ").append(desiredLevel.toString()).append("</h2>");
        output.append("<table class='tvs-table'>\n");
        Map<String, FileInfo> localeNameToFileInfo = null;
        VettingCounters totals = new VettingCounters();
        Set<Map.Entry<String, String>> entrySet = sortedNames.entrySet();
        WriteContext context = new WriteContext(entrySet, choices, organization, totals, localeNameToFileInfo, header);
        WriteAction writeAction = new WriteAction(context);
        writeAction.computeAll();
        context.appendTo(output);
        output.append(header);
        this.writeSummaryRow(output, choices, totals.problemCounter, "Total", null, desiredLevel);
        output.append("</table>");
    }

    private Map<String, String> getSortedNames(Organization org, Level desiredLevel) {
        TreeMap<Object, String> sortedNames = new TreeMap<Object, String>(CLDRConfig.getInstance().getCollator());
        LocalesWithExplicitLevel includeLocale = new LocalesWithExplicitLevel(org, desiredLevel);
        for (String localeID : this.cldrFactory.getAvailable()) {
            if (this.defaultContentLocales.contains(localeID) || localeID.equals("en") || !includeLocale.is(localeID)) continue;
            sortedNames.put(this.getName(localeID), localeID);
        }
        return sortedNames;
    }

    private void showSubtypes(Appendable output, Map<String, String> sortedNames, Map<String, FileInfo> localeNameToFileInfo, VettingCounters totals, boolean errors) throws IOException {
        output.append("<h3>Details: ").append(errors ? "Error Types" : "Warning Types").append("</h3>");
        output.append("<table class='tvs-table'>");
        Counter<CheckCLDR.CheckStatus.Subtype> subtypeCounterTotals = errors ? totals.errorSubtypeCounter : totals.warningSubtypeCounter;
        Set<CheckCLDR.CheckStatus.Subtype> sortedBySize = subtypeCounterTotals.getKeysetSortedByCount(false);
        this.writeDetailHeader(sortedBySize, output);
        for (Map.Entry<String, FileInfo> entry : localeNameToFileInfo.entrySet()) {
            Counter<CheckCLDR.CheckStatus.Subtype> counter;
            Counter<CheckCLDR.CheckStatus.Subtype> counter2 = counter = errors ? entry.getValue().vc.errorSubtypeCounter : entry.getValue().vc.warningSubtypeCounter;
            if (counter.getTotal() == 0L) continue;
            String name = entry.getKey();
            String localeID = sortedNames.get(name);
            output.append("<tr>").append(TH_AND_STYLES);
            this.appendNameAndCode(name, localeID, output);
            output.append("</th>");
            for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
                long count = counter.get(subtype);
                output.append("<td class='tvs-count'>");
                if (count != 0L) {
                    output.append(nf.format(count));
                }
                output.append("</td>");
            }
        }
        this.writeDetailHeader(sortedBySize, output);
        output.append("<tr>").append(TH_AND_STYLES).append("<i>Total</i>").append("</th>").append(TH_AND_STYLES).append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            long count = subtypeCounterTotals.get(subtype);
            output.append("<td class='tvs-count'>");
            if (count != 0L) {
                output.append("<b>").append(nf.format(count)).append("</b>");
            }
            output.append("</td>");
        }
        output.append("</table>");
    }

    private void writeDetailHeader(Set<CheckCLDR.CheckStatus.Subtype> sortedBySize, Appendable output) throws IOException {
        output.append("<tr>").append(TH_AND_STYLES).append("Name").append("</th>").append(TH_AND_STYLES).append("ID").append("</th>");
        for (CheckCLDR.CheckStatus.Subtype subtype : sortedBySize) {
            output.append(TH_AND_STYLES).append(subtype.toString()).append("</th>");
        }
    }

    private String makeSummaryHeader(EnumSet<NotificationCategory> choices) throws IOException {
        StringBuilder headerRow = new StringBuilder();
        headerRow.append("<tr class='tvs-tr'>").append(TH_AND_STYLES).append("Level</th>").append(TH_AND_STYLES).append("Locale</th>").append(TH_AND_STYLES).append("Codes</th>").append(TH_AND_STYLES).append("Progress</th>");
        for (NotificationCategory choice : choices) {
            headerRow.append("<th class='tv-th'>");
            this.appendDisplay(headerRow, choice);
            headerRow.append("</th>");
        }
        headerRow.append(TH_AND_STYLES).append("Status</th>");
        headerRow.append("</tr>\n");
        return headerRow.toString();
    }

    private void writeSummaryRow(Appendable output, EnumSet<NotificationCategory> choices, Counter<NotificationCategory> problemCounter, String name, String localeID, Level level) throws IOException, ExecutionException {
        output.append("<tr>").append(TH_AND_STYLES).append(level.toString()).append("</th>").append(TH_AND_STYLES);
        if (localeID == null) {
            output.append("<i>").append(name).append("</i>").append("</th>").append(TH_AND_STYLES);
        } else {
            this.appendNameAndCode(name, localeID, output);
        }
        output.append("</th>\n");
        String progPerc = localeID == null ? "" : this.getLocaleProgressPercent(localeID, problemCounter);
        output.append("<td class='tvs-count'>").append(progPerc).append("</td>\n");
        for (NotificationCategory choice : choices) {
            long count = problemCounter.get(choice);
            output.append("<td class='tvs-count'>");
            if (localeID == null) {
                output.append("<b>");
            }
            output.append(nf.format(count));
            if (localeID == null) {
                output.append("</b>");
            }
            output.append("</td>\n");
        }
        this.addLocaleStatusColumn(output, localeID);
        output.append("</tr>\n");
    }

    private void addLocaleStatusColumn(Appendable output, String localeID) throws IOException {
        output.append("<td class='tvs-count'>");
        if (localeID != null) {
            output.append(this.getLocaleStatusColumn(CLDRLocale.getInstance(localeID)));
        }
        output.append("</td>\n");
    }

    private String getLocaleStatusColumn(CLDRLocale locale) {
        if (SpecialLocales.getType(locale) == SpecialLocales.Type.algorithmic) {
            return "AL";
        }
        if (Organization.special.getCoveredLocales().containsLocaleOrParent(locale)) {
            return "HC";
        }
        if (Organization.cldr.getCoveredLocales().containsLocaleOrParent(locale)) {
            return "TC";
        }
        return "";
    }

    private String getLocaleProgressPercent(String localeId, Counter<NotificationCategory> problemCounter) throws ExecutionException {
        int total;
        LocaleCompletionData lcd = new LocaleCompletionData(problemCounter);
        int problemCount = lcd.problemCount();
        int done = problemCount >= (total = this.localeBaselineCount.getBaselineProblemCount(CLDRLocale.getInstance(localeId))) ? 0 : total - problemCount;
        int perc = CompletionPercent.calculate(done, total);
        if (perc == 100 && problemCount > 0) {
            perc = 99;
        }
        return perc + "%";
    }

    private void appendNameAndCode(String name, String localeID, Appendable output) throws IOException {
        String url = "v#/" + localeID + "//";
        String[] names = name.split(SPLIT_CHAR);
        output.append("<a href='" + url).append("'>").append(TransliteratorUtilities.toHTML.transform(names[0])).append("</a>").append("</th>").append(TH_AND_STYLES).append("<code>").append(names[1]).append("</code>");
    }

    private String getName(String localeID) {
        Set<String> contents = this.supplementalDataInfo.getEquivalentsForLocale(localeID);
        return this.englishFile.getName(localeID, true, CLDRFile.SHORT_ALTS) + SPLIT_CHAR + VettingViewer.gatherCodes(contents);
    }

    private static String gatherCodes(Set<String> contents) {
        LinkedHashSet<Set<String>> source = new LinkedHashSet<Set<String>>();
        for (String s2 : contents) {
            source.add(new LinkedHashSet<String>(Arrays.asList(s2.split("_"))));
        }
        LinkedHashSet<Set<String>> oldSource = new LinkedHashSet<Set<String>>();
        do {
            oldSource.clear();
            oldSource.addAll(source);
            source.clear();
            Set<String> last = null;
            for (Set<String> set : oldSource) {
                if (last == null) {
                    last = set;
                    continue;
                }
                if (set.containsAll(last)) {
                    last = VettingViewer.combine(last, set);
                    continue;
                }
                source.add(last);
                last = set;
            }
            source.add(last);
        } while (oldSource.size() != source.size());
        StringBuilder b = new StringBuilder();
        for (Set set : source) {
            if (b.length() != 0) {
                b.append(", ");
            }
            String sep = "";
            for (String string : set) {
                if (string.startsWith(CONNECT_PREFIX)) {
                    b.append(string + CONNECT_SUFFIX);
                } else {
                    b.append(sep + string);
                }
                sep = "_";
            }
        }
        return b.toString();
    }

    private static Set<String> combine(Set<String> last, Set<String> ss) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String s2 : ss) {
            if (last.contains(s2)) {
                result.add(s2);
                continue;
            }
            result.add(CONNECT_PREFIX + s2);
        }
        return result;
    }

    public static MissingStatus getMissingStatus(CLDRFile sourceFile, String path, boolean latin) {
        MissingStatus result;
        boolean isAliased;
        if (sourceFile == null) {
            return MissingStatus.ABSENT;
        }
        String sourceLocaleID = sourceFile.getLocaleID();
        if ("root".equals(sourceLocaleID)) {
            return MissingStatus.MISSING_OK;
        }
        String value = sourceFile.getStringValue(path);
        CLDRFile.Status status = new CLDRFile.Status();
        String sourceLocale = sourceFile.getSourceLocaleIdExtended(path, status, false);
        boolean bl = isAliased = !path.equals(status.pathWhereFound);
        if (value == null) {
            result = ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.MISSING_OK : MissingStatus.ABSENT;
        } else {
            String localeFound = sourceFile.getSourceLocaleIdExtended(path, status, false);
            boolean localeFoundIsRootOrCodeFallback = localeFound.equals("root") || localeFound.equals("code-fallback");
            boolean isParentRoot = CLDRLocale.getInstance(sourceFile.getLocaleID()).isParentRoot();
            result = localeFoundIsRootOrCodeFallback ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.ROOT_OK : (isParentRoot ? MissingStatus.ABSENT : MissingStatus.ALIASED)) : (!isAliased ? MissingStatus.PRESENT : (isParentRoot ? (ValuePathStatus.isMissingOk(sourceFile, path, latin, isAliased) ? MissingStatus.MISSING_OK : MissingStatus.ABSENT) : MissingStatus.ALIASED));
        }
        return result;
    }

    public static boolean isLatinScriptLocale(CLDRFile sourceFile) {
        return ValuePathStatus.isLatinScriptLocale(sourceFile);
    }

    private static void appendToMessage(CharSequence usersValue, CheckCLDR.CheckStatus.Subtype subtype, StringBuilder testMessage) {
        if (subtype != null) {
            usersValue = "&lt;" + subtype + "&gt; " + (CharSequence)usersValue;
        }
        VettingViewer.appendToMessage((CharSequence)usersValue, testMessage);
    }

    private static void appendToMessage(CharSequence usersValue, StringBuilder testMessage) {
        if (usersValue.length() == 0) {
            return;
        }
        if (testMessage.length() != 0) {
            testMessage.append("<br>");
        }
        testMessage.append(usersValue);
    }

    public VettingViewer<T> setProgressCallback(ProgressCallback newCallback) {
        this.progressCallback = newCallback;
        return this;
    }

    public static String getHeaderStyles() {
        return "<style>\n.hide {display:none}\n.vve {}\n.vvn {}\n.vvp {}\n.vvl {}\n.vvm {}\n.vvu {}\n.vvw {}\n.vvd {}\n.vvo {}\n</style>";
    }

    public static void getStatus(CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        VettingViewer.getStatus(file.fullIterable(), file, pathHeaderFactory, foundCounter, unconfirmedCounter, missingCounter, missingPaths, unconfirmedPaths);
    }

    public static void getStatus(Iterable<String> allPaths, CLDRFile file, PathHeader.Factory pathHeaderFactory, Counter<Level> foundCounter, Counter<Level> unconfirmedCounter, Counter<Level> missingCounter, Relation<MissingStatus, String> missingPaths, Set<String> unconfirmedPaths) {
        if (!file.isResolved()) {
            throw new IllegalArgumentException("File must be resolved, no minimal draft status");
        }
        foundCounter.clear();
        unconfirmedCounter.clear();
        missingCounter.clear();
        boolean latin = VettingViewer.isLatinScriptLocale(file);
        CoverageLevel2 coverageLevel2 = CoverageLevel2.getInstance(SupplementalDataInfo.getInstance(), file.getLocaleID());
        block5: for (String path : allPaths) {
            Level level;
            PathHeader ph = pathHeaderFactory.fromPath(path);
            if (ph.getSectionId() == PathHeader.SectionId.Special || (level = coverageLevel2.getLevel(path)).compareTo(Level.MODERN) > 0) continue;
            MissingStatus missingStatus = VettingViewer.getMissingStatus(file, path, latin);
            switch (missingStatus) {
                case ABSENT: {
                    missingCounter.add(level, 1L);
                    if (missingPaths == null) continue block5;
                    missingPaths.put(missingStatus, path);
                    continue block5;
                }
                case ALIASED: 
                case PRESENT: {
                    String fullPath = file.getFullXPath(path);
                    if (fullPath.contains("unconfirmed") || fullPath.contains("provisional")) {
                        unconfirmedCounter.add(level, 1L);
                        if (unconfirmedPaths == null) continue block5;
                        unconfirmedPaths.add(path);
                        continue block5;
                    }
                    foundCounter.add(level, 1L);
                    continue block5;
                }
                case MISSING_OK: 
                case ROOT_OK: {
                    continue block5;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static EnumSet<NotificationCategory> getDashboardNotificationCategories(Organization usersOrg) {
        EnumSet<NotificationCategory> choiceSet = EnumSet.allOf(NotificationCategory.class);
        if (VettingViewer.orgIsNeutralForSummary(usersOrg)) {
            choiceSet = EnumSet.of(NotificationCategory.error, NotificationCategory.warning, NotificationCategory.hasDispute, NotificationCategory.notApproved, NotificationCategory.missingCoverage);
        }
        return choiceSet;
    }

    public static EnumSet<NotificationCategory> getPriorityItemsSummaryCategories(Organization org) {
        EnumSet<NotificationCategory> set = VettingViewer.getDashboardNotificationCategories(org);
        set.remove((Object)NotificationCategory.abstained);
        return set;
    }

    public static EnumSet<NotificationCategory> getLocaleCompletionCategories() {
        return localeCompletionCategories;
    }

    public void setSummarizeAllLocales(boolean b) {
        this.summarizeAllLocales = b;
    }

    static {
        outdatedPaths = new OutdatedPaths();
        LATIN = ValuePathStatus.LATIN;
        nf = NumberFormat.getIntegerInstance(ULocale.ENGLISH);
        nf.setGroupingUsed(true);
        localeCompletionCategories = EnumSet.of(NotificationCategory.error, NotificationCategory.hasDispute, NotificationCategory.notApproved, NotificationCategory.missingCoverage);
    }

    public static interface LocaleBaselineCount {
        public int getBaselineProblemCount(CLDRLocale var1) throws ExecutionException;
    }

    public static class ProgressCallback {
        public void nudge() {
        }

        public void done() {
        }

        public boolean isStopped() {
            return false;
        }
    }

    public static enum MissingStatus {
        PRESENT,
        ALIASED,
        MISSING_OK,
        ROOT_OK,
        ABSENT;

    }

    private class WriteAction
    extends RecursiveAction {
        private final int length;
        private final int start;
        private final WriteContext context;
        private static final long serialVersionUID = 1L;

        public WriteAction(WriteContext context) {
            this(context, 0, context.size());
        }

        public WriteAction(WriteContext context, int start, int length) {
            this.context = context;
            this.start = start;
            this.length = length;
        }

        @Override
        protected void compute() {
            if (this.length == 0) {
                return;
            }
            if (this.length <= this.context.configChunkSize) {
                this.computeAll();
            } else {
                int split = this.length / 2;
                WriteAction.invokeAll(new WriteAction(this.context, this.start, split), new WriteAction(this.context, this.start + split, this.length - split));
            }
        }

        private void computeAll() {
            for (int n = this.start; n < this.start + this.length; ++n) {
                this.computeOne(n);
            }
        }

        private void computeOne(int n) {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            String name = this.context.localeNames.get(n);
            String localeID = this.context.localeIds.get(n);
            EnumSet<NotificationCategory> choices = this.context.choices;
            StringBuffer output = this.context.outputs[n];
            if (output == null) {
                throw new NullPointerException("output " + n + " null");
            }
            CLDRFile sourceFile = VettingViewer.this.cldrFactory.make(localeID, true);
            CLDRFile baselineFile = null;
            if (!this.context.ourChoicesThatRequireOldFile.isEmpty()) {
                try {
                    Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
                    baselineFile = baselineFactory.make(localeID, true);
                }
                catch (Exception baselineFactory) {
                    // empty catch block
                }
            }
            Level level = Level.MODERN;
            if (this.context.organization != null) {
                StandardCodes sc = StandardCodes.make();
                level = VettingViewer.orgIsNeutralForSummary((Organization)((Object)this.context.organization)) ? sc.getTargetCoverageLevel(localeID) : sc.getLocaleCoverageLevel(this.context.organization.toString(), localeID);
            }
            FileInfo fileInfo = new FileInfo(localeID, level, choices, this.context.organization);
            fileInfo.setFiles(sourceFile, baselineFile);
            fileInfo.getFileInfo();
            if (this.context.localeNameToFileInfo != null) {
                this.context.localeNameToFileInfo.put(name, fileInfo);
            }
            this.context.totals.addAll(fileInfo.vc);
            try {
                VettingViewer.this.writeSummaryRow(output, choices, fileInfo.vc.problemCounter, name, localeID, level);
            }
            catch (IOException | ExecutionException e) {
                System.err.println("writeAction.compute(" + n + ") - writeexc " + name + ": " + localeID);
                this.completeExceptionally(new RuntimeException("While writing " + localeID, e));
            }
        }
    }

    private class WriteContext {
        private final List<String> localeNames = new ArrayList<String>();
        private final List<String> localeIds = new ArrayList<String>();
        private final StringBuffer[] outputs;
        private final EnumSet<NotificationCategory> choices;
        private final EnumSet<NotificationCategory> ourChoicesThatRequireOldFile;
        private final T organization;
        private final VettingCounters totals;
        private final Map<String, FileInfo> localeNameToFileInfo;
        private final String header;
        private final int configChunkSize;

        private WriteContext(Set<Map.Entry<String, String>> entrySet, EnumSet<NotificationCategory> choices, T organization, VettingCounters totals, Map<String, FileInfo> localeNameToFileInfo, String header) {
            for (Map.Entry<String, String> e : entrySet) {
                this.localeNames.add(e.getKey());
                this.localeIds.add(e.getValue());
            }
            int count = this.localeNames.size();
            this.outputs = new StringBuffer[count];
            for (int i = 0; i < count; ++i) {
                this.outputs[i] = new StringBuffer();
            }
            this.choices = choices;
            EnumSet<NotificationCategory> thingsThatRequireOldFile = EnumSet.of(NotificationCategory.englishChanged, NotificationCategory.missingCoverage, NotificationCategory.changedOldValue, NotificationCategory.inheritedChanged);
            this.ourChoicesThatRequireOldFile = choices.clone();
            this.ourChoicesThatRequireOldFile.retainAll(thingsThatRequireOldFile);
            this.organization = organization;
            this.totals = totals;
            this.localeNameToFileInfo = localeNameToFileInfo;
            this.header = header;
            CLDRConfig config = CLDRConfig.getInstance();
            int configParallel = Math.max(config.getProperty("CLDR_VETTINGVIEWER_PARALLEL", 0), 0);
            if (configParallel < 1) {
                configParallel = Runtime.getRuntime().availableProcessors();
            }
            this.configChunkSize = Math.max(config.getProperty("CLDR_VETTINGVIEWER_CHUNKSIZE", 1), 1);
        }

        private void appendTo(Appendable output) throws IOException {
            char lastChar = ' ';
            for (int n = 0; n < this.outputs.length; ++n) {
                String name = this.localeNames.get(n);
                char nextChar = name.charAt(0);
                if (lastChar != nextChar) {
                    output.append(this.header);
                    lastChar = nextChar;
                }
                output.append(this.outputs[n]);
            }
        }

        private int size() {
            return this.localeNames.size();
        }
    }

    public final class LocalesWithExplicitLevel
    implements Predicate<String> {
        private final Organization org;
        private final Level desiredLevel;

        public LocalesWithExplicitLevel(Organization org, Level level) {
            this.org = org;
            this.desiredLevel = level;
        }

        @Override
        public boolean is(String localeId) {
            StandardCodes sc = StandardCodes.make();
            if (VettingViewer.orgIsNeutralForSummary(this.org)) {
                if (!VettingViewer.this.summarizeAllLocales && !SubmissionLocales.CLDR_LOCALES.contains(localeId)) {
                    return false;
                }
                return this.desiredLevel == sc.getTargetCoverageLevel(localeId);
            }
            Output<StandardCodes.LocaleCoverageType> output = new Output<StandardCodes.LocaleCoverageType>();
            Level level = sc.getLocaleCoverageLevel(this.org, localeId, output);
            return this.desiredLevel == level && output.value == StandardCodes.LocaleCoverageType.explicit;
        }
    }

    private class FileInfo {
        private final String localeId;
        private final CLDRLocale cldrLocale;
        private final Level usersLevel;
        private final EnumSet<NotificationCategory> choices;
        private final T organization;
        private CLDRFile sourceFile = null;
        private CLDRFile baselineFile = null;
        private CLDRFile baselineFileUnresolved = null;
        private boolean latin = false;
        private Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = null;
        private int voterId = 0;
        private VoterProgress voterProgress = null;
        private final VettingCounters vc = new VettingCounters();
        private final EnumSet<NotificationCategory> problems = EnumSet.noneOf(NotificationCategory.class);
        private final StringBuilder htmlMessage = new StringBuilder();
        private final StringBuilder statusMessage = new StringBuilder();
        private final EnumSet<CheckCLDR.CheckStatus.Subtype> subtypes = EnumSet.noneOf(CheckCLDR.CheckStatus.Subtype.class);
        private final DefaultErrorStatus errorChecker;
        private String specificSinglePath;

        private FileInfo(String localeId, Level level, EnumSet<NotificationCategory> choices, T organization) {
            this.errorChecker = new DefaultErrorStatus(VettingViewer.this.cldrFactory);
            this.specificSinglePath = null;
            this.localeId = localeId;
            this.cldrLocale = CLDRLocale.getInstance(localeId);
            this.usersLevel = level;
            this.choices = choices;
            this.organization = organization;
        }

        private void setFiles(CLDRFile sourceFile, CLDRFile baselineFile) {
            this.sourceFile = sourceFile;
            this.baselineFile = baselineFile;
            this.baselineFileUnresolved = baselineFile == null ? null : baselineFile.getUnresolved();
            this.latin = VettingViewer.isLatinScriptLocale(sourceFile);
        }

        private void setSorted(Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted) {
            this.sorted = sorted;
        }

        private void setVoterProgressAndId(VoterProgress voterProgress, int userId) {
            this.voterProgress = voterProgress;
            this.voterId = userId;
        }

        private void setSinglePath(String path) {
            this.specificSinglePath = path;
        }

        private void getFileInfo() {
            if (VettingViewer.this.progressCallback.isStopped()) {
                throw new RuntimeException("Requested to stop");
            }
            this.errorChecker.initErrorStatus(this.sourceFile);
            if (this.specificSinglePath != null) {
                this.handleOnePath(this.specificSinglePath);
                return;
            }
            HashSet<String> seenSoFar = new HashSet<String>();
            for (String path : this.sourceFile.fullIterable()) {
                if (seenSoFar.contains(path)) continue;
                seenSoFar.add(path);
                VettingViewer.this.progressCallback.nudge();
                this.handleOnePath(path);
            }
        }

        private void handleOnePath(String path) {
            VoteStatus voteStatus;
            String oldValue;
            boolean pathLevelIsTooHigh;
            PathHeader ph = pathTransform.fromPath(path);
            if (ph == null || ph.shouldHide()) {
                return;
            }
            String value = this.sourceFile.getWinningValue(path);
            this.statusMessage.setLength(0);
            this.subtypes.clear();
            ErrorChecker.Status errorStatus = this.errorChecker.getErrorStatus(path, value, this.statusMessage, this.subtypes);
            Level pathLevel = VettingViewer.this.supplementalDataInfo.getCoverageLevel(path, this.localeId);
            boolean onlyRecordErrors = pathLevelIsTooHigh = pathLevel.compareTo(this.usersLevel) > 0;
            this.problems.clear();
            this.htmlMessage.setLength(0);
            String string = oldValue = this.baselineFileUnresolved == null ? null : this.baselineFileUnresolved.getWinningValue(path);
            if (this.skipForLimitedSubmission(path, errorStatus, oldValue)) {
                return;
            }
            if (!onlyRecordErrors && this.choices.contains((Object)NotificationCategory.changedOldValue) && this.changedFromBaseline(path, value, oldValue, this.sourceFile)) {
                this.problems.add(NotificationCategory.changedOldValue);
                this.vc.problemCounter.increment(NotificationCategory.changedOldValue);
            }
            if (!onlyRecordErrors && this.choices.contains((Object)NotificationCategory.inheritedChanged) && this.inheritedChangedFromBaseline(path, value, this.sourceFile)) {
                this.problems.add(NotificationCategory.inheritedChanged);
                this.vc.problemCounter.increment(NotificationCategory.inheritedChanged);
            }
            boolean itemsOkIfVoted = (voteStatus = VettingViewer.this.userVoteStatus.getStatusForUsersOrganization(this.sourceFile, path, this.organization)) == VoteStatus.ok;
            MissingStatus missingStatus = onlyRecordErrors ? null : this.recordMissingChangedEtc(path, itemsOkIfVoted, value, oldValue);
            this.recordChoice(errorStatus, itemsOkIfVoted, onlyRecordErrors);
            if (!onlyRecordErrors) {
                this.recordLosingDisputedEtc(path, voteStatus, missingStatus);
            }
            if (pathLevelIsTooHigh && this.problems.isEmpty()) {
                return;
            }
            this.updateVotedOrAbstained(path);
            if (!this.problems.isEmpty() && this.sorted != null) {
                VettingViewer.this.reasonsToPaths.clear();
                Row.R2<PathHeader.SectionId, PathHeader.PageId> group = Row.of(ph.getSectionId(), ph.getPageId());
                this.sorted.put(group, new WritingInfo(ph, this.problems, this.htmlMessage, this.firstSubtype()));
            }
        }

        private boolean changedFromBaseline(String path, String value, String oldValue, CLDRFile sourceFile) {
            if (oldValue != null && !oldValue.equals(value)) {
                String baileyValue;
                return !CldrUtility.INHERITANCE_MARKER.equals(oldValue) || (baileyValue = sourceFile.getBaileyValue(path, null, null)) == null || !baileyValue.equals(value);
            }
            return false;
        }

        private boolean inheritedChangedFromBaseline(String path, String value, CLDRFile sourceFile) {
            String baselineInheritedValue;
            Output<String> pathWhereFound = new Output<String>();
            Output<String> localeWhereFound = new Output<String>();
            String baileyValue = sourceFile.getBaileyValue(path, pathWhereFound, localeWhereFound);
            if (baileyValue == null || "constructed".equals(pathWhereFound.toString()) || "root".equals(localeWhereFound.toString()) || "code-fallback".equals(localeWhereFound.toString())) {
                return false;
            }
            if (!baileyValue.equals(value) && !CldrUtility.INHERITANCE_MARKER.equals(value)) {
                return false;
            }
            if (localeWhereFound.toString().equals(this.localeId)) {
                baselineInheritedValue = this.baselineFile.getWinningValue(pathWhereFound.toString());
            } else {
                Factory baselineFactory = CLDRConfig.getInstance().getCommonAndSeedAndMainAndAnnotationsFactory();
                CLDRFile parentFile = baselineFactory.make(localeWhereFound.toString(), true);
                baselineInheritedValue = parentFile.getWinningValue(pathWhereFound.toString());
            }
            return !baileyValue.equals(baselineInheritedValue);
        }

        private CheckCLDR.CheckStatus.Subtype firstSubtype() {
            for (CheckCLDR.CheckStatus.Subtype subtype : this.subtypes) {
                if (subtype == CheckCLDR.CheckStatus.Subtype.none) continue;
                return subtype;
            }
            return CheckCLDR.CheckStatus.Subtype.none;
        }

        private void updateVotedOrAbstained(String path) {
            if (this.voterProgress == null || this.voterId == 0) {
                return;
            }
            this.voterProgress.incrementVotablePathCount();
            if (VettingViewer.this.userVoteStatus.userDidVote(this.voterId, this.cldrLocale, path)) {
                VoteType voteType = VettingViewer.this.userVoteStatus.getUserVoteType(this.voterId, this.cldrLocale, path);
                this.voterProgress.incrementVotedPathCount(voteType);
            } else if (this.choices.contains((Object)NotificationCategory.abstained)) {
                this.problems.add(NotificationCategory.abstained);
                this.vc.problemCounter.increment(NotificationCategory.abstained);
            }
        }

        private boolean skipForLimitedSubmission(String path, ErrorChecker.Status errorStatus, String oldValue) {
            return false;
        }

        private MissingStatus recordMissingChangedEtc(String path, boolean itemsOkIfVoted, String value, String oldValue) {
            VoteResolver<String> resolver = VettingViewer.this.userVoteStatus.getVoteResolver(this.baselineFile, this.cldrLocale, path);
            MissingStatus missingStatus = resolver.getWinningStatus() == VoteResolver.Status.missing ? VettingViewer.getMissingStatus(this.sourceFile, path, this.latin) : MissingStatus.PRESENT;
            if (this.choices.contains((Object)NotificationCategory.missingCoverage) && missingStatus == MissingStatus.ABSENT) {
                this.problems.add(NotificationCategory.missingCoverage);
                this.vc.problemCounter.increment(NotificationCategory.missingCoverage);
            }
            if (!itemsOkIfVoted && outdatedPaths.isOutdated(this.localeId, path)) {
                this.recordEnglishChanged(path, value, oldValue);
            }
            return missingStatus;
        }

        private void recordEnglishChanged(String path, String value, String oldValue) {
            String oldEnglishValue;
            if (Objects.equals(value, oldValue) && this.choices.contains((Object)NotificationCategory.englishChanged) && !"\ufffd".equals(oldEnglishValue = outdatedPaths.getPreviousEnglish(path))) {
                this.problems.add(NotificationCategory.englishChanged);
                this.vc.problemCounter.increment(NotificationCategory.englishChanged);
            }
        }

        private void recordChoice(ErrorChecker.Status errorStatus, boolean itemsOkIfVoted, boolean onlyRecordErrors) {
            block3: {
                NotificationCategory choice;
                block2: {
                    NotificationCategory notificationCategory = errorStatus == ErrorChecker.Status.error ? NotificationCategory.error : (choice = errorStatus == ErrorChecker.Status.warning ? NotificationCategory.warning : null);
                    if (choice != NotificationCategory.error || !this.choices.contains((Object)NotificationCategory.error) || itemsOkIfVoted && OK_IF_VOTED.containsAll(this.subtypes)) break block2;
                    this.problems.add(choice);
                    VettingViewer.appendToMessage(this.statusMessage, this.htmlMessage);
                    this.vc.problemCounter.increment(choice);
                    for (CheckCLDR.CheckStatus.Subtype subtype : this.subtypes) {
                        this.vc.errorSubtypeCounter.increment(subtype);
                    }
                    break block3;
                }
                if (onlyRecordErrors || choice != NotificationCategory.warning || !this.choices.contains((Object)NotificationCategory.warning) || itemsOkIfVoted && OK_IF_VOTED.containsAll(this.subtypes)) break block3;
                this.problems.add(choice);
                VettingViewer.appendToMessage(this.statusMessage, this.htmlMessage);
                this.vc.problemCounter.increment(choice);
                for (CheckCLDR.CheckStatus.Subtype subtype : this.subtypes) {
                    this.vc.warningSubtypeCounter.increment(subtype);
                }
            }
        }

        private void recordLosingDisputedEtc(String path, VoteStatus voteStatus, MissingStatus missingStatus) {
            switch (voteStatus) {
                case losing: {
                    Object usersValue;
                    if (this.choices.contains((Object)NotificationCategory.weLost)) {
                        this.problems.add(NotificationCategory.weLost);
                        this.vc.problemCounter.increment(NotificationCategory.weLost);
                    }
                    if ((usersValue = VettingViewer.this.userVoteStatus.getWinningValueForUsersOrganization(this.sourceFile, path, this.organization)) == null) break;
                    usersValue = "Losing value: <" + TransliteratorUtilities.toHTML.transform((String)usersValue) + ">";
                    VettingViewer.appendToMessage((CharSequence)usersValue, this.htmlMessage);
                    break;
                }
                case disputed: {
                    if (!this.choices.contains((Object)NotificationCategory.hasDispute)) break;
                    this.problems.add(NotificationCategory.hasDispute);
                    this.vc.problemCounter.increment(NotificationCategory.hasDispute);
                    break;
                }
                case provisionalOrWorse: {
                    if (missingStatus != MissingStatus.PRESENT || !this.choices.contains((Object)NotificationCategory.notApproved)) break;
                    this.problems.add(NotificationCategory.notApproved);
                    this.vc.problemCounter.increment(NotificationCategory.notApproved);
                    break;
                }
            }
        }
    }

    private class VettingCounters {
        private final Counter<NotificationCategory> problemCounter = new Counter();
        private final Counter<CheckCLDR.CheckStatus.Subtype> errorSubtypeCounter = new Counter();
        private final Counter<CheckCLDR.CheckStatus.Subtype> warningSubtypeCounter = new Counter();

        private VettingCounters() {
        }

        private void addAll(VettingCounters other) {
            this.problemCounter.addAll(other.problemCounter);
            this.errorSubtypeCounter.addAll(other.errorSubtypeCounter);
            this.warningSubtypeCounter.addAll(other.warningSubtypeCounter);
        }
    }

    public class DashboardData {
        public Relation<Row.R2<PathHeader.SectionId, PathHeader.PageId>, WritingInfo> sorted = Relation.of(new TreeMap(), TreeSet.class);
        public VoterProgress voterProgress = new VoterProgress();
    }

    public class WritingInfo
    implements Comparable<WritingInfo> {
        public final PathHeader codeOutput;
        public final Set<NotificationCategory> problems;
        public final String htmlMessage;
        public final CheckCLDR.CheckStatus.Subtype subtype;

        public WritingInfo(PathHeader ph, EnumSet<NotificationCategory> problems, CharSequence htmlMessage, CheckCLDR.CheckStatus.Subtype subtype) {
            this.codeOutput = ph;
            this.problems = Collections.unmodifiableSet(problems.clone());
            this.htmlMessage = htmlMessage.toString();
            this.subtype = subtype;
        }

        @Override
        public int compareTo(WritingInfo other) {
            return this.codeOutput.compareTo(other.codeOutput);
        }
    }

    private static class DefaultErrorStatus
    implements ErrorChecker {
        private CheckCLDR checkCldr;
        private HashMap<String, String> options = new HashMap();
        private ArrayList<CheckCLDR.CheckStatus> result = new ArrayList();
        private CLDRFile cldrFile;
        private final Factory factory;

        private DefaultErrorStatus(Factory cldrFactory) {
            this.factory = cldrFactory;
        }

        @Override
        public ErrorChecker.Status initErrorStatus(CLDRFile cldrFile) {
            this.cldrFile = cldrFile;
            this.options = new HashMap();
            this.result = new ArrayList();
            this.checkCldr = CheckCLDR.getCheckAll(this.factory, ".*");
            this.checkCldr.setCldrFileToCheck(cldrFile, new CheckCLDR.Options(this.options), this.result);
            return ErrorChecker.Status.ok;
        }

        @Override
        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String path, String value) {
            String fullPath = this.cldrFile.getFullXPath(path);
            ArrayList<CheckCLDR.CheckStatus> result2 = new ArrayList<CheckCLDR.CheckStatus>();
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), result2);
            return result2;
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage) {
            return this.getErrorStatus(path, value, statusMessage, null);
        }

        @Override
        public ErrorChecker.Status getErrorStatus(String path, String value, StringBuilder statusMessage, EnumSet<CheckCLDR.CheckStatus.Subtype> outputSubtypes) {
            ErrorChecker.Status result0 = ErrorChecker.Status.ok;
            StringBuilder errorMessage = new StringBuilder();
            String fullPath = this.cldrFile.getFullXPath(path);
            this.checkCldr.check(path, fullPath, value, new CheckCLDR.Options(this.options), this.result);
            for (CheckCLDR.CheckStatus checkStatus : this.result) {
                CheckCLDR cause = checkStatus.getCause();
                if (cause instanceof CheckCoverage || cause instanceof CheckNew) continue;
                CheckCLDR.CheckStatus.Type statusType = checkStatus.getType();
                if (statusType.equals((Object)CheckCLDR.CheckStatus.errorType)) {
                    if (result0 == ErrorChecker.Status.warning) {
                        errorMessage.setLength(0);
                        if (outputSubtypes != null) {
                            outputSubtypes.clear();
                        }
                    }
                    result0 = ErrorChecker.Status.error;
                    if (outputSubtypes != null) {
                        outputSubtypes.add(checkStatus.getSubtype());
                    }
                    VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
                    continue;
                }
                if (result0 == ErrorChecker.Status.error || !statusType.equals((Object)CheckCLDR.CheckStatus.warningType)) continue;
                result0 = ErrorChecker.Status.warning;
                if (outputSubtypes != null) {
                    outputSubtypes.add(checkStatus.getSubtype());
                }
                VettingViewer.appendToMessage(checkStatus.getMessage(), checkStatus.getSubtype(), errorMessage);
            }
            if (result0 != ErrorChecker.Status.ok) {
                VettingViewer.appendToMessage(errorMessage, statusMessage);
            }
            return result0;
        }
    }

    public static interface ErrorChecker {
        public Status initErrorStatus(CLDRFile var1);

        public List<CheckCLDR.CheckStatus> getErrorCheckStatus(String var1, String var2);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3);

        public Status getErrorStatus(String var1, String var2, StringBuilder var3, EnumSet<CheckCLDR.CheckStatus.Subtype> var4);

        public static enum Status {
            ok,
            error,
            warning;

        }
    }

    public static interface UsersChoice<T> {
        public String getWinningValueForUsersOrganization(CLDRFile var1, String var2, T var3);

        public VoteStatus getStatusForUsersOrganization(CLDRFile var1, String var2, T var3);

        public boolean userDidVote(int var1, CLDRLocale var2, String var3);

        public VoteResolver<String> getVoteResolver(CLDRFile var1, CLDRLocale var2, String var3);

        public VoteType getUserVoteType(int var1, CLDRLocale var2, String var3);
    }

    public static enum VoteStatus {
        ok_novotes,
        ok,
        provisionalOrWorse,
        losing,
        disputed;

    }
}

