/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.Locale;

public class XChoiceFormat {
    private Condition[] conditions;
    private Object[] results;
    ULocale locale = ULocale.getDefault();

    public void applyPattern(String pattern) {
        String[] items = pattern.split("[|]");
        this.conditions = new Condition[items.length];
        this.results = new Object[items.length];
        int i = 0;
        for (String item : items) {
            int semiPosition = item.indexOf(58);
            if (semiPosition < 0) {
                throw new IllegalArgumentException("syntax error: no semicolon");
            }
            String tag = item.substring(0, semiPosition);
            this.conditions[i] = Condition.valueOf(tag.toUpperCase(Locale.ENGLISH));
            String numberPattern = item.substring(semiPosition + 1);
            this.results[i] = numberPattern.contains("#") ? new DecimalFormat(numberPattern, new DecimalFormatSymbols(this.locale)) : numberPattern;
            ++i;
        }
        if (this.conditions[i - 1] != Condition.N) {
            throw new IllegalArgumentException("final condition must be CN");
        }
    }

    public String format(long num) {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].matches(num)) continue;
            if (this.results[i] instanceof String) {
                return (String)this.results[i];
            }
            return ((NumberFormat)this.results[i]).format(num);
        }
        throw new IllegalArgumentException("final condition must be CN");
    }

    public static void main(String[] args) {
        Object[] tests = new Object[]{new ULocale("en"), "There {N0:are no files|N1:is 1 file|N:are #,### files} in the directory.", new ULocale("fr"), "There {N0:is aucun file|N1:is 1 file|N:are #,### files} in the directory.", new ULocale("sl"), "There {N0:are no mest|S1:is #,### mesto|S2:are #,### mesti|S234:are #,### mesta|N:are #,### mest} in the directory.", new ULocale("ru"), "There {N0:are no zavody|S1:is #,### zavod|S234:are #,### zavoda|N:are #,### zavodov} in the directory."};
        int[] testNumbers = new int[]{0, 1, 2, 3, 5, 10, 11, 12, 15, 20, 21, 22, 25, 123450, 123451, 123452, 123456};
        XChoiceFormat foo = new XChoiceFormat();
        for (Object test : tests) {
            if (test instanceof ULocale) {
                ULocale locale = (ULocale)test;
                System.out.println("Language:\t" + locale.getDisplayName());
                foo.setLocale(locale);
                continue;
            }
            System.out.println("Test pattern:\t\"" + test + "\"");
            String[] parts = ((String)test).split("[{}]");
            foo.applyPattern(parts[1]);
            for (int i : testNumbers) {
                System.out.println("\tSample:\t" + parts[0] + foo.format(i) + parts[2]);
            }
        }
    }

    private void setLocale(ULocale locale2) {
        this.locale = locale2;
    }

    public static enum Condition {
        N0,
        N1,
        N2,
        N3,
        N234,
        S1,
        S2,
        S234,
        N;


        public boolean matches(long num) {
            switch (this) {
                case N0: {
                    return num == 0L;
                }
                case N1: {
                    return num == 1L;
                }
                case N2: {
                    return num == 2L;
                }
                case N3: {
                    return num == 3L;
                }
                case N234: {
                    return num >= 3L && num <= 4L;
                }
                case S1: 
                case S2: 
                case S234: {
                    long digit = num % 10L;
                    if (num / 10L % 10L == 1L) {
                        return false;
                    }
                    switch (this) {
                        case S1: {
                            return digit == 1L;
                        }
                        case S2: {
                            return digit == 2L;
                        }
                    }
                    return digit >= 2L && digit <= 4L;
                }
            }
            return true;
        }
    }
}

