/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.util.Freezable;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DtdData;
import org.unicode.cldr.util.DtdType;
import org.unicode.cldr.util.Log;
import org.unicode.cldr.util.MapComparator;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.XPathParser;

public final class XPathParts
extends XPathParser
implements Freezable<XPathParts>,
Comparable<XPathParts> {
    private static final boolean DEBUGGING = false;
    private volatile boolean frozen = false;
    private List<Element> elements = new ArrayList<Element>();
    private DtdData dtdData = null;
    private static final Map<String, XPathParts> cache = new ConcurrentHashMap<String, XPathParts>();
    public static final int XPATH_STYLE = 0;
    public static final int XML_OPEN = 1;
    public static final int XML_CLOSE = 2;
    public static final int XML_NO_VALUE = 3;
    public static final String NEWLINE = "\n";

    public boolean containsElement(String element) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    public XPathParts clear() {
        this.elements.clear();
        this.dtdData = null;
        return this;
    }

    public XPathParts writeDifference(PrintWriter pw, XPathParts filteredXPath, XPathParts lastFullXPath, String v, Comments xpath_comments) {
        int i;
        int limit;
        int n = limit = lastFullXPath == null ? 0 : this.findFirstDifference(lastFullXPath);
        if (lastFullXPath != null) {
            for (i = lastFullXPath.size() - 2; i >= limit; --i) {
                pw.print(Utility.repeat("\t", i));
                pw.println(lastFullXPath.elements.get(i).toString(2));
            }
        }
        if (v == null) {
            return this;
        }
        for (i = limit; i < this.size() - 1; ++i) {
            if (xpath_comments != null) {
                filteredXPath.writeComment(pw, xpath_comments, i + 1, Comments.CommentType.PREBLOCK);
            }
            pw.print(Utility.repeat("\t", i));
            pw.println(this.elements.get(i).toString(1));
        }
        if (xpath_comments != null) {
            filteredXPath.writeComment(pw, xpath_comments, this.size(), Comments.CommentType.PREBLOCK);
        }
        pw.print(Utility.repeat("\t", this.size() - 1));
        Element e = this.elements.get(this.size() - 1);
        String eValue = v;
        if (eValue.length() == 0) {
            pw.print(e.toString(3));
        } else {
            pw.print(e.toString(1));
            pw.print(this.untrim(eValue, this.size()));
            pw.print(e.toString(2));
        }
        if (xpath_comments != null) {
            filteredXPath.writeComment(pw, xpath_comments, this.size(), Comments.CommentType.LINE);
        }
        pw.println();
        if (xpath_comments != null) {
            filteredXPath.writeComment(pw, xpath_comments, this.size(), Comments.CommentType.POSTBLOCK);
        }
        pw.flush();
        return this;
    }

    public void writeLast(PrintWriter pw) {
        for (int i = this.size() - 2; i >= 0; --i) {
            pw.print(Utility.repeat("\t", i));
            pw.println(this.elements.get(i).toString(2));
        }
    }

    private String untrim(String eValue, int count) {
        String result = TransliteratorUtilities.toHTML.transliterate(eValue);
        if (!result.contains(NEWLINE)) {
            return result;
        }
        String spacer = NEWLINE + Utility.repeat("\t", count);
        result = result.replace(NEWLINE, spacer);
        return result;
    }

    private XPathParts writeComment(PrintWriter pw, Comments xpath_comments, int index, Comments.CommentType style) {
        if (index == 0) {
            return this;
        }
        String xpath = this.toString(index);
        Log.logln(false, "Checking for: " + xpath);
        String comment = xpath_comments.removeComment(style, xpath);
        if (comment != null) {
            boolean blockComment = style != Comments.CommentType.LINE;
            XPathParts.writeComment(pw, index - 1, comment, blockComment);
        }
        return this;
    }

    public int findFirstDifference(XPathParts last) {
        int min2 = this.elements.size();
        if (last.elements.size() < min2) {
            min2 = last.elements.size();
        }
        for (int i = 0; i < min2; ++i) {
            Element e2;
            Element e1 = this.elements.get(i);
            if (e1.equals(e2 = last.elements.get(i))) continue;
            return i;
        }
        return min2;
    }

    public boolean isLike(XPathParts last) {
        int min2 = this.elements.size();
        if (last.elements.size() < min2) {
            min2 = last.elements.size();
        }
        for (int i = 0; i < min2; ++i) {
            Element e2;
            Element e1 = this.elements.get(i);
            if (e1.equals(e2 = last.elements.get(i))) continue;
            if (i == min2 - 1) {
                String et1 = e1.getAttributeValue("type");
                String et2 = e2.getAttributeValue("type");
                if (et1 == null && et2 == null) {
                    et1 = e1.getAttributeValue("id");
                    et2 = e2.getAttributeValue("id");
                }
                if (et1 == null || et2 == null || !et1.equals(et2)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean containsAttribute(String attribute) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            if (element.getAttributeValue(attribute) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeValue(String attribute, String value) {
        for (int i = 0; i < this.elements.size(); ++i) {
            String otherValue = this.elements.get(i).getAttributeValue(attribute);
            if (otherValue == null || !value.equals(otherValue)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public String getElement(int elementIndex) {
        return this.elements.get(elementIndex >= 0 ? elementIndex : elementIndex + this.size()).getElement();
    }

    public int getAttributeCount(int elementIndex) {
        return this.elements.get(elementIndex >= 0 ? elementIndex : elementIndex + this.size()).getAttributeCount();
    }

    public Map<String, String> getAttributes(int elementIndex) {
        return this.elements.get(elementIndex >= 0 ? elementIndex : elementIndex + this.size()).getAttributes();
    }

    public Collection<String> getAttributeKeys(int elementIndex) {
        return this.elements.get(elementIndex >= 0 ? elementIndex : elementIndex + this.size()).getAttributes().keySet();
    }

    @Override
    public String getAttributeValue(int elementIndex, String attribute) {
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        return this.elements.get(elementIndex).getAttributeValue(attribute);
    }

    public void putAttributeValue(int elementIndex, String attribute, String value) {
        elementIndex = elementIndex >= 0 ? elementIndex : elementIndex + this.size();
        Map<String, String> ea = this.elements.get((int)elementIndex).attributes;
        if (!(value != null || ea != null && ea.containsKey(attribute))) {
            return;
        }
        if (value != null && ea != null && value.equals(ea.get(attribute))) {
            return;
        }
        this.makeElementsMutable();
        this.makeElementMutable(elementIndex);
        this.elements.get(elementIndex).putAttribute(attribute, value);
    }

    public Map<String, String> findAttributes(String elementName) {
        int index = this.findElement(elementName);
        if (index == -1) {
            return null;
        }
        return this.getAttributes(index);
    }

    public String findAttributeValue(String elementName, String attributeName) {
        Map<String, String> attributes = this.findAttributes(elementName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(attributeName);
    }

    @Override
    protected void handleClearElements() {
        this.elements.clear();
    }

    @Override
    protected void handleAddElement(String element) {
        this.addElement(element);
    }

    public XPathParts addElement(String element) {
        if (this.elements.size() == 0) {
            try {
                File dir = CLDRConfig.getInstance().getCldrBaseDirectory();
                this.dtdData = DtdData.getInstance(DtdType.fromElement(element), dir);
            }
            catch (Exception e) {
                this.dtdData = null;
            }
        }
        this.makeElementsMutable();
        this.elements.add(new Element(element));
        return this;
    }

    public void makeElementsMutable() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Can't modify frozen object.");
        }
        if (this.elements instanceof ImmutableList) {
            this.elements = new ArrayList<Element>(this.elements);
        }
    }

    public void makeElementMutable(int elementIndex) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Can't modify frozen object.");
        }
        Element e = this.elements.get(elementIndex);
        Map<String, String> ea = e.attributes;
        if (ea == null || ea instanceof ImmutableMap) {
            this.elements.set(elementIndex, e.cloneAsThawed());
        }
    }

    public XPathParts addElements(String ... element) {
        for (String e : element) {
            this.addElement(e);
        }
        return this;
    }

    @Override
    protected void handleAddAttribute(String attribute, String value) {
        this.addAttribute(attribute, value);
    }

    public XPathParts addAttribute(String attribute, String value) {
        this.putAttributeValue(this.elements.size() - 1, attribute, value);
        return this;
    }

    public XPathParts removeAttribute(String elementName, String attributeName) {
        return this.removeAttribute(this.findElement(elementName), attributeName);
    }

    public XPathParts removeAttribute(int elementIndex, String attributeName) {
        this.putAttributeValue(elementIndex, attributeName, null);
        return this;
    }

    public XPathParts removeAttributes(String elementName, Collection<String> attributeNames) {
        return this.removeAttributes(this.findElement(elementName), attributeNames);
    }

    public XPathParts removeAttributes(int elementIndex, Collection<String> attributeNames) {
        elementIndex = elementIndex >= 0 ? elementIndex : elementIndex + this.size();
        Map<String, String> ea = this.elements.get((int)elementIndex).attributes;
        if (ea == null || attributeNames == null || attributeNames.isEmpty() || Collections.disjoint(attributeNames, ea.keySet())) {
            return this;
        }
        this.makeElementsMutable();
        this.makeElementMutable(elementIndex);
        this.elements.get(elementIndex).removeAttributes(attributeNames);
        return this;
    }

    private XPathParts addInternal(String xPath, boolean initial) {
        if (initial) {
            this.dtdData = null;
        }
        this.handleParse(xPath, initial);
        return this;
    }

    public String toString() {
        return this.toString(this.elements.size());
    }

    public String toString(int limit) {
        if (limit < 0) {
            limit += this.size();
        }
        Object result = "/";
        for (int i = 0; i < limit; ++i) {
            result = (String)result + this.elements.get(i).toString(0);
        }
        return result;
    }

    public String toString(int start, int limit) {
        if (start < 0) {
            start += this.size();
        }
        if (limit < 0) {
            limit += this.size();
        }
        StringBuilder result = new StringBuilder();
        for (int i = start; i < limit; ++i) {
            result.append(this.elements.get(i).toString(0));
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        try {
            XPathParts that = (XPathParts)other;
            if (this.elements.size() != that.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (this.elements.get(i).equals(that.elements.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int compareTo(XPathParts that) {
        return this.dtdData.getDtdComparator().xpathComparator(this, that);
    }

    public int hashCode() {
        int result = this.elements.size();
        for (int i = 0; i < this.elements.size(); ++i) {
            result = result * 37 + this.elements.get(i).hashCode();
        }
        return result;
    }

    public int findElement(String elementName) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            if (!e.getElement().equals(elementName)) continue;
            return i;
        }
        return -1;
    }

    private MapComparator<String> getAttributeComparator() {
        return this.dtdData == null ? null : (this.dtdData.dtdType == DtdType.ldml ? CLDRFile.getAttributeOrdering() : this.dtdData.getAttributeComparator());
    }

    public boolean contains(String elementName) {
        return this.findElement(elementName) >= 0;
    }

    public XPathParts addRelative(String path) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Can't modify frozen Element");
        }
        if (((String)path).startsWith("//")) {
            this.elements.clear();
            path = ((String)path).substring(1);
        } else {
            while (((String)path).startsWith("../")) {
                path = ((String)path).substring(3);
                this.trimLast();
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
        }
        return this.addInternal((String)path, false);
    }

    public XPathParts trimLast() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Can't modify frozen Element");
        }
        this.makeElementsMutable();
        this.elements.remove(this.elements.size() - 1);
        return this;
    }

    static void writeComment(PrintWriter pw, int indent, String comment, boolean blockComment) {
        if (comment.length() == 0) {
            return;
        }
        if (blockComment) {
            pw.print(Utility.repeat("\t", indent));
        } else {
            pw.print(" ");
        }
        pw.print("<!--");
        if (comment.indexOf(NEWLINE) > 0) {
            boolean first = true;
            int countEmptyLines = 0;
            for (String line : CldrUtility.splitList(comment, NEWLINE, indent != 0, null)) {
                if (line.length() == 0) {
                    ++countEmptyLines;
                    continue;
                }
                if (countEmptyLines != 0) {
                    for (int i = 0; i < countEmptyLines; ++i) {
                        pw.println();
                    }
                    countEmptyLines = 0;
                }
                if (first) {
                    first = false;
                    line = line.trim();
                    pw.print(" ");
                } else if (indent != 0) {
                    pw.print(Utility.repeat("\t", indent + 1));
                    pw.print(" ");
                }
                pw.println(line);
            }
            pw.print(Utility.repeat("\t", indent));
        } else {
            pw.print(" ");
            pw.print(comment.trim());
            pw.print(" ");
        }
        pw.print("-->");
        if (blockComment) {
            pw.println();
        }
    }

    public static boolean isLanguage(String in) {
        int pos = in.indexOf(95);
        if (pos < 0) {
            return true;
        }
        if (in.indexOf(95, pos + 1) >= 0) {
            return false;
        }
        return in.length() == pos + 5;
    }

    public static int isSubLocale(String parent, String possibleSublocale) {
        if (parent.equals("root")) {
            if (parent.equals(possibleSublocale)) {
                return 0;
            }
            return 1;
        }
        if (parent.length() > possibleSublocale.length()) {
            return -1;
        }
        if (!possibleSublocale.startsWith(parent)) {
            return -1;
        }
        if (parent.length() == possibleSublocale.length()) {
            return 0;
        }
        if (possibleSublocale.charAt(parent.length()) != '_') {
            return -1;
        }
        return 1;
    }

    public XPathParts setAttribute(String elementName, String attributeName, String attributeValue) {
        int index = this.findElement(elementName);
        this.putAttributeValue(index, attributeName, attributeValue);
        return this;
    }

    public XPathParts removeProposed() {
        block0: for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            if (element.getAttributeCount() == 0) continue;
            for (Map.Entry<String, String> attributesAndValues : element.getAttributes().entrySet()) {
                String attribute = attributesAndValues.getKey();
                if (!attribute.equals("alt")) continue;
                String attributeValue = attributesAndValues.getValue();
                int pos = attributeValue.indexOf("proposed");
                if (pos < 0) continue block0;
                if (pos > 0 && attributeValue.charAt(pos - 1) == '-') {
                    --pos;
                }
                if (pos == 0) {
                    this.putAttributeValue(i, attribute, null);
                    continue block0;
                }
                attributeValue = attributeValue.substring(0, pos);
                this.putAttributeValue(i, attribute, attributeValue);
                continue block0;
            }
        }
        return this;
    }

    public XPathParts setElement(int elementIndex, String newElement) {
        this.makeElementsMutable();
        if (elementIndex < 0) {
            elementIndex += this.size();
        }
        Element element = this.elements.get(elementIndex);
        this.elements.set(elementIndex, new Element(element, newElement));
        return this;
    }

    public XPathParts removeElement(int elementIndex) {
        this.makeElementsMutable();
        this.elements.remove(elementIndex >= 0 ? elementIndex : elementIndex + this.size());
        return this;
    }

    public String findFirstAttributeValue(String attribute) {
        for (int i = 0; i < this.elements.size(); ++i) {
            String value = this.getAttributeValue(i, attribute);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public XPathParts setAttribute(int elementIndex, String attributeName, String attributeValue) {
        this.putAttributeValue(elementIndex, attributeName, attributeValue);
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public XPathParts freeze() {
        if (!this.frozen) {
            ArrayList<Element> temp = new ArrayList<Element>(this.elements.size());
            for (Element element : this.elements) {
                temp.add(element.makeImmutable());
            }
            this.elements = ImmutableList.copyOf(temp);
            this.frozen = true;
        }
        return this;
    }

    @Override
    public XPathParts cloneAsThawed() {
        XPathParts xppClone = new XPathParts();
        xppClone.dtdData = this.dtdData;
        if (!this.frozen) {
            for (Element e : this.elements) {
                xppClone.elements.add(e.cloneAsThawed());
            }
        } else {
            xppClone.elements = this.elements;
        }
        return xppClone;
    }

    public static XPathParts getFrozenInstance(String path) {
        XPathParts result = cache.computeIfAbsent(path, forPath -> new XPathParts().addInternal((String)forPath, true).freeze());
        return result;
    }

    public DtdData getDtdData() {
        return this.dtdData;
    }

    public Set<String> getElements() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < this.elements.size(); ++i) {
            builder.add(this.elements.get(i).getElement());
        }
        return builder.build();
    }

    public Map<String, String> getSpecialNondistinguishingAttributes() {
        TreeMap<String, String> ueMap = null;
        for (int i = 0; i < this.size(); ++i) {
            for (Map.Entry<String, String> entry : this.getAttributes(i).entrySet()) {
                String k = entry.getKey();
                if (this.getDtdData().isDistinguishing(this.getElement(i), k) || k.equals("alt") || k.equals("draft") || k.startsWith("xml:")) continue;
                if (ueMap == null) {
                    ueMap = new TreeMap<String, String>();
                }
                ueMap.put(k, entry.getValue());
            }
        }
        return ueMap;
    }

    public static String getPathWithoutAlt(String xpath) {
        XPathParts xpp = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
        xpp.removeAttribute("alt");
        return xpp.toString();
    }

    private XPathParts removeAttribute(String attribute) {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.putAttributeValue(i, attribute, null);
        }
        return this;
    }

    private final class Element {
        private final String element;
        private Map<String, String> attributes;

        public Element(String element) {
            this(element, null);
        }

        public Element(Element other, String element) {
            this(element, other.attributes);
        }

        public Element(String element, Map<String, String> attributes) {
            this.element = element.intern();
            if (attributes == null) {
                this.attributes = null;
            } else {
                this.attributes = new TreeMap<String, String>(XPathParts.this.getAttributeComparator());
                this.attributes.putAll(attributes);
            }
        }

        public void putAttribute(String attribute, String value) {
            attribute = attribute.intern();
            if (value == null) {
                if (this.attributes != null) {
                    this.attributes.remove(attribute);
                    if (this.attributes.size() == 0) {
                        this.attributes = null;
                    }
                }
            } else {
                if (this.attributes == null) {
                    this.attributes = new TreeMap<String, String>(XPathParts.this.getAttributeComparator());
                }
                this.attributes.put(attribute, value);
            }
        }

        private void removeAttributes(Collection<String> attributeNames) {
            if (attributeNames == null) {
                return;
            }
            for (String attribute : attributeNames) {
                this.attributes.remove(attribute);
            }
            if (this.attributes.size() == 0) {
                this.attributes = null;
            }
        }

        public String toString() {
            throw new IllegalArgumentException("Don't use");
        }

        public String toString(int style) {
            StringBuilder result = new StringBuilder();
            switch (style) {
                case 0: {
                    result.append('/').append(this.element);
                    this.writeAttributes("[@", "\"]", false, result);
                    break;
                }
                case 1: 
                case 3: {
                    result.append('<').append(this.element);
                    this.writeAttributes(" ", "\"", true, result);
                    if (style == 3) {
                        result.append('/');
                    }
                    if (CLDRFile.HACK_ORDER && this.element.equals("ldml")) {
                        result.append(' ');
                    }
                    result.append('>');
                    break;
                }
                case 2: {
                    result.append("</").append(this.element).append('>');
                }
            }
            return result.toString();
        }

        private Element writeAttributes(String prefix, String postfix, boolean removeLDMLExtras, StringBuilder result) {
            if (this.getAttributeCount() == 0) {
                return this;
            }
            Map<String, Map<String, String>> suppressionMap = null;
            if (removeLDMLExtras) {
                suppressionMap = CLDRFile.getDefaultSuppressionMap();
            }
            for (Map.Entry<String, String> attributesAndValues : this.attributes.entrySet()) {
                String attribute = attributesAndValues.getKey();
                String value = attributesAndValues.getValue();
                if (removeLDMLExtras && suppressionMap != null && (this.skipAttribute(this.element, attribute, value, suppressionMap) || this.skipAttribute("*", attribute, value, suppressionMap))) continue;
                result.append(prefix).append(attribute).append("=\"").append(removeLDMLExtras ? TransliteratorUtilities.toHTML.transliterate(value) : value).append(postfix);
            }
            return this;
        }

        private boolean skipAttribute(String element, String attribute, String value, Map<String, Map<String, String>> suppressionMap) {
            Map<String, String> attribute_value = suppressionMap.get(element);
            boolean skip = false;
            if (attribute_value != null) {
                String suppressValue = attribute_value.get(attribute);
                if (suppressValue == null) {
                    suppressValue = attribute_value.get("*");
                }
                if (suppressValue != null && (value.equals(suppressValue) || suppressValue.equals("*"))) {
                    skip = true;
                }
            }
            return skip;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            try {
                Element that = (Element)other;
                return this.element == that.element && (this.attributes == null ? that.attributes == null : (that.attributes == null ? this.attributes == null : this.attributes.equals(that.attributes)));
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.element.hashCode() * 37 + (this.attributes == null ? 0 : this.attributes.hashCode());
        }

        public String getElement() {
            return this.element;
        }

        private int getAttributeCount() {
            if (this.attributes == null) {
                return 0;
            }
            return this.attributes.size();
        }

        private Map<String, String> getAttributes() {
            if (this.attributes == null) {
                return ImmutableMap.of();
            }
            return ImmutableMap.copyOf(this.attributes);
        }

        private String getAttributeValue(String attribute) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(attribute);
        }

        public Element makeImmutable() {
            if (this.attributes != null && !(this.attributes instanceof ImmutableMap)) {
                this.attributes = ImmutableMap.copyOf(this.attributes);
            }
            return this;
        }

        public Element cloneAsThawed() {
            return new Element(this.element, this.attributes);
        }
    }

    public static class Comments
    implements Cloneable {
        private EnumMap<CommentType, Map<String, String>> comments = new EnumMap(CommentType.class);
        private String initialComment = "";
        private String finalComment = "";

        public Comments() {
            for (CommentType c : CommentType.values()) {
                this.comments.put(c, new HashMap());
            }
        }

        public String getComment(CommentType style, String xpath) {
            return this.comments.get((Object)style).get(xpath);
        }

        public Comments addComment(CommentType style, String xpath, String comment) {
            String existing = this.comments.get((Object)style).get(xpath);
            if (existing != null) {
                comment = existing + XPathParts.NEWLINE + (String)comment;
            }
            this.comments.get((Object)style).put(xpath, (String)comment);
            return this;
        }

        public String removeComment(CommentType style, String xPath) {
            String result = this.comments.get((Object)style).get(xPath);
            if (result != null) {
                this.comments.get((Object)style).remove(xPath);
            }
            return result;
        }

        public List<String> extractCommentsWithoutBase() {
            ArrayList<String> result = new ArrayList<String>();
            for (CommentType style : CommentType.values()) {
                Iterator<String> it = this.comments.get((Object)style).keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    String value = this.comments.get((Object)style).get(key);
                    result.add(value + "\t - was on: " + key);
                    it.remove();
                }
            }
            return result;
        }

        public Object clone() {
            try {
                Comments result = (Comments)super.clone();
                for (CommentType c : CommentType.values()) {
                    result.comments.put(c, new HashMap<String, String>(this.comments.get((Object)c)));
                }
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("should never happen");
            }
        }

        public Comments joinAll(Comments other) {
            for (CommentType c : CommentType.values()) {
                CldrUtility.joinWithSeparation(this.comments.get((Object)c), XPathParts.NEWLINE, other.comments.get((Object)c));
            }
            return this;
        }

        public Comments removeComment(String string) {
            if (this.initialComment.equals(string)) {
                this.initialComment = "";
            }
            if (this.finalComment.equals(string)) {
                this.finalComment = "";
            }
            for (CommentType c : CommentType.values()) {
                Iterator<String> it = this.comments.get((Object)c).keySet().iterator();
                while (it.hasNext()) {
                    String key = it.next();
                    String value = this.comments.get((Object)c).get(key);
                    if (!value.equals(string)) continue;
                    it.remove();
                }
            }
            return this;
        }

        public String getFinalComment() {
            return this.finalComment;
        }

        public Comments setFinalComment(String finalComment) {
            this.finalComment = finalComment;
            return this;
        }

        public String getInitialComment() {
            return this.initialComment;
        }

        public Comments setInitialComment(String initialComment) {
            this.initialComment = initialComment;
            return this;
        }

        public static enum CommentType {
            LINE,
            PREBLOCK,
            POSTBLOCK;

        }
    }
}

