/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class LocaleFallbackData {
    public static final Map<String, String> DEFAULT_SCRIPT_TABLE = LocaleFallbackData.buildDefaultScriptTable();
    public static final Map<String, String> PARENT_LOCALE_TABLE = LocaleFallbackData.buildParentLocaleTable();

    LocaleFallbackData() {
    }

    private static Map<String, String> buildDefaultScriptTable() {
        HashMap<String, String> t2 = new HashMap<String, String>();
        t2.put("aaf", "Mlym");
        t2.put("aao", "Arab");
        t2.put("aat", "Grek");
        t2.put("ab", "Cyrl");
        t2.put("abh", "Arab");
        t2.put("abl", "Rjng");
        t2.put("abv", "Arab");
        t2.put("acm", "Arab");
        t2.put("acq", "Arab");
        t2.put("acw", "Arab");
        t2.put("acx", "Arab");
        t2.put("adf", "Arab");
        t2.put("adx", "Tibt");
        t2.put("ady", "Cyrl");
        t2.put("ae", "Avst");
        t2.put("aeb", "Arab");
        t2.put("aec", "Arab");
        t2.put("aee", "Arab");
        t2.put("aeq", "Arab");
        t2.put("afb", "Arab");
        t2.put("agi", "Deva");
        t2.put("agj", "Ethi");
        t2.put("agx", "Cyrl");
        t2.put("ahg", "Ethi");
        t2.put("aho", "Ahom");
        t2.put("ahr", "Deva");
        t2.put("aib", "Arab");
        t2.put("aij", "Hebr");
        t2.put("ain", "Kana");
        t2.put("aio", "Mymr");
        t2.put("aiq", "Arab");
        t2.put("akk", "Xsux");
        t2.put("akv", "Cyrl");
        t2.put("alk", "Laoo");
        t2.put("all", "Mlym");
        t2.put("alr", "Cyrl");
        t2.put("alt", "Cyrl");
        t2.put("alw", "Ethi");
        t2.put("am", "Ethi");
        t2.put("ams", "Jpan");
        t2.put("amw", "Syrc");
        t2.put("ani", "Cyrl");
        t2.put("anp", "Deva");
        t2.put("anr", "Deva");
        t2.put("anu", "Ethi");
        t2.put("aot", "Beng");
        t2.put("apc", "Arab");
        t2.put("apd", "Arab");
        t2.put("aph", "Deva");
        t2.put("aqc", "Cyrl");
        t2.put("ar", "Arab");
        t2.put("arc", "Armi");
        t2.put("arq", "Arab");
        t2.put("ars", "Arab");
        t2.put("ary", "Arab");
        t2.put("arz", "Arab");
        t2.put("as", "Beng");
        t2.put("ase", "Sgnw");
        t2.put("ask", "Arab");
        t2.put("atn", "Arab");
        t2.put("atv", "Cyrl");
        t2.put("auj", "Arab");
        t2.put("auz", "Arab");
        t2.put("av", "Cyrl");
        t2.put("avd", "Arab");
        t2.put("avl", "Arab");
        t2.put("awa", "Deva");
        t2.put("awn", "Ethi");
        t2.put("axm", "Armn");
        t2.put("ayh", "Arab");
        t2.put("ayl", "Arab");
        t2.put("ayn", "Arab");
        t2.put("ayp", "Arab");
        t2.put("az_IQ", "Arab");
        t2.put("az_IR", "Arab");
        t2.put("az_RU", "Cyrl");
        t2.put("azb", "Arab");
        t2.put("ba", "Cyrl");
        t2.put("bal", "Arab");
        t2.put("bap", "Deva");
        t2.put("bax", "Bamu");
        t2.put("bbl", "Geor");
        t2.put("bcq", "Ethi");
        t2.put("bdv", "Orya");
        t2.put("bdz", "Arab");
        t2.put("be", "Cyrl");
        t2.put("bee", "Deva");
        t2.put("bej", "Arab");
        t2.put("bfb", "Deva");
        t2.put("bfq", "Taml");
        t2.put("bft", "Arab");
        t2.put("bfu", "Tibt");
        t2.put("bfw", "Orya");
        t2.put("bfy", "Deva");
        t2.put("bfz", "Deva");
        t2.put("bg", "Cyrl");
        t2.put("bgc", "Deva");
        t2.put("bgd", "Deva");
        t2.put("bgn", "Arab");
        t2.put("bgp", "Arab");
        t2.put("bgq", "Deva");
        t2.put("bgw", "Deva");
        t2.put("bgx", "Grek");
        t2.put("bha", "Deva");
        t2.put("bhb", "Deva");
        t2.put("bhd", "Deva");
        t2.put("bhe", "Arab");
        t2.put("bhh", "Cyrl");
        t2.put("bhi", "Deva");
        t2.put("bhj", "Deva");
        t2.put("bhm", "Arab");
        t2.put("bhn", "Syrc");
        t2.put("bho", "Deva");
        t2.put("bht", "Takr");
        t2.put("bhu", "Deva");
        t2.put("biy", "Deva");
        t2.put("bjf", "Syrc");
        t2.put("bjj", "Deva");
        t2.put("bjm", "Arab");
        t2.put("blk", "Mymr");
        t2.put("blt", "Tavt");
        t2.put("bmj", "Deva");
        t2.put("bn", "Beng");
        t2.put("bns", "Deva");
        t2.put("bo", "Tibt");
        t2.put("bph", "Cyrl");
        t2.put("bpx", "Deva");
        t2.put("bpy", "Beng");
        t2.put("bqi", "Arab");
        t2.put("bra", "Deva");
        t2.put("brb", "Khmr");
        t2.put("brd", "Deva");
        t2.put("brh", "Arab");
        t2.put("brk", "Arab");
        t2.put("brv", "Laoo");
        t2.put("brx", "Deva");
        t2.put("bsh", "Arab");
        t2.put("bsk", "Arab");
        t2.put("bsq", "Bass");
        t2.put("bst", "Ethi");
        t2.put("btd", "Batk");
        t2.put("btm", "Batk");
        t2.put("btv", "Deva");
        t2.put("bua", "Cyrl");
        t2.put("bwe", "Mymr");
        t2.put("bxm", "Cyrl");
        t2.put("bxu", "Mong");
        t2.put("byh", "Deva");
        t2.put("byn", "Ethi");
        t2.put("byw", "Deva");
        t2.put("bzi", "Thai");
        t2.put("cbn", "Thai");
        t2.put("ccp", "Cakm");
        t2.put("cde", "Telu");
        t2.put("cdh", "Deva");
        t2.put("cdi", "Gujr");
        t2.put("cdj", "Deva");
        t2.put("cdm", "Deva");
        t2.put("cdo", "Hans");
        t2.put("cdz", "Beng");
        t2.put("ce", "Cyrl");
        t2.put("cgk", "Tibt");
        t2.put("chg", "Arab");
        t2.put("chm", "Cyrl");
        t2.put("chr", "Cher");
        t2.put("chx", "Deva");
        t2.put("cih", "Deva");
        t2.put("cja", "Arab");
        t2.put("cji", "Cyrl");
        t2.put("cjm", "Cham");
        t2.put("cjy", "Hans");
        t2.put("ckb", "Arab");
        t2.put("ckt", "Cyrl");
        t2.put("clh", "Arab");
        t2.put("clw", "Cyrl");
        t2.put("cmg", "Soyo");
        t2.put("cna", "Tibt");
        t2.put("cnp", "Hans");
        t2.put("cog", "Thai");
        t2.put("cop", "Copt");
        t2.put("cpg", "Grek");
        t2.put("cr", "Cans");
        t2.put("crh", "Cyrl");
        t2.put("crj", "Cans");
        t2.put("crk", "Cans");
        t2.put("crl", "Cans");
        t2.put("crm", "Cans");
        t2.put("csh", "Mymr");
        t2.put("csp", "Hans");
        t2.put("csw", "Cans");
        t2.put("ctd", "Pauc");
        t2.put("ctg", "Beng");
        t2.put("ctn", "Deva");
        t2.put("ctt", "Taml");
        t2.put("cu", "Cyrl");
        t2.put("cuu", "Lana");
        t2.put("cv", "Cyrl");
        t2.put("czh", "Hans");
        t2.put("czk", "Hebr");
        t2.put("daq", "Deva");
        t2.put("dar", "Cyrl");
        t2.put("dcc", "Arab");
        t2.put("ddo", "Cyrl");
        t2.put("def", "Arab");
        t2.put("deh", "Arab");
        t2.put("der", "Beng");
        t2.put("dhi", "Deva");
        t2.put("dhn", "Gujr");
        t2.put("dho", "Deva");
        t2.put("dhw", "Deva");
        t2.put("dka", "Tibt");
        t2.put("dlg", "Cyrl");
        t2.put("dmf", "Medf");
        t2.put("dmk", "Arab");
        t2.put("dml", "Arab");
        t2.put("dng", "Cyrl");
        t2.put("dnu", "Mymr");
        t2.put("dnv", "Mymr");
        t2.put("doi", "Deva");
        t2.put("dox", "Ethi");
        t2.put("dre", "Tibt");
        t2.put("drq", "Deva");
        t2.put("drs", "Ethi");
        t2.put("dry", "Deva");
        t2.put("dso", "Orya");
        t2.put("dty", "Deva");
        t2.put("dub", "Gujr");
        t2.put("duh", "Deva");
        t2.put("dus", "Deva");
        t2.put("dv", "Thaa");
        t2.put("dwk", "Orya");
        t2.put("dwz", "Deva");
        t2.put("dz", "Tibt");
        t2.put("dzl", "Tibt");
        t2.put("ecr", "Grek");
        t2.put("ecy", "Cprt");
        t2.put("egy", "Egyp");
        t2.put("eky", "Kali");
        t2.put("el", "Grek");
        t2.put("emg", "Deva");
        t2.put("emu", "Deva");
        t2.put("enf", "Cyrl");
        t2.put("enh", "Cyrl");
        t2.put("era", "Taml");
        t2.put("esg", "Gonm");
        t2.put("esh", "Arab");
        t2.put("ett", "Ital");
        t2.put("eve", "Cyrl");
        t2.put("evn", "Cyrl");
        t2.put("fa", "Arab");
        t2.put("fay", "Arab");
        t2.put("faz", "Arab");
        t2.put("fia", "Arab");
        t2.put("fmu", "Deva");
        t2.put("fub", "Arab");
        t2.put("gan", "Hans");
        t2.put("gaq", "Orya");
        t2.put("gas", "Gujr");
        t2.put("gau", "Telu");
        t2.put("gbj", "Orya");
        t2.put("gbk", "Deva");
        t2.put("gbl", "Gujr");
        t2.put("gbm", "Deva");
        t2.put("gbz", "Arab");
        t2.put("gdb", "Orya");
        t2.put("gdo", "Cyrl");
        t2.put("gdx", "Deva");
        t2.put("gez", "Ethi");
        t2.put("ggg", "Arab");
        t2.put("gha", "Arab");
        t2.put("ghe", "Deva");
        t2.put("ghr", "Arab");
        t2.put("ght", "Tibt");
        t2.put("gig", "Arab");
        t2.put("gin", "Cyrl");
        t2.put("gjk", "Arab");
        t2.put("gju", "Arab");
        t2.put("gld", "Cyrl");
        t2.put("glh", "Arab");
        t2.put("glk", "Arab");
        t2.put("gmv", "Ethi");
        t2.put("gmy", "Linb");
        t2.put("goe", "Tibt");
        t2.put("gof", "Ethi");
        t2.put("gok", "Deva");
        t2.put("gom", "Deva");
        t2.put("gon", "Telu");
        t2.put("got", "Goth");
        t2.put("gra", "Deva");
        t2.put("grc", "Cprt");
        t2.put("grt", "Beng");
        t2.put("gru", "Ethi");
        t2.put("gu", "Gujr");
        t2.put("gvr", "Deva");
        t2.put("gwc", "Arab");
        t2.put("gwf", "Arab");
        t2.put("gwt", "Arab");
        t2.put("gyo", "Deva");
        t2.put("gzi", "Arab");
        t2.put("ha_CM", "Arab");
        t2.put("ha_SD", "Arab");
        t2.put("hac", "Arab");
        t2.put("hak", "Hans");
        t2.put("har", "Ethi");
        t2.put("haz", "Arab");
        t2.put("hbo", "Hebr");
        t2.put("hdy", "Ethi");
        t2.put("he", "Hebr");
        t2.put("hi", "Deva");
        t2.put("hii", "Takr");
        t2.put("hit", "Xsux");
        t2.put("hkh", "Arab");
        t2.put("hlb", "Deva");
        t2.put("hlu", "Hluw");
        t2.put("hmd", "Plrd");
        t2.put("hmj", "Bopo");
        t2.put("hmq", "Bopo");
        t2.put("hnd", "Arab");
        t2.put("hne", "Deva");
        t2.put("hnj", "Hmnp");
        t2.put("hnj_AU", "Laoo");
        t2.put("hnj_CN", "Laoo");
        t2.put("hnj_FR", "Laoo");
        t2.put("hnj_GF", "Laoo");
        t2.put("hnj_LA", "Laoo");
        t2.put("hnj_MM", "Laoo");
        t2.put("hnj_SR", "Laoo");
        t2.put("hnj_TH", "Laoo");
        t2.put("hnj_VN", "Laoo");
        t2.put("hno", "Arab");
        t2.put("hoc", "Deva");
        t2.put("hoh", "Arab");
        t2.put("hoj", "Deva");
        t2.put("how", "Hani");
        t2.put("hoy", "Deva");
        t2.put("hpo", "Mymr");
        t2.put("hrt", "Syrc");
        t2.put("hrz", "Arab");
        t2.put("hsn", "Hans");
        t2.put("hss", "Arab");
        t2.put("htx", "Xsux");
        t2.put("hut", "Deva");
        t2.put("huy", "Hebr");
        t2.put("huz", "Cyrl");
        t2.put("hy", "Armn");
        t2.put("hyw", "Armn");
        t2.put("ii", "Yiii");
        t2.put("imy", "Lyci");
        t2.put("inh", "Cyrl");
        t2.put("int", "Mymr");
        t2.put("ior", "Ethi");
        t2.put("iru", "Taml");
        t2.put("isk", "Arab");
        t2.put("itk", "Hebr");
        t2.put("itl", "Cyrl");
        t2.put("iu", "Cans");
        t2.put("iw", "Hebr");
        t2.put("ja", "Jpan");
        t2.put("jad", "Arab");
        t2.put("jat", "Arab");
        t2.put("jbe", "Hebr");
        t2.put("jbn", "Arab");
        t2.put("jct", "Cyrl");
        t2.put("jda", "Tibt");
        t2.put("jdg", "Arab");
        t2.put("jdt", "Cyrl");
        t2.put("jee", "Deva");
        t2.put("jge", "Geor");
        t2.put("ji", "Hebr");
        t2.put("jje", "Hang");
        t2.put("jkm", "Mymr");
        t2.put("jml", "Deva");
        t2.put("jna", "Takr");
        t2.put("jnd", "Arab");
        t2.put("jnl", "Deva");
        t2.put("jns", "Deva");
        t2.put("jog", "Arab");
        t2.put("jpa", "Hebr");
        t2.put("jpr", "Hebr");
        t2.put("jrb", "Hebr");
        t2.put("jrb_MA", "Arab");
        t2.put("jul", "Deva");
        t2.put("jun", "Orya");
        t2.put("juy", "Orya");
        t2.put("jya", "Tibt");
        t2.put("jye", "Hebr");
        t2.put("ka", "Geor");
        t2.put("kaa", "Cyrl");
        t2.put("kap", "Cyrl");
        t2.put("kaw", "Kawi");
        t2.put("kbd", "Cyrl");
        t2.put("kbu", "Arab");
        t2.put("kby", "Arab");
        t2.put("kca", "Cyrl");
        t2.put("kdq", "Beng");
        t2.put("kdt", "Thai");
        t2.put("ket", "Cyrl");
        t2.put("kex", "Deva");
        t2.put("key", "Telu");
        t2.put("kfa", "Knda");
        t2.put("kfb", "Deva");
        t2.put("kfc", "Telu");
        t2.put("kfd", "Knda");
        t2.put("kfe", "Taml");
        t2.put("kfh", "Mlym");
        t2.put("kfi", "Taml");
        t2.put("kfk", "Deva");
        t2.put("kfm", "Arab");
        t2.put("kfp", "Deva");
        t2.put("kfq", "Deva");
        t2.put("kfr", "Deva");
        t2.put("kfs", "Deva");
        t2.put("kfx", "Deva");
        t2.put("kfy", "Deva");
        t2.put("kgj", "Deva");
        t2.put("kgy", "Deva");
        t2.put("khb", "Talu");
        t2.put("khf", "Thai");
        t2.put("khg", "Tibt");
        t2.put("khn", "Deva");
        t2.put("kht", "Mymr");
        t2.put("khv", "Cyrl");
        t2.put("khw", "Arab");
        t2.put("kif", "Deva");
        t2.put("kim", "Cyrl");
        t2.put("kip", "Deva");
        t2.put("kjg", "Laoo");
        t2.put("kjh", "Cyrl");
        t2.put("kjl", "Deva");
        t2.put("kjo", "Deva");
        t2.put("kjp", "Mymr");
        t2.put("kjt", "Thai");
        t2.put("kk", "Cyrl");
        t2.put("kk_AF", "Arab");
        t2.put("kk_CN", "Arab");
        t2.put("kk_IR", "Arab");
        t2.put("kk_MN", "Arab");
        t2.put("kkf", "Tibt");
        t2.put("kkh", "Lana");
        t2.put("kkt", "Deva");
        t2.put("kle", "Deva");
        t2.put("klj", "Arab");
        t2.put("klr", "Deva");
        t2.put("km", "Khmr");
        t2.put("kmj", "Deva");
        t2.put("kmz", "Arab");
        t2.put("kn", "Knda");
        t2.put("ko", "Kore");
        t2.put("koi", "Cyrl");
        t2.put("kok", "Deva");
        t2.put("kpt", "Cyrl");
        t2.put("kpy", "Cyrl");
        t2.put("kqd", "Syrc");
        t2.put("kqy", "Ethi");
        t2.put("kra", "Deva");
        t2.put("krc", "Cyrl");
        t2.put("krk", "Cyrl");
        t2.put("krr", "Khmr");
        t2.put("kru", "Deva");
        t2.put("krv", "Khmr");
        t2.put("ks", "Arab");
        t2.put("ksu", "Mymr");
        t2.put("ksw", "Mymr");
        t2.put("ksz", "Deva");
        t2.put("ktb", "Ethi");
        t2.put("ktl", "Arab");
        t2.put("ktp", "Plrd");
        t2.put("ku_LB", "Arab");
        t2.put("kuf", "Laoo");
        t2.put("kum", "Cyrl");
        t2.put("kv", "Cyrl");
        t2.put("kva", "Cyrl");
        t2.put("kvq", "Mymr");
        t2.put("kvt", "Mymr");
        t2.put("kvx", "Arab");
        t2.put("kvy", "Kali");
        t2.put("kxf", "Mymr");
        t2.put("kxk", "Mymr");
        t2.put("kxm", "Thai");
        t2.put("kxp", "Arab");
        t2.put("ky", "Cyrl");
        t2.put("ky_CN", "Arab");
        t2.put("kyu", "Kali");
        t2.put("kyv", "Deva");
        t2.put("kyw", "Deva");
        t2.put("lab", "Lina");
        t2.put("lad", "Hebr");
        t2.put("lae", "Deva");
        t2.put("lah", "Arab");
        t2.put("lbc", "Lisu");
        t2.put("lbe", "Cyrl");
        t2.put("lbf", "Deva");
        t2.put("lbj", "Tibt");
        t2.put("lbm", "Deva");
        t2.put("lbo", "Laoo");
        t2.put("lbr", "Deva");
        t2.put("lcp", "Thai");
        t2.put("lep", "Lepc");
        t2.put("lez", "Cyrl");
        t2.put("lhm", "Deva");
        t2.put("lhs", "Syrc");
        t2.put("lif", "Deva");
        t2.put("lis", "Lisu");
        t2.put("lkh", "Tibt");
        t2.put("lki", "Arab");
        t2.put("lmh", "Deva");
        t2.put("lmn", "Telu");
        t2.put("lo", "Laoo");
        t2.put("loy", "Deva");
        t2.put("lpo", "Plrd");
        t2.put("lrc", "Arab");
        t2.put("lrk", "Arab");
        t2.put("lrl", "Arab");
        t2.put("lsa", "Arab");
        t2.put("lsd", "Hebr");
        t2.put("lss", "Arab");
        t2.put("luk", "Tibt");
        t2.put("luu", "Deva");
        t2.put("luv", "Arab");
        t2.put("luz", "Arab");
        t2.put("lwl", "Thai");
        t2.put("lwm", "Thai");
        t2.put("lya", "Tibt");
        t2.put("lzh", "Hans");
        t2.put("mag", "Deva");
        t2.put("mai", "Deva");
        t2.put("man_GN", "Nkoo");
        t2.put("mby", "Arab");
        t2.put("mde", "Arab");
        t2.put("mdf", "Cyrl");
        t2.put("mdx", "Ethi");
        t2.put("mdy", "Ethi");
        t2.put("mfa", "Arab");
        t2.put("mfi", "Arab");
        t2.put("mgp", "Deva");
        t2.put("mhj", "Arab");
        t2.put("mid", "Mand");
        t2.put("mjl", "Deva");
        t2.put("mjq", "Mlym");
        t2.put("mjr", "Mlym");
        t2.put("mjt", "Deva");
        t2.put("mju", "Telu");
        t2.put("mjv", "Mlym");
        t2.put("mjz", "Deva");
        t2.put("mk", "Cyrl");
        t2.put("mkb", "Deva");
        t2.put("mke", "Deva");
        t2.put("mki", "Arab");
        t2.put("mkm", "Thai");
        t2.put("ml", "Mlym");
        t2.put("mlf", "Thai");
        t2.put("mn", "Cyrl");
        t2.put("mn_CN", "Mong");
        t2.put("mni", "Beng");
        t2.put("mnj", "Arab");
        t2.put("mns", "Cyrl");
        t2.put("mnw", "Mymr");
        t2.put("mpz", "Thai");
        t2.put("mr", "Deva");
        t2.put("mra", "Thai");
        t2.put("mrd", "Deva");
        t2.put("mrj", "Cyrl");
        t2.put("mro", "Mroo");
        t2.put("mrr", "Deva");
        t2.put("ms_CC", "Arab");
        t2.put("mtm", "Cyrl");
        t2.put("mtr", "Deva");
        t2.put("mud", "Cyrl");
        t2.put("muk", "Tibt");
        t2.put("mut", "Deva");
        t2.put("muv", "Taml");
        t2.put("muz", "Ethi");
        t2.put("mvf", "Mong");
        t2.put("mvy", "Arab");
        t2.put("mvz", "Ethi");
        t2.put("mwr", "Deva");
        t2.put("mwt", "Mymr");
        t2.put("mww", "Hmnp");
        t2.put("my", "Mymr");
        t2.put("mym", "Ethi");
        t2.put("myv", "Cyrl");
        t2.put("myz", "Mand");
        t2.put("mzn", "Arab");
        t2.put("nan", "Hans");
        t2.put("nao", "Deva");
        t2.put("ncd", "Deva");
        t2.put("ncq", "Laoo");
        t2.put("ndf", "Cyrl");
        t2.put("ne", "Deva");
        t2.put("neg", "Cyrl");
        t2.put("neh", "Tibt");
        t2.put("nei", "Xsux");
        t2.put("new", "Deva");
        t2.put("ngt", "Laoo");
        t2.put("nio", "Cyrl");
        t2.put("nit", "Telu");
        t2.put("niv", "Cyrl");
        t2.put("nli", "Arab");
        t2.put("nlm", "Arab");
        t2.put("nlx", "Deva");
        t2.put("nmm", "Deva");
        t2.put("nnp", "Wcho");
        t2.put("nod", "Lana");
        t2.put("noe", "Deva");
        t2.put("nog", "Cyrl");
        t2.put("noi", "Deva");
        t2.put("non", "Runr");
        t2.put("nos", "Yiii");
        t2.put("npb", "Tibt");
        t2.put("nqo", "Nkoo");
        t2.put("nsd", "Yiii");
        t2.put("nsf", "Yiii");
        t2.put("nsk", "Cans");
        t2.put("nst", "Tnsa");
        t2.put("nsv", "Yiii");
        t2.put("nty", "Yiii");
        t2.put("ntz", "Arab");
        t2.put("nwc", "Newa");
        t2.put("nwx", "Deva");
        t2.put("nyl", "Thai");
        t2.put("nyq", "Arab");
        t2.put("oaa", "Cyrl");
        t2.put("oac", "Cyrl");
        t2.put("oar", "Syrc");
        t2.put("oav", "Geor");
        t2.put("obm", "Phnx");
        t2.put("obr", "Mymr");
        t2.put("odk", "Arab");
        t2.put("oht", "Xsux");
        t2.put("oj", "Cans");
        t2.put("ojs", "Cans");
        t2.put("okm", "Hang");
        t2.put("oko", "Hani");
        t2.put("okz", "Khmr");
        t2.put("ola", "Deva");
        t2.put("ole", "Tibt");
        t2.put("omk", "Cyrl");
        t2.put("omp", "Mtei");
        t2.put("omr", "Modi");
        t2.put("oon", "Deva");
        t2.put("or", "Orya");
        t2.put("ort", "Telu");
        t2.put("oru", "Arab");
        t2.put("orv", "Cyrl");
        t2.put("os", "Cyrl");
        t2.put("osa", "Osge");
        t2.put("osc", "Ital");
        t2.put("osi", "Java");
        t2.put("ota", "Arab");
        t2.put("otb", "Tibt");
        t2.put("otk", "Orkh");
        t2.put("oty", "Gran");
        t2.put("pa", "Guru");
        t2.put("pa_PK", "Arab");
        t2.put("pal", "Phli");
        t2.put("paq", "Cyrl");
        t2.put("pbt", "Arab");
        t2.put("pcb", "Khmr");
        t2.put("pce", "Mymr");
        t2.put("pcf", "Mlym");
        t2.put("pcg", "Mlym");
        t2.put("pch", "Deva");
        t2.put("pci", "Deva");
        t2.put("pcj", "Telu");
        t2.put("peg", "Orya");
        t2.put("peo", "Xpeo");
        t2.put("pgd", "Khar");
        t2.put("pgg", "Deva");
        t2.put("pgl", "Ogam");
        t2.put("pgn", "Ital");
        t2.put("phd", "Deva");
        t2.put("phk", "Mymr");
        t2.put("phl", "Arab");
        t2.put("phn", "Phnx");
        t2.put("pho", "Laoo");
        t2.put("phr", "Arab");
        t2.put("pht", "Thai");
        t2.put("phv", "Arab");
        t2.put("phw", "Deva");
        t2.put("pi", "Sinh");
        t2.put("pka", "Brah");
        t2.put("pkr", "Mlym");
        t2.put("plk", "Arab");
        t2.put("pll", "Mymr");
        t2.put("pmh", "Brah");
        t2.put("pnt", "Grek");
        t2.put("pra", "Khar");
        t2.put("prc", "Arab");
        t2.put("prd", "Arab");
        t2.put("prt", "Thai");
        t2.put("prx", "Arab");
        t2.put("ps", "Arab");
        t2.put("psh", "Arab");
        t2.put("psi", "Arab");
        t2.put("pst", "Arab");
        t2.put("pum", "Deva");
        t2.put("pwo", "Mymr");
        t2.put("pwr", "Deva");
        t2.put("pww", "Thai");
        t2.put("pyx", "Mymr");
        t2.put("qxq", "Arab");
        t2.put("raa", "Deva");
        t2.put("rab", "Deva");
        t2.put("raf", "Deva");
        t2.put("rah", "Beng");
        t2.put("raj", "Deva");
        t2.put("rav", "Deva");
        t2.put("rbb", "Mymr");
        t2.put("rdb", "Arab");
        t2.put("rei", "Orya");
        t2.put("rhg", "Rohg");
        t2.put("rji", "Deva");
        t2.put("rjs", "Deva");
        t2.put("rka", "Khmr");
        t2.put("rki", "Mymr");
        t2.put("rkt", "Beng");
        t2.put("rmi", "Armn");
        t2.put("rmt", "Arab");
        t2.put("rmz", "Mymr");
        t2.put("rom_BG", "Cyrl");
        t2.put("rsk", "Cyrl");
        t2.put("rtw", "Deva");
        t2.put("ru", "Cyrl");
        t2.put("rue", "Cyrl");
        t2.put("rut", "Cyrl");
        t2.put("rwr", "Deva");
        t2.put("ryu", "Kana");
        t2.put("sa", "Deva");
        t2.put("sah", "Cyrl");
        t2.put("sam", "Samr");
        t2.put("sat", "Olck");
        t2.put("saz", "Saur");
        t2.put("sbn", "Arab");
        t2.put("sbu", "Tibt");
        t2.put("sck", "Deva");
        t2.put("scl", "Arab");
        t2.put("scl_IN", "Arab");
        t2.put("scp", "Deva");
        t2.put("sct", "Laoo");
        t2.put("scu", "Takr");
        t2.put("scx", "Grek");
        t2.put("sd", "Arab");
        t2.put("sd_IN", "Deva");
        t2.put("sdb", "Arab");
        t2.put("sdf", "Arab");
        t2.put("sdg", "Arab");
        t2.put("sdh", "Arab");
        t2.put("sds", "Arab");
        t2.put("sel", "Cyrl");
        t2.put("sfm", "Plrd");
        t2.put("sga", "Ogam");
        t2.put("sgh", "Cyrl");
        t2.put("sgj", "Deva");
        t2.put("sgr", "Arab");
        t2.put("sgt", "Tibt");
        t2.put("sgw", "Ethi");
        t2.put("sgy", "Arab");
        t2.put("shd", "Arab");
        t2.put("shi", "Tfng");
        t2.put("shm", "Arab");
        t2.put("shn", "Mymr");
        t2.put("shu", "Arab");
        t2.put("shv", "Arab");
        t2.put("si", "Sinh");
        t2.put("sia", "Cyrl");
        t2.put("sip", "Tibt");
        t2.put("siy", "Arab");
        t2.put("siz", "Arab");
        t2.put("sjd", "Cyrl");
        t2.put("sjp", "Deva");
        t2.put("sjt", "Cyrl");
        t2.put("skb", "Thai");
        t2.put("skj", "Deva");
        t2.put("skr", "Arab");
        t2.put("smh", "Yiii");
        t2.put("smp", "Samr");
        t2.put("smu", "Khmr");
        t2.put("smy", "Arab");
        t2.put("soa", "Tavt");
        t2.put("sog", "Sogd");
        t2.put("soi", "Deva");
        t2.put("sou", "Thai");
        t2.put("spt", "Tibt");
        t2.put("spv", "Orya");
        t2.put("sqo", "Arab");
        t2.put("sqq", "Laoo");
        t2.put("sqt", "Arab");
        t2.put("sr", "Cyrl");
        t2.put("srb", "Sora");
        t2.put("srh", "Arab");
        t2.put("srx", "Deva");
        t2.put("srz", "Arab");
        t2.put("ssh", "Arab");
        t2.put("sss", "Laoo");
        t2.put("sts", "Arab");
        t2.put("stv", "Ethi");
        t2.put("sty", "Cyrl");
        t2.put("suz", "Deva");
        t2.put("sva", "Geor");
        t2.put("swb", "Arab");
        t2.put("swi", "Hani");
        t2.put("swv", "Deva");
        t2.put("syc", "Syrc");
        t2.put("syl", "Beng");
        t2.put("syn", "Syrc");
        t2.put("syr", "Syrc");
        t2.put("syw", "Deva");
        t2.put("ta", "Taml");
        t2.put("tab", "Cyrl");
        t2.put("taj", "Deva");
        t2.put("tbk", "Tagb");
        t2.put("tcn", "Tibt");
        t2.put("tco", "Mymr");
        t2.put("tcx", "Taml");
        t2.put("tcy", "Knda");
        t2.put("tda", "Tfng");
        t2.put("tdb", "Deva");
        t2.put("tdd", "Tale");
        t2.put("tdg", "Deva");
        t2.put("tdh", "Deva");
        t2.put("te", "Telu");
        t2.put("tes", "Java");
        t2.put("tg", "Cyrl");
        t2.put("tg_PK", "Arab");
        t2.put("tge", "Deva");
        t2.put("tgf", "Tibt");
        t2.put("th", "Thai");
        t2.put("the", "Deva");
        t2.put("thf", "Deva");
        t2.put("thi", "Tale");
        t2.put("thl", "Deva");
        t2.put("thm", "Thai");
        t2.put("thq", "Deva");
        t2.put("thr", "Deva");
        t2.put("ths", "Deva");
        t2.put("ti", "Ethi");
        t2.put("tig", "Ethi");
        t2.put("tij", "Deva");
        t2.put("tin", "Cyrl");
        t2.put("tjl", "Mymr");
        t2.put("tjo", "Arab");
        t2.put("tkb", "Deva");
        t2.put("tks", "Arab");
        t2.put("tkt", "Deva");
        t2.put("tmr", "Syrc");
        t2.put("tnv", "Cakm");
        t2.put("tov", "Arab");
        t2.put("tpu", "Khmr");
        t2.put("tra", "Arab");
        t2.put("trg", "Hebr");
        t2.put("trm", "Arab");
        t2.put("trw", "Arab");
        t2.put("tsd", "Grek");
        t2.put("tsj", "Tibt");
        t2.put("tt", "Cyrl");
        t2.put("tth", "Laoo");
        t2.put("tto", "Laoo");
        t2.put("tts", "Thai");
        t2.put("tvn", "Mymr");
        t2.put("twm", "Deva");
        t2.put("txg", "Tang");
        t2.put("txo", "Toto");
        t2.put("tyr", "Tavt");
        t2.put("tyv", "Cyrl");
        t2.put("ude", "Cyrl");
        t2.put("udg", "Mlym");
        t2.put("udi", "Aghb");
        t2.put("udm", "Cyrl");
        t2.put("ug", "Arab");
        t2.put("ug_KZ", "Cyrl");
        t2.put("ug_MN", "Cyrl");
        t2.put("uga", "Ugar");
        t2.put("ugh", "Cyrl");
        t2.put("ugo", "Thai");
        t2.put("uk", "Cyrl");
        t2.put("uki", "Orya");
        t2.put("ulc", "Cyrl");
        t2.put("unr", "Beng");
        t2.put("unr_NP", "Deva");
        t2.put("unx", "Beng");
        t2.put("ur", "Arab");
        t2.put("urk", "Thai");
        t2.put("ush", "Arab");
        t2.put("uum", "Grek");
        t2.put("uz_AF", "Arab");
        t2.put("uz_CN", "Cyrl");
        t2.put("uzs", "Arab");
        t2.put("vaa", "Taml");
        t2.put("vaf", "Arab");
        t2.put("vah", "Deva");
        t2.put("vai", "Vaii");
        t2.put("vas", "Deva");
        t2.put("vav", "Deva");
        t2.put("vay", "Deva");
        t2.put("vgr", "Arab");
        t2.put("vmd", "Knda");
        t2.put("vmh", "Arab");
        t2.put("wal", "Ethi");
        t2.put("wbk", "Arab");
        t2.put("wbq", "Telu");
        t2.put("wbr", "Deva");
        t2.put("wlo", "Arab");
        t2.put("wme", "Deva");
        t2.put("wne", "Arab");
        t2.put("wni", "Arab");
        t2.put("wsg", "Gong");
        t2.put("wsv", "Arab");
        t2.put("wtm", "Deva");
        t2.put("wuu", "Hans");
        t2.put("xal", "Cyrl");
        t2.put("xan", "Ethi");
        t2.put("xas", "Cyrl");
        t2.put("xco", "Chrs");
        t2.put("xcr", "Cari");
        t2.put("xdq", "Cyrl");
        t2.put("xhe", "Arab");
        t2.put("xhm", "Khmr");
        t2.put("xis", "Orya");
        t2.put("xka", "Arab");
        t2.put("xkc", "Arab");
        t2.put("xkj", "Arab");
        t2.put("xkp", "Arab");
        t2.put("xlc", "Lyci");
        t2.put("xld", "Lydi");
        t2.put("xly", "Elym");
        t2.put("xmf", "Geor");
        t2.put("xmn", "Mani");
        t2.put("xmr", "Merc");
        t2.put("xna", "Narb");
        t2.put("xnr", "Deva");
        t2.put("xpg", "Grek");
        t2.put("xpi", "Ogam");
        t2.put("xpm", "Cyrl");
        t2.put("xpr", "Prti");
        t2.put("xrm", "Cyrl");
        t2.put("xrn", "Cyrl");
        t2.put("xsa", "Sarb");
        t2.put("xsr", "Deva");
        t2.put("xub", "Taml");
        t2.put("xuj", "Taml");
        t2.put("xve", "Ital");
        t2.put("xvi", "Arab");
        t2.put("xwo", "Cyrl");
        t2.put("xzh", "Marc");
        t2.put("yai", "Cyrl");
        t2.put("ybh", "Deva");
        t2.put("ybi", "Deva");
        t2.put("ydg", "Arab");
        t2.put("yea", "Mlym");
        t2.put("yej", "Grek");
        t2.put("yeu", "Telu");
        t2.put("ygp", "Plrd");
        t2.put("yhd", "Hebr");
        t2.put("yi", "Hebr");
        t2.put("yig", "Yiii");
        t2.put("yih", "Hebr");
        t2.put("yiv", "Yiii");
        t2.put("ykg", "Cyrl");
        t2.put("yna", "Plrd");
        t2.put("ynk", "Cyrl");
        t2.put("yoi", "Jpan");
        t2.put("yoy", "Thai");
        t2.put("yrk", "Cyrl");
        t2.put("ysd", "Yiii");
        t2.put("ysn", "Yiii");
        t2.put("ysp", "Yiii");
        t2.put("ysr", "Cyrl");
        t2.put("ysy", "Plrd");
        t2.put("yud", "Hebr");
        t2.put("yue", "Hant");
        t2.put("yue_CN", "Hans");
        t2.put("yug", "Cyrl");
        t2.put("yux", "Cyrl");
        t2.put("ywq", "Plrd");
        t2.put("ywu", "Plrd");
        t2.put("zau", "Tibt");
        t2.put("zba", "Arab");
        t2.put("zch", "Hani");
        t2.put("zdj", "Arab");
        t2.put("zeh", "Hani");
        t2.put("zen", "Tfng");
        t2.put("zgb", "Hani");
        t2.put("zgh", "Tfng");
        t2.put("zgm", "Hani");
        t2.put("zgn", "Hani");
        t2.put("zh", "Hans");
        t2.put("zh_AU", "Hant");
        t2.put("zh_BN", "Hant");
        t2.put("zh_GB", "Hant");
        t2.put("zh_GF", "Hant");
        t2.put("zh_HK", "Hant");
        t2.put("zh_ID", "Hant");
        t2.put("zh_MO", "Hant");
        t2.put("zh_PA", "Hant");
        t2.put("zh_PF", "Hant");
        t2.put("zh_PH", "Hant");
        t2.put("zh_SR", "Hant");
        t2.put("zh_TH", "Hant");
        t2.put("zh_TW", "Hant");
        t2.put("zh_US", "Hant");
        t2.put("zh_VN", "Hant");
        t2.put("zhd", "Hani");
        t2.put("zhx", "Nshu");
        t2.put("zko", "Cyrl");
        t2.put("zkt", "Kits");
        t2.put("zkz", "Cyrl");
        t2.put("zlj", "Hani");
        t2.put("zln", "Hani");
        t2.put("zlq", "Hani");
        t2.put("zqe", "Hani");
        t2.put("zrp", "Hebr");
        t2.put("zum", "Arab");
        t2.put("zyg", "Hani");
        t2.put("zyn", "Hani");
        t2.put("zzj", "Hani");
        return Collections.unmodifiableMap(t2);
    }

    private static Map<String, String> buildParentLocaleTable() {
        HashMap<String, String> t2 = new HashMap<String, String>();
        t2.put("az_Arab", "root");
        t2.put("az_Cyrl", "root");
        t2.put("bal_Latn", "root");
        t2.put("blt_Latn", "root");
        t2.put("bm_Nkoo", "root");
        t2.put("bs_Cyrl", "root");
        t2.put("byn_Latn", "root");
        t2.put("cu_Glag", "root");
        t2.put("dje_Arab", "root");
        t2.put("dyo_Arab", "root");
        t2.put("en_150", "en_001");
        t2.put("en_AG", "en_001");
        t2.put("en_AI", "en_001");
        t2.put("en_AT", "en_150");
        t2.put("en_AU", "en_001");
        t2.put("en_BB", "en_001");
        t2.put("en_BE", "en_150");
        t2.put("en_BM", "en_001");
        t2.put("en_BS", "en_001");
        t2.put("en_BW", "en_001");
        t2.put("en_BZ", "en_001");
        t2.put("en_CC", "en_001");
        t2.put("en_CH", "en_150");
        t2.put("en_CK", "en_001");
        t2.put("en_CM", "en_001");
        t2.put("en_CX", "en_001");
        t2.put("en_CY", "en_001");
        t2.put("en_DE", "en_150");
        t2.put("en_DG", "en_001");
        t2.put("en_DK", "en_150");
        t2.put("en_DM", "en_001");
        t2.put("en_Dsrt", "root");
        t2.put("en_ER", "en_001");
        t2.put("en_FI", "en_150");
        t2.put("en_FJ", "en_001");
        t2.put("en_FK", "en_001");
        t2.put("en_FM", "en_001");
        t2.put("en_GB", "en_001");
        t2.put("en_GD", "en_001");
        t2.put("en_GG", "en_001");
        t2.put("en_GH", "en_001");
        t2.put("en_GI", "en_001");
        t2.put("en_GM", "en_001");
        t2.put("en_GY", "en_001");
        t2.put("en_HK", "en_001");
        t2.put("en_ID", "en_001");
        t2.put("en_IE", "en_001");
        t2.put("en_IL", "en_001");
        t2.put("en_IM", "en_001");
        t2.put("en_IN", "en_001");
        t2.put("en_IO", "en_001");
        t2.put("en_JE", "en_001");
        t2.put("en_JM", "en_001");
        t2.put("en_KE", "en_001");
        t2.put("en_KI", "en_001");
        t2.put("en_KN", "en_001");
        t2.put("en_KY", "en_001");
        t2.put("en_LC", "en_001");
        t2.put("en_LR", "en_001");
        t2.put("en_LS", "en_001");
        t2.put("en_MG", "en_001");
        t2.put("en_MO", "en_001");
        t2.put("en_MS", "en_001");
        t2.put("en_MT", "en_001");
        t2.put("en_MU", "en_001");
        t2.put("en_MV", "en_001");
        t2.put("en_MW", "en_001");
        t2.put("en_MY", "en_001");
        t2.put("en_NA", "en_001");
        t2.put("en_NF", "en_001");
        t2.put("en_NG", "en_001");
        t2.put("en_NL", "en_150");
        t2.put("en_NR", "en_001");
        t2.put("en_NU", "en_001");
        t2.put("en_NZ", "en_001");
        t2.put("en_PG", "en_001");
        t2.put("en_PK", "en_001");
        t2.put("en_PN", "en_001");
        t2.put("en_PW", "en_001");
        t2.put("en_RW", "en_001");
        t2.put("en_SB", "en_001");
        t2.put("en_SC", "en_001");
        t2.put("en_SD", "en_001");
        t2.put("en_SE", "en_150");
        t2.put("en_SG", "en_001");
        t2.put("en_SH", "en_001");
        t2.put("en_SI", "en_150");
        t2.put("en_SL", "en_001");
        t2.put("en_SS", "en_001");
        t2.put("en_SX", "en_001");
        t2.put("en_SZ", "en_001");
        t2.put("en_Shaw", "root");
        t2.put("en_TC", "en_001");
        t2.put("en_TK", "en_001");
        t2.put("en_TO", "en_001");
        t2.put("en_TT", "en_001");
        t2.put("en_TV", "en_001");
        t2.put("en_TZ", "en_001");
        t2.put("en_UG", "en_001");
        t2.put("en_VC", "en_001");
        t2.put("en_VG", "en_001");
        t2.put("en_VU", "en_001");
        t2.put("en_WS", "en_001");
        t2.put("en_ZA", "en_001");
        t2.put("en_ZM", "en_001");
        t2.put("en_ZW", "en_001");
        t2.put("es_AR", "es_419");
        t2.put("es_BO", "es_419");
        t2.put("es_BR", "es_419");
        t2.put("es_BZ", "es_419");
        t2.put("es_CL", "es_419");
        t2.put("es_CO", "es_419");
        t2.put("es_CR", "es_419");
        t2.put("es_CU", "es_419");
        t2.put("es_DO", "es_419");
        t2.put("es_EC", "es_419");
        t2.put("es_GT", "es_419");
        t2.put("es_HN", "es_419");
        t2.put("es_JP", "es_419");
        t2.put("es_MX", "es_419");
        t2.put("es_NI", "es_419");
        t2.put("es_PA", "es_419");
        t2.put("es_PE", "es_419");
        t2.put("es_PR", "es_419");
        t2.put("es_PY", "es_419");
        t2.put("es_SV", "es_419");
        t2.put("es_US", "es_419");
        t2.put("es_UY", "es_419");
        t2.put("es_VE", "es_419");
        t2.put("ff_Adlm", "root");
        t2.put("ff_Arab", "root");
        t2.put("ha_Arab", "root");
        t2.put("hi_Latn", "en_IN");
        t2.put("ht", "fr_HT");
        t2.put("iu_Latn", "root");
        t2.put("kk_Arab", "root");
        t2.put("ks_Deva", "root");
        t2.put("ku_Arab", "root");
        t2.put("kxv_Deva", "root");
        t2.put("kxv_Orya", "root");
        t2.put("kxv_Telu", "root");
        t2.put("ky_Arab", "root");
        t2.put("ky_Latn", "root");
        t2.put("ml_Arab", "root");
        t2.put("mn_Mong", "root");
        t2.put("mni_Mtei", "root");
        t2.put("ms_Arab", "root");
        t2.put("nb", "no");
        t2.put("nn", "no");
        t2.put("no_NO", "no");
        t2.put("pa_Arab", "root");
        t2.put("pt_AO", "pt_PT");
        t2.put("pt_CH", "pt_PT");
        t2.put("pt_CV", "pt_PT");
        t2.put("pt_FR", "pt_PT");
        t2.put("pt_GQ", "pt_PT");
        t2.put("pt_GW", "pt_PT");
        t2.put("pt_LU", "pt_PT");
        t2.put("pt_MO", "pt_PT");
        t2.put("pt_MZ", "pt_PT");
        t2.put("pt_ST", "pt_PT");
        t2.put("pt_TL", "pt_PT");
        t2.put("sat_Deva", "root");
        t2.put("sd_Deva", "root");
        t2.put("sd_Khoj", "root");
        t2.put("sd_Sind", "root");
        t2.put("shi_Latn", "root");
        t2.put("so_Arab", "root");
        t2.put("sr_Latn", "root");
        t2.put("sw_Arab", "root");
        t2.put("tg_Arab", "root");
        t2.put("ug_Cyrl", "root");
        t2.put("uz_Arab", "root");
        t2.put("uz_Cyrl", "root");
        t2.put("vai_Latn", "root");
        t2.put("wo_Arab", "root");
        t2.put("yo_Arab", "root");
        t2.put("yue_Hans", "root");
        t2.put("zh_Hant", "root");
        t2.put("zh_Hant_MO", "zh_Hant_HK");
        return Collections.unmodifiableMap(t2);
    }
}

