/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.icu;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleFactory;

public class ExtractICUData {
    static Set<String> skipLines = new HashSet<String>(Arrays.asList("#--------------------------------------------------------------------", "#--------------------------------------------------------------------"));
    static Set<String> skipFiles = new HashSet<String>(Arrays.asList("el", "en", "root"));
    static String fixLineRules = "'<>' > '\u2194';'<' > '\u2190';'>' > '\u2192';'&' > '\u00a7';('\\u00'[0-7][0-9A-Fa-f]) > $1;('\\u'[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]) > |@&hex-any/java($1);([[:whitespace:][:Default_Ignorable_Code_Point:][:C:]-[\\u0020\\u200E\\0009]]) > &any-hex/java($1);";
    static Transliterator fixLine = Transliterator.createFromRules("foo", fixLineRules, 0);
    private static final String INDEX = "index";
    private static final String RB_RULE_BASED_IDS = "RuleBasedTransliteratorIDs";
    static String idPattern = "\\s*(\\p{L}+)(?:[_-](\\p{L}+))?(?:\\[_/](\\p{L}+))?";
    static Matcher idMatcher = PatternCache.get(idPattern).matcher("");
    static Matcher instanceMatcher = PatternCache.get("\\s*(\\[.*\\]\\s*)?(.*)").matcher("");
    static Matcher privateFiles = PatternCache.get(".*(Spacedhan|InterIndic|ThaiLogical|ThaiSemi).*").matcher("");
    static Matcher allowNames = PatternCache.get("(Fullwidth|Halfwidth|NumericPinyin|Publishing)").matcher("");
    static Set<String> collectedNames = new TreeSet<String>();

    public static void main(String[] args) throws Exception {
        String file = CldrUtility.getProperty("file", null);
        if (file != null) {
            String targetDirectory = CldrUtility.getProperty("target", CLDRPaths.GEN_DIRECTORY + "/translit/gen/");
            ExtractICUData.convertFile(file, targetDirectory);
        } else {
            ExtractICUData.generateTransliterators();
        }
        System.out.println("Done");
    }

    static void generateTransliterators() throws IOException {
        Matcher fileFilter = PatternCache.get(".*").matcher("");
        CLDRFile accumulatedItems = SimpleFactory.makeSupplemental("allItems");
        ExtractICUData.getTranslitIndex(accumulatedItems);
        File translitSource = new File("C:\\cvsdata\\icu\\icu\\source\\data\\translit\\");
        System.out.println("Source: " + PathUtilities.getNormalizedPathString(translitSource));
        File[] fileArray = translitSource.listFiles();
        ArrayList<File> list = new ArrayList<File>(Arrays.asList(fileArray));
        String[] attributesOut = new String[1];
        for (Object e : list) {
            String line;
            String coreName;
            String fileName = e instanceof File ? ((File)e).getName() : (String)e;
            if (!fileName.endsWith(".txt") || skipFiles.contains(coreName = fileName.substring(0, fileName.length() - 4))) continue;
            String id = ExtractICUData.fixTransID(coreName, attributesOut);
            String outName = id.replace('/', '-');
            Object attributes = attributesOut[0];
            attributes = (String)attributes + "[@direction=\"both\"]";
            System.out.println(coreName + "\t=>\t" + outName + " => " + (String)attributes);
            if (!fileFilter.reset(fileName).matches()) continue;
            BufferedReader input = e instanceof File ? FileUtilities.openUTF8Reader(((File)e).getParent() + File.separator, fileName) : CldrUtility.getUTF8Data(fileName);
            CLDRFile outFile = SimpleFactory.makeSupplemental(fileName);
            int count = 0;
            String prefixBase = "//supplementalData[@version=\"45\"]/transforms/transform" + (String)attributes;
            String rulePrefix = prefixBase + "/tRule[@_q=\"";
            String commentPrefix = prefixBase + "/comment[@_q=\"";
            StringBuffer accumulatedLines = new StringBuffer();
            while ((line = input.readLine()) != null) {
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if (skipLines.contains(line = line.trim()) || line.length() == 0) continue;
                String fixedLine = ExtractICUData.fixTransRule(line);
                accumulatedLines.append("\n\t\t");
                accumulatedLines.append(fixedLine);
                String prefix = line.startsWith("#") ? commentPrefix : rulePrefix;
                ExtractICUData.addInTwo(outFile, accumulatedItems, prefix + ++count + "\"]", fixedLine);
            }
            PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "/translit/gen/", outName + ".xml");
            outFile.write(pw);
            pw.close();
        }
        PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "/translit/gen/", "All.xml");
        accumulatedItems.write(pw);
        pw.close();
    }

    static void convertFile(String fileName, String targetDirectory) throws IOException {
        String line;
        String coreName = new File(fileName).getName();
        if (coreName.endsWith(".txt")) {
            coreName = coreName.substring(0, coreName.length() - 4);
        }
        String[] attributesOut = new String[]{""};
        String id = ExtractICUData.fixTransID(coreName, attributesOut);
        String outName = id.replace('/', '-');
        Object attributes = attributesOut[0];
        attributes = (String)attributes + "[@direction=\"both\"]";
        System.out.println(coreName + "\t=>\t" + outName + " => " + (String)attributes);
        BufferedReader input = FileUtilities.openUTF8Reader("", fileName);
        CLDRFile outFile = SimpleFactory.makeSupplemental(coreName);
        int count = 0;
        String prefixBase = "//supplementalData[@version=\"45\"]/transforms/transform" + (String)attributes;
        String rulePrefix = prefixBase + "/tRule[@_q=\"";
        String commentPrefix = prefixBase + "/comment[@_q=\"";
        StringBuffer accumulatedLines = new StringBuffer();
        while ((line = input.readLine()) != null) {
            if (line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (skipLines.contains(line = line.trim()) || line.length() == 0) continue;
            String fixedLine = ExtractICUData.fixTransRule(line);
            accumulatedLines.append("\n\t\t");
            accumulatedLines.append(fixedLine);
            String prefix = line.startsWith("#") ? commentPrefix : rulePrefix;
            ExtractICUData.addInTwo(outFile, null, prefix + ++count + "\"]", fixedLine);
        }
        PrintWriter pw = FileUtilities.openUTF8Writer(targetDirectory, outName + ".xml");
        outFile.write(pw);
        pw.close();
    }

    private static void addInTwo(CLDRFile outFile, CLDRFile accumulatedItems, String path, String value) {
        outFile.add(path, value);
        if (accumulatedItems != null) {
            accumulatedItems.add(path, value);
        }
    }

    private static String fixTransRule(String line) {
        int hashPos = ((String)line).indexOf(35);
        if (hashPos >= 0 && ((String)line).indexOf(39, hashPos) < 0) {
            String core = ((String)line).substring(0, hashPos).trim();
            Object comment = ((String)line).substring(hashPos + 1).trim();
            if (((String)comment).length() != 0) {
                comment = "# " + (String)comment;
            } else if (core.length() == 0) {
                return "#";
            }
            line = (String)(core.length() == 0 ? "" : core + " ") + (String)comment;
        }
        String fixedLine = fixLine.transliterate((String)line);
        return fixedLine;
    }

    private static void getTranslitIndex(CLDRFile accumulatedItems) throws IOException {
        UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt75b/translit", INDEX);
        UResourceBundle transIDs = bundle.get(RB_RULE_BASED_IDS);
        String[] attributesOut = new String[1];
        int count = 0;
        int maxRows = transIDs.getSize();
        for (int row = 0; row < maxRows; ++row) {
            UResourceBundle colBund = transIDs.get(row);
            String ID = colBund.getKey();
            UResourceBundle res = colBund.get(0);
            String type = res.getKey();
            if (type.equals("file") || type.equals("internal")) continue;
            if (type.equals("alias")) {
                CLDRFile outFile = SimpleFactory.makeSupplemental("transformAliases");
                ID = ExtractICUData.fixTransID(ID, attributesOut);
                String outName = ID.replace('/', '-');
                Object attributes = attributesOut[0];
                attributes = (String)attributes + "[@direction=\"forward\"]";
                System.out.println(ID + " => " + (String)attributes);
                String prefix = "//supplementalData[@version=\"45\"]/transforms/transform" + (String)attributes + "/tRule[@_q=\"";
                String resString = res.getString();
                if (!instanceMatcher.reset(resString).matches()) {
                    System.out.println("Doesn't match id: " + resString);
                } else {
                    String filter = instanceMatcher.group(1);
                    if (filter != null) {
                        filter = ExtractICUData.fixTransRule(filter);
                        outFile.add(prefix + ++count + "\"]", "::" + filter + ";");
                        accumulatedItems.add(prefix + ++count + "\"]", "::" + filter + ";");
                    }
                    String rest = instanceMatcher.group(2);
                    String[] pieces = rest.split(";");
                    for (int i = 0; i < pieces.length; ++i) {
                        String piece = pieces[i].trim();
                        if (piece.length() == 0) continue;
                        piece = ExtractICUData.fixTransID(piece, null);
                        outFile.add(prefix + ++count + "\"]", "::" + piece + ";");
                        accumulatedItems.add(prefix + ++count + "\"]", "::" + piece + ";");
                    }
                }
                PrintWriter pw = FileUtilities.openUTF8Writer(CLDRPaths.GEN_DIRECTORY + "/translit/gen/", outName + ".xml");
                outFile.write(pw);
                pw.close();
                continue;
            }
            throw new RuntimeException("Unknown type: " + type);
        }
    }

    private static String fixTransID(String id, String[] attributesOut) {
        if (!idMatcher.reset((CharSequence)id).matches()) {
            System.out.println("Doesn't match id:: " + (String)id);
        } else {
            String source = ExtractICUData.fixTransIDPart(idMatcher.group(1));
            Object target = ExtractICUData.fixTransIDPart(idMatcher.group(2));
            Object variant = ExtractICUData.fixTransIDPart(idMatcher.group(3));
            if (attributesOut != null) {
                attributesOut[0] = "[@source=\"" + source + "\"][@target=\"" + (String)target + "\"]" + (String)(variant == null ? "" : "[@variant=\"" + (String)variant + "\"]");
                if (privateFiles.reset((CharSequence)id).matches()) {
                    attributesOut[0] = attributesOut[0] + "[@visibility=\"internal\"]";
                }
            }
            target = target == null ? "" : "-" + (String)target;
            variant = variant == null ? "" : "/" + (String)variant;
            id = source + (String)target + (String)variant;
        }
        return id;
    }

    private static String fixTransIDPart(String name) {
        if (name == null) {
            return name;
        }
        try {
            UCharacter.getPropertyValueEnum(4106, name);
        }
        catch (IllegalArgumentException e) {
            collectedNames.add(name);
        }
        if (name.equals("Tone")) {
            return "Pinyin";
        }
        if (name.equals("Digit")) {
            return "NumericPinyin";
        }
        if (name.equals("Jamo")) {
            return "ConjoiningJamo";
        }
        if (name.equals("LowerLatin")) {
            return "Latin";
        }
        return name;
    }

    static void testProps() {
        int[][] ranges = new int[][]{{0, 75}, {4096, 4122}, {12288, 12288}, {16384, 16398}};
        Collator col = Collator.getInstance(ULocale.ROOT);
        ((RuleBasedCollator)col).setNumericCollation(true);
        TreeMap<Object, TreeSet<Object>> alpha = new TreeMap<Object, TreeSet<Object>>(col);
        for (int range = 0; range < ranges.length; ++range) {
            block9: for (int propIndex = ranges[range][0]; propIndex < ranges[range][1]; ++propIndex) {
                String propName = UCharacter.getPropertyName(propIndex, 1);
                String shortPropName = UCharacter.getPropertyName(propIndex, 0);
                propName = ExtractICUData.getName(propIndex, propName, shortPropName);
                TreeSet<Object> valueOrder = new TreeSet<Object>(col);
                alpha.put(propName, valueOrder);
                switch (range) {
                    case 0: {
                        valueOrder.add("[binary]");
                        continue block9;
                    }
                    case 2: {
                        valueOrder.add("[double]");
                        continue block9;
                    }
                    case 3: {
                        valueOrder.add("[string]");
                        continue block9;
                    }
                    case 1: {
                        for (int valueIndex = 0; valueIndex < 256; ++valueIndex) {
                            try {
                                String valueName = UCharacter.getPropertyValueName(propIndex, valueIndex, 1);
                                String shortValueName = UCharacter.getPropertyValueName(propIndex, valueIndex, 0);
                                valueName = ExtractICUData.getName(valueIndex, valueName, shortValueName);
                                valueOrder.add(valueName);
                                continue;
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                        continue block9;
                    }
                }
            }
        }
        PrintStream out = System.out;
        for (String propName : alpha.keySet()) {
            Set values = (Set)alpha.get(propName);
            out.println("<tr><td>" + propName + "</td>");
            out.println("<td><table>");
            for (String propValue : values) {
                System.out.println("<tr><td>" + propValue + "</td></tr>");
            }
            out.println("</table></td></tr>");
        }
        Collator c = Collator.getInstance(ULocale.ENGLISH);
        ((RuleBasedCollator)c).setNumericCollation(true);
    }

    private static String getName(int index, String valueName, String shortValueName) {
        if (valueName == null) {
            if (shortValueName == null) {
                return String.valueOf(index);
            }
            return shortValueName;
        }
        if (shortValueName == null) {
            return valueName;
        }
        if (valueName.equals(shortValueName)) {
            return valueName;
        }
        return valueName + "\u00a0(" + shortValueName + ")";
    }
}

