/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.ibm.icu.impl.Row;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.impl.number.DecimalQuantity;
import com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DateFormatSymbols;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.ListFormatter;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.SimpleFormatter;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.BestMinimalPairSamples;
import org.unicode.cldr.test.EmojiSubdivisionNames;
import org.unicode.cldr.test.ExampleCache;
import org.unicode.cldr.test.HelpMessages;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.CodePointEscaper;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.EmojiConstants;
import org.unicode.cldr.util.GrammarInfo;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.PathDescription;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PluralSamples;
import org.unicode.cldr.util.Rational;
import org.unicode.cldr.util.ScriptToExemplars;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.TransliteratorUtilities;
import org.unicode.cldr.util.UnitConverter;
import org.unicode.cldr.util.Units;
import org.unicode.cldr.util.XListFormatter;
import org.unicode.cldr.util.XPathParts;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class ExampleGenerator {
    private static final String INTERNAL = "internal: ";
    private static final String SUBTRACTS = "\u2796";
    private static final String ADDS = "\u2795";
    private static final String HINTS = "\ud83d\udddd\ufe0f";
    private static final String EXAMPLE_OF_INCORRECT = "\u274c  ";
    private static final String EXAMPLE_OF_CAUTION = "\u26a0\ufe0f  ";
    private static final boolean DEBUG_EXAMPLE_GENERATOR = false;
    static final boolean DEBUG_SHOW_HELP = false;
    private static final CLDRConfig CONFIG = CLDRConfig.getInstance();
    private static final String ALT_STAND_ALONE = "[@alt=\"stand-alone\"]";
    private static final String EXEMPLAR_CITY_LOS_ANGELES = "//ldml/dates/timeZoneNames/zone[@type=\"America/Los_Angeles\"]/exemplarCity";
    private static final Pattern URL_PATTERN = Pattern.compile("http://[\\-a-zA-Z0-9]+(\\.[\\-a-zA-Z0-9]+)*([/#][\\-a-zA-Z0-9]+)*");
    private static final SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
    static final UnitConverter UNIT_CONVERTER = supplementalDataInfo.getUnitConverter();
    public static final double NUMBER_SAMPLE = 123456.789;
    public static final double NUMBER_SAMPLE_WHOLE = 2345.0;
    public static final TimeZone ZONE_SAMPLE = TimeZone.getTimeZone("America/Indianapolis");
    public static final TimeZone GMT_ZONE_SAMPLE = TimeZone.getTimeZone("Etc/GMT");
    private static final String exampleStart = "<div class='cldr_example'>";
    private static final String exampleStartAuto = "<div class='cldr_example_auto' dir='auto'>";
    private static final String exampleStartRTL = "<div class='cldr_example_rtl' dir='rtl'>";
    private static final String exampleStartHeader = "<div class='cldr_example_rtl'>";
    private static final String exampleEnd = "</div>";
    private static final String startItalic = "<i>";
    private static final String endItalic = "</i>";
    private static final String startSup = "<sup>";
    private static final String endSup = "</sup>";
    private static final String backgroundAutoStart = "<span class='cldr_background_auto'>";
    private static final String backgroundAutoEnd = "</span>";
    private String backgroundStart = "<span class='cldr_substituted'>";
    private String backgroundEnd = "</span>";
    public static final String backgroundStartSymbol = "\ue234";
    public static final String backgroundEndSymbol = "\ue235";
    private static final String backgroundTempSymbol = "\ue236";
    private static final String exampleSeparatorSymbol = "\ue237";
    private static final String startItalicSymbol = "\ue238";
    private static final String endItalicSymbol = "\ue239";
    private static final String startSupSymbol = "\ue23a";
    private static final String endSupSymbol = "\ue23b";
    private static final String backgroundAutoStartSymbol = "\ue23c";
    private static final String backgroundAutoEndSymbol = "\ue23d";
    private static final String exampleStartAutoSymbol = "\ue23e";
    private static final String exampleStartRTLSymbol = "\ue23f";
    private static final String exampleStartHeaderSymbol = "\ue240";
    private static final String exampleEndSymbol = "\ue241";
    private static final String contextheader = "Key: \ue23cneutral\ue23d, RTL";
    public static final char TEXT_VARIANT = '\ufe0e';
    private static final UnicodeSet BIDI_MARKS = new UnicodeSet("[:Bidi_Control:]").freeze();
    public static final Date DATE_SAMPLE;
    private static final Date DATE_SAMPLE2;
    private static final Date DATE_SAMPLE3;
    private static final Date DATE_SAMPLE4;
    static final List<DecimalQuantity> CURRENCY_SAMPLES;
    public static final Pattern PARAMETER;
    public static final Pattern PARAMETER_SKIP0;
    public static final Pattern ALL_DIGITS;
    private static final Calendar generatingCalendar;
    private static final Date FIRST_INTERVAL;
    private static final Map<String, Date> SECOND_INTERVAL;
    private boolean verboseErrors = false;
    private final Calendar calendar = Calendar.getInstance(ZONE_SAMPLE, ULocale.ENGLISH);
    private final CLDRFile cldrFile;
    private final CLDRFile englishFile;
    private CLDRFile cyrillicFile;
    private CLDRFile japanFile;
    private final BestMinimalPairSamples bestMinimalPairSamples;
    private final ExampleCache exCache = new ExampleCache();
    private final ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    private final SupplementalDataInfo.PluralInfo pluralInfo;
    private final GrammarInfo grammarInfo;
    private PluralSamples patternExamples;
    private final Map<String, String> subdivisionIdToName;
    private String creationTime = null;
    private final IntervalFormat intervalFormat = new IntervalFormat();
    private PathDescription pathDescription;
    private final boolean typeIsEnglish;
    private final boolean isRTL;
    HelpMessages helpMessages;
    static final SimpleUnicodeSetFormatter SUSF;
    static final SimpleUnicodeSetFormatter SUSFNS;
    static final String LRM = "\u200e";
    static final UnicodeSet NEEDS_LRM;
    private static final boolean SHOW_NON_SPACING_IN_UNICODE_SET = true;
    PersonNamesCache personNamesCache = this.exCache.registerCache(new PersonNamesCache(), "//ldml/personNames/sampleName[@item=\"*\"]/nameField[@type=\"*\"]", "//ldml/personNames/initialPattern[@type=\"*\"]", "//ldml/personNames/foreignSpaceReplacement", "//ldml/personNames/nativeSpaceReplacement", "//ldml/personNames/personName[@order=\"*\"][@length=\"*\"][@usage=\"*\"][@formality=\"*\"]/namePattern");
    private static final Function<String, String> BACKGROUND_TRANSFORM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date getDate(int year, int month, int date, int hour, int minute, int second) {
        Calendar calendar = generatingCalendar;
        synchronized (calendar) {
            generatingCalendar.setTimeZone(GMT_ZONE_SAMPLE);
            generatingCalendar.set(year, month, date, hour, minute, second);
            return generatingCalendar.getTime();
        }
    }

    public void setCachingEnabled(boolean enabled) {
        this.exCache.setCachingEnabled(enabled);
        this.icuServiceBuilder.setCachingEnabled(enabled);
    }

    public CLDRFile getCldrFile() {
        return this.cldrFile;
    }

    public void updateCache(String xpath) {
        this.exCache.update(xpath);
        this.icuServiceBuilder.clearCache();
    }

    public String getBackgroundEnd() {
        return this.backgroundEnd;
    }

    public void setBackgroundEnd(String backgroundEnd) {
        this.backgroundEnd = backgroundEnd;
    }

    public String getBackgroundStart() {
        return this.backgroundStart;
    }

    public void setBackgroundStart(String backgroundStart) {
        this.backgroundStart = backgroundStart;
    }

    public void setVerboseErrors(boolean verbosity) {
        this.verboseErrors = verbosity;
    }

    public ExampleGenerator(CLDRFile resolvedCldrFile, CLDRFile englishFile) {
        if (!resolvedCldrFile.isResolved()) {
            throw new IllegalArgumentException("CLDRFile must be resolved");
        }
        if (!englishFile.isResolved()) {
            throw new IllegalArgumentException("English CLDRFile must be resolved");
        }
        this.cldrFile = resolvedCldrFile;
        String localeId = this.cldrFile.getLocaleID();
        this.subdivisionIdToName = EmojiSubdivisionNames.getSubdivisionIdToName(localeId);
        this.pluralInfo = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, localeId);
        this.grammarInfo = supplementalDataInfo.getGrammarInfo(localeId);
        this.englishFile = englishFile;
        this.typeIsEnglish = resolvedCldrFile == englishFile;
        this.icuServiceBuilder.setCldrFile(this.cldrFile);
        this.bestMinimalPairSamples = new BestMinimalPairSamples(this.cldrFile, this.icuServiceBuilder, false);
        String characterOrder = this.cldrFile.getStringValue("//ldml/layout/orientation/characterOrder");
        this.isRTL = characterOrder != null && characterOrder.equals("right-to-left");
    }

    public String getExampleHtml(String xpath, String value) {
        return this.getExampleHtmlExtended(xpath, value, false);
    }

    public String getNonTrivialExampleHtml(String xpath, String value) {
        return this.getExampleHtmlExtended(xpath, value, true);
    }

    private String getExampleHtmlExtended(String xpath, String value, boolean nonTrivial) {
        Object result;
        if (value == null || xpath == null || xpath.endsWith("/alias")) {
            return null;
        }
        try {
            if (CldrUtility.INHERITANCE_MARKER.equals(value) && (value = this.cldrFile.getBaileyValue(xpath, null, null)) == null) {
                return null;
            }
            ExampleCache exampleCache = this.exCache;
            Objects.requireNonNull(exampleCache);
            ExampleCache.ExampleCacheItem cacheItem = new ExampleCache.ExampleCacheItem(exampleCache, xpath, value);
            result = cacheItem.getExample();
            if (result != null) {
                return result;
            }
            result = this.constructExampleHtml(xpath, value, nonTrivial);
            cacheItem.putExample((String)result);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String unchained = this.verboseErrors ? "<br>" + this.finalizeBackground(ExampleGenerator.unchainException(e)) : "";
            result = "<i>Parsing error. " + this.finalizeBackground(e.getMessage()) + endItalic + unchained;
        }
        return result;
    }

    private String constructExampleHtml(String xpath, String value, boolean nonTrivial) {
        String result = null;
        boolean showContexts = this.isRTL || BIDI_MARKS.containsSome(value);
        XPathParts parts = XPathParts.getFrozenInstance(xpath).cloneAsThawed();
        if (parts.contains("dateRangePattern")) {
            result = this.handleDateRangePattern(value);
        } else if (parts.contains("timeZoneNames")) {
            result = this.handleTimeZoneName(parts, value);
        } else if (parts.contains("localeDisplayNames")) {
            result = this.handleDisplayNames(xpath, parts, value);
        } else if (parts.contains("currency")) {
            result = this.handleCurrency(xpath, parts, value);
        } else if (parts.contains("dayPeriods")) {
            result = this.handleDayPeriod(parts, value);
        } else if (parts.contains("pattern") || parts.contains("dateFormatItem")) {
            if (parts.contains("calendar")) {
                result = this.handleDateFormatItem(xpath, value, showContexts);
            } else if (parts.contains("miscPatterns")) {
                result = this.handleMiscPatterns(parts, value);
            } else if (parts.contains("numbers")) {
                result = parts.contains("currencyFormat") ? this.handleCurrencyFormat(parts, value, showContexts) : this.handleDecimalFormat(parts, value, showContexts);
            }
        } else if (parts.getElement(2).contains("symbols")) {
            result = this.handleNumberSymbol(parts, value);
        } else if (parts.contains("defaultNumberingSystem") || parts.contains("otherNumberingSystems")) {
            result = this.handleNumberingSystem(value);
        } else if (parts.contains("currencyFormats") && parts.contains("unitPattern")) {
            result = this.formatCountValue(xpath, parts, value);
        } else if (parts.getElement(-1).equals("compoundUnitPattern")) {
            result = this.handleCompoundUnit(parts);
        } else if (parts.getElement(-1).equals("compoundUnitPattern1") || parts.getElement(-1).equals("unitPrefixPattern")) {
            result = this.handleCompoundUnit1(parts, value);
        } else if (parts.getElement(-2).equals("unit") && (parts.getElement(-1).equals("unitPattern") || parts.getElement(-1).equals("displayName"))) {
            result = this.handleFormatUnit(parts, value);
        } else if (parts.getElement(-1).equals("perUnitPattern")) {
            result = this.handleFormatPerUnit(value);
        } else if (parts.getElement(-2).equals("minimalPairs")) {
            result = this.handleMinimalPairs(parts, value);
        } else if (parts.getElement(-1).equals("durationUnitPattern")) {
            result = this.handleDurationUnit(value);
        } else if (parts.contains("intervalFormats")) {
            result = this.handleIntervalFormats(parts, value);
        } else if (parts.getElement(1).equals("delimiters")) {
            result = this.handleDelimiters(parts, xpath, value);
        } else if (parts.getElement(1).equals("listPatterns")) {
            result = this.handleListPatterns(parts, value);
        } else if (parts.getElement(2).equals("ellipsis")) {
            result = this.handleEllipsis(parts.getAttributeValue(-1, "type"), value);
        } else if (parts.getElement(-1).equals("monthPattern")) {
            result = this.handleMonthPatterns(parts, value);
        } else if (parts.getElement(-1).equals("appendItem")) {
            result = this.handleAppendItems(parts, value);
        } else if (parts.getElement(-1).equals("annotation")) {
            result = this.handleAnnotationName(parts, value);
        } else if (parts.getElement(-1).equals("characterLabel")) {
            result = this.handleLabel(parts, value);
        } else if (parts.getElement(-1).equals("characterLabelPattern")) {
            result = this.handleLabelPattern(parts, value);
        } else if (parts.getElement(1).equals("personNames")) {
            result = this.handlePersonName(parts, value);
        } else if (parts.getElement(-1).equals("exemplarCharacters") || parts.getElement(-1).equals("parseLenient")) {
            result = this.handleUnicodeSet(parts, xpath, value);
        }
        if (result != null) {
            result = nonTrivial && value.equals(result) ? null : this.finalizeBackground(result);
        }
        return result;
    }

    private String handleUnicodeSet(XPathParts parts, String xpath, String value) {
        UnicodeSet valueSet;
        ArrayList<String> examples = new ArrayList<String>();
        try {
            valueSet = new UnicodeSet(value);
        }
        catch (Exception e) {
            return null;
        }
        String winningValue = this.cldrFile.getWinningValue(xpath);
        if (!winningValue.equals(value)) {
            UnicodeSet winningSet = new UnicodeSet(winningValue);
            UnicodeSet value_minus_winning = new UnicodeSet(valueSet).removeAll(winningSet);
            UnicodeSet winning_minus_value = new UnicodeSet(winningSet).removeAll(valueSet);
            if (!value_minus_winning.isEmpty()) {
                examples.add("\u200e\u2795 " + SUSF.format(value_minus_winning));
            }
            if (!winning_minus_value.isEmpty()) {
                examples.add("\u200e\u2796 " + SUSF.format(winning_minus_value));
            }
        }
        if (parts.containsAttributeValue("type", "auxiliary")) {
            LanguageTagParser ltp = new LanguageTagParser();
            String ltpScript = ltp.set(this.cldrFile.getLocaleID()).getResolvedScript();
            UnicodeSet exemplars = ScriptToExemplars.getExemplars(ltpScript);
            UnicodeSet main = this.cldrFile.getExemplarSet(CLDRFile.ExemplarType.main, CLDRFile.WinningChoice.WINNING);
            UnicodeSet mainAndAux = new UnicodeSet(main).addAll(valueSet);
            if (!mainAndAux.containsAll(exemplars)) {
                examples.add("\u200e\ud83d\udddd\ufe0f " + SUSF.format(new UnicodeSet(exemplars).removeAll(mainAndAux)));
            }
        }
        if (valueSet.containsSome(CodePointEscaper.FORCE_ESCAPE)) {
            for (String nsm : new UnicodeSet(valueSet).retainAll(CodePointEscaper.FORCE_ESCAPE)) {
                examples.add(CodePointEscaper.toExample(nsm.codePointAt(0)));
            }
        }
        examples.add(this.setBackground(INTERNAL) + valueSet.toPattern(false));
        return this.formatExampleList(examples);
    }

    private String handlePersonName(XPathParts parts, String value) {
        Object debugState = "start";
        try {
            PersonNameFormatter.FormatParameters formatParameters = new PersonNameFormatter.FormatParameters(PersonNameFormatter.Order.from(parts.getAttributeValue(2, "order")), PersonNameFormatter.Length.from(parts.getAttributeValue(2, "length")), PersonNameFormatter.Usage.from(parts.getAttributeValue(2, "usage")), PersonNameFormatter.Formality.from(parts.getAttributeValue(2, "formality")));
            ArrayList<String> examples = null;
            CLDRFile cldrFile2 = this.getCldrFile();
            switch (parts.getElement(2)) {
                case "nameOrderLocales": {
                    examples = new ArrayList<String>();
                    for (String localeId : PersonNameFormatter.SPLIT_SPACE.split(value)) {
                        String name = localeId.equals("und") ? "\u00abany other\u00bb" : cldrFile2.getName(localeId);
                        examples.add(localeId + " = " + name);
                    }
                    break;
                }
                case "initialPattern": {
                    return null;
                }
                case "sampleName": {
                    return null;
                }
                case "personName": {
                    examples = new ArrayList();
                    Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames = this.personNamesCache.getSampleNames(cldrFile2);
                    PersonNameFormatter personNameFormatter = this.personNamesCache.getPersonNameFormatter(cldrFile2);
                    boolean lastIsNative = false;
                    for (Map.Entry<PersonNameFormatter.SampleType, SimpleNameObject> typeAndSampleNameObject : sampleNames.entrySet()) {
                        PersonNameFormatter.NamePattern namePattern = PersonNameFormatter.NamePattern.from(0, value);
                        boolean isNative = typeAndSampleNameObject.getKey().isNative();
                        if (isNative != lastIsNative) {
                            String title = isNative ? "\ud83d\udfe8 Native name and script:" : "\ud83d\udfe7 Foreign name and native script:";
                            examples.add(startItalicSymbol + title + endItalicSymbol);
                            lastIsNative = isNative;
                        }
                        debugState = "<NamePattern.from: " + namePattern;
                        PersonNameFormatter.FallbackFormatter fallbackInfo = personNameFormatter.getFallbackInfo();
                        debugState = "<getFallbackInfo: " + fallbackInfo;
                        PersonNameFormatter.TransformingNameObject nameObject = new PersonNameFormatter.TransformingNameObject((PersonNameFormatter.NameObject)typeAndSampleNameObject.getValue(), BACKGROUND_TRANSFORM);
                        String result = namePattern.format(nameObject, formatParameters, fallbackInfo);
                        debugState = "<namePattern.format: " + result;
                        examples.add(result);
                    }
                    String script = new LikelySubtags().getLikelyScript(this.cldrFile.getLocaleID());
                    Output<Boolean> haveHeaderLine = new Output<Boolean>(false);
                    if (!script.equals("Latn")) {
                        this.formatSampleName(formatParameters, this.englishFile, examples, haveHeaderLine);
                    }
                    if (!script.equals("Cyrl")) {
                        this.formatSampleName(formatParameters, PersonNameScripts.Cyrl, examples, haveHeaderLine);
                    }
                    if (script.equals("Jpan")) break;
                    this.formatSampleName(formatParameters, PersonNameScripts.Jpan, examples, haveHeaderLine);
                }
            }
            return this.formatExampleList(examples);
        }
        catch (Exception e) {
            StringBuffer stackTrace;
            try (StringWriter sw = new StringWriter();
                 PrintWriter p = new PrintWriter(sw);){
                e.printStackTrace(p);
                stackTrace = sw.getBuffer();
            }
            catch (Exception e2) {
                stackTrace = new StringBuffer("internal error");
            }
            return "Internal error: " + e.getMessage() + "\n" + (String)debugState + "\n" + stackTrace;
        }
    }

    public void formatSampleName(PersonNameFormatter.FormatParameters formatParameters, PersonNameScripts script, List<String> examples, Output<Boolean> haveHeaderLine) {
        switch (script) {
            case Cyrl: {
                if (this.cyrillicFile == null) {
                    this.cyrillicFile = CLDRConfig.getInstance().getCldrFactory().make("uk", true);
                }
                this.formatSampleName(formatParameters, this.cyrillicFile, examples, haveHeaderLine);
                break;
            }
            case Jpan: {
                if (this.japanFile == null) {
                    this.japanFile = CLDRConfig.getInstance().getCldrFactory().make("ja", true);
                }
                this.formatSampleName(formatParameters, this.japanFile, examples, haveHeaderLine);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void formatSampleName(PersonNameFormatter.FormatParameters formatParameters, CLDRFile cldrFile2, List<String> examples, Output<Boolean> haveHeaderLine) {
        String result2;
        PersonNameFormatter formatter2 = new PersonNameFormatter(cldrFile2);
        Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames2 = PersonNameFormatter.loadSampleNames(cldrFile2);
        SimpleNameObject sampleName = this.getBestAvailable(sampleNames2, PersonNameFormatter.SampleType.nativeFull, PersonNameFormatter.SampleType.nativeGGS);
        if (sampleName != null && (result2 = formatter2.format(new PersonNameFormatter.TransformingNameObject((PersonNameFormatter.NameObject)sampleName, BACKGROUND_TRANSFORM), formatParameters)) != null) {
            if (!((Boolean)haveHeaderLine.value).booleanValue()) {
                haveHeaderLine.value = Boolean.TRUE;
                examples.add("\ue238\ud83d\udfe5 Foreign name and script:\ue239");
            }
            examples.add(result2);
        }
    }

    private SimpleNameObject getBestAvailable(Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNamesMap, PersonNameFormatter.SampleType ... sampleTypes) {
        for (PersonNameFormatter.SampleType sampleType : sampleTypes) {
            SimpleNameObject result = sampleNamesMap.get((Object)sampleType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String handleLabelPattern(XPathParts parts, String value) {
        if ("category-list".equals(parts.getAttributeValue(-1, "type"))) {
            ArrayList<String> examples = new ArrayList<String>();
            CLDRFile cfile = this.getCldrFile();
            SimpleFormatter initialPattern = SimpleFormatter.compile(this.setBackground(value));
            String path = CLDRFile.getKey(2, "FR");
            String regionName = cfile.getStringValue(path);
            String flagName = cfile.getStringValue("//ldml/characterLabels/characterLabel[@type=\"flag\"]");
            examples.add(this.invertBackground(EmojiConstants.getEmojiFromRegionCodes("FR") + " \u21d2 " + initialPattern.format(flagName, regionName)));
            return this.formatExampleList(examples);
        }
        return null;
    }

    private String handleLabel(XPathParts parts, String value) {
        switch (parts.getAttributeValue(-1, "type")) {
            case "flag": {
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                CLDRFile cfile = this.getCldrFile();
                ArrayList<String> examples = new ArrayList<String>();
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                this.addFlag(value2, "FR", cfile, initialPattern, examples);
                this.addFlag(value2, "CN", cfile, initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbeng", initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbsct", initialPattern, examples);
                this.addSubdivisionFlag(value2, "gbwls", initialPattern, examples);
                return this.formatExampleList(examples);
            }
            case "keycap": {
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                ArrayList<String> examples = new ArrayList<String>();
                CLDRFile cfile = this.getCldrFile();
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                examples.add(this.invertBackground(initialPattern.format(value2, "1")));
                examples.add(this.invertBackground(initialPattern.format(value2, "10")));
                examples.add(this.invertBackground(initialPattern.format(value2, "#")));
                return this.formatExampleList(examples);
            }
        }
        return null;
    }

    private void addFlag(String value2, String isoRegionCode, CLDRFile cfile, SimpleFormatter initialPattern, List<String> examples) {
        String path = CLDRFile.getKey(2, isoRegionCode);
        String regionName = cfile.getStringValue(path);
        examples.add(this.invertBackground(EmojiConstants.getEmojiFromRegionCodes(isoRegionCode) + " \u21d2 " + initialPattern.format(value2, regionName)));
    }

    private void addSubdivisionFlag(String value2, String isoSubdivisionCode, SimpleFormatter initialPattern, List<String> examples) {
        String subdivisionName = this.subdivisionIdToName.get(isoSubdivisionCode);
        if (subdivisionName == null) {
            subdivisionName = isoSubdivisionCode;
        }
        examples.add(this.invertBackground(EmojiConstants.getEmojiFromSubdivisionCodes(isoSubdivisionCode) + " \u21d2 " + initialPattern.format(value2, subdivisionName)));
    }

    private String handleAnnotationName(XPathParts parts, String value) {
        if (!"tts".equals(parts.getAttributeValue(-1, "type"))) {
            return null;
        }
        String cp = parts.getAttributeValue(-1, "cp");
        if (cp == null || cp.isEmpty()) {
            return null;
        }
        LinkedHashSet<String> examples = new LinkedHashSet<String>();
        int first = cp.codePointAt(0);
        switch (first) {
            case 128106: {
                examples.add(this.formatGroup(value, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc67", "\ud83d\udc66"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66", "\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc66"));
                break;
            }
            case 128143: {
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc68"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc69"));
                break;
            }
            case 128145: {
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc68", "\ud83d\udc69", "\ud83d\udc68"));
                examples.add(this.formatGroup(value, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "\ud83d\udc69", "\ud83d\udc69"));
                break;
            }
            default: {
                boolean isSkin = EmojiConstants.MODIFIERS.contains(first);
                if (!isSkin && !EmojiConstants.HAIR.contains(first)) break;
                String value2 = backgroundStartSymbol + value + backgroundEndSymbol;
                CLDRFile cfile = this.getCldrFile();
                String skin = "\ud83c\udffd";
                Object hair = "\ud83e\uddb0";
                String skinName = this.getEmojiName(cfile, skin);
                String hairName = this.getEmojiName(cfile, (String)hair);
                if (hairName == null) {
                    hair = "[missing]";
                }
                SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
                SimpleFormatter listPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/listPatterns/listPattern[@type=\"unit-short\"]/listPatternPart[@type=\"2\"]"));
                hair = EmojiConstants.JOINER_STRING + (String)hair;
                this.formatPeople(cfile, first, isSkin, value2, "\ud83d\udc69", skin, skinName, (String)hair, hairName, initialPattern, listPattern, examples);
                this.formatPeople(cfile, first, isSkin, value2, "\ud83d\udc68", skin, skinName, (String)hair, hairName, initialPattern, listPattern, examples);
            }
        }
        return this.formatExampleList(examples);
    }

    private String getEmojiName(CLDRFile cfile, String skin) {
        return cfile.getStringValue("//ldml/annotations/annotation[@cp=\"" + skin + "\"][@type=\"tts\"]");
    }

    private String formatGroup(String value, String sourceEmoji, String ... components) {
        CLDRFile cfile = this.getCldrFile();
        SimpleFormatter initialPattern = SimpleFormatter.compile(cfile.getStringValue("//ldml/characterLabels/characterLabelPattern[@type=\"category-list\"]"));
        String value2 = backgroundEndSymbol + value + backgroundStartSymbol;
        String[] names = new String[components.length];
        int i = 0;
        for (String component : components) {
            names[i++] = this.getEmojiName(cfile, component);
        }
        return backgroundStartSymbol + sourceEmoji + " \u21d2 " + initialPattern.format(value2, this.longListPatternExample(EmojiConstants.COMPOSED_NAME_LIST.getPath(), "n/a", "n/a2", names));
    }

    private void formatPeople(CLDRFile cfile, int first, boolean isSkin, String value2, String person, String skin, String skinName, String hair, String hairName, SimpleFormatter initialPattern, SimpleFormatter listPattern, Collection<String> examples) {
        String personName = this.getEmojiName(cfile, person);
        StringBuilder emoji = new StringBuilder(person).appendCodePoint(first);
        String cp = UTF16.valueOf(first);
        cp = isSkin ? cp : EmojiConstants.JOINER_STRING + cp;
        examples.add(person + cp + " \u21d2 " + this.invertBackground(initialPattern.format(personName, value2)));
        emoji.setLength(0);
        emoji.append(personName);
        if (isSkin) {
            skinName = value2;
            skin = cp;
        } else {
            hairName = value2;
            hair = cp;
        }
        examples.add(person + skin + hair + " \u21d2 " + this.invertBackground(listPattern.format(initialPattern.format(personName, skinName), hairName)));
    }

    private String handleDayPeriod(XPathParts parts, String value) {
        ArrayList<String> examples = new ArrayList<String>();
        String dayPeriodType = parts.getAttributeValue(5, "type");
        if (dayPeriodType == null) {
            return null;
        }
        DayPeriodInfo.Type aType = dayPeriodType.equals("format") ? DayPeriodInfo.Type.format : DayPeriodInfo.Type.selection;
        DayPeriodInfo dayPeriodInfo = supplementalDataInfo.getDayPeriods(aType, this.cldrFile.getLocaleID());
        String periodString = parts.getAttributeValue(-1, "type");
        if (periodString == null) {
            return null;
        }
        DayPeriodInfo.DayPeriod dayPeriod = DayPeriodInfo.DayPeriod.valueOf(periodString);
        String periods = dayPeriodInfo.toString(dayPeriod);
        examples.add(periods);
        if ("format".equals(dayPeriodType)) {
            Row.R3<Integer, Integer, Boolean> info;
            if (value == null) {
                value = "\ufffd";
            }
            if ((info = dayPeriodInfo.getFirstDayPeriodInfo(dayPeriod)) != null) {
                int time = ((Integer)info.get0() + (Integer)info.get1()) % 86400000 / 2;
                String timeFormatString = this.icuServiceBuilder.formatDayPeriod(time, backgroundStartSymbol + value + backgroundEndSymbol);
                examples.add(this.invertBackground(timeFormatString));
            }
        }
        return this.formatExampleList(examples.toArray(new String[0]));
    }

    private String handleMinimalPairs(XPathParts parts, String minimalPattern) {
        String sampleBad;
        String sample;
        ArrayList<String> examples = new ArrayList<String>();
        Output<String> output = new Output<String>();
        String locale = this.getCldrFile().getLocaleID();
        switch (parts.getElement(-1)) {
            case "ordinalMinimalPairs": {
                String count = parts.getAttributeValue(-1, "ordinal");
                sample = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.ordinal, count);
                String otherCount = ExampleGenerator.getOtherCount(locale, SupplementalDataInfo.PluralType.ordinal, count);
                sampleBad = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.ordinal, otherCount);
                break;
            }
            case "pluralMinimalPairs": {
                String count = parts.getAttributeValue(-1, "count");
                sample = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, count);
                String otherCount = ExampleGenerator.getOtherCount(locale, SupplementalDataInfo.PluralType.cardinal, count);
                sampleBad = this.bestMinimalPairSamples.getPluralOrOrdinalSample(SupplementalDataInfo.PluralType.cardinal, otherCount);
                break;
            }
            case "caseMinimalPairs": {
                String gCase = parts.getAttributeValue(-1, "case");
                sample = this.bestMinimalPairSamples.getBestUnitWithCase(gCase, output);
                sampleBad = this.getOtherCase(sample);
                break;
            }
            case "genderMinimalPairs": {
                String gender = parts.getAttributeValue(-1, "gender");
                sample = this.bestMinimalPairSamples.getBestUnitWithGender(gender, output);
                String otherGender = this.getOtherGender(gender);
                sampleBad = this.bestMinimalPairSamples.getBestUnitWithGender(otherGender, output);
                break;
            }
            default: {
                return null;
            }
        }
        String formattedUnit = ExampleGenerator.format(minimalPattern, backgroundStartSymbol + sample + backgroundEndSymbol);
        examples.add(formattedUnit);
        if (sampleBad == null) {
            sampleBad = "n/a";
        }
        formattedUnit = ExampleGenerator.format(minimalPattern, backgroundStartSymbol + sampleBad + backgroundEndSymbol);
        examples.add(EXAMPLE_OF_INCORRECT + formattedUnit);
        return this.formatExampleList(examples);
    }

    private String getOtherGender(String gender) {
        if (gender == null) {
            return null;
        }
        Collection<String> unitGenders = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalGender, GrammarInfo.GrammaticalScope.units);
        for (String otherGender : unitGenders) {
            if (gender.equals(otherGender)) continue;
            return otherGender;
        }
        return null;
    }

    private String getOtherCase(String sample) {
        if (sample == null) {
            return null;
        }
        Collection<String> unitCases = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
        Output<String> output = new Output<String>();
        for (String otherCase : unitCases) {
            String sampleBad = this.bestMinimalPairSamples.getBestUnitWithCase(otherCase, output);
            if (sample.equals(sampleBad)) continue;
            return sampleBad;
        }
        return null;
    }

    private static String getOtherCount(String locale, SupplementalDataInfo.PluralType ordinal, String count) {
        String otherCount = null;
        if (!Objects.equals(count, "other")) {
            otherCount = "other";
        } else {
            SupplementalDataInfo.PluralInfo rules = SupplementalDataInfo.getInstance().getPlurals(ordinal, locale);
            Set<String> counts = rules.getAdjustedCountStrings();
            for (String tryCount : counts) {
                if (tryCount.equals("other")) continue;
                otherCount = tryCount;
                break;
            }
        }
        return otherCount;
    }

    private UnitLength getUnitLength(XPathParts parts) {
        return UnitLength.valueOf(parts.getAttributeValue(-3, "type").toUpperCase(Locale.ENGLISH));
    }

    private String handleFormatUnit(XPathParts parts, String unitPattern) {
        String count;
        DecimalQuantity amount;
        String longUnitId = parts.getAttributeValue(-2, "type");
        String shortUnitId = UNIT_CONVERTER.getShortId(longUnitId);
        if (UnitConverter.HACK_SKIP_UNIT_NAMES.contains(shortUnitId)) {
            return null;
        }
        ArrayList<String> examples = new ArrayList<String>();
        if (parts.getElement(-1).equals("unitPattern") && (amount = this.getBest(SupplementalDataInfo.PluralInfo.Count.valueOf(count = parts.getAttributeValue(-1, "count")))) != null) {
            this.addFormattedUnits(examples, parts, unitPattern, shortUnitId, amount);
        }
        Map<Rational, String> relatedUnits = UNIT_CONVERTER.getRelatedExamples(shortUnitId, UnitConverter.getExampleUnitSystems(this.cldrFile.getLocaleID()));
        String unitSystem = null;
        boolean first = true;
        for (Map.Entry<Rational, String> relatedUnitInfo : relatedUnits.entrySet()) {
            if (unitSystem == null) {
                Set<UnitConverter.UnitSystem> systems = UNIT_CONVERTER.getSystemsEnum(shortUnitId);
                unitSystem = UnitConverter.UnitSystem.getSystemsDisplay(systems);
            }
            Rational relatedValue = relatedUnitInfo.getKey();
            String relatedUnit = relatedUnitInfo.getValue();
            Set<UnitConverter.UnitSystem> systems = UNIT_CONVERTER.getSystemsEnum(relatedUnit);
            String relation = "\u2261";
            String relatedValueDisplay = relatedValue.toString(Rational.FormatStyle.approx);
            if (relatedValueDisplay.startsWith("~")) {
                relation = "\u2248";
                relatedValueDisplay = relatedValueDisplay.substring(1);
            }
            if (first) {
                if (!examples.isEmpty()) {
                    examples.add("");
                }
                first = false;
            }
            examples.add(String.format("1 %s%s %s %s %s%s", shortUnitId, unitSystem, relation, relatedValueDisplay, relatedUnit, UnitConverter.UnitSystem.getSystemsDisplay(systems)));
        }
        return this.formatExampleList(examples);
    }

    public void addFormattedUnits(List<String> examples, XPathParts parts, String unitPattern, String shortUnitId, DecimalQuantity amount) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        String formattedAmount = numberFormat.format(amount.toBigDecimal());
        examples.add(ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol));
        if (parts.getElement(-2).equals("unit") && unitPattern != null) {
            String minimalPattern;
            String gCase = parts.getAttributeValue(-1, "case");
            if (gCase == null) {
                gCase = GrammarInfo.GrammaticalFeature.grammaticalCase.getDefault(null);
            }
            Collection<String> unitCaseInfo = null;
            if (this.grammarInfo != null) {
                unitCaseInfo = this.grammarInfo.get(GrammarInfo.GrammaticalTarget.nominal, GrammarInfo.GrammaticalFeature.grammaticalCase, GrammarInfo.GrammaticalScope.units);
            }
            if ((minimalPattern = this.cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + gCase + "\"]")) != null) {
                String composed = ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol);
                examples.add(backgroundStartSymbol + ExampleGenerator.format(minimalPattern, backgroundEndSymbol + composed + backgroundStartSymbol) + backgroundEndSymbol);
                if (unitCaseInfo != null && !unitCaseInfo.isEmpty()) {
                    String constrastingCase = this.getConstrastingCase(unitPattern, gCase, unitCaseInfo, parts);
                    if (constrastingCase != null) {
                        minimalPattern = this.cldrFile.getStringValue("//ldml/numbers/minimalPairs/caseMinimalPairs[@case=\"" + constrastingCase + "\"]");
                        composed = ExampleGenerator.format(unitPattern, backgroundStartSymbol + formattedAmount + backgroundEndSymbol);
                        examples.add("\u274c  \ue234" + ExampleGenerator.format(minimalPattern, backgroundEndSymbol + composed + backgroundStartSymbol) + backgroundEndSymbol);
                    }
                } else {
                    examples.add("\u26a0\ufe0f  \ufe0fNo Case Minimal Pair available yet\ufe0f");
                }
            }
        }
    }

    private String getConstrastingCase(String unitPattern, String gCase, Collection<String> unitCaseInfo, XPathParts parts) {
        for (String otherCase : unitCaseInfo) {
            if (otherCase.equals(gCase)) continue;
            parts.putAttributeValue(-1, "case", "nominative".equals(otherCase) ? null : otherCase);
            String otherValue = this.cldrFile.getStringValue(parts.toString());
            if (otherValue == null || otherValue.equals(unitPattern)) continue;
            return otherCase;
        }
        return null;
    }

    private String handleFormatPerUnit(String value) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        return ExampleGenerator.format(value, backgroundStartSymbol + numberFormat.format(1L) + backgroundEndSymbol);
    }

    public String handleCompoundUnit(XPathParts parts) {
        UnitLength unitLength = this.getUnitLength(parts);
        String compoundType = parts.getAttributeValue(-2, "type");
        SupplementalDataInfo.PluralInfo.Count count = SupplementalDataInfo.PluralInfo.Count.valueOf(CldrUtility.ifNull(parts.getAttributeValue(-1, "count"), "other"));
        return this.handleCompoundUnit(unitLength, compoundType, count);
    }

    public String handleCompoundUnit(UnitLength unitLength, String compoundType, SupplementalDataInfo.PluralInfo.Count count) {
        String unit2mid;
        String unit1mid;
        DecimalQuantity amount = this.getBest(count);
        if (amount == null) {
            return "n/a";
        }
        DecimalQuantity oneValue = DecimalQuantity_DualStorageBCD.fromExponentString("1");
        switch (compoundType) {
            default: {
                return "n/a";
            }
            case "per": {
                unit1mid = this.getFormattedUnit("length-meter", unitLength, amount);
                unit2mid = this.getFormattedUnit("duration-second", unitLength, oneValue, "");
                break;
            }
            case "times": {
                unit1mid = this.getFormattedUnit("force-newton", unitLength, oneValue, this.icuServiceBuilder.getNumberFormat(1).format(amount.toBigDecimal()));
                unit2mid = this.getFormattedUnit("length-meter", unitLength, amount, "");
            }
        }
        String unit1 = backgroundStartSymbol + unit1mid.trim() + backgroundEndSymbol;
        String unit2 = backgroundStartSymbol + unit2mid.trim() + backgroundEndSymbol;
        String form = this.pluralInfo.getPluralRules().select(amount);
        String perPath = this.makeCompoundUnitPath(unitLength, compoundType, "compoundUnitPattern");
        return ExampleGenerator.format(this.getValueFromFormat(perPath, form), unit1, unit2);
    }

    public String handleCompoundUnit1(XPathParts parts, String compoundPattern) {
        UnitLength unitLength = this.getUnitLength(parts);
        String pathCount = parts.getAttributeValue(-1, "count");
        if (pathCount == null) {
            return this.handleCompoundUnit1Name(unitLength, compoundPattern);
        }
        return this.handleCompoundUnit1(unitLength, SupplementalDataInfo.PluralInfo.Count.valueOf(pathCount), compoundPattern);
    }

    private String handleCompoundUnit1Name(UnitLength unitLength, String compoundPattern) {
        String pathFormat = "//ldml/units/unitLength" + unitLength.typeString + "/unit[@type=\"{0}\"]/displayName";
        String meterFormat = this.getValueFromFormat(pathFormat, "length-meter");
        String modFormat = this.combinePrefix(meterFormat, compoundPattern, unitLength == UnitLength.LONG);
        return this.removeEmptyRuns(modFormat);
    }

    public String handleCompoundUnit1(UnitLength unitLength, SupplementalDataInfo.PluralInfo.Count count, String compoundPattern) {
        DecimalQuantity amount = this.getBest(count);
        if (amount == null) {
            return "n/a";
        }
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        String form1 = this.pluralInfo.getPluralRules().select(amount);
        String pathFormat = "//ldml/units/unitLength" + unitLength.typeString + "/unit[@type=\"{0}\"]/unitPattern[@count=\"{1}\"]";
        String meterFormat = this.getValueFromFormat(pathFormat, "length-meter", form1);
        String modFormat = this.combinePrefix(meterFormat, compoundPattern, unitLength == UnitLength.LONG);
        return this.removeEmptyRuns(ExampleGenerator.format(modFormat, numberFormat.format(amount.toBigDecimal())));
    }

    public String combinePrefix(String unitFormat, String inCompoundPattern, boolean lowercaseUnitIfNoSpaceInCompound) {
        String compoundPattern = backgroundEndSymbol + inCompoundPattern.replace("{0}", "\ue234{0}\ue235") + backgroundStartSymbol;
        String modFormat = Units.combinePattern(unitFormat, compoundPattern, lowercaseUnitIfNoSpaceInCompound);
        return backgroundStartSymbol + modFormat + backgroundEndSymbol;
    }

    public String makeCompoundUnitPath(UnitLength unitLength, String compoundType, String patternType) {
        return "//ldml/units/unitLength" + unitLength.typeString + "/compoundUnit[@type=\"" + compoundType + "\"]/" + patternType;
    }

    private DecimalQuantity getBest(SupplementalDataInfo.PluralInfo.Count count) {
        PluralRules.DecimalQuantitySamples samples = this.pluralInfo.getPluralRules().getDecimalSamples(count.name(), PluralRules.SampleType.DECIMAL);
        if (samples == null) {
            samples = this.pluralInfo.getPluralRules().getDecimalSamples(count.name(), PluralRules.SampleType.INTEGER);
        }
        if (samples == null) {
            return null;
        }
        Set<PluralRules.DecimalQuantitySamplesRange> samples2 = samples.getSamples();
        PluralRules.DecimalQuantitySamplesRange range = samples2.iterator().next();
        return range.end;
    }

    private String handleMiscPatterns(XPathParts parts, String value) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(0);
        String start = backgroundStartSymbol + numberFormat.format(99L) + backgroundEndSymbol;
        if ("range".equals(parts.getAttributeValue(-1, "type"))) {
            String end = backgroundStartSymbol + numberFormat.format(144L) + backgroundEndSymbol;
            return ExampleGenerator.format(value, start, end);
        }
        return ExampleGenerator.format(value, start);
    }

    private String handleIntervalFormats(XPathParts parts, String value) {
        if (!parts.getAttributeValue(3, "type").equals("gregorian")) {
            return null;
        }
        if (parts.getElement(6).equals("intervalFormatFallback")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            String fallbackFormat = this.invertBackground(this.setBackground(value));
            return ExampleGenerator.format(fallbackFormat, dateFormat.format(FIRST_INTERVAL), dateFormat.format(SECOND_INTERVAL.get("y")));
        }
        String greatestDifference = parts.getAttributeValue(-1, "id");
        if (greatestDifference.equals("H")) {
            greatestDifference = "h";
        } else if (greatestDifference.equals("B") || greatestDifference.equals("b")) {
            greatestDifference = "a";
        }
        this.intervalFormat.setPattern(parts, value);
        Date later = SECOND_INTERVAL.get(greatestDifference);
        if (later == null) {
            return null;
        }
        return this.intervalFormat.format(FIRST_INTERVAL, later);
    }

    private String handleDelimiters(XPathParts parts, String xpath, String value) {
        String lastElement = parts.getElement(-1);
        String[] elements = new String[]{"quotationStart", "alternateQuotationStart", "alternateQuotationEnd", "quotationEnd"};
        String[] quotes = new String[4];
        String baseXpath = xpath.substring(0, xpath.lastIndexOf(47));
        for (int i = 0; i < quotes.length; ++i) {
            String currElement = elements[i];
            quotes[i] = lastElement.equals(currElement) ? backgroundStartSymbol + value + backgroundEndSymbol : this.cldrFile.getWinningValue(baseXpath + "/" + currElement);
        }
        String example = this.cldrFile.getStringValue("//ldml/localeDisplayNames/types/type[@key=\"calendar\"][@type=\"gregorian\"]");
        return this.invertBackground(ExampleGenerator.format("{0}They said {1}" + example + "{2}.{3}", quotes));
    }

    private String handleListPatterns(XPathParts parts, String value) {
        String listPatternType = parts.getAttributeValue(-2, "type");
        if (listPatternType == null || !listPatternType.contains("unit")) {
            return this.handleRegularListPatterns(parts, value, XListFormatter.ListTypeLength.from(listPatternType));
        }
        return this.handleDurationListPatterns(parts, value, UnitLength.from(listPatternType));
    }

    private String handleRegularListPatterns(XPathParts parts, String value, XListFormatter.ListTypeLength listTypeLength) {
        String patternType = parts.getAttributeValue(-1, "type");
        if (patternType == null) {
            return null;
        }
        String pathFormat = "//ldml/localeDisplayNames/territories/territory[@type=\"{0}\"]";
        String territory1 = this.getValueFromFormat(pathFormat, "CH");
        String territory2 = this.getValueFromFormat(pathFormat, "JP");
        if (patternType.equals("2")) {
            return this.invertBackground(ExampleGenerator.format(this.setBackground(value), territory1, territory2));
        }
        String territory3 = this.getValueFromFormat(pathFormat, "EG");
        String territory4 = this.getValueFromFormat(pathFormat, "CA");
        return this.longListPatternExample(listTypeLength.getPath(), patternType, value, territory1, territory2, territory3, territory4);
    }

    private String handleDurationListPatterns(XPathParts parts, String value, UnitLength unitWidth) {
        String patternType = parts.getAttributeValue(-1, "type");
        if (patternType == null) {
            return null;
        }
        String duration1 = this.getFormattedUnit("duration-day", unitWidth, 4.0);
        String duration2 = this.getFormattedUnit("duration-hour", unitWidth, 2.0);
        if (patternType.equals("2")) {
            return this.invertBackground(ExampleGenerator.format(this.setBackground(value), duration1, duration2));
        }
        String duration3 = this.getFormattedUnit("duration-minute", unitWidth, 37.0);
        String duration4 = this.getFormattedUnit("duration-second", unitWidth, 23.0);
        return this.longListPatternExample(unitWidth.listTypeLength.getPath(), patternType, value, duration1, duration2, duration3, duration4);
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, DecimalQuantity unitAmount) {
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(1);
        return this.getFormattedUnit(unitType, unitWidth, unitAmount, numberFormat.format(unitAmount.toBigDecimal()));
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, double unitAmount) {
        return this.getFormattedUnit(unitType, unitWidth, new DecimalQuantity_DualStorageBCD(unitAmount));
    }

    private String getFormattedUnit(String unitType, UnitLength unitWidth, DecimalQuantity unitAmount, String formattedUnitAmount) {
        String form = this.pluralInfo.getPluralRules().select(unitAmount);
        String pathFormat = "//ldml/units/unitLength" + unitWidth.typeString + "/unit[@type=\"{0}\"]/unitPattern[@count=\"{1}\"]";
        return ExampleGenerator.format(this.getValueFromFormat(pathFormat, unitType, form), formattedUnitAmount);
    }

    private String longListPatternExample(String listPathFormat, String patternType, String value, String ... items) {
        String doublePattern = this.getPattern(listPathFormat, "2", patternType, value);
        String startPattern = this.getPattern(listPathFormat, "start", patternType, value);
        String middlePattern = this.getPattern(listPathFormat, "middle", patternType, value);
        String endPattern = this.getPattern(listPathFormat, "end", patternType, value);
        ListFormatter listFormatter = new ListFormatter(doublePattern, startPattern, middlePattern, endPattern);
        String example = listFormatter.format(items);
        return this.invertBackground(example);
    }

    private String getPattern(String pathFormat, String pathPatternType, String valuePatternType, String value) {
        return valuePatternType.equals(pathPatternType) ? this.setBackground(value) : this.getValueFromFormat(pathFormat, pathPatternType);
    }

    private String getValueFromFormat(String format, Object ... arguments) {
        return this.cldrFile.getWinningValue(ExampleGenerator.format(format, arguments));
    }

    public String handleEllipsis(String type, String value) {
        String pathFormat = "//ldml/localeDisplayNames/territories/territory[@type=\"{0}\"]";
        String territory1 = this.getValueFromFormat(pathFormat, "CH");
        String territory2 = this.getValueFromFormat(pathFormat, "JP");
        if (!type.contains("word")) {
            territory1 = ExampleGenerator.clip(territory1, 0, 1);
            territory2 = ExampleGenerator.clip(territory2, 1, 0);
        }
        if (type.contains("initial")) {
            territory1 = territory2;
        }
        return this.invertBackground(ExampleGenerator.format(this.setBackground(value), territory1, territory2));
    }

    public static String clip(String text, int clipStart, int clipEnd) {
        BreakIterator bi = BreakIterator.getCharacterInstance();
        bi.setText(text);
        for (int i = 0; i < clipStart; ++i) {
            bi.next();
        }
        int start = bi.current();
        bi.last();
        for (int i = 0; i < clipEnd; ++i) {
            bi.previous();
        }
        int end = bi.current();
        return start >= end ? text : text.substring(start, end);
    }

    private String handleMonthPatterns(XPathParts parts, String value) {
        String calendar = parts.getAttributeValue(3, "type");
        String context = parts.getAttributeValue(5, "type");
        String month = "8";
        if (!context.equals("numeric")) {
            String width = parts.getAttributeValue(6, "type");
            String xpath = "//ldml/dates/calendars/calendar[@type=\"{0}\"]/months/monthContext[@type=\"{1}\"]/monthWidth[@type=\"{2}\"]/month[@type=\"8\"]";
            month = this.getValueFromFormat(xpath, calendar, context, width);
        }
        return this.invertBackground(ExampleGenerator.format(this.setBackground(value), month));
    }

    private String handleAppendItems(XPathParts parts, String value) {
        String request = parts.getAttributeValue(-1, "request");
        if (!"Timezone".equals(request)) {
            return null;
        }
        String calendar = parts.getAttributeValue(3, "type");
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendar, 0, 2, null);
        String zone = this.cldrFile.getStringValue("//ldml/dates/timeZoneNames/gmtZeroFormat");
        return ExampleGenerator.format(value, this.setBackground(sdf.format(DATE_SAMPLE)), this.setBackground(zone));
    }

    private String handleDurationUnit(String value) {
        SimpleDateFormat df = this.icuServiceBuilder.getDateFormat("gregorian", value.replace('h', 'H'));
        df.setTimeZone(TimeZone.GMT_ZONE);
        long time = 20243000L;
        try {
            return df.format(new Date(time));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String formatCountValue(String xpath, XPathParts parts, String value) {
        SupplementalDataInfo.PluralInfo.Count count;
        if (!parts.containsAttribute("count")) {
            return null;
        }
        SupplementalDataInfo.PluralInfo plurals = supplementalDataInfo.getPlurals(SupplementalDataInfo.PluralType.cardinal, this.cldrFile.getLocaleID());
        PluralRules pluralRules = plurals.getPluralRules();
        String unitType = parts.getAttributeValue(-2, "type");
        if (unitType == null) {
            unitType = "USD";
        }
        boolean isPattern = parts.contains("unitPattern");
        boolean isCurrency = !parts.contains("units");
        LinkedHashSet<DecimalQuantity> exampleCount = new LinkedHashSet<DecimalQuantity>(CURRENCY_SAMPLES);
        String countString = parts.getAttributeValue(-1, "count");
        if (countString == null) {
            return null;
        }
        try {
            count = SupplementalDataInfo.PluralInfo.Count.valueOf(countString);
        }
        catch (Exception e) {
            return null;
        }
        ExampleGenerator.getStartEndSamples(pluralRules.getDecimalSamples(countString, PluralRules.SampleType.INTEGER), exampleCount);
        ExampleGenerator.getStartEndSamples(pluralRules.getDecimalSamples(countString, PluralRules.SampleType.DECIMAL), exampleCount);
        String result = "";
        DecimalFormat currencyFormat = this.icuServiceBuilder.getCurrencyFormat(unitType);
        int decimalCount = currencyFormat.getMinimumFractionDigits();
        ArrayList<DecimalQuantity> examplesSeen = new ArrayList<DecimalQuantity>();
        int maxCount = 2;
        block2: for (int phase = 0; phase < 2; ++phase) {
            for (DecimalQuantity example : exampleCount) {
                if (isCurrency && phase == 0) {
                    DecimalQuantity_DualStorageBCD newExample = new DecimalQuantity_DualStorageBCD();
                    newExample.copyFrom(example);
                    newExample.setMinFraction(decimalCount);
                    example = newExample;
                }
                if (examplesSeen.contains(example)) continue;
                examplesSeen.add(example);
                if (!pluralRules.select(example).equals(count.toString())) continue;
                if (value == null) {
                    String fallbackPath = this.cldrFile.getCountPathWithFallback(xpath, count, true);
                    value = this.cldrFile.getStringValue(fallbackPath);
                }
                String resultItem = this.formatCurrency(value, unitType, isPattern, isCurrency, count, example);
                result = this.addExampleResult(resultItem, result);
                if (isPattern) {
                    String territory = this.getDefaultTerritory();
                    String currency = supplementalDataInfo.getDefaultCurrency(territory);
                    if (currency.equals(unitType) && (currency = "EUR").equals(unitType)) {
                        currency = "JAY";
                    }
                    resultItem = this.formatCurrency(value, currency, isPattern, isCurrency, count, example);
                    result = this.addExampleResult(resultItem, result);
                }
                if (--maxCount >= 1) continue;
                break block2;
            }
        }
        return result.isEmpty() ? null : result;
    }

    public static void getStartEndSamples(PluralRules.DecimalQuantitySamples samples, Set<DecimalQuantity> target) {
        if (samples != null) {
            for (PluralRules.DecimalQuantitySamplesRange item : samples.getSamples()) {
                target.add(item.start);
                target.add(item.end);
            }
        }
    }

    private String formatCurrency(String value, String unitType, boolean isPattern, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count, DecimalQuantity example) {
        String unitPattern;
        String unitName;
        if (isPattern) {
            unitName = this.getUnitName(unitType, isCurrency, count);
            unitPattern = this.typeIsEnglish ? this.getUnitPattern(unitType, isCurrency, count) : value;
        } else {
            unitPattern = this.getUnitPattern(unitType, isCurrency, count);
            unitName = this.typeIsEnglish ? this.getUnitName(unitType, isCurrency, count) : value;
        }
        unitPattern = isPattern ? this.setBackground(unitPattern) : this.setBackgroundExceptMatch(unitPattern, PARAMETER_SKIP0);
        MessageFormat unitPatternFormat = new MessageFormat(unitPattern);
        DecimalFormat unitDecimalFormat = this.icuServiceBuilder.getNumberFormat(1);
        unitDecimalFormat.setMaximumFractionDigits((int)example.getPluralOperand(PluralRules.Operand.v));
        unitDecimalFormat.setMinimumFractionDigits((int)example.getPluralOperand(PluralRules.Operand.v));
        String formattedNumber = unitDecimalFormat.format(example.toDouble());
        unitPatternFormat.setFormatByArgumentIndex(0, unitDecimalFormat);
        String resultItem = unitPattern.replace("{0}", formattedNumber).replace("{1}", unitName);
        if (isPattern) {
            resultItem = this.invertBackground(resultItem);
        }
        return resultItem;
    }

    private String addExampleResult(String resultItem, String resultToAddTo) {
        return this.addExampleResult(resultItem, resultToAddTo, false);
    }

    private String addExampleResult(String resultItem, String resultToAddTo, boolean showContexts) {
        if (!showContexts) {
            if (((String)resultToAddTo).length() != 0) {
                resultToAddTo = (String)resultToAddTo + exampleSeparatorSymbol;
            }
            resultToAddTo = (String)resultToAddTo + resultItem;
        } else {
            resultToAddTo = (String)resultToAddTo + exampleStartAutoSymbol + resultItem + exampleEndSymbol;
            resultToAddTo = (String)resultToAddTo + exampleStartRTLSymbol + resultItem + exampleEndSymbol;
        }
        return resultToAddTo;
    }

    private String getUnitPattern(String unitType, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count) {
        return this.cldrFile.getStringValue(isCurrency ? "//ldml/numbers/currencyFormats/unitPattern" + this.countAttribute(count) : "//ldml/units/unit[@type=\"" + unitType + "\"]/unitPattern" + this.countAttribute(count));
    }

    private String getUnitName(String unitType, boolean isCurrency, SupplementalDataInfo.PluralInfo.Count count) {
        return this.cldrFile.getStringValue(isCurrency ? "//ldml/numbers/currencies/currency[@type=\"" + unitType + "\"]/displayName" + this.countAttribute(count) : "//ldml/units/unit[@type=\"" + unitType + "\"]/unitPattern" + this.countAttribute(count));
    }

    public String countAttribute(SupplementalDataInfo.PluralInfo.Count count) {
        return "[@count=\"" + count + "\"]";
    }

    private String handleNumberSymbol(XPathParts parts, String value) {
        String formattedValue;
        int index;
        String symbolType = parts.getElement(-1);
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        double numberSample = 123456.789;
        String originalValue = this.cldrFile.getWinningValue(parts.toString());
        boolean isSuperscripting = false;
        if (symbolType.equals("decimal") || symbolType.equals("group")) {
            index = 1;
        } else if (symbolType.equals("minusSign")) {
            index = 1;
            numberSample = -numberSample;
        } else if (symbolType.equals("percentSign")) {
            index = 2;
            numberSample = 0.23;
        } else if (symbolType.equals("perMille")) {
            index = 2;
            numberSample = 0.023;
            originalValue = this.cldrFile.getWinningValue(parts.addRelative("../percentSign").toString());
        } else if (symbolType.equals("approximatelySign")) {
            index = 1;
            numberSample = -numberSample;
            originalValue = this.cldrFile.getWinningValue(parts.addRelative("../minusSign").toString());
        } else if (symbolType.equals("exponential") || symbolType.equals("plusSign")) {
            index = 3;
        } else if (symbolType.equals("superscriptingExponent")) {
            index = 3;
            isSuperscripting = true;
        } else {
            return null;
        }
        DecimalFormat x = this.icuServiceBuilder.getNumberFormat(index, numberSystem);
        if (isSuperscripting) {
            DecimalFormatSymbols symbols = x.getDecimalFormatSymbols();
            char[] digits = symbols.getDigits();
            x.setDecimalFormatSymbols(symbols);
            x.setNegativeSuffix(endSupSymbol + x.getNegativeSuffix());
            x.setPositiveSuffix(endSupSymbol + x.getPositiveSuffix());
            x.setExponentSignAlwaysShown(false);
            originalValue = symbols.getExponentSeparator();
            formattedValue = backgroundEndSymbol + value + digits[1] + digits[0] + "\ue234\ue23a";
        } else {
            x.setExponentSignAlwaysShown(true);
            formattedValue = backgroundEndSymbol + value + backgroundStartSymbol;
        }
        String example = x.format(numberSample);
        example = example.replace(originalValue, formattedValue);
        return backgroundStartSymbol + example + backgroundEndSymbol;
    }

    private String handleNumberingSystem(String value) {
        NumberFormat x = this.icuServiceBuilder.getGenericNumberFormat(value);
        x.setGroupingUsed(false);
        return x.format(2345.0);
    }

    private String handleTimeZoneName(XPathParts parts, String value) {
        Object result = null;
        if (parts.contains("exemplarCity")) {
            String timezone = parts.getAttributeValue(3, "type");
            String countryCode = supplementalDataInfo.getZone_territory(timezone);
            if (countryCode == null) {
                result = value == null ? timezone.substring(timezone.lastIndexOf(47) + 1).replace('_', ' ') : value;
                return result;
            }
            if (countryCode.equals("001")) {
                try {
                    String hourOffset = timezone.substring(timezone.contains("+") ? 8 : 7);
                    int hours = Integer.parseInt(hourOffset);
                    result = this.getGMTFormat(null, null, hours);
                }
                catch (RuntimeException e) {
                    return null;
                }
            } else {
                result = this.setBackground(this.cldrFile.getName(2, countryCode));
            }
        } else if (parts.contains("zone")) {
            result = value;
        } else if (parts.contains("regionFormat")) {
            result = ExampleGenerator.format(value, this.setBackground(this.cldrFile.getName(2, "JP")));
            result = this.addExampleResult(ExampleGenerator.format(value, this.setBackground(this.cldrFile.getWinningValue(EXEMPLAR_CITY_LOS_ANGELES))), (String)result);
        } else if (parts.contains("fallbackFormat")) {
            String central = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/metazone[@type=\"America_Central\"]/long/generic"));
            String cancun = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/zone[@type=\"America/Cancun\"]/exemplarCity"));
            result = ExampleGenerator.format(value, cancun, central);
        } else if (parts.contains("gmtFormat")) {
            result = this.getGMTFormat(null, value, -8);
        } else if (parts.contains("hourFormat")) {
            result = this.getGMTFormat(value, null, -8);
        } else if (parts.contains("metazone") && !parts.contains("commonlyUsed")) {
            if (value != null && value.length() > 0) {
                result = this.getMZTimeFormat() + " " + value;
            } else if (parts.contains("generic")) {
                String metazone_name = parts.getAttributeValue(3, "type");
                String timezone = supplementalDataInfo.getZoneForMetazoneByRegion(metazone_name, "001");
                String countryCode = supplementalDataInfo.getZone_territory(timezone);
                String regionFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/regionFormat");
                String countryName = this.cldrFile.getWinningValue("//ldml/localeDisplayNames/territories/territory[@type=\"" + countryCode + "\"]");
                result = this.setBackground(this.getMZTimeFormat() + " " + ExampleGenerator.format(regionFormat, countryName));
            } else {
                String gmtFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/gmtFormat");
                String hourFormat = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/hourFormat");
                String metazone_name = parts.getAttributeValue(3, "type");
                String tz_string = supplementalDataInfo.getZoneForMetazoneByRegion(metazone_name, "001");
                TimeZone currentZone = TimeZone.getTimeZone(tz_string);
                int tzOffset = currentZone.getRawOffset();
                if (parts.contains("daylight")) {
                    tzOffset += currentZone.getDSTSavings();
                }
                long tm_hrs = (long)tzOffset / 216000000L;
                long tm_mins = (long)tzOffset % 216000000L / 3600000L;
                result = this.setBackground(this.getMZTimeFormat() + " " + this.getGMTFormat(hourFormat, gmtFormat, (int)tm_hrs, (int)tm_mins));
            }
        }
        return result;
    }

    private String handleDateFormatItem(String xpath, String value, boolean showContexts) {
        String fullpath = this.cldrFile.getFullXPath(xpath);
        XPathParts parts = XPathParts.getFrozenInstance(fullpath);
        String calendar = parts.findAttributeValue("calendar", "type");
        if (parts.contains("dateTimeFormat")) {
            String formatType = parts.findAttributeValue("dateTimeFormat", "type");
            String dateFormatXPath = this.cldrFile.getWinningPath(xpath.replaceAll("dateTimeFormat", "dateFormat").replaceAll("atTime", "standard"));
            String dateFormatValue = this.cldrFile.getWinningValue(dateFormatXPath);
            parts = XPathParts.getFrozenInstance(this.cldrFile.getFullXPath(dateFormatXPath));
            String dateNumbersOverride = parts.findAttributeValue("pattern", "numbers");
            SimpleDateFormat df = this.icuServiceBuilder.getDateFormat(calendar, dateFormatValue, dateNumbersOverride);
            df.setTimeZone(ZONE_SAMPLE);
            String timeFormatXPathForPrefix = this.cldrFile.getWinningPath(xpath.replaceAll("dateTimeFormat", "timeFormat"));
            int tfLengthOffset = timeFormatXPathForPrefix.indexOf("timeFormatLength");
            if (tfLengthOffset < 0) {
                return "";
            }
            String timeFormatXPathPrefix = timeFormatXPathForPrefix.substring(0, tfLengthOffset);
            String timeFullFormatXPath = timeFormatXPathPrefix.concat("timeFormatLength[@type=\"full\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
            String timeShortFormatXPath = timeFormatXPathPrefix.concat("timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
            String timeFormatValue = this.cldrFile.getWinningValue(timeFullFormatXPath);
            parts = XPathParts.getFrozenInstance(this.cldrFile.getFullXPath(timeFullFormatXPath));
            String timeNumbersOverride = parts.findAttributeValue("pattern", "numbers");
            SimpleDateFormat tff = this.icuServiceBuilder.getDateFormat(calendar, timeFormatValue, timeNumbersOverride);
            tff.setTimeZone(ZONE_SAMPLE);
            timeFormatValue = this.cldrFile.getWinningValue(timeShortFormatXPath);
            parts = XPathParts.getFrozenInstance(this.cldrFile.getFullXPath(timeShortFormatXPath));
            timeNumbersOverride = parts.findAttributeValue("pattern", "numbers");
            SimpleDateFormat tsf = this.icuServiceBuilder.getDateFormat(calendar, timeFormatValue, timeNumbersOverride);
            tsf.setTimeZone(ZONE_SAMPLE);
            String relativeDayXPath = this.cldrFile.getWinningPath("//ldml/dates/fields/field[@type=\"day\"]/relative[@type=\"0\"]");
            String relativeDayValue = this.cldrFile.getWinningValue(relativeDayXPath);
            ArrayList<String> examples = new ArrayList<String>();
            String dfResult = df.format(DATE_SAMPLE);
            String tffResult = tff.format(DATE_SAMPLE);
            String tsfResult = tsf.format(DATE_SAMPLE);
            SimpleDateFormat dtf = this.icuServiceBuilder.getDateFormat(calendar, MessageFormat.format(value, this.setBackground("'" + tffResult + "'"), this.setBackground("'" + dfResult + "'")));
            examples.add(dtf.format(DATE_SAMPLE));
            dtf = this.icuServiceBuilder.getDateFormat(calendar, MessageFormat.format(value, this.setBackground("'" + tsfResult + "'"), this.setBackground("'" + dfResult + "'")));
            examples.add(dtf.format(DATE_SAMPLE));
            if (!formatType.contentEquals("atTime")) {
                int dtfLengthOffset = xpath.indexOf("dateTimeFormatLength");
                if (dtfLengthOffset > 0) {
                    String intervalFormatFallbackXPath = xpath.substring(0, dtfLengthOffset).concat("intervalFormats/intervalFormatFallback");
                    String intervalFormatFallbackValue = this.cldrFile.getWinningValue(intervalFormatFallbackXPath);
                    String tsfAMResult = tsf.format(DATE_SAMPLE3);
                    String timeRange = ExampleGenerator.format(intervalFormatFallbackValue, tsfAMResult, tsfResult);
                    dtf = this.icuServiceBuilder.getDateFormat(calendar, MessageFormat.format(value, this.setBackground("'" + timeRange + "'"), this.setBackground("'" + dfResult + "'")));
                    examples.add(dtf.format(DATE_SAMPLE));
                    dtf = this.icuServiceBuilder.getDateFormat(calendar, MessageFormat.format(value, this.setBackground("'" + timeRange + "'"), this.setBackground("'" + relativeDayValue + "'")));
                    examples.add(dtf.format(DATE_SAMPLE));
                }
            } else {
                dtf = this.icuServiceBuilder.getDateFormat(calendar, MessageFormat.format(value, this.setBackground("'" + tsfResult + "'"), this.setBackground("'" + relativeDayValue + "'")));
                examples.add(dtf.format(DATE_SAMPLE));
            }
            return this.formatExampleList(examples.toArray(new String[0]));
        }
        String id = parts.findAttributeValue("dateFormatItem", "id");
        if ("NEW".equals(id) || value == null) {
            return "\ue238n/a\ue239";
        }
        String numbersOverride = parts.findAttributeValue("pattern", "numbers");
        SimpleDateFormat sdf = this.icuServiceBuilder.getDateFormat(calendar, value, numbersOverride);
        sdf.setTimeZone(ZONE_SAMPLE);
        String defaultNumberingSystem = this.cldrFile.getWinningValue("//ldml/numbers/defaultNumberingSystem");
        String timeSeparator = this.cldrFile.getWinningValue("//ldml/numbers/symbols[@numberSystem='" + defaultNumberingSystem + "']/timeSeparator");
        DateFormatSymbols dfs = sdf.getDateFormatSymbols();
        dfs.setTimeSeparatorString(timeSeparator);
        sdf.setDateFormatSymbols(dfs);
        if (id == null || id.indexOf(66) < 0) {
            if (value.contains("MMM") || value.contains("LLL")) {
                return sdf.format(DATE_SAMPLE);
            }
            String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
            example = this.addExampleResult(sdf.format(DATE_SAMPLE), example, showContexts);
            return example;
        }
        ArrayList<String> examples = new ArrayList<String>();
        examples.add(sdf.format(DATE_SAMPLE3));
        examples.add(sdf.format(DATE_SAMPLE));
        examples.add(sdf.format(DATE_SAMPLE4));
        return this.formatExampleList(examples.toArray(new String[0]));
    }

    private boolean symbolIsLetters(String currencySymbol, boolean onBothSides) {
        int len = currencySymbol.length();
        if (len == 0) {
            return false;
        }
        int limitChar = currencySymbol.codePointAt(0);
        if (UCharacter.isLetter(limitChar)) {
            if (!onBothSides) {
                return true;
            }
        } else if (onBothSides) {
            return false;
        }
        if (len > 1) {
            limitChar = currencySymbol.codePointAt(len - 1);
            return UCharacter.isLetter(limitChar);
        }
        return false;
    }

    private String handleCurrencyFormat(XPathParts parts, String value, boolean showContexts) {
        boolean altAlpha;
        String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
        String territory = this.getDefaultTerritory();
        String currency = supplementalDataInfo.getDefaultCurrency(territory);
        String checkPath = "//ldml/numbers/currencies/currency[@type=\"" + currency + "\"]/symbol";
        String currencySymbol = this.cldrFile.getWinningValue(checkPath);
        String altValue = parts.getAttributeValue(-1, "alt");
        boolean bl = altAlpha = altValue != null && altValue.equals("alphaNextToNumber");
        if (altAlpha && !this.symbolIsLetters(currencySymbol, true)) {
            currencySymbol = currency;
        }
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        DecimalFormat df = this.icuServiceBuilder.getCurrencyFormat(currency, currencySymbol, numberSystem);
        df.applyPattern(value);
        String countValue = parts.getAttributeValue(-1, "count");
        if (countValue != null) {
            return this.formatCountDecimal(df, countValue);
        }
        double sampleAmount = 1295.0;
        example = this.addExampleResult(this.formatNumber(df, sampleAmount), example, showContexts);
        example = this.addExampleResult(this.formatNumber(df, -sampleAmount), example, showContexts);
        if (showContexts && !altAlpha) {
            if (this.symbolIsLetters(currencySymbol, false)) {
                currency = "EUR";
                checkPath = "//ldml/numbers/currencies/currency[@type=\"" + currency + "\"]/symbol";
                currencySymbol = this.cldrFile.getWinningValue(checkPath);
            } else {
                currencySymbol = currency;
            }
            df = this.icuServiceBuilder.getCurrencyFormat(currency, currencySymbol, numberSystem);
            df.applyPattern(value);
            example = this.addExampleResult(this.formatNumber(df, sampleAmount), example, showContexts);
            example = this.addExampleResult(this.formatNumber(df, -sampleAmount), example, showContexts);
        }
        return example;
    }

    private String getDefaultTerritory() {
        String territory = "US";
        if (!this.typeIsEnglish) {
            CLDRLocale loc = CLDRLocale.getInstance(this.cldrFile.getLocaleID());
            territory = loc.getCountry();
            if ((territory == null || territory.length() == 0) && (loc = supplementalDataInfo.getDefaultContentFromBase(loc)) != null && (territory = loc.getCountry()).equals("001") && loc.getLanguage().equals("ar")) {
                territory = "EG";
            }
            if (territory == null || territory.length() == 0) {
                territory = "US";
            }
        }
        return territory;
    }

    private String handleDecimalFormat(XPathParts parts, String value, boolean showContexts) {
        String example = showContexts ? "\ue240Key: \ue23cneutral\ue23d, RTL\ue241" : "";
        String numberSystem = parts.getAttributeValue(2, "numberSystem");
        DecimalFormat numberFormat = this.icuServiceBuilder.getNumberFormat(value, numberSystem);
        String countValue = parts.getAttributeValue(-1, "count");
        if (countValue != null) {
            return this.formatCountDecimal(numberFormat, countValue);
        }
        double sampleNum1 = 5.43;
        double sampleNum2 = 123456.789;
        if (parts.getElement(4).equals("percentFormat")) {
            sampleNum1 = 0.0543;
        }
        example = this.addExampleResult(this.formatNumber(numberFormat, sampleNum1), example, showContexts);
        example = this.addExampleResult(this.formatNumber(numberFormat, sampleNum2), example, showContexts);
        example = this.addExampleResult(this.formatNumber(numberFormat, -sampleNum2), example, showContexts);
        return example;
    }

    private String formatCountDecimal(DecimalFormat numberFormat, String countValue) {
        String temp;
        int fractionLength;
        SupplementalDataInfo.PluralInfo.Count count;
        try {
            count = SupplementalDataInfo.PluralInfo.Count.valueOf(countValue);
        }
        catch (Exception e) {
            String locale = this.getCldrFile().getLocaleID();
            SupplementalDataInfo.PluralInfo pluralInfo = supplementalDataInfo.getPlurals(locale);
            count = pluralInfo.getCount(DecimalQuantity_DualStorageBCD.fromExponentString(countValue));
        }
        Double numberSample = this.getExampleForPattern(numberFormat, count);
        if (numberSample == null) {
            int digits = numberFormat.getMinimumIntegerDigits();
            numberSample = Math.round(1.2345678901234 * Math.pow(10.0, digits - 1));
        }
        int n = fractionLength = (temp = String.valueOf(numberSample)).endsWith(".0") ? 0 : temp.length() - temp.indexOf(46) - 1;
        if (fractionLength != numberFormat.getMaximumFractionDigits()) {
            numberFormat = (DecimalFormat)numberFormat.clone();
            numberFormat.setMinimumFractionDigits(fractionLength);
            numberFormat.setMaximumFractionDigits(fractionLength);
        }
        return this.formatNumber(numberFormat, numberSample);
    }

    private String formatNumber(DecimalFormat format, double value) {
        String example = format.format(value);
        return this.setBackgroundOnMatch(example, ALL_DIGITS);
    }

    private Double getExampleForPattern(DecimalFormat format, SupplementalDataInfo.PluralInfo.Count count) {
        int numDigits;
        Map<SupplementalDataInfo.PluralInfo.Count, Double> samples;
        if (this.patternExamples == null) {
            this.patternExamples = PluralSamples.getInstance(this.cldrFile.getLocaleID());
        }
        if ((samples = this.patternExamples.getSamples(numDigits = format.getMinimumIntegerDigits())) == null) {
            return null;
        }
        return samples.get((Object)count);
    }

    private String handleCurrency(String xpath, XPathParts parts, String value) {
        String currency = parts.getAttributeValue(-2, "type");
        String fullPath = this.cldrFile.getFullXPath(xpath, false);
        if (parts.contains("symbol")) {
            if (fullPath != null && fullPath.contains("[@choice=\"true\"]")) {
                ChoiceFormat cf = new ChoiceFormat(value);
                value = cf.format(123456.789);
            }
            if (value == null) {
                throw new NullPointerException(this.cldrFile.getSourceLocation(fullPath) + ": " + this.cldrFile.getLocaleID() + ": : Error: no currency symbol for " + currency);
            }
            DecimalFormat x = this.icuServiceBuilder.getCurrencyFormat(currency, value);
            String result = x.format(123456.789);
            result = this.setBackground(result).replace(value, backgroundEndSymbol + value + backgroundStartSymbol);
            return result;
        }
        if (parts.contains("displayName")) {
            return this.formatCountValue(xpath, parts, value);
        }
        return null;
    }

    private String handleDateRangePattern(String value) {
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", 2, 0);
        String result = ExampleGenerator.format(value, this.setBackground(dateFormat.format(DATE_SAMPLE)), this.setBackground(dateFormat.format(DATE_SAMPLE2)));
        return result;
    }

    private String getLocaleDisplayPattern(String elementToOverride, String element, String value) {
        String localeDisplayPatternPath = "//ldml/localeDisplayNames/localeDisplayPattern/";
        if (elementToOverride.equals(element)) {
            return value;
        }
        return this.cldrFile.getWinningValue("//ldml/localeDisplayNames/localeDisplayPattern/" + elementToOverride);
    }

    private String handleDisplayNames(String xpath, XPathParts parts, String value) {
        String result;
        block23: {
            ArrayList<String> examples;
            block27: {
                String nameType;
                block26: {
                    String type;
                    block25: {
                        block24: {
                            block22: {
                                result = null;
                                if (!parts.contains("codePatterns")) break block22;
                                String type2 = parts.getAttributeValue(-1, "type");
                                result = ExampleGenerator.format(value, this.setBackground(type2.equals("language") ? "ace" : (type2.equals("script") ? "Avst" : (type2.equals("territory") ? "057" : "CODE"))));
                                break block23;
                            }
                            if (!parts.contains("localeDisplayPattern")) break block24;
                            String element = parts.getElement(-1);
                            value = this.setBackground(value);
                            String localeKeyTypePattern = this.getLocaleDisplayPattern("localeKeyTypePattern", element, value);
                            String localePattern = this.getLocaleDisplayPattern("localePattern", element, value);
                            String localeSeparator = this.getLocaleDisplayPattern("localeSeparator", element, value);
                            ArrayList<String> locales = new ArrayList<String>();
                            if (element.equals("localePattern")) {
                                locales.add("uz-AF");
                            }
                            locales.add(element.equals("localeKeyTypePattern") ? "uz-Arab-u-tz-etadd" : "uz-Arab-AF");
                            locales.add("uz-Arab-AF-u-tz-etadd-nu-arab");
                            String[] examples2 = new String[locales.size()];
                            for (int i = 0; i < locales.size(); ++i) {
                                examples2[i] = this.invertBackground(this.cldrFile.getName((String)locales.get(i), false, localeKeyTypePattern, localePattern, localeSeparator));
                            }
                            result = this.formatExampleList(examples2);
                            break block23;
                        }
                        if (!parts.contains("languages") && !parts.contains("scripts") && !parts.contains("territories")) break block23;
                        type = parts.getAttributeValue(-1, "type");
                        if (!type.contains("_")) break block25;
                        result = value != null && !value.equals(type) ? value : this.cldrFile.getBaileyValue(xpath, null, null);
                        break block23;
                    }
                    value = this.setBackground(value);
                    examples = new ArrayList<String>();
                    nameType = parts.getElement(3);
                    Map<String, String> likely = supplementalDataInfo.getLikelySubtags();
                    String alt = parts.getAttributeValue(-1, "alt");
                    boolean isStandAloneValue = "stand-alone".equals(alt);
                    if (!isStandAloneValue) {
                        Object tag = "language".equals(nameType) ? type : "und_" + type;
                        String max = LikelySubtags.maximize((String)tag, likely);
                        if (max == null) {
                            return null;
                        }
                        LanguageTagParser ltp = new LanguageTagParser().set(max);
                        String languageName = null;
                        String scriptName = null;
                        String territoryName = null;
                        if (nameType.equals("language")) {
                            languageName = value;
                        } else if (nameType.equals("script")) {
                            scriptName = value;
                        } else {
                            territoryName = value;
                        }
                        if (languageName == null) {
                            languageName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(0, ltp.getLanguage()));
                            if (languageName == null) {
                                languageName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(0, "en"));
                            }
                            if (languageName == null) {
                                languageName = ltp.getLanguage();
                            }
                        }
                        if (scriptName == null) {
                            scriptName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(1, ltp.getScript()));
                            if (scriptName == null) {
                                scriptName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(1, "Latn"));
                            }
                            if (scriptName == null) {
                                scriptName = ltp.getScript();
                            }
                        }
                        if (territoryName == null) {
                            territoryName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(2, ltp.getRegion()));
                            if (territoryName == null) {
                                territoryName = this.cldrFile.getStringValueWithBailey(CLDRFile.getKey(2, "US"));
                            }
                            if (territoryName == null) {
                                territoryName = ltp.getRegion();
                            }
                        }
                        languageName = languageName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        scriptName = scriptName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        territoryName = territoryName.replace('(', '[').replace(')', ']').replace('\uff08', '\uff3b').replace('\uff09', '\uff3d');
                        String localePattern = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localePattern");
                        String localeSeparator = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/localeDisplayPattern/localeSeparator");
                        String scriptTerritory = ExampleGenerator.format(localeSeparator, scriptName, territoryName);
                        if (!nameType.equals("script")) {
                            examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, territoryName)));
                        }
                        if (!nameType.equals("territory")) {
                            examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, scriptName)));
                        }
                        examples.add(this.invertBackground(ExampleGenerator.format(localePattern, languageName, scriptTerritory)));
                    }
                    if (isStandAloneValue) break block26;
                    Output<String> pathWhereFound = new Output<String>();
                    if (this.cldrFile.getStringValueWithBailey(xpath + ALT_STAND_ALONE, pathWhereFound, null) != null && ((String)pathWhereFound.value).contains(ALT_STAND_ALONE)) break block27;
                }
                String codePattern = this.cldrFile.getStringValueWithBailey("//ldml/localeDisplayNames/codePatterns/codePattern[@type=\"" + nameType + "\"]");
                examples.add(this.invertBackground(ExampleGenerator.format(codePattern, value)));
            }
            result = this.formatExampleList(examples.toArray(new String[0]));
        }
        return result;
    }

    private String formatExampleList(String[] examples) {
        String result = examples[0];
        int len = examples.length;
        for (int i = 1; i < len; ++i) {
            result = this.addExampleResult(examples[i], result);
        }
        return result;
    }

    private String formatExampleList(Collection<String> examples) {
        if (examples == null || examples.isEmpty()) {
            return null;
        }
        String result = "";
        boolean first = true;
        for (String example : examples) {
            if (first) {
                result = example;
                first = false;
                continue;
            }
            result = this.addExampleResult(example, result);
        }
        return result;
    }

    public static String format(String format, Object ... objects) {
        if (format == null) {
            return null;
        }
        return MessageFormat.format(format, objects);
    }

    public static String unchainException(Exception e) {
        Object stackStr = "[unknown stack]<br>";
        try {
            StringWriter asString = new StringWriter();
            e.printStackTrace(new PrintWriter(asString));
            stackStr = "<pre>" + asString + "</pre>";
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stackStr;
    }

    private String setBackground(String inputPattern) {
        if (inputPattern == null) {
            return "?";
        }
        Matcher m4 = PARAMETER.matcher(inputPattern);
        return backgroundStartSymbol + m4.replaceAll("\ue235$1\ue234") + backgroundEndSymbol;
    }

    private String setBackgroundExceptMatch(String input, Pattern patternToEmbed) {
        Matcher m4 = patternToEmbed.matcher(input);
        return backgroundStartSymbol + m4.replaceAll("\ue235$1\ue234") + backgroundEndSymbol;
    }

    private String setBackgroundOnMatch(String inputPattern, Pattern patternToEmbed) {
        Matcher m4 = patternToEmbed.matcher(inputPattern);
        return m4.replaceAll("\ue234$1\ue235");
    }

    private String finalizeBackground(String input) {
        if (input == null) {
            return null;
        }
        String coreString = TransliteratorUtilities.toHTML.transliterate(input).replace("\ue234\ue235", "").replace("\ue235\ue234", "").replace(backgroundStartSymbol, this.backgroundStart).replace(backgroundEndSymbol, this.backgroundEnd).replace(backgroundAutoStartSymbol, backgroundAutoStart).replace(backgroundAutoEndSymbol, backgroundAutoEnd).replace(exampleSeparatorSymbol, "</div><div class='cldr_example'>").replace(exampleStartAutoSymbol, exampleStartAuto).replace(exampleStartRTLSymbol, exampleStartRTL).replace(exampleStartHeaderSymbol, exampleStartHeader).replace(exampleEndSymbol, exampleEnd).replace(startItalicSymbol, startItalic).replace(endItalicSymbol, endItalic).replace(startSupSymbol, startSup).replace(endSupSymbol, endSup);
        return input.contains(exampleStartAutoSymbol) ? coreString : exampleStart + coreString + exampleEnd;
    }

    private String invertBackground(String input) {
        return input == null ? null : backgroundStartSymbol + input.replace(backgroundStartSymbol, backgroundTempSymbol).replace(backgroundEndSymbol, backgroundStartSymbol).replace(backgroundTempSymbol, backgroundEndSymbol) + backgroundEndSymbol;
    }

    private String removeEmptyRuns(String input) {
        return input.replace("\ue234\ue235", "").replace("\ue235\ue234", "");
    }

    private String getGMTFormat(String gmtHourString, String gmtFormat, int hours) {
        return this.getGMTFormat(gmtHourString, gmtFormat, hours, 0);
    }

    private String getGMTFormat(String gmtHourString, String gmtFormat, int hours, int minutes) {
        boolean hoursBackground = false;
        if (gmtHourString == null) {
            hoursBackground = true;
            gmtHourString = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/hourFormat");
        }
        if (gmtFormat == null) {
            hoursBackground = false;
            gmtFormat = this.setBackground(this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/gmtFormat"));
        }
        String[] plusMinus = gmtHourString.split(";");
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", plusMinus[hours >= 0 ? 0 : 1]);
        dateFormat.setTimeZone(ZONE_SAMPLE);
        this.calendar.set(1999, 9, 27, Math.abs(hours), minutes, 0);
        Date sample = this.calendar.getTime();
        String hourString = dateFormat.format(sample);
        if (hoursBackground) {
            hourString = this.setBackground(hourString);
        }
        String result = ExampleGenerator.format(gmtFormat, hourString);
        return result;
    }

    private String getMZTimeFormat() {
        String timeFormat = this.cldrFile.getWinningValue("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
        if (timeFormat == null) {
            timeFormat = "HH:mm";
        }
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", timeFormat);
        dateFormat.setTimeZone(ZONE_SAMPLE);
        this.calendar.set(1999, 9, 13, 13, 25, 59);
        Date sample = this.calendar.getTime();
        String result = dateFormat.format(sample);
        return result;
    }

    public synchronized String getHelpHtml(String xpath, String value) {
        if (this.pathDescription == null) {
            HashMap<String, List<Set<String>>> starredPaths = new HashMap<String, List<Set<String>>>();
            HashMap<String, String> extras = new HashMap<String, String>();
            this.pathDescription = new PathDescription(supplementalDataInfo, this.englishFile, extras, starredPaths, PathDescription.ErrorHandling.CONTINUE);
            if (this.helpMessages == null) {
                this.helpMessages = new HelpMessages("test_help_messages.html");
            }
        }
        Level level = CONFIG.getCoverageInfo().getCoverageLevel(xpath, this.cldrFile.getLocaleID());
        String description = this.pathDescription.getDescription(xpath, value, null);
        if (description == null || description.equals("SKIP")) {
            return null;
        }
        int start = 0;
        StringBuilder buffer = new StringBuilder();
        Matcher URLMatcher = URL_PATTERN.matcher("");
        while (URLMatcher.reset(description).find(start)) {
            String url = URLMatcher.group();
            buffer.append(TransliteratorUtilities.toHTML.transliterate(description.substring(start, URLMatcher.start()))).append("<a target='CLDR-ST-DOCS' href='").append(url).append("'>").append(url).append("</a>");
            start = URLMatcher.end();
        }
        buffer.append(TransliteratorUtilities.toHTML.transliterate(description.substring(start)));
        if (AnnotationUtil.pathIsAnnotation(xpath)) {
            XPathParts emoji = XPathParts.getFrozenInstance(xpath);
            String cp = emoji.getAttributeValue(-1, "cp");
            String minimal = Utility.hex(cp).replace(',', '_').toLowerCase(Locale.ROOT);
            buffer.append("<br><img height='64px' width='auto' src='images/emoji/emoji_" + minimal + ".png'>");
        }
        return buffer.toString();
    }

    public static String simplify(String exampleHtml) {
        return ExampleGenerator.simplify(exampleHtml, false);
    }

    public static String simplify(String exampleHtml, boolean internal) {
        int endIndex;
        if (exampleHtml == null) {
            return null;
        }
        if (internal) {
            return "\u3016" + ((String)exampleHtml).replace(backgroundStartSymbol, "\u276c").replace(backgroundEndSymbol, "\u276d") + "\u3017";
        }
        int startIndex = ((String)exampleHtml).indexOf(exampleStartHeader);
        if (startIndex >= 0 && (endIndex = ((String)exampleHtml).indexOf(exampleEnd, startIndex)) > startIndex) {
            String head = ((String)exampleHtml).substring(0, startIndex);
            String tail = ((String)exampleHtml).substring(endIndex += exampleEnd.length());
            exampleHtml = head + tail;
        }
        return ((String)exampleHtml).replace(exampleStart, "\u3016").replace(exampleStartAuto, "\u3010").replace(exampleStartRTL, "\u3010\u20ea").replace(exampleEnd, "\u3017").replace("<span class='cldr_substituted'>", "\u276c").replace(backgroundAutoEnd, "\u276d");
    }

    static {
        Calendar calendar = Calendar.getInstance(ZONE_SAMPLE, ULocale.ENGLISH);
        calendar.set(1999, 8, 5, 13, 25, 59);
        DATE_SAMPLE = calendar.getTime();
        calendar.set(1999, 9, 27, 13, 25, 59);
        DATE_SAMPLE2 = calendar.getTime();
        calendar.set(1999, 8, 5, 7, 0, 0);
        DATE_SAMPLE3 = calendar.getTime();
        calendar.set(1999, 8, 5, 23, 0, 0);
        DATE_SAMPLE4 = calendar.getTime();
        CURRENCY_SAMPLES = ImmutableList.of(DecimalQuantity_DualStorageBCD.fromExponentString("1.23"), DecimalQuantity_DualStorageBCD.fromExponentString("0"), DecimalQuantity_DualStorageBCD.fromExponentString("2.34"), DecimalQuantity_DualStorageBCD.fromExponentString("3.45"), DecimalQuantity_DualStorageBCD.fromExponentString("5.67"), DecimalQuantity_DualStorageBCD.fromExponentString("1"));
        PARAMETER = PatternCache.get("(\\{(?:0|[1-9][0-9]*)\\})");
        PARAMETER_SKIP0 = PatternCache.get("(\\{[1-9][0-9]*\\})");
        ALL_DIGITS = PatternCache.get("(\\p{Nd}+(.\\p{Nd}+)?)");
        generatingCalendar = Calendar.getInstance(ULocale.US);
        FIRST_INTERVAL = ExampleGenerator.getDate(2008, 1, 13, 5, 7, 9);
        SECOND_INTERVAL = CldrUtility.asMap(new Object[][]{{"G", ExampleGenerator.getDate(1009, 2, 14, 17, 8, 10)}, {"y", ExampleGenerator.getDate(2009, 2, 14, 17, 8, 10)}, {"M", ExampleGenerator.getDate(2008, 2, 14, 17, 8, 10)}, {"d", ExampleGenerator.getDate(2008, 1, 14, 17, 8, 10)}, {"a", ExampleGenerator.getDate(2008, 1, 13, 17, 8, 10)}, {"h", ExampleGenerator.getDate(2008, 1, 13, 6, 8, 10)}, {"m", ExampleGenerator.getDate(2008, 1, 13, 5, 8, 10)}});
        SUSF = new SimpleUnicodeSetFormatter(SimpleUnicodeSetFormatter.BASIC_COLLATOR);
        SUSFNS = new SimpleUnicodeSetFormatter(SimpleUnicodeSetFormatter.BASIC_COLLATOR, CodePointEscaper.FORCE_ESCAPE_WITH_NONSPACING);
        NEEDS_LRM = new UnicodeSet("[:BidiClass=R:]").freeze();
        BACKGROUND_TRANSFORM = x -> backgroundStartSymbol + x + backgroundEndSymbol;
    }

    private class IntervalFormat {
        DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
        SimpleDateFormat firstFormat = new SimpleDateFormat();
        SimpleDateFormat secondFormat = new SimpleDateFormat();
        StringBuilder first = new StringBuilder();
        StringBuilder second = new StringBuilder();
        BitSet letters = new BitSet();

        private IntervalFormat() {
        }

        public String format(Date earlier, Date later) {
            if (earlier == null || later == null) {
                return null;
            }
            if (later.compareTo(earlier) < 0) {
                Date tmp = earlier;
                earlier = later;
                later = tmp;
            }
            return this.firstFormat.format(earlier) + this.secondFormat.format(later);
        }

        public IntervalFormat setPattern(XPathParts parts, String pattern) {
            if (this.formatParser == null || pattern == null) {
                return this;
            }
            try {
                this.formatParser.set(pattern);
            }
            catch (NullPointerException e) {
                System.err.println("Caught NullPointerException in IntervalFormat.setPattern, pattern = " + pattern);
                e.printStackTrace();
                return null;
            }
            this.first.setLength(0);
            this.second.setLength(0);
            boolean doFirst = true;
            this.letters.clear();
            for (Object item : this.formatParser.getItems()) {
                if (item instanceof DateTimePatternGenerator.VariableField) {
                    char c = item.toString().charAt(0);
                    if (this.letters.get(c)) {
                        doFirst = false;
                    } else {
                        this.letters.set(c);
                    }
                    if (doFirst) {
                        this.first.append(item);
                        continue;
                    }
                    this.second.append(item);
                    continue;
                }
                if (doFirst) {
                    this.first.append(this.formatParser.quoteLiteral((String)item));
                    continue;
                }
                this.second.append(this.formatParser.quoteLiteral((String)item));
            }
            String calendar = parts.findAttributeValue("calendar", "type");
            this.firstFormat = ExampleGenerator.this.icuServiceBuilder.getDateFormat(calendar, this.first.toString());
            this.firstFormat.setTimeZone(GMT_ZONE_SAMPLE);
            this.secondFormat = ExampleGenerator.this.icuServiceBuilder.getDateFormat(calendar, this.second.toString());
            this.secondFormat.setTimeZone(GMT_ZONE_SAMPLE);
            return this;
        }
    }

    public static enum UnitLength {
        LONG(XListFormatter.ListTypeLength.UNIT_WIDE),
        SHORT(XListFormatter.ListTypeLength.UNIT_SHORT),
        NARROW(XListFormatter.ListTypeLength.UNIT_NARROW);

        final String typeString = "[@type=\"" + this.name().toLowerCase(Locale.ENGLISH) + "\"]";
        final XListFormatter.ListTypeLength listTypeLength;

        private UnitLength(XListFormatter.ListTypeLength listTypeLength) {
            this.listTypeLength = listTypeLength;
        }

        public static UnitLength from(String listPatternType) {
            switch (listPatternType) {
                case "unit": {
                    return LONG;
                }
                case "unit-narrow": {
                    return NARROW;
                }
                case "unit-short": {
                    return SHORT;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static enum PersonNameScripts {
        Latn,
        Cyrl,
        Jpan;

    }

    private static class PersonNamesCache
    implements ExampleCache.ClearableCache {
        Map<PersonNameFormatter.SampleType, SimpleNameObject> sampleNames = null;
        PersonNameFormatter personNameFormatter = null;

        private PersonNamesCache() {
        }

        @Override
        public void clear() {
            this.sampleNames = null;
            this.personNameFormatter = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<PersonNameFormatter.SampleType, SimpleNameObject> getSampleNames(CLDRFile cldrFile) {
            PersonNamesCache personNamesCache = this;
            synchronized (personNamesCache) {
                if (this.sampleNames == null) {
                    this.sampleNames = PersonNameFormatter.loadSampleNames(cldrFile);
                }
                return this.sampleNames;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PersonNameFormatter getPersonNameFormatter(CLDRFile cldrFile) {
            PersonNamesCache personNamesCache = this;
            synchronized (personNamesCache) {
                if (this.personNameFormatter == null) {
                    this.personNameFormatter = new PersonNameFormatter(cldrFile);
                }
                return this.personNameFormatter;
            }
        }

        public String toString() {
            return "[" + (this.sampleNames == null ? "" : Joiner.on('\n').join(this.sampleNames.entrySet())) + ", " + (this.personNameFormatter == null ? "" : this.personNameFormatter.toString()) + "]";
        }
    }
}

