/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.impl.Relation;
import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.util.Pair;

public class MakeTransliterator {
    static int forceSeparateIfShorter = 4;
    private static final String CHECK_BASE = null;
    private static final String CHECK_BUILT = null;
    private static final String TEST_STRING = "territories";
    private static final boolean SHOW_OVERRIDES = true;
    private static final int MINIMUM_FREQUENCY = 9999;
    static boolean isIPA = true;
    static boolean onlyToTarget = true;
    static NumberFormat nf = NumberFormat.getInstance(ULocale.ENGLISH);
    static Collator col = Collator.getInstance(ULocale.ROOT);
    static String cldrDataDir = "C:\\cvsdata\\unicode\\cldr\\tools\\java\\org\\unicode\\cldr\\util\\data\\transforms\\";
    public static UnicodeSet vowels = new UnicodeSet("[aeiou \u00e6 \u0251 \u0259 \u025b \u026a \u028a \u00e2 \u00ee \u00f4]").freeze();
    public static UnicodeSet short_vowels = new UnicodeSet("[\u0251 \u00e6 \u0259 \u025b \u026a \u028a]").freeze();
    static UnicodeSet targetChars = new UnicodeSet();
    static UnicodeSet targetCoreChars = new UnicodeSet();
    static UnicodeSet tempDiff = new UnicodeSet();
    static Transliterator distinguishLongVowels = Transliterator.createFromRules("faa", "\u0251\u028a > \u00e2 ;\u0251\u026a > \u00ee ;o\u026a > \u00f4 ;", 0);
    static final Transliterator skeletonize = Transliterator.createFromRules("faa", "\u0251\u028a > \u00e2\u028a ;\u0251\u026a > \u00e2i ;o\u026a > oi ;\u0251r > \u00e2r ;\u00e6r > er ;\u025br > er ;\u026ar > ir ;\u028ar > ur ;", 0);
    static Transliterator spellout = Transliterator.createFromRules("foo", "a > e ;b > bi ;c > si ;d > di ;e > i ;f > \u025bf ;g > d\u0292i ;h > et\u0283 ;i > \u0251\u026a ;j > d\u0292e ;k > ke ;l > \u025bl ;m > \u025bm ;n > \u025bn ;o > o ;p > pi ;q > kwu ;r > \u0251r ;s > \u025bs ;t > ti ;u > ju ;v > vi ;w > d\u0259bj\u0259 ;x > \u025bks ;y > w\u0251\u026a ;z > zi ;", 0);
    static Comparator MyComparator = new Comparator(){

        public int compare(Object a, Object b) {
            String as = (String)a;
            String bs = (String)b;
            if (as.length() < bs.length()) {
                return -1;
            }
            if (as.length() > bs.length()) {
                return 1;
            }
            int result = col.compare(as, bs);
            if (result != 0) {
                return result;
            }
            return as.compareTo(bs);
        }
    };
    static int LIMIT = Integer.MAX_VALUE;
    private static Transliterator fixBadIpa;
    private static UnicodeSet targetCharacters;
    private static UnicodeSet sourceCharacters;
    private static UnicodeSet allowedSourceCharacters;
    private static UnicodeSet allowedTargetCharacters;
    private static int countSkipped;
    private static long skippedFrequency;
    private static long frequency;
    private static long totalFrequency;
    private static Transliterator coreBase;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        Object line;
        MakeTransliterator.setTranslitDebug(true);
        Locale fil = new Locale("fil");
        System.out.println(fil);
        fil = new Locale("fil", "US");
        System.out.println(fil);
        String sourceFile = cldrDataDir + "internal_raw_IPA.txt";
        String targetFile = cldrDataDir + "en-IPA.txt";
        String targetCountFile = cldrDataDir + "en-IPA_count.txt";
        String skippedLinesFile = "C:\\DATA\\GEN\\SkippedIPA.txt";
        PrintWriter skippedOut = FileUtilities.openUTF8Writer("", skippedLinesFile);
        String fixBadIpaRules = MakeTransliterator.createFromFile(cldrDataDir + "internal_fixBadIpa.txt", null, null);
        fixBadIpa = Transliterator.createFromRules("foo", fixBadIpaRules, 0);
        Map<String, String> overrides = MakeTransliterator.getOverrides();
        String coreForeRules = MakeTransliterator.createFromFile(cldrDataDir + "internal_baseEnglishToIpa.txt", null, null);
        coreBase = Transliterator.createFromRules("foo", coreForeRules, 0);
        if (CHECK_BASE != null) {
            MakeTransliterator.setTranslitDebug(true);
            System.out.println(coreBase.transliterate(CHECK_BASE));
            return;
        }
        if (CHECK_BUILT != null) {
            String foo = MakeTransliterator.createFromFile(cldrDataDir + "en-IPA.txt", null, null);
            Transliterator fooTrans = Transliterator.createFromRules("foo", foo, 0);
            MakeTransliterator.setTranslitDebug(true);
            System.out.println(fooTrans.transliterate(CHECK_BUILT));
            return;
        }
        String coreBackRules = MakeTransliterator.createFromFile(cldrDataDir + "internal_English-IPA-backwards.txt", null, null);
        MakeTransliterator.checkCoreReversibility(skippedOut, coreForeRules, coreBackRules);
        String coreRules = coreForeRules + coreBackRules;
        System.out.println(coreRules);
        Relation<String, Pair<String, Long>> store = Relation.of(new TreeMap(MyComparator), TreeSet.class);
        targetCharacters = new UnicodeSet();
        sourceCharacters = new UnicodeSet();
        allowedSourceCharacters = new UnicodeSet("[[:Letter:]\u2019]").freeze();
        allowedTargetCharacters = new UnicodeSet("[\u00e6 \u0251 b d\u00f0 e \u0259 \u025b f-i \u026a j-n \u014b o p r s \u0283 t u \u028a v w z \u0292 \u03b8]").freeze();
        countSkipped = 0;
        totalFrequency = 0L;
        skippedFrequency = 0L;
        int targetField = isIPA ? 2 : 1;
        BufferedReader in = FileUtilities.openUTF8Reader("", sourceFile);
        block0: while ((line = in.readLine()) != null) {
            if (((String)line).startsWith("\ufeff")) {
                line = ((String)line).substring(1);
            }
            Object originalLine = line;
            int commentCharPosition = ((String)line).indexOf(35);
            if (commentCharPosition >= 0) {
                line = ((String)line).substring(0, commentCharPosition);
            }
            line = ((String)line).trim();
            frequency = -1L;
            String[] pieces = ((String)line).split(" *[\\t,] *");
            if (pieces.length <= targetField) continue;
            String source = pieces[0];
            if (TEST_STRING != null && source.equals(TEST_STRING)) {
                System.out.println((String)line);
            }
            source = source.replace("'", "\u2019");
            if ((source = UCharacter.toLowerCase(ULocale.ENGLISH, source)).endsWith(".")) {
                source = source.substring(0, source.length() - 1);
            }
            if (source.contains(" ") || source.contains("-")) {
                skippedOut.println((String)originalLine + "\tspace or hyphen");
                ++countSkipped;
                skippedFrequency += frequency;
                continue;
            }
            String override = overrides.get(source);
            String spelling = spellout.transliterate(source);
            for (int i = 1; i < pieces.length; ++i) {
                String target = pieces[i];
                if (target.startsWith("%")) {
                    frequency = Long.parseLong(target.substring(1));
                    continue;
                }
                if (override != null) {
                    System.out.println("Overriding\t" + source + " \u2192 ! " + target + " \u2192 " + override);
                    if (override.length() == 0) continue block0;
                    if (TEST_STRING != null && source.equals(TEST_STRING)) {
                        MakeTransliterator.setTranslitDebug(true);
                    }
                    target = fixBadIpa.transliterate(override);
                    MakeTransliterator.setTranslitDebug(false);
                    MakeTransliterator.addSourceTarget(skippedOut, source, target, (String)originalLine, store);
                    continue block0;
                }
                if (frequency < 9999L) {
                    ++countSkipped;
                    continue;
                }
                target = UCharacter.toLowerCase(ULocale.ENGLISH, target);
                if ((target = target.replace(" ", "")).startsWith("-") || target.endsWith("-")) continue;
                String oldTarget = target;
                if ((target = fixBadIpa.transliterate(target)).equals(spelling)) {
                    skippedOut.println((String)originalLine + "\tspellout");
                    ++countSkipped;
                    continue;
                }
                if (!target.equals(oldTarget)) {
                    skippedOut.println("\t### fixed IPA:\t" + source + "\t" + target + "\twas: " + oldTarget);
                }
                MakeTransliterator.addSourceTarget(skippedOut, source, target, (String)originalLine, store);
            }
        }
        for (String word : overrides.keySet()) {
            String target;
            if (store.containsKey(word) || (target = overrides.get(word)).length() == 0) continue;
            System.out.println("New overrides:\t" + word + " \u2192 " + target);
            MakeTransliterator.addSourceTarget(skippedOut, word, target, "overrides", store);
        }
        in.close();
        System.out.println("total count: " + nf.format(store.size()));
        System.out.println("skipped count: " + nf.format(countSkipped));
        System.out.println("total frequency-weighted: " + nf.format(totalFrequency));
        System.out.println("skipped frequency-weighted: " + nf.format(skippedFrequency));
        int countAdded = 0;
        int countTotal = 0;
        long frequencyAdded = 0L;
        long frequencySkipped = 0L;
        Transliterator base = Transliterator.createFromRules("foo", coreRules, 0);
        ArrayList<String> newRules = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        int lastSourceLength = 1;
        Relation<Long, CallSite> count_failures = Relation.of(new TreeMap(), TreeSet.class);
        block3: for (String string : store.keySet()) {
            void var27_40;
            if (TEST_STRING != null && string.equals(TEST_STRING)) {
                System.out.println(string + "\t" + store.getAll(string));
            }
            ++countTotal;
            if (string.length() != lastSourceLength && string.length() >= forceSeparateIfShorter) {
                System.out.println("Building transliterator for length " + lastSourceLength + " : " + newRules.size());
                System.out.flush();
                skippedOut.flush();
                String rules = MakeTransliterator.buildRules(coreRules, newRules, buffer);
                base = Transliterator.createFromRules("foo", rules, 0);
                lastSourceLength = string.length();
            }
            Set<Pair<String, Long>> targetSet = store.getAll(string);
            String targetUsingCore = base.transliterate(string);
            String bestTarget = null;
            int bestDistance = 999;
            long frequency = 0L;
            for (Pair<String, Long> targetPair : targetSet) {
                String target = targetPair.getFirst();
                if (target.length() == 0) {
                    throw new IllegalArgumentException(string + " \u2192 " + target);
                }
                frequency = targetPair.getSecond();
                if (targetUsingCore.equals(target)) {
                    skippedOut.println("# skipping " + string + " \u2192 " + target + " ;");
                    frequencySkipped += frequency;
                    continue block3;
                }
                if (MakeTransliterator.mostlyEqual(string, target, targetUsingCore)) {
                    skippedOut.println("# skipping " + string + " \u2192 " + target + " ; # close enough to " + targetUsingCore);
                    frequencySkipped += frequency;
                    continue block3;
                }
                int distance = MakeTransliterator.distance(string, target, targetUsingCore);
                if (bestDistance <= distance) continue;
                bestTarget = target;
                bestDistance = distance;
            }
            if (bestTarget == null) continue;
            boolean forceSeparate = false;
            if (string.length() < forceSeparateIfShorter || bestTarget.length() * 2 > string.length() * 3) {
                forceSeparate = true;
            } else {
                String spelling = spellout.transliterate(string);
                if (bestTarget.equals(spelling)) {
                    forceSeparate = true;
                } else if (string.endsWith("e")) {
                    forceSeparate = true;
                }
            }
            String targetUsingBaseCore = coreBase.transliterate(string);
            if (forceSeparate) {
                String string2 = "$x{" + string + "}$x";
            } else {
                String string3 = "$x{" + string;
            }
            String hackSource = var27_40.startsWith("use") ? "'" + (String)var27_40 + "'" : var27_40;
            newRules.add(hackSource + " \u2192 " + bestTarget + " ; # " + targetUsingCore + (String)(targetUsingBaseCore.equals(targetUsingCore) ? "" : "\t\t" + targetUsingBaseCore) + "\n");
            skippedOut.println("# couldn't replace  " + (String)var27_40 + " \u2192 " + bestTarget + " ; # " + targetUsingCore);
            count_failures.put(-frequency, (CallSite)((Object)((String)var27_40 + " \u2192 " + bestTarget + " ; # " + targetUsingCore)));
            ++countAdded;
            frequencyAdded += frequency;
        }
        String rules = MakeTransliterator.buildRules(coreRules, newRules, buffer);
        base = Transliterator.createFromRules("foo", rules, 0);
        PrintWriter printWriter = FileUtilities.openUTF8Writer("", targetFile);
        printWriter.println(rules);
        printWriter.close();
        PrintWriter printWriter2 = FileUtilities.openUTF8Writer("", targetCountFile);
        Iterator iterator = count_failures.keySet().iterator();
        while (iterator.hasNext()) {
            long count = (Long)iterator.next();
            for (String line2 : count_failures.getAll(count)) {
                printWriter2.println(count + "\t" + line2);
            }
        }
        printWriter2.close();
        skippedOut.close();
        System.out.println("countTotal: " + nf.format(countTotal));
        System.out.println("countAdded: " + nf.format(countAdded));
        System.out.println("countSkipped: " + nf.format(countTotal - countAdded));
        System.out.println("frequencyTotal: " + nf.format(frequencyAdded + frequencySkipped));
        System.out.println("frequencyAdded: " + nf.format(frequencyAdded));
        System.out.println("frequencySkipped: " + nf.format(frequencySkipped));
    }

    private static void setTranslitDebug(boolean newSetting) {
        try {
            Field debug = Transliterator.class.getField("DEBUG");
            debug.setBoolean(Transliterator.class, newSetting);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addSourceTarget(PrintWriter skippedOut, String source, String target, String originalLine, Relation<String, Pair<String, Long>> store) {
        if (source.equals("teh")) {
            System.out.println("debug");
        }
        if (!allowedSourceCharacters.containsAll(source)) {
            skippedOut.println(originalLine + "\t# Strange source values:\t" + source + "\t" + new UnicodeSet().addAll(source).removeAll(allowedSourceCharacters).toPattern(false));
            ++countSkipped;
            skippedFrequency += frequency;
            return;
        }
        if (!allowedTargetCharacters.containsAll(target)) {
            System.out.println(originalLine + "\t# Strange target values:\t" + target + "\t" + new UnicodeSet().addAll(target).removeAll(allowedTargetCharacters).toPattern(false));
            ++countSkipped;
            skippedFrequency += frequency;
            return;
        }
        sourceCharacters.addAll(source);
        targetCharacters.addAll(target);
        store.put(source, new Pair<String, Long>(target, frequency));
        totalFrequency += frequency;
    }

    private static void checkCoreReversibility(PrintWriter skippedOut, String coreRules, String coreBackRules) {
        String[] tests;
        Transliterator base = Transliterator.createFromRules("foo", coreRules, 0);
        Transliterator back = Transliterator.createFromRules("foo2", coreBackRules, 1);
        for (String test : tests = "bat bait bet beet bit bite bot boat but bute bout boot book boy pat bat vat fat mat tat dat thew father nat sat zoo ash asia gate cat late rate hate yet rang chat jet".split("\\s")) {
            String test2 = base.transliterate(test);
            String test3 = back.transliterate(test2);
            skippedOut.println(test + "\t " + test2 + "\t " + test3);
        }
        skippedOut.flush();
    }

    private static String buildRules(String coreRules, List<String> newRules, StringBuilder buffer) {
        buffer.setLength(0);
        buffer.append("# Author: M Davis\n# Email: mark.davis@icu-project.org\n# Description: English to IPA\n:: lower(); \n$x = [:^letter:] ;\n");
        for (int i = newRules.size() - 1; i >= 0; --i) {
            buffer.append(newRules.get(i));
        }
        buffer.append(coreRules);
        String result = buffer.toString();
        return result;
    }

    private static void showSet(UnicodeSet sourceCharacters) {
        UnicodeSetIterator it = new UnicodeSetIterator(sourceCharacters);
        while (it.next()) {
            System.out.println(Utility.hex(it.codepoint) + "\t(" + UTF16.valueOf(it.codepoint) + ")\t" + UCharacter.getName(it.codepoint));
        }
    }

    private static int distance(String source, String target, String targetUsingCore) {
        if (target.equals(targetUsingCore)) {
            return 0;
        }
        if (MakeTransliterator.mostlyEqual(source, target, targetUsingCore)) {
            return 1;
        }
        String zappedTarget = distinguishLongVowels.transliterate(target);
        String zappedCoreTarget = distinguishLongVowels.transliterate(targetUsingCore);
        targetChars.clear().addAll(zappedTarget);
        targetCoreChars.clear().addAll(zappedCoreTarget);
        if (targetChars.equals(targetCoreChars)) {
            return 3;
        }
        targetChars.removeAll(short_vowels);
        targetCoreChars.removeAll(short_vowels);
        if (targetChars.equals(targetCoreChars)) {
            return 5;
        }
        targetChars.removeAll(vowels);
        targetCoreChars.removeAll(vowels);
        if (targetChars.equals(targetCoreChars)) {
            return 5;
        }
        tempDiff.clear().addAll(targetChars).removeAll(targetCoreChars);
        int result = 7 + tempDiff.size();
        tempDiff.clear().addAll(targetCoreChars).removeAll(targetChars);
        return result += tempDiff.size();
    }

    private static boolean mostlyEqual(String inSource, String inTarget, String inTargetUsingCore) {
        if (inTarget.length() != inTargetUsingCore.length()) {
            return false;
        }
        String target = skeletonize.transliterate(inTarget);
        String targetUsingCore = skeletonize.transliterate(inTargetUsingCore);
        for (int i = 0; i < target.length(); ++i) {
            char cb;
            char ca = target.charAt(i);
            if (ca == (cb = targetUsingCore.charAt(i)) || ca == '\u0259' && short_vowels.contains(cb) || short_vowels.contains(ca) && cb == '\u0259' || ca == '\u026a' && cb == '\u025b' || ca == '\u026a' && cb == '\u025b') continue;
            return false;
        }
        return true;
    }

    public static String createFromFile(String fileName, Transliterator pretrans, Transliterator pretrans2) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder();
        BufferedReader fli = FileUtilities.openUTF8Reader("", fileName);
        while ((line = fli.readLine()) != null) {
            if (line.startsWith("\ufeff")) {
                line = line.substring(1);
            }
            if (pretrans != null) {
                line = pretrans.transliterate(line);
            }
            if (pretrans2 != null) {
                line = pretrans2.transliterate(line);
            }
            buffer.append(line);
            buffer.append("\n");
        }
        fli.close();
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOverrides() throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        try (BufferedReader br = FileUtilities.openUTF8Reader(cldrDataDir, "internal_overrides.txt");){
            int counter = 0;
            while (counter < LIMIT) {
                String line = br.readLine();
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).length() == 0) continue;
                String[] iLine = line.split("\\s*\u2192\\s*");
                String word = iLine[0].trim();
                if (result.containsKey(word)) {
                    System.out.println("Overrides already contain: " + word);
                    continue;
                }
                if (iLine.length < 2) {
                    result.put(word, "");
                    continue;
                }
                String ipa = fixBadIpa.transliterate(iLine[1].trim());
                result.put(word, ipa);
            }
        }
        return result;
    }
}

