/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.dev.tool.shared.UOption;
import com.ibm.icu.lang.UCharacter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.unicode.cldr.util.LDMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ModifyCase {
    static final int INDENT = 8;
    static BufferedWriter m_out;
    static String[] m_locales;
    static String[] m_xpaths;
    static String m_sourceDir;
    static String m_destDir;
    private static final int HELP1 = 0;
    private static final int HELP2 = 1;
    private static final int DESTDIR = 2;
    private static final int LOCALES = 3;
    private static final int SOURCEDIR = 4;
    private static final int XPATHS = 5;
    private static final UOption[] options;

    public static void main(String[] args) {
        UOption.parseArgs(args, options);
        if (!ModifyCase.processArgs()) {
            return;
        }
        for (int i = 0; i < m_locales.length; ++i) {
            System.err.println("Locale : " + m_locales[i]);
            String srcfile = m_sourceDir + "/" + m_locales[i] + ".xml";
            String destfile = m_destDir + "/" + m_locales[i] + ".xml";
            Document doc = LDMLUtilities.parse(srcfile, false);
            if (doc == null) continue;
            try {
                m_out = new BufferedWriter(new FileWriter(destfile));
                ModifyCase.openLDML(m_locales[i], doc);
                for (int j = 0; j < m_xpaths.length; ++j) {
                    ModifyCase.makeLowerCase(doc, m_xpaths[j]);
                }
                ModifyCase.closeLDML();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void usage() {
        System.err.println("org.unicode.cldr.tool.ModifyCase allows the casing of the first letter to be changed");
        System.err.println("The output is just the data category which has changed. Run CLDRModify to merge with source");
        System.err.println("-d : specify dest dir (must exist) where resulting modified data is written");
        System.err.println("-l : specify comma separated list of LDML locales to be changed");
        System.err.println("-s : specify src dir of LDML data to be modified");
        System.err.println("-x : specify comma separated list of xpaths to data to be modified");
        System.err.println("Example : ModifyCase -d /dest -s /cldr/comon/main -l bg,en,it,fr -x //ldml/localeDisplayNames/languages/language");
    }

    private static boolean processArgs() {
        if (ModifyCase.options[0].doesOccur || ModifyCase.options[1].doesOccur) {
            ModifyCase.usage();
            return false;
        }
        if (ModifyCase.options[2].value == null || ModifyCase.options[3].value == null || ModifyCase.options[4].value == null || ModifyCase.options[5].value == null) {
            ModifyCase.usage();
            return false;
        }
        m_destDir = ModifyCase.options[2].value;
        m_locales = ModifyCase.options[3].value.split(",");
        m_sourceDir = ModifyCase.options[4].value;
        m_xpaths = ModifyCase.options[5].value.split(",");
        return true;
    }

    public static void openLDML(String locale, Document doc) {
        try {
            m_out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            m_out.write("<!DOCTYPE ldml SYSTEM \"http://www.unicode.org/cldr/dtd/1.5/ldml.dtd\">\n");
            m_out.write("<ldml>\n");
            ModifyCase.indent(8);
            m_out.write("<identity>\n");
            Node n = LDMLUtilities.getNode(doc, "//ldml/identity/version/@number");
            ModifyCase.indent(16);
            m_out.write("<version number=\"" + LDMLUtilities.getNodeValue(n) + "\"/>\n");
            n = LDMLUtilities.getNode(doc, "//ldml/identity/generation/@date");
            ModifyCase.indent(16);
            m_out.write("<generation date=\"" + LDMLUtilities.getNodeValue(n) + "\"/>\n");
            String[] parts = locale.split("_");
            ModifyCase.indent(16);
            m_out.write("<language type=\"" + parts[0] + "\"/>\n");
            if (parts.length > 1) {
                ModifyCase.indent(16);
                m_out.write("<territory type=\"" + parts[1] + "\"/>\n");
            }
            ModifyCase.indent(8);
            m_out.write("</identity>\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void makeLowerCase(Document doc, String xpath) {
        try {
            String path = xpath.substring(xpath.indexOf("//ldml") + 7);
            String[] parts = path.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                ModifyCase.indent(8 * (i + 1));
                if (ModifyCase.addCasingAttribute(parts[i])) {
                    m_out.write("<" + parts[i] + " casing=\"lowercase-words\">\n");
                    continue;
                }
                m_out.write("<" + parts[i] + ">\n");
            }
            Node[] n = LDMLUtilities.getNodeListAsArray(doc, xpath);
            if (n == null) {
                n = new Node[]{LDMLUtilities.getNode(doc, xpath)};
            }
            for (int j = 0; j < n.length; ++j) {
                if (n[j] == null) continue;
                String value = LDMLUtilities.getNodeValue(n[j]);
                boolean bUpperFound = false;
                for (int k = 1; k < value.length(); ++k) {
                    int c = value.codePointAt(k);
                    if (!UCharacter.isUUppercase(c)) continue;
                    bUpperFound = true;
                    break;
                }
                if (bUpperFound) {
                    NamedNodeMap map = n[j].getAttributes();
                    Node langnode = map.getNamedItem("type");
                    String lang = langnode.getNodeValue();
                    System.err.println("Skipping conversion of : " + lang + "  " + value);
                }
                if (!bUpperFound) {
                    value = value.toLowerCase();
                }
                ModifyCase.indent(8 * parts.length);
                m_out.write("<" + parts[parts.length - 1]);
                NamedNodeMap map = n[j].getAttributes();
                for (int k = 0; k < map.getLength(); ++k) {
                    Node node = map.item(k);
                    m_out.write(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                }
                m_out.write(">" + value + "</" + parts[parts.length - 1] + ">\n");
            }
            for (int i = parts.length - 2; i >= 0; --i) {
                ModifyCase.indent(8 * (i + 1));
                m_out.write("</" + parts[i] + ">\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeLDML() {
        try {
            m_out.write("</ldml>\n");
            m_out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void indent(int n) {
        try {
            Object spaces = "";
            for (int i = 0; i < n; ++i) {
                spaces = (String)spaces + " ";
            }
            m_out.write((String)spaces);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean addCasingAttribute(String element) {
        String[] elements_with_casing_attribute = new String[]{"languages", "scripts", "territories", "variants", "keys", "types", "measurementSystemNames", "monthWidth", "dayWidth", "quarterWidth", "long", "fields", "currency"};
        for (int i = 0; i < elements_with_casing_attribute.length; ++i) {
            if (element.compareTo(elements_with_casing_attribute[i]) != 0) continue;
            return true;
        }
        return false;
    }

    static {
        options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("dest", 'd', 1), UOption.create("locales", 'l', 1), UOption.create("source", 's', 1), UOption.create("xpaths", 'x', 1)};
    }
}

