/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.unicode.cldr.test.DisplayAndInputProcessor;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.FileReaders;
import org.unicode.cldr.util.LocaleInheritanceInfo;
import org.unicode.cldr.util.StringId;
import org.unicode.cldr.util.With;
import org.unicode.cldr.util.XMLSource;

@CLDRTool(alias="pathinfo", description="Get information about paths such as inheritance")
public class PathInfo {
    static final Option.Options options = new Option.Options(PathInfo.class).add("locale", (Object)".*", "und", "Locale ID for the path info").add("infile", (Object)".*", null, "File to read paths from or '--infile=-' for stdin").add("nosource", "Don\u2019t print the XML Source line").add("OutputDaip", ".*", "run a string through DAIP for output").add("InputDaip", ".*", "run a string through DAIP for input");

    public static void main(String[] args) throws IOException {
        Set<String> paths = options.parse(args, true);
        String inPath = options.get("infile").getValue();
        if (inPath != null) {
            if (inPath.equals("-")) {
                PathInfo.addLines(System.in, paths);
            } else {
                PathInfo.addLines(inPath, paths);
            }
        }
        if (paths.isEmpty()) {
            System.err.println("Error: No paths were specified.");
            System.out.println(options.getHelp());
            System.exit(1);
        }
        CLDRFile file = null;
        String locale = options.get("locale").getValue();
        try {
            file = CLDRConfig.getInstance().getCLDRFile(locale, true);
        }
        catch (Throwable t2) {
            System.err.println("Could not load locale " + locale + " due to " + t2);
        }
        PathInfo.showPaths(paths, file);
        if (file == null) {
            System.err.println("To enable inheritance lookup, use a different path.");
        }
    }

    private static void showPaths(Set<String> paths, CLDRFile file) {
        boolean prePopulated = false;
        boolean hadStringMisses = false;
        for (String path : paths) {
            String xpath;
            if (path.startsWith("//")) {
                PathInfo.showPath(path, file);
                continue;
            }
            if (!prePopulated && file != null) {
                System.err.println("INFO: Scanning all possible xpaths for hex IDs...");
                file.getExtraPaths().forEach(x -> StringId.getHexId(x));
                file.fullIterable().forEach(x -> StringId.getHexId(x));
                prePopulated = true;
            }
            if ((xpath = StringId.getStringFromHexId(path)) == null) {
                System.err.println("\u2022 ERROR: could not find hex id " + path + " - may not have been seen yet.");
                hadStringMisses = true;
            }
            PathInfo.showPath(xpath, file);
        }
        if (hadStringMisses) {
            System.err.println("ERROR: One or more XPaths could not be converted from hex form.");
            if (file == null) {
                System.err.println("Tip: Set a locale ID with -l when using hex ids");
            }
            System.exit(1);
        }
    }

    private static void showPath(String path, CLDRFile file) {
        String fullPath;
        XMLSource.SourceLocation source;
        boolean nosource = options.get("nosource").doesOccur();
        System.out.println("-------------------\n");
        System.out.println("\u2022 " + path);
        System.out.println("\u2022 " + StringId.getHexId(path));
        if (file == null) {
            return;
        }
        String dPath = CLDRFile.getDistinguishingXPath(path, null);
        if (dPath != null && !dPath.equals(path)) {
            System.out.println("\u2022 Distinguishing: " + dPath);
            System.out.println("\u2022 Distinguishing:" + StringId.getHexId(dPath));
        }
        System.out.println("\u2022 Value: " + file.getStringValue(dPath));
        if (!nosource && (source = file.getSourceLocation(path)) != null) {
            System.out.println(source + " XML Source Location");
        }
        if (!(fullPath = file.getFullXPath(path)).equals(path)) {
            System.out.println("\u2022 Full path: " + fullPath);
            System.out.println("\u2022 Full path: " + StringId.getHexId(fullPath));
        }
        Option inputDaip = options.get("InputDaip");
        Option outputDaip = options.get("OutputDaip");
        if (inputDaip.doesOccur() || outputDaip.doesOccur()) {
            DisplayAndInputProcessor daip = new DisplayAndInputProcessor(file);
            if (inputDaip.doesOccur()) {
                String input = inputDaip.getValue();
                System.out.println("INPUT: " + input);
                Exception[] e = new Exception[1];
                String raw = daip.processInput(path, input, e);
                System.out.println("RAW<<: " + raw);
                if (e.length > 0) {
                    for (Exception ex : e) {
                        System.err.println(ex);
                    }
                }
            }
            if (outputDaip.doesOccur()) {
                String output = outputDaip.getValue();
                System.out.println("RAW   : " + output);
                String disp = daip.processForDisplay(path, output);
                System.out.println("DISP>>: " + disp);
            }
            return;
        }
        CLDRFile.Status status = new CLDRFile.Status();
        System.out.println("\u2022 Inheritance chain:");
        for (LocaleInheritanceInfo e : file.getPathsWhereFound(dPath)) {
            CLDRFile subFile;
            XMLSource.SourceLocation subsource;
            System.out.print("  ");
            if (e.getReason().isTerminal()) {
                System.out.print("\u2022");
            } else {
                System.out.print("|");
            }
            System.out.println(" " + e);
            if (e.getAttribute() != null) {
                System.out.println("    attribute=" + e.getAttribute());
            }
            if (e.getLocale() == null || e.getPath() == null || e.getLocale().equals("code-fallback") || (subsource = (subFile = CLDRConfig.getInstance().getCLDRFile(e.getLocale(), false)).getSourceLocation(e.getPath())) == null || nosource) continue;
            System.out.println("    " + subsource + " XML Source");
        }
    }

    private static void addLines(InputStream in, Set<String> set) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            With.in(new With.SimpleIterator[]{new FileReaders.ReadLineSimpleIterator(br)}).forEach(str -> {
                if (!str.isBlank()) {
                    set.add(str.trim());
                }
            });
        }
    }

    private static void addLines(String path, Set<String> set) throws IOException {
        try (FileInputStream fis = new FileInputStream(path);){
            PathInfo.addLines(fis, set);
        }
    }
}

