/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.lang.CharSequences;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;
import org.unicode.cldr.util.XListFormatter;

public class EmojiConstants {
    public static final String EMOJI_VARIANT_STRING = "\ufe0f";
    static final int FIRST_REGIONAL = 127462;
    static final int LAST_REGIONAL = 127487;
    public static final UnicodeSet REGIONAL_INDICATORS = new UnicodeSet(127462, 127487).freeze();
    public static final String KEYCAP_MARK_STRING = "\u20e3";
    public static final UnicodeSet MODIFIERS = new UnicodeSet(127995, 127999).freeze();
    public static final UnicodeSet HAIR = new UnicodeSet(129456, 129459).freeze();
    public static final char JOINER = '\u200d';
    public static final String JOINER_STRING = String.valueOf('\u200d');
    public static final UnicodeSet COMPONENTS = new UnicodeSet(MODIFIERS).add(EmojiConstants.fromCodePoints(8205, 129456)).add(EmojiConstants.fromCodePoints(8205, 129457)).add(EmojiConstants.fromCodePoints(8205, 129458)).add(EmojiConstants.fromCodePoints(8205, 129459)).freeze();
    public static final String KISS = "\ud83d\udc8b";
    public static final String HEART = "\u2764";
    public static final String TAG_TERM = UTF16.valueOf(917631);
    public static final String BLACK_FLAG = UTF16.valueOf(127988);
    public static final String HANDSHAKE = UTF16.valueOf(129309);
    public static final String COMPOSED_HANDSHAKE = new String(new int[]{129777, 8205, 129778}, 0, 3);
    public static final String MALE_SIGN = "\u2642";
    public static final String FEMALE_SIGN = "\u2640";
    public static final String MAN = "\ud83d\udc68";
    public static final String WOMAN = "\ud83d\udc69";
    public static final String JOINER_MALE_SIGN = JOINER_STRING + "\u2642";
    public static final String JOINER_FEMALE_SIGN = JOINER_STRING + "\u2640";
    public static final UnicodeSet HAIR_EXPLICIT = new UnicodeSet("[\ud83e\uddd4 \ud83d\udc71]").freeze();
    public static final XListFormatter.ListTypeLength COMPOSED_NAME_LIST = XListFormatter.ListTypeLength.UNIT_SHORT;
    public static final int TAG_BASE = 917504;
    public static final int TAG_TERM_CHAR = 917631;
    public static final UnicodeSet FAMILY_MARKERS = new UnicodeSet().add(128102, 128105).add(128118).add(JOINER_STRING).freeze();
    public static final UnicodeSet REM_SKIP_SET = new UnicodeSet().add(JOINER_STRING).freeze();
    public static final UnicodeSet REM_GROUP_SKIP_SET = new UnicodeSet(REM_SKIP_SET).add("\u2764").add("\ud83d\udc8b").add(HANDSHAKE).add("\u2642").add("\u2640").freeze();

    public static String getFlagCode(String s2) {
        return String.valueOf((char)(s2.codePointAt(0) - 127462 + 65)) + (char)(s2.codePointAt(2) - 127462 + 65);
    }

    public static String getEmojiFromRegionCodes(String chars) {
        return new StringBuilder().appendCodePoint(chars.codePointAt(0) + 127462 - 65).appendCodePoint(chars.codePointAt(1) + 127462 - 65).toString();
    }

    public static String getEmojiFromSubdivisionCodes(String string) {
        string = string.toLowerCase(Locale.ROOT).replace("-", "");
        StringBuilder result = new StringBuilder().appendCodePoint(127988);
        for (int cp : CharSequences.codePoints(string)) {
            result.appendCodePoint(917504 + cp);
        }
        return result.appendCodePoint(917631).toString();
    }

    public static String getTagSpec(String code) {
        StringBuilder b = new StringBuilder();
        for (int codePoint : CharSequences.codePoints(code)) {
            if (codePoint < 917536 || codePoint > 917630) continue;
            b.appendCodePoint(codePoint - 917504);
        }
        return b.toString();
    }

    public static String toTagSeq(String subdivisionCode) {
        StringBuilder b = new StringBuilder().appendCodePoint(127988);
        for (int i = 0; i < subdivisionCode.length(); ++i) {
            b.appendCodePoint(subdivisionCode.charAt(i) + 917504);
        }
        return b.appendCodePoint(917631).toString();
    }

    public static CharSequence fromCodePoints(int ... codePoints) {
        return EmojiConstants.appendCodePoints(new StringBuilder(), codePoints).toString();
    }

    public static StringBuilder appendCodePoints(StringBuilder b, int ... codePoints) {
        for (int i = 0; i < codePoints.length; ++i) {
            b.appendCodePoint(codePoints[i]);
        }
        return b;
    }
}

