/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Locale;
import java.util.Set;
import org.unicode.cldr.util.StandardCodes;

public enum Level {
    UNDETERMINED(0, "none", 0, "\ufffd"),
    CORE(10, "G4", 100, "\u24d2"),
    BASIC(40, "G3", 80, "\u24d1"),
    MODERATE(60, "G2", 70, "\u24dc"),
    MODERN(80, "G1", 50, "\ud83c\udd3c"),
    COMPREHENSIVE(100, "G0", 2, "\ud83c\udd32");

    public static final Set<Level> CORE_TO_MODERN;
    @Deprecated
    public static final Level POSIX;
    @Deprecated
    public static final Level MINIMAL;
    @Deprecated
    public static final Level OPTIONAL;
    private final byte level;
    private final String altName;
    private final int value;
    private String abbreviation;
    private static final Level[] VALUES;

    public int getValue() {
        return this.value;
    }

    private Level(int i, String altName, int value, String abbreviation) {
        this.level = (byte)i;
        this.altName = altName;
        this.value = value;
        this.abbreviation = abbreviation;
    }

    public static Level get(String name) {
        try {
            return Level.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            for (Level level : VALUES) {
                if (!name.equalsIgnoreCase(level.altName)) continue;
                return level;
            }
            if (name.equalsIgnoreCase("POSIX")) {
                return POSIX;
            }
            if (name.equalsIgnoreCase("MINIMAL")) {
                return MINIMAL;
            }
            if (name.equalsIgnoreCase("OPTIONAL")) {
                return OPTIONAL;
            }
            return UNDETERMINED;
        }
    }

    public String getAltName() {
        return this.altName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static int getDefaultWeight(String organization, String desiredLocale) {
        Level level = StandardCodes.make().getLocaleCoverageLevel(organization, desiredLocale);
        if (level.compareTo(MODERATE) >= 0) {
            return 4;
        }
        return 1;
    }

    public byte getLevel() {
        return this.level;
    }

    public static Level fromLevel(int level) {
        for (Level result : Level.values()) {
            if (level != result.level) continue;
            return result;
        }
        if (level == 20) {
            return POSIX;
        }
        if (level == 30) {
            return MINIMAL;
        }
        if (level == 101) {
            return OPTIONAL;
        }
        throw new IllegalArgumentException(String.valueOf(level));
    }

    public static Level fromString(String source) {
        return Level.get(source);
    }

    public static Level min(Level a, Level b) {
        return Level.fromLevel(Math.min(a.getLevel(), b.getLevel()));
    }

    public static Level max(Level a, Level b) {
        if (a == null) {
            return b;
        }
        return Level.fromLevel(Math.max(a.getLevel(), b.getLevel()));
    }

    public static Level max(Level ... levels) {
        Level result = UNDETERMINED;
        for (Level level : levels) {
            if (level == null) continue;
            result = Level.max(result, level);
        }
        return result;
    }

    public boolean isAtLeast(Level other) {
        return this.getLevel() >= other.getLevel();
    }

    public boolean isAbove(Level other) {
        return this.getLevel() > other.getLevel();
    }

    static {
        CORE_TO_MODERN = ImmutableSortedSet.of(CORE, BASIC, MODERATE, MODERN);
        POSIX = BASIC;
        MINIMAL = BASIC;
        OPTIONAL = COMPREHENSIVE;
        VALUES = Level.values();
    }
}

