/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.UnicodeSet;
import java.util.BitSet;
import java.util.HashSet;

public class TestMixedScript {
    private final BitSet singleScripts = new BitSet();
    private final HashSet<BitSet> combinations = new HashSet();
    private BitSet tempBitSet = new BitSet();
    static final UnicodeSet HAS_EXTENSIONS;
    private static final BitSet ALL_SCRIPTS;
    static final BitSet DISALLOWED_WITH_LATIN;
    private static final ScriptMatch[] ALLOWED;
    private static final UnicodeSet BAD_NUMBERS;
    private static final UnicodeSet DECIMAL_NUMBERS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MixedScriptLevel getLevel(String source) {
        TestMixedScript testMixedScript = this;
        synchronized (testMixedScript) {
            this.findScripts(source);
            MixedScriptLevel result = this.checkSimple();
            if (result == MixedScriptLevel.unrestricted && (result = this.checkHighlyRestricted()) == MixedScriptLevel.unrestricted) {
                result = this.checkModeratelyRestricted();
            }
            return result;
        }
    }

    private boolean findScripts(String source) {
        int cp;
        this.singleScripts.clear();
        this.combinations.clear();
        this.tempBitSet.clear();
        for (int i = 0; i < source.length(); i += Character.charCount(cp)) {
            cp = source.codePointAt(i);
            if (HAS_EXTENSIONS.contains(cp)) {
                BitSet ext = new BitSet();
                UScript.getScriptExtensions(cp, ext);
                this.combinations.add(ext);
                continue;
            }
            int script = UScript.getScript(cp);
            if (script == 103) {
                return false;
            }
            if (script == 0 || script == 1) continue;
            this.singleScripts.set(script);
        }
        return true;
    }

    private MixedScriptLevel checkSimple() {
        block6: {
            int singleScriptsCount = this.singleScripts.cardinality();
            if (singleScriptsCount <= 1) {
                if (this.combinations.size() == 0) {
                    return MixedScriptLevel.single;
                }
                if (singleScriptsCount == 1) {
                    int single = this.singleScripts.nextSetBit(0);
                    for (BitSet combo : this.combinations) {
                        if (combo.get(single)) continue;
                        break block6;
                    }
                    return MixedScriptLevel.single;
                }
                this.tempBitSet.or(ALL_SCRIPTS);
                for (BitSet combo : this.combinations) {
                    this.tempBitSet.and(combo);
                }
                if (!this.tempBitSet.isEmpty()) {
                    return MixedScriptLevel.single;
                }
            }
        }
        return MixedScriptLevel.unrestricted;
    }

    private MixedScriptLevel checkHighlyRestricted() {
        block0: for (ScriptMatch match : ALLOWED) {
            if (!match.contains(this.singleScripts)) continue;
            for (BitSet combo : this.combinations) {
                if (match.intersects(combo)) continue;
                continue block0;
            }
            return match.level;
        }
        return MixedScriptLevel.unrestricted;
    }

    private MixedScriptLevel checkModeratelyRestricted() {
        if (!this.singleScripts.get(25) || DISALLOWED_WITH_LATIN.intersects(this.singleScripts)) {
            return MixedScriptLevel.unrestricted;
        }
        this.singleScripts.clear(25);
        MixedScriptLevel result = this.checkSimple();
        if (result == MixedScriptLevel.unrestricted) {
            result = this.checkHighlyRestricted();
        }
        this.singleScripts.set(25);
        return result == MixedScriptLevel.unrestricted ? result : MixedScriptLevel.moderately_restrictive;
    }

    public static boolean containsAll(BitSet a, BitSet b) {
        int i = b.nextSetBit(0);
        while (i >= 0) {
            if (!a.get(i)) {
                return false;
            }
            i = b.nextSetBit(i + 1);
        }
        return true;
    }

    public NumberStatus getNumberStatus(String text) {
        int cp;
        int base = -1;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            if (DECIMAL_NUMBERS.contains(cp)) {
                if (UCharacter.getIntPropertyValue(cp, 56) != 0) {
                    return NumberStatus.non_nfkc_cf;
                }
                int newBase = cp - UCharacter.getNumericValue(cp);
                if (newBase == base) continue;
                if (base != -1) {
                    return NumberStatus.mixedDecimals;
                }
                base = newBase;
                continue;
            }
            if (!BAD_NUMBERS.contains(cp)) continue;
            return NumberStatus.nonDecimalNumbers;
        }
        return NumberStatus.ok;
    }

    public static void main(String[] args) {
        TestMixedScript.testLevels();
        TestMixedScript.testNumbers();
    }

    private static void testNumbers() {
        String[][] tests = new String[][]{{"ok", "1234ab23"}, {"ok", "\u0666ab\u0666"}, {"mixedDecimals", "6\u0666"}, {"mixedDecimals", "\u0666\u06f6"}, {"nonDecimalNumbers", "\u3022"}, {"non_nfkc_cf", "\ud835\udfce"}, {"nonDecimalNumbers", "\u24f5"}};
        TestMixedScript tester = new TestMixedScript();
        for (String[] testPair : tests) {
            NumberStatus expected = NumberStatus.valueOf(testPair[0]);
            NumberStatus actual = tester.getNumberStatus(testPair[1]);
            System.out.println((actual == expected ? "ok" : "BAD") + "\t" + actual + "\t" + expected + "\t" + testPair[1]);
        }
    }

    private static void testLevels() {
        String[][] tests = new String[][]{{"moderately_restrictive", "a\u30fcb"}, {"unrestricted", "\u03b1\u30fc\u03b2"}, {"moderately_restrictive", "a\u30fcb"}, {"moderately_restrictive", "a\u30a2\u30fcb"}, {"highly_restrictive", "\u3400\u30a2\u30fc\u3042"}, {"single", "\u3006\u30fc"}, {"unrestricted", "\u1805\u30fc"}, {"moderately_restrictive", "a\u1805"}, {"single", "ab cd"}, {"highly_restrictive", "\u3400\u3105"}, {"highly_restrictive", "\u3400\uac00"}, {"highly_restrictive", "\u3400\u3042"}, {"highly_restrictive", "\u3400\u30a2"}, {"highly_restrictive", "\u3400\u30a2\u3042"}, {"moderately_restrictive", "a\u0915b"}, {"unrestricted", "\u3400\u30a2\u3042\uac00"}, {"unrestricted", "\u03b1a"}, {"unrestricted", "\u03b1\u0915b"}};
        TestMixedScript tester = new TestMixedScript();
        for (String[] testPair : tests) {
            MixedScriptLevel expected = MixedScriptLevel.valueOf(testPair[0]);
            MixedScriptLevel actual = tester.getLevel(testPair[1]);
            System.out.println((actual == expected ? "ok" : "BAD") + "\t" + actual + "\t" + expected + "\t" + testPair[1]);
        }
    }

    static {
        BitSet bitSet = new BitSet();
        UnicodeSet temp = new UnicodeSet();
        for (int i = 0; i < 0x10FFFF; ++i) {
            UScript.getScriptExtensions(i, bitSet);
            if (bitSet.cardinality() <= 0) continue;
            temp.add(i);
        }
        HAS_EXTENSIONS = temp.freeze();
        ALL_SCRIPTS = new BitSet();
        ALL_SCRIPTS.set(0, 208, true);
        DISALLOWED_WITH_LATIN = new BitSet();
        DISALLOWED_WITH_LATIN.xor(ALL_SCRIPTS);
        DISALLOWED_WITH_LATIN.clear(2);
        DISALLOWED_WITH_LATIN.clear(3);
        DISALLOWED_WITH_LATIN.clear(4);
        DISALLOWED_WITH_LATIN.clear(5);
        DISALLOWED_WITH_LATIN.clear(10);
        DISALLOWED_WITH_LATIN.clear(11);
        DISALLOWED_WITH_LATIN.clear(12);
        DISALLOWED_WITH_LATIN.clear(15);
        DISALLOWED_WITH_LATIN.clear(16);
        DISALLOWED_WITH_LATIN.clear(17);
        DISALLOWED_WITH_LATIN.clear(18);
        DISALLOWED_WITH_LATIN.clear(19);
        DISALLOWED_WITH_LATIN.clear(20);
        DISALLOWED_WITH_LATIN.clear(21);
        DISALLOWED_WITH_LATIN.clear(22);
        DISALLOWED_WITH_LATIN.clear(23);
        DISALLOWED_WITH_LATIN.clear(24);
        DISALLOWED_WITH_LATIN.clear(25);
        DISALLOWED_WITH_LATIN.clear(26);
        DISALLOWED_WITH_LATIN.clear(28);
        DISALLOWED_WITH_LATIN.clear(31);
        DISALLOWED_WITH_LATIN.clear(33);
        DISALLOWED_WITH_LATIN.clear(35);
        DISALLOWED_WITH_LATIN.clear(36);
        DISALLOWED_WITH_LATIN.clear(37);
        DISALLOWED_WITH_LATIN.clear(38);
        DISALLOWED_WITH_LATIN.clear(39);
        DISALLOWED_WITH_LATIN.clear(27);
        DISALLOWED_WITH_LATIN.clear(60);
        DISALLOWED_WITH_LATIN.clear(41);
        ALLOWED = new ScriptMatch[]{new ScriptMatch(MixedScriptLevel.highly_restrictive, 17, 22, 20), new ScriptMatch(MixedScriptLevel.highly_restrictive, 17, 5), new ScriptMatch(MixedScriptLevel.highly_restrictive, 17, 18)};
        BAD_NUMBERS = new UnicodeSet("[[:Nl:][:No:]]").freeze();
        DECIMAL_NUMBERS = new UnicodeSet("[:Nd:]").freeze();
    }

    public static enum NumberStatus {
        ok,
        non_nfkc_cf,
        mixedDecimals,
        nonDecimalNumbers;

    }

    static class ScriptMatch {
        private final BitSet match;
        private final MixedScriptLevel level;

        public ScriptMatch(MixedScriptLevel level, int ... scripts) {
            this.level = level;
            this.match = new BitSet();
            for (int script : scripts) {
                this.match.set(script);
            }
        }

        public boolean intersects(BitSet other) {
            return this.match.intersects(other);
        }

        public boolean contains(BitSet singleScripts) {
            return TestMixedScript.containsAll(this.match, singleScripts);
        }
    }

    public static enum MixedScriptLevel {
        single,
        highly_restrictive,
        moderately_restrictive,
        unrestricted;

    }
}

