/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.unicode.cldr.util.PatternCache;

public class FallbackIterator
implements Iterator<String> {
    private static final boolean DEBUG = false;
    private static final List<FallbackRule> FALLBACK_LIST = new ArrayList<FallbackRule>();
    private static final List<FallbackRule> CANONICALIZE_LIST = new ArrayList<FallbackRule>();
    private static final List<FallbackRule> DECANONICALIZE_LIST = new ArrayList<FallbackRule>();
    private static Iterator<String> emptyIterator;
    private Iterator<String> iterator = emptyIterator;

    public FallbackIterator() {
    }

    public FallbackIterator(String source) {
        this.set(source);
    }

    public FallbackIterator set(String source) {
        String original = source;
        ArrayList<String> items = new ArrayList<String>();
        items.add(original);
        block0: while (true) {
            for (FallbackRule rule : CANONICALIZE_LIST) {
                if (!rule.matches(source)) continue;
                source = rule.getAdditions().get(1);
                continue block0;
            }
            break;
        }
        block2: while (true) {
            for (FallbackRule rule : FALLBACK_LIST) {
                if (!rule.matches(source)) continue;
                items.addAll(rule.getAdditions());
                String last = (String)items.get(items.size() - 1);
                items.remove(items.size() - 1);
                source = last;
                continue block2;
            }
            break;
        }
        items.add(source);
        for (FallbackRule rule : DECANONICALIZE_LIST) {
            ArrayList<String> localExpanded = new ArrayList<String>();
            for (String localeItem : items) {
                if (rule.matches(localeItem)) {
                    localExpanded.addAll(rule.getAdditions());
                    continue;
                }
                localExpanded.add(localeItem);
            }
            items = localExpanded;
        }
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        results.addAll(items);
        this.iterator = results.iterator();
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public String next() {
        return this.iterator.next();
    }

    static {
        String[] data = new String[]{"canonicalize", "art-lojban;jbo", "cel-gaulish;xcg", "en-GB-oed;en-GB-x-oed", "i-ami;ami", "i-bnn;bnn", "i-default;und", "i-enochian;x-enochian", "i-hak;zh-hakka", "i-klingon;tlh", "i-lux;lb", "i-mingo;see", "i-navajo;nv", "i-pwn;pwn", "i-tao;tao", "i-tay;tay", "i-tsu;tsu", "no-bok;nb", "no-nyn;nn", "sgn-BE-fr;sfb", "sgn-BE-nl;vgt", "sgn-CH-de;sgg", "zh-cmn;cmn", "zh-cmn-Hans;cmn-Hans", "zh-cmn-Hant;cmn-Hant", "zh-gan;gan", "zh-guoyu;zh-cmn", "zh-hakka;hak", "zh-min;nan", "zh-min-nan;nan", "zh-wuu;wuu", "zh-xiang;hsn", "zh-yue;yue", "in(-.*)?;id$1", "iw(-.*)?;he$1", "ji(-.*)?;yi$1", "jw(-.*)?;jv$1", "(.*-)BU(-.*)?;$1MM$2", "(.*-)DD(-.*)?;$1DE$2", "(.*-)FX(-.*)?;$1FR$2", "(.*-)TP(-.*)?;$1TL$2", "(.*-)YD(-.*)?;$1YE$2", "(.*-)YU(-.*)?;$1CS$2", "(.*-)ZR(-.*)?;$1CD$2", "decanonicalize", "id(-.*)?;in$1", "he(-.*)?;iw$1", "yi(-.*)?;ji$1", "jv(-.*)?;jw$1", "(.*-)MM(-.*)?;$1BU$2", "(.*-)DE(-.*)?;$1DD$2", "(.*-)FR(-.*)?;$1FX$2", "(.*-)TL(-.*)?;$1TP$2", "(.*-)YE(-.*)?;$1YD$2", "(.*-)CS(-.*)?;$1YU$2", "(.*-)CD(-.*)?;$1ZR$2", "canonicalize", "arb(-.*)?;ar$1", "gom(-.*)?;kok$1", "mly(-.*)?;ms$1", "swh(-.*)?;sw$1", "uzn(-.*)?;uz$1", "cmn(-.*)?;zh$1", "uzn(-.*)?;uz$1", "sh(?!-[a-zA-Z]{4}(?:-.*)?)(-.*)?;sr-Latn$1", "sh(-[a-zA-Z]{4}-.*);sr$1", "fallback", "zh-TW(-.*)?;zh-Hant-TW$1", "zh-CN(-.*)?;zh-Hans-CN$1", "zh-HK(-.*)?;zh-Hant-HK$1", "zh-MO(-.*)?;zh-Hant-MO$1", "zh(?!-[a-zA-Z]{4}(?:-.*)?)(-.*);zh-Hans$1", "(.*)-[^-]*;$1", "decanonicalize"};
        Type type = null;
        block5: for (String row : data) {
            if (!row.contains(";")) {
                type = Type.valueOf(row);
                continue;
            }
            FallbackRule fallbackRule = new FallbackRule(row);
            switch (type) {
                case canonicalize: {
                    CANONICALIZE_LIST.add(fallbackRule);
                    continue block5;
                }
                case fallback: {
                    FALLBACK_LIST.add(fallbackRule);
                    continue block5;
                }
                case decanonicalize: {
                    DECANONICALIZE_LIST.add(fallbackRule);
                }
            }
        }
        List foo = Collections.emptyList();
        emptyIterator = foo.iterator();
    }

    private static enum Type {
        canonicalize,
        fallback,
        decanonicalize;

    }

    private static class FallbackRule {
        Matcher matcher;
        String[] additions;
        String source;

        public FallbackRule(String string) {
            String[] data = string.split(";");
            boolean first = true;
            ArrayList<String> strings = new ArrayList<String>();
            for (String datum : data) {
                if (first) {
                    this.matcher = PatternCache.get(datum).matcher("");
                    first = false;
                    continue;
                }
                strings.add(datum);
            }
            this.additions = strings.toArray(new String[strings.size()]);
        }

        public boolean matches(String source) {
            this.source = source;
            return this.matcher.reset(source).matches();
        }

        public List<String> getAdditions() {
            ArrayList<String> results = new ArrayList<String>(this.additions.length);
            results.add(this.source);
            String[] stringArray = this.additions;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String addition;
                String copy = addition = stringArray[i];
                for (int i2 = 0; i2 <= this.matcher.groupCount(); ++i2) {
                    String group = this.matcher.group(i2);
                    copy = copy.replace("$" + i2, group == null ? "" : group);
                }
                results.add(copy);
            }
            return results;
        }

        public String toString() {
            return "{" + this.matcher.toString() + ", " + Arrays.asList(this.additions) + "}";
        }
    }
}

