/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.util.Locale;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.ICUServiceBuilder;

public class ZoneFormats {
    private String gmtFormat;
    private String hourFormat;
    private String[] hourFormatPlusMinus;
    private ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    CLDRFile cldrFile;

    public ZoneFormats set(CLDRFile cldrFile) {
        this.cldrFile = cldrFile;
        this.gmtFormat = cldrFile.getWinningValue("//ldml/dates/timeZoneNames/gmtFormat");
        this.hourFormat = cldrFile.getWinningValue("//ldml/dates/timeZoneNames/hourFormat");
        this.hourFormatPlusMinus = this.hourFormat.split(";");
        this.icuServiceBuilder.setCldrFile(cldrFile);
        return this;
    }

    public String formatGMT(TimeZone currentZone) {
        int tzOffset = currentZone.getRawOffset();
        SimpleDateFormat dateFormat = this.icuServiceBuilder.getDateFormat("gregorian", this.hourFormatPlusMinus[tzOffset >= 0 ? 0 : 1]);
        String hoursMinutes = dateFormat.format(tzOffset >= 0 ? tzOffset : -tzOffset);
        return MessageFormat.format(this.gmtFormat, hoursMinutes);
    }

    public String getExemplarCity(String timezoneString) {
        String exemplarCity = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/zone[@type=\"" + timezoneString + "\"]/exemplarCity");
        if (exemplarCity == null) {
            exemplarCity = timezoneString.substring(timezoneString.lastIndexOf(47) + 1).replace('_', ' ');
        }
        return exemplarCity;
    }

    public String getMetazoneName(String metazone, Length length, Type typeIn) {
        Type type = typeIn == Type.genericOrStandard ? Type.generic : typeIn;
        String name = this.cldrFile.getWinningValue("//ldml/dates/timeZoneNames/metazone[@type=\"" + metazone + "\"]/" + length + "/" + type);
        return name != null ? name : (typeIn != Type.genericOrStandard ? "n/a" : this.getMetazoneName(metazone, length, Type.standard));
    }

    public static enum Type {
        generic,
        standard,
        daylight,
        genericOrStandard;

    }

    public static enum Length {
        LONG,
        SHORT;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

