/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.edit.AbstractPatternVisitor;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.xsd.ChildType;
import com.thaiopensource.util.VoidValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class SchemaInfo {
    private final SchemaCollection sc;
    private final GrammarPattern grammar;
    private final ErrorReporter er;
    private final Map<Pattern, ChildType> childTypeMap = new HashMap<Pattern, ChildType>();
    private final Map<String, Define> defineMap = new HashMap<String, Define>();
    private final Set<DefineComponent> ignoredDefines = new HashSet<DefineComponent>();
    private final PatternVisitor<ChildType> childTypeVisitor = new ChildTypeVisitor();
    private static final int DEFINE_KEEP = 0;
    private static final int DEFINE_IGNORE = 1;
    private static final int DEFINE_REQUIRE = 2;

    SchemaInfo(SchemaCollection schemaCollection, ErrorReporter errorReporter) {
        this.sc = schemaCollection;
        this.er = errorReporter;
        this.forceGrammar();
        this.grammar = this.getSchema(schemaCollection.getMainUri());
        this.grammar.componentsAccept(new GrammarVisitor());
    }

    private void forceGrammar() {
        SchemaDocument schemaDocument = this.sc.getSchemaDocumentMap().get(this.sc.getMainUri());
        schemaDocument.setPattern(SchemaInfo.convertToGrammar(schemaDocument.getPattern()));
    }

    private static GrammarPattern convertToGrammar(Pattern pattern) {
        if (pattern instanceof GrammarPattern) {
            return (GrammarPattern)pattern;
        }
        GrammarPattern grammarPattern = new GrammarPattern();
        grammarPattern.setSourceLocation(pattern.getSourceLocation());
        grammarPattern.setContext(pattern.getContext());
        DefineComponent defineComponent = new DefineComponent(DefineComponent.START, pattern);
        defineComponent.setSourceLocation(pattern.getSourceLocation());
        grammarPattern.getComponents().add(defineComponent);
        return grammarPattern;
    }

    GrammarPattern getGrammar() {
        return this.grammar;
    }

    String getMainUri() {
        return this.sc.getMainUri();
    }

    GrammarPattern getSchema(String string) {
        return (GrammarPattern)this.sc.getSchemaDocumentMap().get(string).getPattern();
    }

    String getEncoding(String string) {
        return this.sc.getSchemaDocumentMap().get(string).getEncoding();
    }

    ChildType getChildType(Pattern pattern) {
        ChildType childType = this.childTypeMap.get(pattern);
        if (childType == null) {
            childType = pattern.accept(this.childTypeVisitor);
            this.childTypeMap.put(pattern, childType);
        }
        return childType;
    }

    Pattern getStart() {
        return this.lookupDefine((String)DefineComponent.START).pattern;
    }

    Pattern getBody(RefPattern refPattern) {
        return this.lookupDefine((String)refPattern.getName()).pattern;
    }

    Pattern getBody(DefineComponent defineComponent) {
        Define define = this.lookupDefine(defineComponent.getName());
        if (define == null || define.head != defineComponent) {
            return null;
        }
        return define.pattern;
    }

    boolean isIgnored(DefineComponent defineComponent) {
        return this.ignoredDefines.contains(defineComponent);
    }

    private Define lookupDefine(String string) {
        Define define = this.defineMap.get(string);
        if (define == null) {
            define = new Define();
            this.defineMap.put(string, define);
        }
        return define;
    }

    class GrammarVisitor
    implements ComponentVisitor<VoidValue> {
        private final Set<String> openIncludes = new HashSet<String>();
        private final Set<String> allIncludes = new HashSet<String>();
        private List<Override> overrides = null;

        GrammarVisitor() {
        }

        @java.lang.Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            Define define = SchemaInfo.this.lookupDefine(defineComponent.getName());
            if (this.overrides != null) {
                this.overrides.add(new Override(define, defineComponent.getName()));
            }
            if (define.status != 0) {
                SchemaInfo.this.ignoredDefines.add(defineComponent);
                define.status = 1;
                return VoidValue.VOID;
            }
            if (defineComponent.getCombine() == null) {
                if (define.hadImplicit) {
                    SchemaInfo.this.er.error("multiple_define", defineComponent.getName(), defineComponent.getSourceLocation());
                    return VoidValue.VOID;
                }
                define.hadImplicit = true;
            } else if (define.combine == null) {
                define.combine = defineComponent.getCombine();
                define.wrapper = define.combine == Combine.CHOICE ? new ChoicePattern() : new InterleavePattern();
                define.wrapper.setSourceLocation(defineComponent.getSourceLocation());
            } else if (define.combine != defineComponent.getCombine()) {
                SchemaInfo.this.er.error("inconsistent_combine", defineComponent.getName(), defineComponent.getSourceLocation());
                return VoidValue.VOID;
            }
            if (define.pattern == null) {
                define.pattern = defineComponent.getBody();
                define.head = defineComponent;
            } else {
                if (define.pattern != define.wrapper) {
                    define.wrapper.getChildren().add(define.pattern);
                }
                define.wrapper.getChildren().add(defineComponent.getBody());
                define.pattern = define.wrapper;
            }
            return VoidValue.VOID;
        }

        @java.lang.Override
        public VoidValue visitDiv(DivComponent divComponent) {
            divComponent.componentsAccept(this);
            return VoidValue.VOID;
        }

        @java.lang.Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            Vector<Override> vector = new Vector<Override>();
            List<Override> list = this.overrides;
            this.overrides = vector;
            includeComponent.componentsAccept(this);
            this.overrides = list;
            String string = includeComponent.getUri();
            if (this.openIncludes.contains(string)) {
                SchemaInfo.this.er.error("include_loop", string, includeComponent.getSourceLocation());
            } else if (this.allIncludes.contains(string)) {
                SchemaInfo.this.er.error("multiple_include", string, includeComponent.getSourceLocation());
            } else {
                for (Override override : vector) {
                    override.status = override.define.status;
                    override.define.status = 2;
                }
                this.allIncludes.add(string);
                this.openIncludes.add(string);
                SchemaInfo.this.getSchema(string).componentsAccept(this);
                this.openIncludes.remove(string);
                for (Override override : vector) {
                    if (override.define.status == 2) {
                        if (override.name == DefineComponent.START) {
                            SchemaInfo.this.er.error("missing_start_replacement", includeComponent.getSourceLocation());
                        } else {
                            SchemaInfo.this.er.error("missing_define_replacement", override.name, includeComponent.getSourceLocation());
                        }
                    }
                    override.define.status = override.status;
                }
            }
            return VoidValue.VOID;
        }
    }

    static class Override {
        int status;
        final Define define;
        final String name;

        Override(Define define, String string) {
            this.define = define;
            this.name = string;
        }
    }

    class ChildTypeVisitor
    extends PatternAnalysisVisitor<ChildType> {
        ChildTypeVisitor() {
        }

        @java.lang.Override
        ChildType get(Pattern pattern) {
            return SchemaInfo.this.getChildType(pattern);
        }

        @java.lang.Override
        ChildType empty() {
            return ChildType.EMPTY;
        }

        @java.lang.Override
        ChildType text() {
            return ChildType.choice(ChildType.TEXT, ChildType.EMPTY);
        }

        @java.lang.Override
        ChildType data() {
            return ChildType.DATA;
        }

        @java.lang.Override
        ChildType notAllowed() {
            return ChildType.NOT_ALLOWED;
        }

        @java.lang.Override
        ChildType list(ChildType childType) {
            if (childType == ChildType.NOT_ALLOWED) {
                return childType;
            }
            return this.data();
        }

        @java.lang.Override
        ChildType choice(ChildType childType, ChildType childType2) {
            return ChildType.choice(childType, childType2);
        }

        @java.lang.Override
        ChildType group(ChildType childType, ChildType childType2) {
            return ChildType.group(childType, childType2);
        }

        @java.lang.Override
        public ChildType visitElement(ElementPattern elementPattern) {
            return ChildType.ELEMENT;
        }

        @java.lang.Override
        public ChildType visitAttribute(AttributePattern attributePattern) {
            if (SchemaInfo.this.getChildType(attributePattern.getChild()) == ChildType.NOT_ALLOWED) {
                return ChildType.NOT_ALLOWED;
            }
            return ChildType.choice(ChildType.ATTRIBUTE, ChildType.EMPTY);
        }
    }

    abstract class PatternAnalysisVisitor<T>
    extends AbstractPatternVisitor<T> {
        PatternAnalysisVisitor() {
        }

        abstract T get(Pattern var1);

        abstract T choice(T var1, T var2);

        abstract T group(T var1, T var2);

        T interleave(T t2, T t3) {
            return this.group(t2, t3);
        }

        T ref(T t2) {
            return t2;
        }

        T oneOrMore(T t2) {
            return this.group(t2, t2);
        }

        abstract T empty();

        abstract T text();

        abstract T data();

        abstract T notAllowed();

        T list(T t2) {
            return this.data();
        }

        @java.lang.Override
        public T visitChoice(ChoicePattern choicePattern) {
            List<Pattern> list = choicePattern.getChildren();
            T t2 = this.get(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                t2 = this.choice(t2, this.get(list.get(i)));
            }
            return t2;
        }

        @java.lang.Override
        public T visitGroup(GroupPattern groupPattern) {
            List<Pattern> list = groupPattern.getChildren();
            T t2 = this.get(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                t2 = this.group(t2, this.get(list.get(i)));
            }
            return t2;
        }

        @java.lang.Override
        public T visitInterleave(InterleavePattern interleavePattern) {
            List<Pattern> list = interleavePattern.getChildren();
            T t2 = this.get(list.get(0));
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                t2 = this.interleave(t2, this.get(list.get(i)));
            }
            return t2;
        }

        @java.lang.Override
        public T visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return this.choice(this.empty(), this.oneOrMore(this.get(zeroOrMorePattern.getChild())));
        }

        @java.lang.Override
        public T visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.oneOrMore(this.get(oneOrMorePattern.getChild()));
        }

        @java.lang.Override
        public T visitOptional(OptionalPattern optionalPattern) {
            return this.choice(this.empty(), this.get(optionalPattern.getChild()));
        }

        @java.lang.Override
        public T visitEmpty(EmptyPattern emptyPattern) {
            return this.empty();
        }

        @java.lang.Override
        public T visitRef(RefPattern refPattern) {
            return this.ref(this.get(SchemaInfo.this.getBody(refPattern)));
        }

        @java.lang.Override
        public T visitMixed(MixedPattern mixedPattern) {
            return this.interleave(this.text(), this.get(mixedPattern.getChild()));
        }

        @java.lang.Override
        public T visitText(TextPattern textPattern) {
            return this.text();
        }

        @java.lang.Override
        public T visitData(DataPattern dataPattern) {
            return this.data();
        }

        @java.lang.Override
        public T visitValue(ValuePattern valuePattern) {
            return this.data();
        }

        @java.lang.Override
        public T visitList(ListPattern listPattern) {
            return this.list(this.get(listPattern.getChild()));
        }

        @java.lang.Override
        public T visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            return this.notAllowed();
        }

        @java.lang.Override
        public T visitPattern(Pattern pattern) {
            return null;
        }
    }

    private static class Define {
        int status = 0;
        boolean hadImplicit;
        Combine combine;
        Pattern pattern;
        CompositePattern wrapper;
        DefineComponent head;

        private Define() {
        }
    }
}

