/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.unicode.cldr.api.AttributeKey;
import org.unicode.cldr.api.CldrDataType;
import org.unicode.cldr.api.CldrPath;
import org.unicode.cldr.api.CldrPaths;
import org.unicode.cldr.util.CldrUtility;

public final class CldrValue
implements AttributeKey.AttributeSupplier {
    private final String value;
    private final ImmutableMap<AttributeKey, String> attributes;
    private final CldrPath path;
    private final int hashCode;

    public static CldrValue parseValue(String fullPath, String value) {
        LinkedHashMap<AttributeKey, String> valueAttributes = new LinkedHashMap<AttributeKey, String>();
        CldrPath path = CldrPaths.processXPath(fullPath, ImmutableList.of(), valueAttributes::put);
        return new CldrValue(value, valueAttributes, path);
    }

    public CldrValue replacePath(CldrPath path) {
        if (this.path.equals(path)) {
            return this;
        }
        Preconditions.checkArgument(CldrValue.hasSameElements(this.path, path), "invalid replacement path '%s' for value: %s", (Object)path, (Object)this);
        return new CldrValue(this.getValue(), this.attributes, path);
    }

    private static boolean hasSameElements(CldrPath x, CldrPath y) {
        if (x.getLength() != y.getLength()) {
            return false;
        }
        do {
            if (!x.getName().equals(y.getName())) {
                return false;
            }
            x = x.getParent();
            y = y.getParent();
        } while (x != null);
        return true;
    }

    static CldrValue create(String value, Map<AttributeKey, String> valueAttributes, CldrPath path) {
        return new CldrValue(value, valueAttributes, path);
    }

    private CldrValue(String value, Map<AttributeKey, String> attributes, CldrPath path) {
        Preconditions.checkArgument(!value.equals(CldrUtility.INHERITANCE_MARKER), "unexpected inheritance marker '%s' for path: %s", (Object)value, (Object)path);
        this.value = Preconditions.checkNotNull(value);
        this.attributes = CldrValue.checkAttributeMap(attributes);
        this.path = Preconditions.checkNotNull(path);
        this.hashCode = Objects.hash(value, this.attributes, path);
    }

    private static ImmutableMap<AttributeKey, String> checkAttributeMap(Map<AttributeKey, String> attributes) {
        for (String v : attributes.values()) {
            Preconditions.checkArgument(!v.contains("\""), "unsupported '\"' in attribute value: %s", (Object)v);
        }
        return ImmutableMap.copyOf(attributes);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String get(AttributeKey key) {
        if (this.getPath().getDataType().isValueAttribute(key)) {
            return this.attributes.get(key);
        }
        return this.getPath().get(key);
    }

    @Override
    public CldrDataType getDataType() {
        return this.getPath().getDataType();
    }

    public ImmutableMap<AttributeKey, String> getValueAttributes() {
        return this.attributes;
    }

    public CldrPath getPath() {
        return this.path;
    }

    public String getFullPath() {
        return this.getPath().getFullPath(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CldrValue)) {
            return false;
        }
        CldrValue other = (CldrValue)obj;
        return this.path.equals(other.path) && this.value.equals(other.value) && this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.value.isEmpty()) {
            return String.format("attributes=%s, path=%s", this.attributes, this.path);
        }
        if (this.attributes.isEmpty()) {
            return String.format("value=\"%s\", path=%s", this.value, this.path);
        }
        return String.format("value=\"%s\", attributes=%s, path=%s", this.value, this.attributes, this.path);
    }
}

