/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.FilteredNormalizer2;
import com.ibm.icu.text.Normalizer2;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.ULocale;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unicode.cldr.draft.CharEncoder;
import org.unicode.cldr.draft.CodePoints;
import org.unicode.cldr.tool.LanguageCodeConverter;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;

public class ExemplarInfo {
    public static UnicodeSet IGNORE = new UnicodeSet("[[:sc=unknown:][:script=common:]-[:M:]]").freeze();
    public static UnicodeSet TEST_ENCODING = new UnicodeSet("[[:any:]-[:c:] [:cc:]]").freeze();
    public static final Normalizer2 nfkd = Normalizer2.getInstance(null, "nfkc", Normalizer2.Mode.DECOMPOSE);
    public static final Normalizer2 nfd = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.DECOMPOSE);
    public static final Normalizer2 nfc = Normalizer2.getInstance(null, "nfc", Normalizer2.Mode.COMPOSE);
    private static final Normalizer2 nfkdMinus = new FilteredNormalizer2(nfkd, new UnicodeSet("[[:dt=Initial:][:dt=Medial:][:dt=Final:][:dt=Isolated:][:dt=Narrow:][:dt=Wide:][:dt=Vertical:][:dt=Canonical:]]").freeze());
    private static Map<String, ExemplarInfo> languageToExemplars = new TreeMap<String, ExemplarInfo>();
    private static UnicodeSet az = new UnicodeSet("[a-z]").freeze();
    private static UnicodeMap<String> JapaneseEducationLevels;
    private UnicodeSet exemplars;
    UnicodeSet exemplarsX;
    UnicodeSet auxiliariesX;
    UnicodeSet exemplarScripts;
    UnicodeSet auxiliaryScripts;
    UnicodeMap<String> educationLevels = new UnicodeMap();
    static Factory cldrFactory;
    static SortedMap<String, Charset> charsets;

    private ExemplarInfo(String main, String aux) {
        this(new UnicodeSet(main), new UnicodeSet(aux), null);
    }

    public Status getStatus(String sequence) {
        if (IGNORE.containsAll(sequence)) {
            return Status.O;
        }
        if (this.exemplarsX.containsAll(sequence)) {
            return Status.M;
        }
        if (this.auxiliariesX.containsAll(sequence)) {
            return Status.A;
        }
        if (this.exemplarScripts.containsAll(sequence)) {
            return Status.S;
        }
        if (this.auxiliaryScripts.containsAll(sequence)) {
            return Status.T;
        }
        return Status.X;
    }

    public UnicodeSet getExemplars() {
        return this.exemplars;
    }

    private ExemplarInfo(UnicodeSet exemplars1, UnicodeSet auxiliary1, ULocale locale) {
        if (auxiliary1 == null) {
            auxiliary1 = new UnicodeSet();
        }
        this.exemplars = ExemplarInfo.flatten(exemplars1, locale).freeze();
        auxiliary1.addAll(exemplars1);
        if (auxiliary1.containsSome(az) && !auxiliary1.containsAll(az)) {
            System.err.println("WARNING " + String.valueOf(locale) + " Aux+Main inconsistent on a-z:\t" + UnicodeSetPrettyPrinter.ROOT_ICU.format(auxiliary1));
        }
        auxiliary1.addAll(az);
        this.auxiliariesX = ExemplarInfo.flatten(auxiliary1, locale).addAll(IGNORE).freeze();
        this.exemplarsX = new UnicodeSet(this.exemplars).addAll(IGNORE).freeze();
        this.exemplarScripts = this.expandScripts(exemplars1, locale).addAll(IGNORE).freeze();
        this.auxiliaryScripts = this.expandScripts(auxiliary1, locale).addAll(IGNORE).freeze();
        if (locale != null) {
            if (locale.equals(ULocale.JAPANESE)) {
                this.educationLevels.putAll(this.getCharset("Shift_JIS"), "SJIS");
                this.educationLevels.putAll(JapaneseEducationLevels);
            } else if (locale.equals(ULocale.KOREAN)) {
                this.educationLevels.putAll(this.getCharset("x-windows-949"), "949");
            } else if (locale.equals(ULocale.CHINESE)) {
                this.educationLevels.putAll(this.getCharset("GB2312"), "2312");
            } else if (locale.equals(ULocale.TRADITIONAL_CHINESE)) {
                this.educationLevels.putAll(this.getCharset("Big5"), "Big5");
            }
        }
    }

    UnicodeSet getCharset(String name) {
        UnicodeSet result = new UnicodeSet();
        Charset charset = (Charset)charsets.get(name);
        CharEncoder encoder = new CharEncoder(charset, false, false);
        byte[] temp = new byte[100];
        UnicodeSetIterator usi = new UnicodeSetIterator(TEST_ENCODING);
        while (usi.next()) {
            int len = encoder.getValue(usi.codepoint, temp, 0);
            if (len <= 0) continue;
            result.add(usi.codepoint);
        }
        return result.freeze();
    }

    private UnicodeSet expandScripts(UnicodeSet source, ULocale locale) {
        UnicodeSet temp = new UnicodeSet();
        UnicodeSet scripts = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(source);
        while (it.next()) {
            int cp;
            String s2 = it.getString();
            if (scripts.containsAll(s2)) continue;
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.codePointAt(i);
                int script = UScript.getScript(cp);
                if (script == 0 || script == 103 || script == 1) continue;
                temp.applyIntPropertyValue(4106, script);
                scripts.addAll(temp);
            }
        }
        return ExemplarInfo.flatten(scripts, locale);
    }

    public static String getCldrLanguage(String language) {
        return LanguageCodeConverter.fromGoogleLocaleId(language);
    }

    public static String specialNormalize(String marks, ULocale locale) {
        marks = nfd.normalize(marks);
        marks = locale == null ? UCharacter.toLowerCase(marks) : UCharacter.toLowerCase(locale, marks);
        marks = nfkdMinus.normalize(marks);
        marks = nfc.normalize(marks);
        return marks;
    }

    public static UnicodeSet flatten(UnicodeSet exemplar1, ULocale locale) {
        if (exemplar1 == null) {
            return null;
        }
        UnicodeSet result = new UnicodeSet();
        UnicodeSetIterator it = new UnicodeSetIterator(exemplar1);
        while (it.next()) {
            int cp;
            String s2 = it.getString();
            if ((s2 = ExemplarInfo.specialNormalize(s2, locale)).contains("\u017f") && locale != null) {
                System.out.print("");
            }
            if (s2.codePointCount(0, s2.length()) == 1) {
                result.add(s2);
                continue;
            }
            int lastPos = 0;
            for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
                cp = s2.codePointAt(i);
                int type = UCharacter.getType(cp);
                if (type == 7 || type == 6 || type == 8) continue;
                if (i > lastPos) {
                    result.add(s2.substring(lastPos, i));
                }
                lastPos = i;
            }
            result.add(s2.substring(lastPos, s2.length()));
        }
        return result;
    }

    public static ExemplarInfo make(String language, Set<String> missingExemplars) {
        String cldrLanguage = ExemplarInfo.getCldrLanguage(language);
        ExemplarInfo exemplarInfo = languageToExemplars.get(cldrLanguage);
        if (exemplarInfo == null) {
            UnicodeSet auxiliary1;
            UnicodeSet exemplars1;
            ULocale locale;
            block5: {
                locale = new ULocale(cldrLanguage);
                exemplars1 = null;
                auxiliary1 = null;
                try {
                    if (cldrLanguage.startsWith("zh")) {
                        System.out.print("");
                    }
                    CLDRFile file = cldrFactory.make(cldrLanguage, true);
                    exemplars1 = file.getExemplarSet("", CLDRFile.WinningChoice.WINNING, 0);
                    auxiliary1 = file.getExemplarSet("auxiliary", CLDRFile.WinningChoice.WINNING, 0);
                }
                catch (Exception e) {
                    System.out.println("Can't read " + (exemplars1 == null ? "main" : "aux") + " exemplars for " + cldrLanguage);
                    if (missingExemplars == null) break block5;
                    missingExemplars.add(cldrLanguage);
                }
            }
            if (exemplars1 == null) {
                exemplars1 = new UnicodeSet();
            }
            exemplarInfo = new ExemplarInfo(exemplars1, auxiliary1, locale);
            languageToExemplars.put(cldrLanguage, exemplarInfo);
        }
        return exemplarInfo;
    }

    public String getEducationLevel(CharSequence input) {
        String result = null;
        CodePoints cps = new CodePoints(input);
        while (cps.next()) {
            String level = this.educationLevels.get(cps.getCodePoint());
            if (level == null) {
                return null;
            }
            if (result != null && result.compareTo(level) >= 0) continue;
            result = level;
        }
        return result;
    }

    public static void main(String[] args) {
        TreeSet<String> missingExemplars = new TreeSet<String>();
        System.out.println(Charset.availableCharsets());
        System.out.println(ExemplarInfo.make("ja", missingExemplars).getEducationLevel("\u4e00"));
        System.out.println(ExemplarInfo.make("zh", missingExemplars).getEducationLevel("\u4e00"));
        System.out.println(ExemplarInfo.make("zh-Hant", missingExemplars).getEducationLevel("\u4e00"));
        System.out.println(ExemplarInfo.make("ko", missingExemplars).getEducationLevel("\u4e00"));
    }

    static {
        languageToExemplars.put("qu", new ExemplarInfo("[pt{ch}kq{p\u02bc}{t\u02bc}{ch\u02bc}{k\u02bc}{q\u02bc}{ph}{th}{chh}{kh}{qh}s{sh}hmnjl{ll}rwy\u00f1aiu]", "[a-z]"));
        languageToExemplars.put("co", new ExemplarInfo("[abc{chj}defg{ghj}hijlmnopqrstuvz]", "[a-z]"));
        languageToExemplars.put("fy", new ExemplarInfo("[a  b c d e f g h i y j k l m n o p q r s t u v w x z\u00e2  \u00ea \u00e9 \u00f4 \u00fb \u00fa]", "[a-z]"));
        languageToExemplars.put("bho", new ExemplarInfo("[:sc=deva:]", "[a-z]"));
        languageToExemplars.put("gd", new ExemplarInfo("[abcdefghilmnoprstu\u00e0\u00e8\u00ec\u00f2\u00f9]", "[a-z]"));
        languageToExemplars.put("ht", new ExemplarInfo("[a{an}b{ch}de{en}\u00e8fgijklmno\u00f2{on}{ou}prst{tch}vwyz]", "[a-z]"));
        languageToExemplars.put("jv", new ExemplarInfo("[a  b c d e \u00e9 \u00e8 f g h i j k l m n o p q r s t u v w x y z]", "[a-z]"));
        languageToExemplars.put("la", new ExemplarInfo("[abcdefghiklmnopqrstuxyz]", "[a-z]"));
        languageToExemplars.put("lb", new ExemplarInfo("[a-z \u00e9 \u00e4 \u00eb]", "[a-z]"));
        languageToExemplars.put("sd", new ExemplarInfo("[\u062c\u06be \u0684 \u062c \u067e \u062b \u067a \u067d \u067f \u062a \u0680 \u067b \u0628 \u0627\u0699  \u0631 \u0630 \u068d \u068a \u068f \u068c \u062f \u062e \u062d \u0687 \u0686 \u0683\u0642  \u06a6 \u0641 \u063a \u0639 \u0638 \u0637 \u0636 \u0635 \u0634 \u0633 \u0632 \u0699\u06be\u064a \u0647 \u0648 \u06bb \u0646 \u0645 \u0644 \u06b1 \u06af\u06be  \u06b3 \u06af \u06a9 \u06aa]", "[:sc=deva:]"));
        languageToExemplars.put("su", new ExemplarInfo("[aeiou\u00e9pbtdkgcjh{ng}{ny}mnswlry]", "[a-z]"));
        languageToExemplars.put("gn", new ExemplarInfo("[a-vx-z\u00e1 \u00e9 \u00ed \u00f3 \u00fa \u00fd \u00f1 \u00e3 \u1ebd \u0129 \u00f5 \u0169 \u1ef9 {g\u0303}]", "[a-z]"));
        JapaneseEducationLevels = new UnicodeMap<String>().putAll(new UnicodeSet("[\u4e00\u4e03\u4e09-\u4e0b\u4e2d\u4e5d\u4e8c\u4e94\u4eba\u4f11\u5148\u5165\u516b\u516d\u5186\u51fa\u529b\u5341\u5343\u53e3\u53f3\u540d\u56db\u571f\u5915\u5927\u5929\u5973\u5b50\u5b57\u5b66\u5c0f\u5c71\u5ddd\u5de6\u5e74\u624b\u6587\u65e5\u65e9\u6708\u6728\u672c\u6751\u6797\u6821\u68ee\u6b63\u6c17\u6c34\u706b\u72ac\u7389\u738b\u751f\u7530\u7537\u753a\u767d\u767e\u76ee\u77f3\u7a7a\u7acb\u7af9\u7cf8\u8033\u82b1\u8349\u866b\u898b\u8c9d\u8d64\u8db3\u8eca\u91d1\u96e8\u9752\u97f3]"), "1").putAll(new UnicodeSet("[\u4e07\u4e38\u4ea4\u4eac\u4eca\u4f1a\u4f53\u4f55\u4f5c\u5143\u5144\u5149\u516c\u5185\u51ac\u5200\u5206\u5207\u524d\u5317\u5348\u534a\u5357\u539f\u53cb\u53e4\u53f0\u5408\u540c\u56de\u56f3\u56fd\u5712\u5730\u5834\u58f0\u58f2\u590f\u5916\u591a\u591c\u592a\u59b9\u59c9\u5ba4\u5bb6\u5bfa\u5c11\u5ca9\u5de5\u5e02\u5e30\u5e83\u5e97\u5f13\u5f15\u5f1f\u5f31\u5f37\u5f53\u5f62\u5f8c\u5fc3\u601d\u6238\u624d\u6559\u6570\u65b0\u65b9\u660e\u661f\u6625\u663c\u6642\u6674\u66dc\u66f8\u671d\u6765\u6771\u697d\u6b4c\u6b62\u6b69\u6bcd\u6bce\u6bdb\u6c60\u6c7d\u6d3b\u6d77\u70b9\u7236\u725b\u7406\u7528\u753b\u756a\u76f4\u77e2\u77e5\u793e\u79cb\u79d1\u7b54\u7b97\u7c73\u7d19\u7d30\u7d44\u7d75\u7dda\u7fbd\u8003\u805e\u8089\u81ea\u8239\u8272\u8336\u884c\u897f\u89aa\u89d2\u8a00\u8a08\u8a18\u8a71\u8a9e\u8aad\u8c37\u8cb7\u8d70\u8fd1\u901a\u9031\u9053\u9060\u91cc\u91ce\u9577\u9580\u9593\u96ea\u96f2\u96fb\u982d\u9854\u98a8\u98df\u9996\u99ac\u9ad8\u9b5a\u9ce5\u9cf4\u9ea6\u9ec4\u9ed2]"), "2").putAll(new UnicodeSet("[\u4e01\u4e16\u4e21\u4e3b\u4e57\u4e88\u4e8b\u4ed5\u4ed6\u4ee3\u4f4f\u4f7f\u4fc2\u500d\u5168\u5177\u5199\u5217\u52a9\u52c9\u52d5\u52dd\u5316\u533a\u533b\u53bb\u53cd\u53d6\u53d7\u53f7\u5411\u541b\u5473\u547d\u548c\u54c1\u54e1\u5546\u554f\u5742\u592e\u59cb\u59d4\u5b88\u5b89\u5b9a\u5b9f\u5ba2\u5bae\u5bbf\u5bd2\u5bfe\u5c40\u5c4b\u5cb8\u5cf6\u5dde\u5e33\u5e73\u5e78\u5ea6\u5eab\u5ead\u5f0f\u5f79\u5f85\u6025\u606f\u60aa\u60b2\u60f3\u610f\u611f\u6240\u6253\u6295\u62fe\u6301\u6307\u653e\u6574\u65c5\u65cf\u6614\u662d\u6691\u6697\u66f2\u6709\u670d\u671f\u677f\u67f1\u6839\u690d\u696d\u69d8\u6a2a\u6a4b\u6b21\u6b6f\u6b7b\u6c37\u6c7a\u6cb9\u6ce2\u6ce8\u6cf3\u6d0b\u6d41\u6d88\u6df1\u6e29\u6e2f\u6e56\u6e6f\u6f22\u70ad\u7269\u7403\u7531\u7533\u754c\u7551\u75c5\u767a\u767b\u76ae\u76bf\u76f8\u770c\u771f\u7740\u77ed\u7814\u793c\u795e\u796d\u798f\u79d2\u7a76\u7ae0\u7ae5\u7b1b\u7b2c\u7b46\u7b49\u7bb1\u7d1a\u7d42\u7dd1\u7df4\u7f8a\u7f8e\u7fd2\u8005\u80b2\u82e6\u8377\u843d\u8449\u85ac\u8840\u8868\u8a69\u8abf\u8ac7\u8c46\u8ca0\u8d77\u8def\u8eab\u8ee2\u8efd\u8fb2\u8fd4\u8ffd\u9001\u901f\u9032\u904a\u904b\u90e8\u90fd\u914d\u9152\u91cd\u9244\u9280\u958b\u9662\u967d\u968e\u96c6\u9762\u984c\u98f2\u9928\u99c5\u9f3b]"), "3").putAll(new UnicodeSet("[\u4e0d\u4e89\u4ed8\u4ee4\u4ee5\u4ef2\u4f1d\u4f4d\u4f4e\u4f8b\u4fbf\u4fe1\u5009\u5019\u501f\u505c\u5065\u5074\u50cd\u5104\u5146\u5150\u5171\u5175\u5178\u51b7\u521d\u5225\u5229\u5237\u526f\u529f\u52a0\u52aa\u52b4\u52c7\u5305\u5352\u5354\u5358\u535a\u5370\u53c2\u53f2\u53f8\u5404\u544a\u5468\u5531\u559c\u5668\u56f2\u56fa\u578b\u5802\u5869\u58eb\u5909\u592b\u5931\u597d\u5b63\u5b6b\u5b8c\u5b98\u5bb3\u5bdf\u5de3\u5dee\u5e0c\u5e2d\u5e2f\u5e95\u5e9c\u5eb7\u5efa\u5f84\u5f92\u5f97\u5fc5\u5ff5\u611b\u6210\u6226\u6298\u6319\u6539\u6551\u6557\u6563\u6599\u65d7\u6628\u666f\u6700\u671b\u672a\u672b\u672d\u6750\u675f\u677e\u679c\u6804\u6848\u6885\u68b0\u6975\u6a19\u6a5f\u6b20\u6b74\u6b8b\u6bba\u6bd2\u6c0f\u6c11\u6c42\u6cbb\u6cd5\u6ce3\u6d45\u6d74\u6e05\u6e80\u6f01\u706f\u7121\u7136\u713c\u7167\u71b1\u7267\u7279\u7523\u7684\u7701\u795d\u7968\u7a2e\u7a4d\u7af6\u7b11\u7ba1\u7bc0\u7c89\u7d00\u7d04\u7d50\u7d66\u7d9a\u7f6e\u8001\u80c3\u8108\u8178\u81e3\u822a\u826f\u82b8\u82bd\u82f1\u83dc\u8857\u8863\u8981\u899a\u89b3\u8a13\u8a66\u8aac\u8ab2\u8b70\u8c61\u8ca8\u8caf\u8cbb\u8cde\u8ecd\u8f2a\u8f9e\u8fba\u9023\u9054\u9078\u90e1\u91cf\u9332\u93e1\u95a2\u9678\u968a\u9759\u9806\u9858\u985e\u98db\u98ef\u990a\u9a13]"), "4").putAll(new UnicodeSet("[\u4e45\u4ecf\u4eee\u4ef6\u4efb\u4f3c\u4f59\u4fa1\u4fdd\u4fee\u4ff5\u500b\u5099\u50cf\u518d\u520a\u5224\u5236\u5238\u5247\u52b9\u52d9\u52e2\u539a\u53e5\u53ef\u55b6\u56e0\u56e3\u5727\u5728\u5747\u57fa\u5831\u5883\u5893\u5897\u5922\u59bb\u5a66\u5bb9\u5bc4\u5bcc\u5c0e\u5c45\u5c5e\u5e03\u5e2b\u5e38\u5e79\u5e8f\u5f01\u5f35\u5f80\u5fa9\u5fb3\u5fd7\u5fdc\u5feb\u6027\u6069\u60c5\u614b\u6163\u627f\u6280\u62db\u6388\u63a1\u63a5\u63d0\u640d\u652f\u653f\u6545\u6575\u65ad\u65e7\u6613\u66b4\u6761\u679d\u67fb\u683c\u685c\u691c\u69cb\u6b66\u6bd4\u6c38\u6cb3\u6db2\u6df7\u6e1b\u6e2c\u6e96\u6f14\u6f54\u707d\u71c3\u7248\u72af\u72b6\u72ec\u7387\u73fe\u7559\u7565\u76ca\u773c\u7834\u78ba\u793a\u7956\u7981\u79fb\u7a0b\u7a0e\u7bc9\u7cbe\u7d20\u7d4c\u7d71\u7d76\u7dbf\u7dcf\u7de8\u7e3e\u7e54\u7f6a\u7fa4\u7fa9\u8015\u8077\u80a5\u80fd\u8208\u820c\u820e\u8853\u885b\u88fd\u8907\u898f\u89e3\u8a2d\u8a31\u8a3c\u8a55\u8b1b\u8b1d\u8b58\u8b77\u8c4a\u8ca1\u8ca7\u8cac\u8cb8\u8cbf\u8cc0\u8cc7\u8cdb\u8cea\u8f38\u8ff0\u8ff7\u9000\u9006\u9020\u904e\u9069\u9178\u9271\u9285\u92ad\u9632\u9650\u967a\u969b\u96d1\u975e\u9810\u9818\u984d\u98fc]"), "5").putAll(new UnicodeSet("[\u4e26\u4e71\u4e73\u4ea1\u4ec1\u4f9b\u4ff3\u5024\u50b7\u512a\u515a\u518a\u51e6\u523b\u5272\u5275\u5287\u52e4\u5371\u5375\u53b3\u53ce\u540e\u5426\u5438\u547c\u5584\u56f0\u5782\u57ce\u57df\u594f\u596e\u59ff\u5b58\u5b5d\u5b85\u5b87\u5b97\u5b99\u5b9d\u5ba3\u5bc6\u5bf8\u5c02\u5c04\u5c06\u5c0a\u5c31\u5c3a\u5c4a\u5c55\u5c64\u5df1\u5dfb\u5e55\u5e72\u5e7c\u5e81\u5ea7\u5ef6\u5f8b\u5f93\u5fd8\u5fe0\u61b2\u6211\u6279\u62c5\u62dd\u62e1\u6368\u63a2\u63a8\u63ee\u64cd\u656c\u6620\u6669\u6696\u66ae\u6717\u673a\u679a\u67d3\u682a\u68d2\u6a21\u6a29\u6a39\u6b32\u6bb5\u6cbf\u6cc9\u6d17\u6d3e\u6e08\u6e90\u6f6e\u6fc0\u7070\u719f\u7247\u73ed\u7570\u7591\u75db\u7687\u76db\u76df\u770b\u7802\u78c1\u79c1\u79d8\u7a40\u7a74\u7a93\u7b4b\u7b56\u7c21\u7cd6\u7cfb\u7d05\u7d0d\u7d14\u7d79\u7e26\u7e2e\u7f72\u7fcc\u8056\u80ba\u80cc\u80f8\u8133\u8179\u81d3\u81e8\u81f3\u82e5\u8457\u84b8\u8535\u8695\u8846\u88c1\u88c5\u88cf\u88dc\u8996\u89a7\u8a0e\u8a2a\u8a33\u8a5e\u8a8c\u8a8d\u8a95\u8aa0\u8aa4\u8ad6\u8af8\u8b66\u8cb4\u8cc3\u907a\u90f5\u90f7\u91dd\u92fc\u9589\u95a3\u964d\u965b\u9664\u969c\u96e3\u9769\u9802\u9aa8]"), "6").putAll(new UnicodeSet("[\u4e08\u4e0e\u4e14\u4e18\u4e19\u4e39\u4e4f\u4e59\u4e7e\u4e86\u4e92\u4e95\u4e9c\u4eab\u4ead\u4ecb\u4ed9\u4ef0\u4f01\u4f0f\u4f10\u4f2f\u4f34\u4f38\u4f3a\u4f46\u4f50\u4f73\u4f75\u4f8d\u4f9d\u4fae\u4faf\u4fb5\u4fc3\u4fca\u4fd7\u4ff8\u5012\u5023\u502b\u5039\u5049\u504f\u5075\u5076\u507d\u508d\u5091\u5098\u50ac\u50b5\u50be\u50d5\u50da\u50e7\u5100\u5112\u511f\u5145\u514b\u514d\u517c\u5192\u5197\u51a0\u51c6\u51cd\u51dd\u51e1\u51f6\u51f8\u51f9\u5203\u5208\u5211\u5230\u523a\u524a\u5256\u525b\u5263\u5264\u5270\u52a3\u52b1\u52be\u52c5\u52d8\u52df\u52e7\u52f2\u52fa\u5301\u5320\u5339\u533f\u5347\u5351\u5353\u5360\u5373\u5374\u5378\u5384\u5398\u53c8\u53ca\u53cc\u53d4\u53d9\u53eb\u53ec\u5409\u540f\u5410\u541f\u542b\u5439\u5448\u5449\u54b2\u54c0\u54f2\u5506\u5507\u5510\u552f\u5553\u559a\u559d\u55aa\u55ab\u55e3\u5606\u5631\u5674\u5687\u56da\u570f\u574a\u5751\u576a\u57a3\u57cb\u57f7\u57f9\u5800\u5805\u5815\u5824\u582a\u5840\u5841\u584a\u5851\u5854\u5857\u585a\u587e\u589c\u58a8\u58b3\u58be\u58c1\u58c7\u58ca\u58cc\u58ee\u58f1\u5947\u5949\u5951\u5954\u5965\u5968\u596a\u5974\u5982-\u5984\u598a\u5999\u59a5\u59a8\u59d3\u59eb\u59fb\u5a01\u5a18\u5a20\u5a2f\u5a46\u5a5a\u5a7f\u5a92\u5ac1\u5acc\u5ae1\u5b22\u5b54\u5b64\u5b9c\u5bb0\u5bb4\u5bb5\u5bc2\u5bdb\u5bdd\u5be1\u5be7\u5be9\u5bee\u5bff\u5c01\u5c09\u5c0b\u5c1a\u5c3c-\u5c3f\u5c48\u5c65\u5c6f\u5c90\u5cac\u5cb3\u5ce0\u5ce1\u5cf0\u5d07\u5d0e\u5d29\u5de1\u5de7\u5de8\u5e06\u5e1d\u5e25\u5e3d\u5e45\u5e63\u5e7b\u5e7d\u5e7e\u5e8a\u5eb6\u5eb8\u5ec3\u5ec9\u5eca\u5ef7\u5f0a\u5f10\u5f14\u5f26\u5f27\u5f3e\u5f69\u5f6b\u5f70\u5f71\u5f7c\u5f81\u5f90\u5fa1\u5faa\u5fae\u5fb4\u5fb9\u5fcc\u5fcd\u5fd9\u6012\u6016\u6020\u602a\u604b\u6050\u6052\u6065\u6068\u606d\u6075\u6094\u609f\u60a0\u60a3\u60a6\u60a9\u60bc\u60d1\u60dc\u60e8\u60f0\u6101\u6109\u611a\u6148\u614c\u614e\u6155\u6162\u6168\u616e\u6170\u6176\u6182\u618e\u61a4\u61a9\u61b6\u61be\u61c7\u61d0\u61f2\u61f8\u6212\u622f\u623b\u623f\u6247\u6249\u6255\u6271\u6276\u6284\u628a\u6291\u6297\u629c\u629e\u62ab\u62b1\u62b5\u62b9\u62bc\u62bd\u62cd\u62d0\u62d2\u62d3\u62d8\u62d9\u62e0\u62ec\u62f7\u6311\u631f\u632f\u633f\u6355\u635c\u636e\u6383\u638c\u6392\u6398\u639b\u63a7\u63aa\u63b2\u63cf\u63da\u63db\u63e1\u63f4\u63fa\u642c\u642d\u643a\u643e\u6442\u6458\u6469\u6483\u64a4\u64ae\u64b2\u64c1\u64e6\u64ec\u653b\u654f\u6562\u6577\u6589\u658e\u6597\u659c\u65a4\u65a5\u65bd\u65cb\u65e2\u65e8\u65ec\u6606\u6607\u662f\u666e\u6676\u6681\u6687\u66a6\u66ab\u66c7\u66f4\u66f9\u66ff\u6715\u6731\u6734\u673d\u6749\u676f\u6790\u67a0\u67a2\u67af\u67b6\u67c4\u67d0\u67d4\u67f3\u6813\u6838\u683d\u6843\u6851\u685f\u68c4\u68cb\u68da\u68df\u68fa\u697c\u6982\u69fd\u6b04\u6b27\u6b3a\u6b3e\u6b53\u6b73\u6b89\u6b8a\u6b96\u6bb4\u6bbb\u6bbf\u6c41\u6c57\u6c5a\u6c5f\u6c88\u6c96\u6ca1\u6ca2\u6cb8\u6cbc\u6cc1\u6cca\u6ccc\u6ce1\u6ce5\u6cf0\u6d1e\u6d25\u6d2a\u6d44\u6d5c\u6d66\u6d6a\u6d6e\u6d78\u6d99\u6daf\u6dbc\u6dd1\u6de1\u6dfb\u6e07\u6e09\u6e0b\u6e13\u6e21\u6e26\u6e7e\u6e7f\u6e9d\u6eb6\u6ec5\u6ecb\u6ed1\u6edd\u6ede\u6ef4\u6f02\u6f06\u6f0f\u6f20\u6f2b\u6f2c\u6f38\u6f5c\u6f5f\u6f64\u6f84\u6fc1\u6fc3\u6feb\u6fef\u702c\u7089\u708a\u708e\u70ba\u70c8\u7126\u7159\u7169\u716e\u71e5\u7206\u7235\u7272\u72a0\u72c2\u72e9\u72ed\u731b\u731f\u732b\u732e\u7336\u733f\u7344\u7363\u7372\u7384\u73cd\u73e0\u7434\u74b0\u74bd\u74f6\u7518\u751a\u7532\u7554\u755c\u755d\u7573\u758e\u75ab\u75b2\u75be\u75c7\u75d8\u75e2\u75f4\u7642\u7652\u7656\u7686\u76c6\u76d7\u76e3\u76e4\u76f2\u76fe\u7720\u773a\u7761\u7763\u77ac\u77db\u77ef\u7815\u7832\u785d\u786b\u786c\u7881\u7891\u78e8\u7901\u790e\u7948\u7949\u7965\u7985\u798d\u79c0\u79df\u79e9\u79f0\u7a1a\u7a32\u7a3c\u7a3f\u7a42\u7a4f\u7a6b\u7a81\u7a83\u7a92\u7aae\u7aaf\u7adc\u7aef\u7b26\u7b52\u7b87\u7bc4\u7be4\u7c3f\u7c4d\u7c8b\u7c92\u7c97\u7c98\u7c9b\u7ca7\u7ce7\u7cfe\u7d0b\u7d1b\u7d21\u7d22\u7d2b\u7d2f\u7d33\u7d39\u7d3a\u7d5e\u7d61\u7d99\u7dad\u7db1\u7db2\u7dca\u7dd2\u7de0\u7de9\u7def\u7e01\u7e04\u7e1b\u7e2b\u7e41\u7e4a\u7e55\u7e6d\u7e70\u7f36\u7f70\u7f77\u7f85\u7fc1\u7ffb\u7ffc\u8010\u8017\u8074\u808c\u8096\u809d\u80a2\u80a9\u80aa\u80af\u80c6\u80ce\u80de\u80f4\u8102\u8105\u811a\u8131\u8139\u8150\u8155\u8170\u819a\u819c\u81a8\u81ed\u81f4\u8217\u821e\u821f\u822c\u8236\u8247\u8266\u828b\u829d\u82b3\u82d7\u8302\u830e\u8352\u8358\u83ca\u83cc\u83d3\u83ef\u846c\u84c4\u8584\u85a6\u85aa\u85ab\u85e9\u85fb\u8650\u865a\u865c\u865e\u868a\u86c7\u86cd\u86ee\u878d\u885d\u8861\u8870\u8877\u888b\u88ab\u88c2\u88d5\u88f8\u8910\u8912\u895f\u8972\u8986\u8987\u89e6\u8a02\u8a17\u8a1f\u8a34\u8a3a\u8a50\u8a54\u8a60\u8a70\u8a72\u8a73\u8a87\u8a89\u8a93\u8a98\u8acb\u8aed\u8aee\u8afe\u8b00\u8b01\u8b04\u8b19\u8b21\u8b39\u8b5c\u8b72\u8c5a\u8c6a\u8c9e\u8ca2\u8ca9\u8cab\u8cc4\u8cca\u8cd3\u8cdc\u8ce0\u8ce2\u8ce6\u8cfc\u8d08\u8d66\u8d74\u8d85\u8d8a\u8da3\u8ddd\u8de1\u8df3\u8df5\u8e0a\u8e0f\u8e8d\u8ecc\u8ed2\u8edf\u8ef8\u8f03\u8f09\u8f1d\u8f29\u8f44\u8f9b\u8fb1\u8fbc\u8fc5\u8fce\u8feb\u8fed\u9003\u900f\u9010\u9013\u9014\u901d\u902e\u9038\u9042\u9045\u9047\u904d\u9055\u9063\u906d\u906e\u9075\u9077\u907f\u9084\u90a6\u90aa\u90b8\u90ca\u90ce\u90ed\u914c\u9154\u9162\u916a\u916c\u9175\u9177\u919c\u91b8\u91c8\u91e3\u920d\u9234\u925b\u9262\u9283\u9291\u9298\u92ed\u92f3\u9318\u9320\u932c\u932f\u935b\u9396\u93ae\u9418\u9451\u9591\u95a5\u95b2\u95d8\u963b\u9644\u9663\u9665\u966a\u9670\u9673\u9675\u9676\u9685\u9686\u968f\u9694\u96a0\u96a3\u96b7\u96bb\u96c4\u96c5\u96c7\u96cc\u96e2\u96f0\u96f6\u96f7\u9700\u9707\u970a\u971c\u9727\u9732\u9774\u97fb\u97ff\u9805\u9811\u9812\u983b\u983c\u9855\u9867\u98e2\u98fd\u98fe\u9913\u9999\u99c4\u99c6\u99d0\u9a0e\u9a12\u9a30\u9a5a\u9ac4\u9aea\u9b3c\u9b42\u9b45\u9b54\u9bae\u9be8\u9d8f\u9e97\u9ebb\u9ed9\u9f13\u9f62]"), "9").freeze();
        cldrFactory = Factory.make(CLDRPaths.MAIN_DIRECTORY, ".*");
        charsets = Charset.availableCharsets();
    }

    public static enum Status {
        O,
        M,
        A,
        S,
        T,
        X,
        N;

    }
}

