/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.StringTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.unicode.cldr.draft.RegexTransformState;
import org.unicode.cldr.draft.Rule;

public class RegexTransform
implements StringTransform {
    private static final char BUCKETSIZE = '\u0101';
    private final List<Rule> rules;
    private final List<Rule>[] buckets = new List[257];

    public RegexTransform(List<Rule> rules2) {
        this.rules = new ArrayList<Rule>(rules2);
        for (int i = 0; i < 257; ++i) {
            this.buckets[i] = new ArrayList<Rule>();
        }
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (Rule rule : this.rules) {
            matchers.add(rule.getPostmatcher(""));
        }
        for (char i = '\u0000'; i < '\ud800'; i = (char)(i + '\u0001')) {
            String s2 = String.valueOf(i);
            int masked = i % 257;
            for (int j = 0; j < matchers.size(); ++j) {
                Matcher matcher = (Matcher)matchers.get(j);
                if (!matcher.reset(s2).matches() && !matcher.hitEnd()) continue;
                this.buckets[masked].add(this.rules.get(j));
            }
        }
    }

    Iterator<Rule> iterator(CharSequence toProcess) {
        char c;
        if (toProcess.length() > 0 && (c = toProcess.charAt(0)) < '\ud800') {
            return this.buckets[c % 257].iterator();
        }
        return this.rules.iterator();
    }

    @Override
    public String transform(String text) {
        return new RegexTransformState(this, text).toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.rules.size(); ++i) {
            result.append(this.rules.get(i)).append("\n");
        }
        return result.toString();
    }
}

