/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.ibm.icu.text.UnicodeSet;
import java.io.BufferedReader;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.TreeSet;
import org.unicode.cldr.draft.FileUtilities;
import org.unicode.cldr.draft.StateMachine;
import org.unicode.cldr.draft.UnicodeSetBuilder;
import org.unicode.cldr.util.PathUtilities;

public class StateMachineTest {
    private static boolean SHOW_MACHINE = false;
    private static int failureCount;
    private static boolean SHOW_IF_ERROR;

    public static void main(String[] args) throws Exception {
        String line;
        System.out.println(PathUtilities.getNormalizedPathString(".", new String[0]));
        BufferedReader in = FileUtilities.openUTF8Reader("../", "cldr-code/java/org/unicode/cldr/draft/UnicodeSetBuilderTests.txt");
        ArrayList<String[]> testLines = new ArrayList<String[]>();
        while ((line = in.readLine()) != null) {
            int commentPos = line.indexOf(35);
            if (commentPos >= 0) {
                line = line.substring(0, commentPos);
            }
            if (line.length() == 0) continue;
            testLines.add(line.trim().split("\\s*;\\s*"));
        }
        in.close();
        UnicodeSetBuilder machine = new UnicodeSetBuilder();
        if (SHOW_MACHINE) {
            System.out.println(machine);
        }
        UnicodeSetBuilder.MyActions[] valuesUsed = UnicodeSetBuilder.MyActions.values();
        TreeSet<String> possibleActions = new TreeSet<String>();
        TreeSet<String> actionsUsed = new TreeSet<String>();
        TreeSet<String> errors = new TreeSet<String>();
        for (UnicodeSetBuilder.MyActions valueUsed : valuesUsed) {
            String string = valueUsed.toString();
            actionsUsed.add(string);
        }
        for (String possible : machine.getActionNames()) {
            if (possible.contains("Error")) {
                errors.add(possible);
                continue;
            }
            possibleActions.add(possible);
        }
        System.out.println("Errors: " + String.valueOf(errors));
        TreeSet<String> temp = new TreeSet<String>();
        temp.addAll(possibleActions);
        temp.removeAll(actionsUsed);
        System.out.println("Unused Actions: " + String.valueOf(temp));
        temp.clear();
        temp.addAll(actionsUsed);
        temp.removeAll(possibleActions);
        System.out.println("Extra Enums: " + String.valueOf(temp));
        ParsePosition parsePosition = new ParsePosition(0);
        failureCount = 0;
        block5: for (String[] testLinePair : testLines) {
            int j;
            String testLine = testLinePair[0];
            if (testLine.startsWith("@")) {
                if (testLine.equals("@show")) {
                    SHOW_MACHINE = true;
                    StateMachine.SHOW_STATE_TRANSITIONS = true;
                    SHOW_IF_ERROR = false;
                    continue;
                }
                if (testLine.equals("@hide")) {
                    SHOW_MACHINE = false;
                    StateMachine.SHOW_STATE_TRANSITIONS = false;
                    SHOW_IF_ERROR = false;
                    continue;
                }
                if (testLine.equals("@showerror")) {
                    SHOW_MACHINE = false;
                    StateMachine.SHOW_STATE_TRANSITIONS = false;
                    SHOW_IF_ERROR = true;
                    continue;
                }
                throw new IllegalArgumentException("Illegal test command: " + testLine);
            }
            String expectedString = testLinePair[testLinePair.length > 1 ? 1 : 0];
            UnicodeSet expected = expectedString.startsWith("[") || expectedString.startsWith("\\") ? new UnicodeSet(expectedString) : null;
            System.out.println();
            System.out.println("Test: " + testLine);
            int i = 0;
            parsePosition.setIndex(0);
            do {
                UnicodeSet result = null;
                String actualString = "<no failure>";
                try {
                    result = machine.parse(testLine, parsePosition);
                }
                catch (Exception e) {
                    actualString = e.getMessage();
                }
                if (expected == null) {
                    if (expectedString.equals(actualString)) continue block5;
                    StateMachineTest.showFailure(testLine, expectedString, "<no failure>");
                    continue block5;
                }
                j = parsePosition.getIndex();
                if (j <= i) {
                    System.out.println("ERROR: " + testLine.substring(0, parsePosition.getErrorIndex()) + "$" + testLine.substring(parsePosition.getErrorIndex()));
                    StateMachineTest.repeatCall(machine, parsePosition, testLine);
                    continue block5;
                }
                if (result.equals(expected)) continue;
                StateMachineTest.showFailure(testLine, expected.toPattern(false), result.toPattern(false));
                StateMachineTest.repeatCall(machine, parsePosition, testLine);
            } while ((i = j) < testLine.length());
        }
        System.out.println();
        System.out.println("TOTAL Failures: " + failureCount);
    }

    private static void repeatCall(UnicodeSetBuilder machine, ParsePosition parsePosition, String testLine) {
        if (!SHOW_IF_ERROR) {
            return;
        }
        boolean oldShow = SHOW_MACHINE;
        SHOW_MACHINE = true;
        StateMachine.SHOW_STATE_TRANSITIONS = true;
        try {
            machine.parse(testLine, parsePosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StateMachine.SHOW_STATE_TRANSITIONS = SHOW_MACHINE = oldShow;
    }

    private static void showFailure(String testLine, String expectedString, String actualString) {
        System.out.println("***\nFAILURE with: " + testLine + "\tExpected: " + expectedString + "\tActual: " + actualString + "\n***");
        ++failureCount;
    }

    static {
        SHOW_IF_ERROR = true;
    }
}

