/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.draft;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.ibm.icu.impl.Row;
import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Counter;
import org.unicode.cldr.util.LanguageTagParser;
import org.unicode.cldr.util.SupplementalDataInfo;

public class XLikelySubtags {
    private static final SupplementalDataInfo SDI = CLDRConfig.getInstance().getSupplementalDataInfo();
    private static final Map<String, Map<String, Row.R2<List<String>, String>>> aliasInfo = SDI.getLocaleAliasInfo();
    private static final Map<String, Row.R2<List<String>, String>> REGION_ALIASES = aliasInfo.get("territory");
    private static final Map<String, Row.R2<List<String>, String>> LANGUAGE_ALIASES = aliasInfo.get("language");
    private static final XLikelySubtags DEFAULT = new XLikelySubtags(SDI.getLikelySubtags(), true);
    private static final boolean SHORT = false;
    final Map<String, Map<String, Map<String, LSR>>> langTable;

    public static final XLikelySubtags getDefault() {
        return DEFAULT;
    }

    public XLikelySubtags(Map<String, String> rawData, boolean skipNoncanonical) {
        this.langTable = this.init(rawData, skipNoncanonical);
    }

    private Map<String, Map<String, Map<String, LSR>>> init(Map<String, String> rawData, boolean skipNoncanonical) {
        HashMultimap<String, String> canonicalToAliasLanguage = HashMultimap.create();
        this.getAliasInfo(LANGUAGE_ALIASES, canonicalToAliasLanguage);
        HashMultimap<String, String> canonicalToAliasRegion = HashMultimap.create();
        this.getAliasInfo(REGION_ALIASES, canonicalToAliasRegion);
        Maker maker = Maker.TREEMAP;
        Map result = (Map)maker.make();
        LanguageTagParser ltp = new LanguageTagParser();
        Splitter bar = Splitter.on('_');
        int last = -1;
        HashMap<LSR, LSR> internCache = new HashMap<LSR, LSR>();
        for (Map.Entry<String, String> sourceTarget : rawData.entrySet()) {
            Collection regionAliases;
            ltp.set(sourceTarget.getKey());
            String language = ltp.getLanguage();
            String script = ltp.getScript();
            String region = ltp.getRegion();
            ltp.set(sourceTarget.getValue());
            String languageTarget = ltp.getLanguage();
            String scriptTarget = ltp.getScript();
            String regionTarget = ltp.getRegion();
            this.set(result, language, script, region, languageTarget, scriptTarget, regionTarget, internCache);
            Collection languageAliases = canonicalToAliasLanguage.get(language);
            if (languageAliases.isEmpty()) {
                languageAliases = Collections.singleton(language);
            }
            if ((regionAliases = canonicalToAliasRegion.get(region)).isEmpty()) {
                regionAliases = Collections.singleton(region);
            }
            for (String languageAlias : languageAliases) {
                for (String regionAlias : regionAliases) {
                    if (languageAlias.equals(language) && regionAlias.equals(region)) continue;
                    this.set(result, languageAlias, script, regionAlias, languageTarget, scriptTarget, regionTarget, internCache);
                }
            }
        }
        this.set(result, "und", "Latn", "", "en", "Latn", "US", internCache);
        Map undScriptMap = (Map)result.get("und");
        Map undEmptyRegionMap = (Map)undScriptMap.get("");
        for (Map.Entry regionEntry : undEmptyRegionMap.entrySet()) {
            LSR value = (LSR)regionEntry.getValue();
            this.set(result, "und", value.script, value.region, value);
        }
        if (!result.containsKey("und")) {
            throw new IllegalArgumentException("failure: base");
        }
        for (Map.Entry langEntry : result.entrySet()) {
            String lang = (String)langEntry.getKey();
            Map scriptMap = (Map)langEntry.getValue();
            if (!scriptMap.containsKey("")) {
                throw new IllegalArgumentException("failure: " + lang);
            }
            for (Map.Entry scriptEntry : scriptMap.entrySet()) {
                String script = (String)scriptEntry.getKey();
                Map regionMap = (Map)scriptEntry.getValue();
                if (regionMap.containsKey("")) continue;
                throw new IllegalArgumentException("failure: " + lang + "-" + script);
            }
        }
        return result;
    }

    private void getAliasInfo(Map<String, Row.R2<List<String>, String>> aliasInfo, Multimap<String, String> canonicalToAlias) {
        for (Map.Entry<String, Row.R2<List<String>, String>> e : aliasInfo.entrySet()) {
            String alias = e.getKey();
            if (alias.contains("_")) continue;
            String canonical = XLikelySubtags.getCanonical(e.getValue());
            canonicalToAlias.put(canonical, alias);
        }
    }

    private static String getCanonical(Row.R2<List<String>, String> aliasAndReason) {
        if (aliasAndReason == null) {
            return null;
        }
        if (((String)aliasAndReason.get1()).equals("overlong")) {
            return null;
        }
        List value = (List)aliasAndReason.get0();
        if (value.size() != 1) {
            return null;
        }
        String canonical = (String)value.iterator().next();
        if (canonical.contains("_")) {
            return null;
        }
        return canonical;
    }

    private void set(Map<String, Map<String, Map<String, LSR>>> langTable, String language, String script, String region, String languageTarget, String scriptTarget, String regionTarget, Map<LSR, LSR> internCache) {
        LSR newValue = new LSR(languageTarget, scriptTarget, regionTarget);
        LSR oldValue = internCache.get(newValue);
        if (oldValue == null) {
            internCache.put(newValue, newValue);
            oldValue = newValue;
        }
        this.set(langTable, language, script, region, oldValue);
    }

    private void set(Map<String, Map<String, Map<String, LSR>>> langTable, String language, String script, String region, LSR newValue) {
        Map<String, Map<String, LSR>> scriptTable = Maker.TREEMAP.getSubtable(langTable, language);
        Map<String, LSR> regionTable = Maker.TREEMAP.getSubtable(scriptTable, script);
        LSR oldValue = regionTable.get(region);
        if (oldValue != null) {
            boolean bl = false;
        }
        regionTable.put(region, newValue);
    }

    public LSR maximize(String source) {
        return this.maximize(ULocale.forLanguageTag(source));
    }

    public LSR maximize(ULocale source) {
        return this.maximize(source.getLanguage(), source.getScript(), source.getCountry());
    }

    public LSR maximize(LSR source) {
        return this.maximize(source.language, source.script, source.region);
    }

    public LSR maximize(String language, String script, String region) {
        LSR result;
        Map<String, LSR> regionTable;
        int retainOldMask = 0;
        Map<String, Map<String, LSR>> scriptTable = this.langTable.get(language);
        if (scriptTable == null) {
            retainOldMask |= 4;
            scriptTable = this.langTable.get("und");
        } else if (!language.equals("und")) {
            retainOldMask |= 4;
        }
        if (script.equals("Zzzz")) {
            script = "";
        }
        if ((regionTable = scriptTable.get(script)) == null) {
            retainOldMask |= 2;
            regionTable = scriptTable.get("");
        } else if (!script.isEmpty()) {
            retainOldMask |= 2;
        }
        if (region.equals("ZZ")) {
            region = "";
        }
        if ((result = regionTable.get(region)) == null) {
            retainOldMask |= 1;
            result = regionTable.get("");
            if (result == null) {
                return null;
            }
        } else if (!region.isEmpty()) {
            retainOldMask |= 1;
        }
        switch (retainOldMask) {
            default: {
                return result;
            }
            case 1: {
                return result.replace(null, null, region);
            }
            case 2: {
                return result.replace(null, script, null);
            }
            case 3: {
                return result.replace(null, script, region);
            }
            case 4: {
                return result.replace(language, null, null);
            }
            case 5: {
                return result.replace(language, null, region);
            }
            case 6: {
                return result.replace(language, script, null);
            }
            case 7: 
        }
        return result.replace(language, script, region);
    }

    private LSR minimizeSubtags(String languageIn, String scriptIn, String regionIn, ULocale.Minimize fieldToFavor) {
        LSR result2;
        LSR result = this.maximize(languageIn, scriptIn, regionIn);
        Map<String, Map<String, LSR>> scriptTable = this.langTable.get(result.language);
        Map<String, LSR> regionTable0 = scriptTable.get("");
        LSR value00 = regionTable0.get("");
        boolean favorRegionOk = false;
        if (result.script.equals(value00.script)) {
            if (result.region.equals(value00.region)) {
                return result.replace(null, "", "");
            }
            if (fieldToFavor == ULocale.Minimize.FAVOR_REGION) {
                return result.replace(null, "", null);
            }
            favorRegionOk = true;
        }
        if ((result2 = this.maximize(languageIn, scriptIn, "")).equals(result)) {
            return result.replace(null, null, "");
        }
        if (favorRegionOk) {
            return result.replace(null, "", null);
        }
        return result;
    }

    private static <V> StringBuilder show(Map<String, V> map, String indent, StringBuilder output) {
        String first = indent.isEmpty() ? "" : "\t";
        for (Map.Entry<String, V> e : map.entrySet()) {
            String key = e.getKey();
            V value = e.getValue();
            output.append(first + (key.isEmpty() ? "\u2205" : key));
            if (value instanceof Map) {
                XLikelySubtags.show((Map)value, indent + "\t", output);
            } else {
                output.append("\t" + CldrUtility.toString(value)).append("\n");
            }
            first = indent;
        }
        return output;
    }

    public String toString() {
        return XLikelySubtags.show(this.langTable, "", new StringBuilder()).toString();
    }

    public static void main(String[] args) {
        System.out.println(LSR.fromMaximalized(ULocale.ENGLISH));
        SupplementalDataInfo sdi = SDI;
        Map<String, String> rawData = sdi.getLikelySubtags();
        XLikelySubtags ls = XLikelySubtags.getDefault();
        System.out.println(ls);
        ls.maximize(new ULocale("iw"));
    }

    private static void add(String target, Counter<String> languageCounter, String language, int count) {
        if (language.equals("aa")) {
            boolean bl = false;
        }
        languageCounter.add(language, count);
    }

    private static void removeSingletons(Set<String> languages, Counter<String> languageCounter) {
        for (String s2 : languageCounter) {
            long count = languageCounter.get(s2);
            if (count > 1L) continue;
            languages.remove(s2);
        }
    }

    public static class LSR {
        public final String language;
        public final String script;
        public final String region;

        public static LSR from(String language, String script, String region) {
            return new LSR(language, script, region);
        }

        public static LSR from(ULocale locale) {
            return new LSR(locale.getLanguage(), locale.getScript(), locale.getCountry());
        }

        public static LSR fromMaximalized(ULocale locale) {
            return LSR.fromMaximalized(locale.getLanguage(), locale.getScript(), locale.getCountry());
        }

        public static LSR fromMaximalized(String language, String script, String region) {
            String canonicalLanguage = XLikelySubtags.getCanonical(LANGUAGE_ALIASES.get(language));
            if (language.equals("mo")) {
                canonicalLanguage = "ro";
            }
            String canonicalRegion = XLikelySubtags.getCanonical(REGION_ALIASES.get(region));
            return DEFAULT.maximize(canonicalLanguage == null ? language : canonicalLanguage, script, canonicalRegion == null ? region : canonicalRegion);
        }

        public LSR(String language, String script, String region) {
            this.language = language;
            this.script = script;
            this.region = region;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.language);
            if (!this.script.isEmpty()) {
                result.append('-').append(this.script);
            }
            if (!this.region.isEmpty()) {
                result.append('-').append(this.region);
            }
            return result.toString();
        }

        public LSR replace(String language2, String script2, String region2) {
            if (language2 == null && script2 == null && region2 == null) {
                return this;
            }
            return new LSR(language2 == null ? this.language : language2, script2 == null ? this.script : script2, region2 == null ? this.region : region2);
        }

        public boolean equals(Object obj) {
            LSR other = (LSR)obj;
            return this.language.equals(other.language) && this.script.equals(other.script) && this.region.equals(other.region);
        }

        public int hashCode() {
            return Objects.hash(this.language, this.script, this.region);
        }
    }

    static abstract class Maker {
        static final Maker HASHMAP = new Maker(){

            public Map<Object, Object> make() {
                return new HashMap<Object, Object>();
            }
        };
        static final Maker TREEMAP = new Maker(){

            public Map<Object, Object> make() {
                return new TreeMap<Object, Object>();
            }
        };

        Maker() {
        }

        abstract <V> V make();

        public <K, V> V getSubtable(Map<K, V> langTable, K language) {
            V scriptTable = langTable.get(language);
            if (scriptTable == null) {
                scriptTable = this.make();
                langTable.put(language, scriptTable);
            }
            return scriptTable;
        }
    }
}

