/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.posix;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import java.io.PrintWriter;
import org.unicode.cldr.posix.POSIXUtilities;
import org.unicode.cldr.util.CLDRFile;

public class POSIX_LCCtype {
    UnicodeSet chars;

    public POSIX_LCCtype(CLDRFile doc, UnicodeSet chars) {
        String SearchLocation = "//ldml/characters/exemplarCharacters";
        UnicodeSet ExemplarCharacters = new UnicodeSet(doc.getWinningValue(SearchLocation));
        boolean ExemplarError = false;
        UnicodeSetIterator it = new UnicodeSetIterator(ExemplarCharacters);
        while (it.next()) {
            if (it.codepoint == -1 || chars.contains(it.codepoint)) continue;
            System.out.println("WARNING: Target codeset does not contain exemplar character : " + POSIXUtilities.POSIXCharName(it.codepoint));
            ExemplarError = true;
        }
        if (ExemplarError) {
            System.out.println("WARNING: Not all exemplar characters are in the target codeset.");
            System.out.println("    The resulting locale source might not compile.");
        }
        this.chars = chars;
    }

    public void write(PrintWriter out) {
        UnicodeSetIterator it;
        int last;
        int item;
        UnicodeSet us;
        out.println("*************");
        out.println("LC_CTYPE");
        out.println("*************");
        out.println();
        String[][] types = new String[][]{{"upper", "[:Uppercase:]"}, {"lower", "[:Lowercase:]"}, {"alpha", "[[:Alphabetic:]-[[:Uppercase:][:Lowercase:]]]"}, {"space", "[:Whitespace:]"}, {"cntrl", "[:Control:]"}, {"graph", "[^[:Whitespace:][:Control:][:Format:][:Surrogate:][:Unassigned:]]"}, {"print", "[^[:Control:][:Format:][:Surrogate:][:Unassigned:]]"}, {"punct", "[:Punctuation:]"}, {"digit", "[0-9]"}, {"xdigit", "[0-9 a-f A-F]"}, {"blank", "[[:Whitespace:]-[\\u000A-\\u000D \\u0085 [:Line_Separator:][:Paragraph_Separator:]]]"}};
        for (int i = 0; i < types.length; ++i) {
            us = new UnicodeSet(types[i][1]).retainAll(this.chars);
            item = 0;
            last = us.size() - 1;
            it = new UnicodeSetIterator(us);
            while (it.next()) {
                if (item == 0) {
                    out.print(types[i][0]);
                }
                out.print("\t" + POSIXUtilities.POSIXCharName(it.codepoint));
                if (item != last) {
                    out.print(";/");
                }
                out.println("");
                ++item;
            }
            out.println();
        }
        UnicodeSet lowers = new UnicodeSet(types[1][1]).retainAll(this.chars);
        us = new UnicodeSet();
        it = new UnicodeSetIterator(this.chars);
        while (it.next()) {
            int upp = UCharacter.toUpperCase(it.codepoint);
            if (upp == it.codepoint || !this.chars.contains(upp) || !lowers.contains(it.codepoint)) continue;
            us.add(it.codepoint);
        }
        item = 0;
        last = us.size() - 1;
        it = new UnicodeSetIterator(us);
        while (it.next()) {
            if (item == 0) {
                out.print("toupper");
            }
            out.print("\t(" + POSIXUtilities.POSIXCharName(it.codepoint) + "," + POSIXUtilities.POSIXCharName(UCharacter.toUpperCase(it.codepoint)) + ")");
            if (item != last) {
                out.print(";/");
            }
            out.println("");
            ++item;
        }
        out.println("");
        UnicodeSet uppers = new UnicodeSet(types[0][1]).retainAll(this.chars);
        us = new UnicodeSet();
        UnicodeSetIterator it2 = new UnicodeSetIterator(this.chars);
        while (it2.next()) {
            int low = UCharacter.toLowerCase(it2.codepoint);
            if (low == it2.codepoint || !this.chars.contains(low) || !uppers.contains(it2.codepoint)) continue;
            us.add(it2.codepoint);
        }
        item = 0;
        last = us.size() - 1;
        it2 = new UnicodeSetIterator(us);
        while (it2.next()) {
            if (item == 0) {
                out.print("tolower");
            }
            out.print("\t(" + POSIXUtilities.POSIXCharName(it2.codepoint) + "," + POSIXUtilities.POSIXCharName(UCharacter.toLowerCase(it2.codepoint)) + ")");
            if (item != last) {
                out.print(";/");
            }
            out.println("");
            ++item;
        }
        out.println();
        out.println("END LC_CTYPE");
        out.println();
        out.println();
    }
}

