/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckConsistentCasing;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleXMLSource;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class CasingInfo {
    private static final Option.Options options = new Option.Options("This program is used to generate casing files for locales.").add("locales", (Object)".*", ".*", "A regex of the locales to generate casing information for").add("summary", null, "generates a summary of the casing for all locales that had casing generated for this run");
    private Map<String, Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag>> casing;
    private List<File> casingDirs = new ArrayList<File>();

    public CasingInfo(Factory factory) {
        for (File f : factory.getSourceDirectories()) {
            this.casingDirs.add(new File(f.getAbsolutePath() + "/../casing"));
        }
        this.casing = CldrUtility.newConcurrentHashMap();
    }

    public CasingInfo() {
        this.casingDirs.add(new File(CLDRPaths.CASING_DIRECTORY));
        this.casing = CldrUtility.newConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag> getLocaleCasing(String localeID) {
        if (!this.casing.containsKey(localeID)) {
            Map<String, Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag>> map = this.casing;
            synchronized (map) {
                String parentID;
                CasingHandler handler = this.loadFromXml(localeID);
                if (handler != null) {
                    handler.addParsedResult(this.casing);
                }
                if (!this.casing.containsKey(localeID) && !(parentID = LocaleIDParser.getSimpleParent(localeID)).equals("root")) {
                    this.casing.put(localeID, this.getLocaleCasing(parentID));
                }
            }
        }
        return this.casing.get(localeID);
    }

    private CasingHandler loadFromXml(String localeID) {
        for (File casingDir : this.casingDirs) {
            File casingFile = new File(casingDir, localeID + ".xml");
            if (!casingFile.isFile()) continue;
            CasingHandler handler = new CasingHandler();
            XMLFileReader xfr = new XMLFileReader().setHandler(handler);
            xfr.read(casingFile.toString(), -1, true);
            return handler;
        }
        return null;
    }

    private Map<String, Boolean> generateCasingInformation(String localePattern) {
        SupplementalDataInfo supplementalDataInfo = SupplementalDataInfo.getInstance();
        Set<String> defaultContentLocales = supplementalDataInfo.getDefaultContentLocales();
        String sourceDirectory = CldrUtility.checkValidDirectory(CLDRPaths.MAIN_DIRECTORY);
        Factory cldrFactory = Factory.make(sourceDirectory, localePattern);
        LinkedHashSet<String> locales = new LinkedHashSet<String>(cldrFactory.getAvailable());
        locales.removeAll(defaultContentLocales);
        UnicodeSet allCaps = new UnicodeSet("[:Lu:]");
        HashMap<String, Boolean> localeUsesCasing = new HashMap<String, Boolean>();
        LocaleIDParser parser = new LocaleIDParser();
        for (String localeID : locales) {
            if (CLDRFile.isSupplementalName(localeID)) continue;
            parser.set(localeID);
            if (parser.getRegion().length() > 0 && !localeID.equals("pt_PT")) {
                System.out.println("Skipping regional locale " + localeID);
                continue;
            }
            CLDRFile file = cldrFactory.make(localeID, true);
            UnicodeSet examplars = file.getExemplarSet("", CLDRFile.WinningChoice.NORMAL);
            localeUsesCasing.put(localeID, examplars.containsSome(allCaps));
            this.createCasingXml(localeID, CheckConsistentCasing.getSamples(file));
        }
        return localeUsesCasing;
    }

    private void createCasingSummary(String outputFile, Map<String, Boolean> localeUsesCasing) {
        PrintWriter out;
        try {
            out = new PrintWriter(outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        out.print(",");
        for (CheckConsistentCasing.Category category : CheckConsistentCasing.Category.values()) {
            out.print("," + category.toString().replace('_', '-'));
        }
        out.println();
        out.print("Locale ID,Case");
        for (int i = 0; i < CheckConsistentCasing.Category.values().length; ++i) {
            out.print("," + i);
        }
        out.println();
        Set<String> locales = this.casing.keySet();
        for (String localeID : locales) {
            out.print(localeID);
            out.print(",");
            out.print(localeUsesCasing.get(localeID) != false ? "Y" : "N");
            Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag> types = this.casing.get(localeID);
            for (CheckConsistentCasing.Category category : CheckConsistentCasing.Category.values()) {
                CheckConsistentCasing.CasingTypeAndErrFlag value = types.get((Object)category);
                out.print("," + String.valueOf((Object)value) == null ? null : Character.valueOf(value.type().toString().charAt(0)));
            }
            out.println();
            out.flush();
        }
        out.close();
    }

    private void createCasingXml(String localeID, Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingType> localeCasing) {
        CasingHandler handler = this.loadFromXml(localeID);
        Map<CheckConsistentCasing.Category, Object> overrides = handler == null ? new EnumMap(CheckConsistentCasing.Category.class) : handler.getOverrides();
        localeCasing.putAll(overrides);
        SimpleXMLSource source = new SimpleXMLSource(localeID);
        for (CheckConsistentCasing.Category category : CheckConsistentCasing.Category.values()) {
            Object path;
            if (category == CheckConsistentCasing.Category.NOT_USED) continue;
            CheckConsistentCasing.CasingType type = localeCasing.get((Object)category);
            if (overrides.containsKey((Object)category)) {
                path = MessageFormat.format("//ldml/metadata/casingData/casingItem[@type=\"{0}\"][@override=\"true\"]", new Object[]{category});
                source.putValueAtPath((String)path, type.toString());
                continue;
            }
            if (type == CheckConsistentCasing.CasingType.other) continue;
            path = "//ldml/metadata/casingData/casingItem[@type=\"" + String.valueOf((Object)category) + "\"]";
            source.putValueAtPath((String)path, type.toString());
        }
        CLDRFile cldrFile = new CLDRFile(source);
        File casingFile = new File(CLDRPaths.GEN_DIRECTORY + "/casing", localeID + ".xml");
        try {
            PrintWriter out = new PrintWriter(casingFile);
            cldrFile.write(out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CasingInfo casingInfo = new CasingInfo();
        options.parse(args, true);
        Map<String, Boolean> localeUsesCasing = casingInfo.generateCasingInformation(options.get("locales").getValue());
        if (options.get("summary").doesOccur()) {
            casingInfo.createCasingSummary(args[0], localeUsesCasing);
        }
    }

    private class CasingHandler
    extends XMLFileReader.SimpleHandler {
        private Pattern localePattern = PatternCache.get("//ldml/identity/language\\[@type=\"(\\w+)\"\\]");
        private String localeID;
        private Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag> caseMap = new EnumMap<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag>(CheckConsistentCasing.Category.class);
        private Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingType> overrideMap = new EnumMap<CheckConsistentCasing.Category, CheckConsistentCasing.CasingType>(CheckConsistentCasing.Category.class);

        private CasingHandler() {
        }

        @Override
        public void handlePathValue(String path, String value) {
            if (path.contains("casingItem")) {
                XPathParts parts = XPathParts.getFrozenInstance(path);
                CheckConsistentCasing.Category category = CheckConsistentCasing.Category.valueOf(parts.getAttributeValue(-1, "type").replace('-', '_'));
                CheckConsistentCasing.CasingType casingType = CheckConsistentCasing.CasingType.valueOf(value);
                boolean errFlag = Boolean.parseBoolean(parts.getAttributeValue(-1, "forceError"));
                for (CheckConsistentCasing.CasingTypeAndErrFlag typeAndFlag : CheckConsistentCasing.CasingTypeAndErrFlag.values()) {
                    if (casingType != typeAndFlag.type() || errFlag != typeAndFlag.flag()) continue;
                    this.caseMap.put(category, typeAndFlag);
                    break;
                }
                if (Boolean.valueOf(parts.getAttributeValue(-1, "override")).booleanValue()) {
                    this.overrideMap.put(category, casingType);
                }
            } else {
                Matcher matcher = this.localePattern.matcher(path);
                if (matcher.matches()) {
                    this.localeID = matcher.group(1);
                }
            }
        }

        public void addParsedResult(Map<String, Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingTypeAndErrFlag>> map) {
            map.put(this.localeID, this.caseMap);
        }

        public Map<CheckConsistentCasing.Category, CheckConsistentCasing.CasingType> getOverrides() {
            return this.overrideMap;
        }
    }
}

