/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.ibm.icu.impl.Relation;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.DateIntervalInfo;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.CoverageLevel2;
import org.unicode.cldr.test.DateOrder;
import org.unicode.cldr.test.ExampleGenerator;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.test.FlexibleDateFromCLDR;
import org.unicode.cldr.test.RelatedDatePathValues;
import org.unicode.cldr.tool.LikelySubtags;
import org.unicode.cldr.util.ApproximateWidth;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.DateTimeCanonicalizer;
import org.unicode.cldr.util.DayPeriodInfo;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.ICUServiceBuilder;
import org.unicode.cldr.util.Level;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.PathHeader;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.PreferredAndAllowedHour;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class CheckDates
extends FactoryCheckCLDR {
    private static final boolean DISABLE = true;
    private static final boolean DEBUG = false;
    private static final boolean DISABLE_DATE_ORDER = true;
    static boolean GREGORIAN_ONLY = CldrUtility.getProperty("GREGORIAN", false);
    private static final Set<String> CALENDARS_FOR_CORES = Set.of("gregorian", "iso8601");
    ICUServiceBuilder icuServiceBuilder = new ICUServiceBuilder();
    DateTimePatternGenerator.FormatParser formatParser = new DateTimePatternGenerator.FormatParser();
    DateTimePatternGenerator dateTimePatternGenerator = DateTimePatternGenerator.getEmptyInstance();
    private CoverageLevel2 coverageLevel;
    private final SupplementalDataInfo sdi = SupplementalDataInfo.getInstance();
    List<CLDRFile> parentCLDRFiles = new ArrayList<CLDRFile>();
    Map<String, DateTimePatternGenerator> dtpgForType = new HashMap<String, DateTimePatternGenerator>();
    private static final int REFCHAR = ApproximateWidth.getWidth("0");
    private Level requiredLevel;
    private String language;
    private String territory;
    private DayPeriodInfo dateFormatInfoFormat;
    private static final String DECIMAL_XPATH = "//ldml/numbers/symbols[@numberSystem='latn']/decimal";
    private static final Pattern HOUR_SYMBOL = PatternCache.get("H{1,2}");
    private static final Pattern MINUTE_SYMBOL = PatternCache.get("mm");
    private static final Pattern YEAR_FIELDS = PatternCache.get("(y|Y|u|U|r){1,5}");
    private static final String CALENDAR_ID_PREFIX = "/calendar[@type=\"";
    private static final String TIME_FORMAT_CHECK_PATH = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]";
    Map<String, Map<DateOrder, String>> pathsWithConflictingOrder2sample;
    BreakIterator bi;
    FlexibleDateFromCLDR flexInfo;
    Collection<String> redundants = new HashSet<String>();
    CLDRFile.Status status = new CLDRFile.Status();
    private static final Pattern datePatternDoesntEndsWithDigits = Pattern.compile(".*(MMM|LLL|[^yd])");
    private static final XPathParts timeParts = XPathParts.getFrozenInstance("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/timeFormats/timeFormatLength[@type=\"short\"]/timeFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
    private static final XPathParts dateParts = XPathParts.getFrozenInstance("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateFormats/dateFormatLength[@type=\"short\"]/dateFormat[@type=\"standard\"]/pattern[@type=\"standard\"]");
    private static final XPathParts availableParts = XPathParts.getFrozenInstance("//ldml/dates/calendars/calendar[@type=\"generic\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"yyyyQQQ\"]");
    private static final int calendarIndex = timeParts.findElement("calendar");
    private static final int dateFormatLengthIndex = timeParts.findElement("dateFormatLength");
    private static final int dateFormatIndex = timeParts.findElement("timeFormat");
    static final Set<Integer> expectedField = ImmutableSet.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5), Integer.valueOf(4), new Integer[]{7, 6, 11, 12, 13, 10, 15});
    static final List<Integer> toOrder = Lists.reverse(List.copyOf(expectedField));
    static final Pattern HACK_CONFLICTING = PatternCache.get("Conflicting fields:\\s+M+,\\s+l");
    static final SimpleDateFormat neutralFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", ULocale.ENGLISH);
    static final Map<DateOrTime, Relation<DateTimeLengths, String>> STOCK_PATTERNS;
    static final String AVAILABLE_PREFIX = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"";
    static final String AVAILABLE_SUFFIX = "\"]";
    static final String APPEND_TIMEZONE = "//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/appendItems/appendItem[@request=\"Timezone\"]";
    static final Set<String> YgLanguages;
    static final Pattern[] dateTimePatterns;
    static final String[] dateTimeMessage;

    public CheckDates(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        if (cldrFileToCheck == null) {
            return this;
        }
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        this.icuServiceBuilder.setCldrFile(this.getResolvedCldrFileToCheck());
        try {
            this.bi = BreakIterator.getCharacterInstance(new ULocale(cldrFileToCheck.getLocaleID()));
        }
        catch (RuntimeException e) {
            this.bi = BreakIterator.getCharacterInstance(new ULocale(""));
        }
        CLDRFile resolved = this.getResolvedCldrFileToCheck();
        this.flexInfo = new FlexibleDateFromCLDR();
        this.flexInfo.set(resolved);
        String decimal = resolved.getWinningValue(DECIMAL_XPATH);
        if (decimal != null) {
            this.flexInfo.checkFlexibles(DECIMAL_XPATH, decimal, DECIMAL_XPATH);
        }
        String localeID = cldrFileToCheck.getLocaleID();
        LocaleIDParser lp = new LocaleIDParser();
        this.territory = lp.set(localeID).getRegion();
        this.language = lp.getLanguage();
        if (this.territory == null || this.territory.isEmpty()) {
            if (this.language.equals("root")) {
                this.territory = "001";
            } else {
                CLDRLocale loc = CLDRLocale.getInstance(localeID);
                CLDRLocale defContent = this.sdi.getDefaultContentFromBase(loc);
                this.territory = defContent == null ? "001" : defContent.getCountry();
                if ("001".equals(this.territory) && "ar".equals(this.language)) {
                    this.territory = "EG";
                }
            }
        }
        this.coverageLevel = CoverageLevel2.getInstance(this.sdi, localeID);
        this.requiredLevel = options.getRequiredLevel(localeID);
        Iterator<String> it = resolved.iterator("//ldml/dates/calendars/calendar[@type=\"gregorian\"]");
        while (it.hasNext()) {
            String path = it.next();
            String value = resolved.getWinningValue(path);
            String fullPath = resolved.getFullXPath(path);
            try {
                this.flexInfo.checkFlexibles(path, value, fullPath);
            }
            catch (Exception e) {
                String message = e.getMessage();
                CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(message.contains("Conflicting fields") ? CheckCLDR.CheckStatus.Subtype.dateSymbolCollision : CheckCLDR.CheckStatus.Subtype.internalError).setMessage(message);
                possibleErrors.add(item);
            }
        }
        this.redundants.clear();
        this.flexInfo.getRedundants(this.redundants);
        this.dateFormatInfoFormat = this.sdi.getDayPeriods(DayPeriodInfo.Type.format, cldrFileToCheck.getLocaleID());
        this.parentCLDRFiles.clear();
        this.parentCLDRFiles.add(cldrFileToCheck);
        while ((localeID = LocaleIDParser.getParent(localeID)) != null) {
            CLDRFile resolvedParentCLDRFile = this.getFactory().make(localeID, true);
            this.parentCLDRFiles.add(resolvedParentCLDRFile);
        }
        this.dtpgForType.clear();
        return this;
    }

    private String stripPrefix(String s2) {
        if (s2 != null) {
            int prefEnd = s2.lastIndexOf(" ");
            if (prefEnd < 0 || prefEnd >= 3) {
                prefEnd = s2.lastIndexOf("\u2019");
            }
            if (prefEnd >= 0 && prefEnd < 3) {
                return s2.substring(prefEnd + 1);
            }
        }
        return s2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        block58: {
            String errorMessage;
            CheckCLDR.CheckStatus item;
            Map<DateOrder, String> problem;
            if (fullPath == null) {
                return this;
            }
            if (value == null) {
                return this;
            }
            XPathParts parts = XPathParts.getFrozenInstance(fullPath);
            if (!path.contains("/dates") || path.endsWith("/default") || path.endsWith("/alias")) {
                return this;
            }
            if (!this.accept(result)) {
                return this;
            }
            if (TIME_FORMAT_CHECK_PATH.equals(fullPath)) {
                this.checkTimeFormatMatchesRegion(value, result);
            }
            String sourceLocale = this.getCldrFileToCheck().getSourceLocaleID(path, this.status);
            if (!path.equals(this.status.pathWhereFound) || !sourceLocale.equals(this.getCldrFileToCheck().getLocaleID())) {
                return this;
            }
            if (this.pathsWithConflictingOrder2sample != null && (problem = this.pathsWithConflictingOrder2sample.get(path)) != null) {
                item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("The ordering of date fields is inconsistent with others: {0}", this.getValues(this.getResolvedCldrFileToCheck(), problem.values()));
                result.add(item);
            }
            if ((errorMessage = CheckDates.checkIso8601(path, value)) != null) {
                item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage(errorMessage);
                result.add(item);
            }
            try {
                DateTimeCanonicalizer.DateTimePatternType dateTypePatternType;
                CheckCLDR.CheckStatus item2;
                String abbrValue;
                String pathToAbbr;
                String wideValue;
                String pathToWide;
                if (path.contains("[@type=\"abbreviated\"]")) {
                    Set<String> grouping;
                    pathToWide = path.replace("[@type=\"abbreviated\"]", "[@type=\"wide\"]");
                    wideValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToWide);
                    if (wideValue != null && this.isTooMuchWiderThan(value, wideValue)) {
                        CheckCLDR.CheckStatus item22 = new CheckCLDR.CheckStatus().setCause(this).setMainType(this.errorOrIfBuildWarning()).setSubtype(CheckCLDR.CheckStatus.Subtype.abbreviatedDateFieldTooWide).setMessage("Abbreviated value \"{0}\" can't be longer than the corresponding wide value \"{1}\"", value, wideValue);
                        result.add(item22);
                    }
                    if ((grouping = LogicalGrouping.getPaths(this.getCldrFileToCheck(), path)) != null) {
                        for (String lgPath : grouping) {
                            void var23_43;
                            String lgPathValue = this.getCldrFileToCheck().getWinningValueWithBailey(lgPath);
                            if (lgPathValue == null) continue;
                            String lgPathToWide = lgPath.replace("[@type=\"abbreviated\"]", "[@type=\"wide\"]");
                            String lgPathWideValue = this.getCldrFileToCheck().getWinningValueWithBailey(lgPathToWide);
                            String thisValueStripped = this.stripPrefix(value);
                            String wideValueStripped = this.stripPrefix(wideValue);
                            String lgPathValueStripped = this.stripPrefix(lgPathValue);
                            String lgPathWideValueStripped = this.stripPrefix(lgPathWideValue);
                            boolean thisPathHasPeriod = value.contains(".");
                            boolean lgPathHasPeriod = lgPathValue.contains(".");
                            if (thisValueStripped.equalsIgnoreCase(wideValueStripped) || lgPathValueStripped.equalsIgnoreCase(lgPathWideValueStripped) || thisPathHasPeriod == lgPathHasPeriod) continue;
                            CheckCLDR.CheckStatus.Type type = CheckCLDR.CheckStatus.errorType;
                            if (path.contains("dayPeriod")) {
                                CheckCLDR.CheckStatus.Type type2 = CheckCLDR.CheckStatus.warningType;
                            }
                            CheckCLDR.CheckStatus checkStatus = new CheckCLDR.CheckStatus().setCause(this).setMainType((CheckCLDR.CheckStatus.Type)var23_43).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentPeriods).setMessage("Inconsistent use of periods in abbreviations for this section.");
                            result.add(checkStatus);
                            break;
                        }
                    }
                } else if (path.contains("[@type=\"narrow\"]")) {
                    pathToAbbr = path.replace("[@type=\"narrow\"]", "[@type=\"abbreviated\"]");
                    abbrValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToAbbr);
                    if (abbrValue != null && this.isTooMuchWiderThan(value, abbrValue)) {
                        item2 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.narrowDateFieldTooWide).setMessage("Narrow value \"{0}\" shouldn't be longer than the corresponding abbreviated value \"{1}\"", value, abbrValue);
                        result.add(item2);
                    }
                } else if (path.contains("[@type=\"short\"]")) {
                    pathToAbbr = path.replace("[@type=\"short\"]", "[@type=\"abbreviated\"]");
                    abbrValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToAbbr);
                    String pathToNarrow = path.replace("[@type=\"short\"]", "[@type=\"narrow\"]");
                    String narrowValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToNarrow);
                    if (abbrValue != null && this.isTooMuchWiderThan(value, abbrValue) && value.length() > abbrValue.length() || narrowValue != null && this.isTooMuchWiderThan(narrowValue, value) && narrowValue.length() > value.length()) {
                        String compareValue;
                        String message;
                        if (abbrValue != null && this.isTooMuchWiderThan(value, abbrValue) && value.length() > abbrValue.length()) {
                            message = "Short value \"{0}\" can't be longer than the corresponding abbreviated value \"{1}\"";
                            compareValue = abbrValue;
                        } else {
                            message = "Short value \"{0}\" can't be shorter than the corresponding narrow value \"{1}\"";
                            compareValue = narrowValue;
                        }
                        CheckCLDR.CheckStatus item4 = new CheckCLDR.CheckStatus().setCause(this).setMainType(this.errorOrIfBuildWarning()).setSubtype(CheckCLDR.CheckStatus.Subtype.shortDateFieldInconsistentLength).setMessage(message, value, compareValue);
                        result.add(item4);
                    }
                } else if (path.contains("/eraNarrow")) {
                    pathToAbbr = path.replace("/eraNarrow", "/eraAbbr");
                    abbrValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToAbbr);
                    if (abbrValue != null && this.isTooMuchWiderThan(value, abbrValue)) {
                        item2 = new CheckCLDR.CheckStatus().setCause(this).setMainType(this.errorOrIfBuildWarning()).setSubtype(CheckCLDR.CheckStatus.Subtype.narrowDateFieldTooWide).setMessage("Narrow value \"{0}\" can't be longer than the corresponding abbreviated value \"{1}\"", value, abbrValue);
                        result.add(item2);
                    }
                } else if (path.contains("/eraAbbr")) {
                    pathToWide = path.replace("/eraAbbr", "/eraNames");
                    wideValue = this.getCldrFileToCheck().getWinningValueWithBailey(pathToWide);
                    if (wideValue != null && this.isTooMuchWiderThan(value, wideValue)) {
                        item2 = new CheckCLDR.CheckStatus().setCause(this).setMainType(this.errorOrIfBuildWarning()).setSubtype(CheckCLDR.CheckStatus.Subtype.abbreviatedDateFieldTooWide).setMessage("Abbreviated value \"{0}\" can't be longer than the corresponding wide value \"{1}\"", value, wideValue);
                        result.add(item2);
                    }
                }
                String failure = this.flexInfo.checkValueAgainstSkeleton(path, value);
                if (failure != null) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(this.errorOrIfBuildWarning()).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage(failure));
                }
                String collisionPrefix = "//ldml/dates/calendars/calendar";
                if (path.startsWith("//ldml/dates/calendars/calendar")) {
                    int pos;
                    if (parts.containsElement("dateTimeFormats") && !parts.containsElement("appendItems")) {
                        this.checkDateTimeFormats(path, parts, value, result);
                    }
                    if ((pos = path.indexOf(AVAILABLE_SUFFIX)) >= 0 && !this.skipPath(path)) {
                        pos += 2;
                        String myType = this.getLastType(path);
                        if (myType != null) {
                            String myMainType = this.getMainType(path);
                            String calendarPrefix = path.substring(0, pos);
                            boolean endsWithDisplayName = path.endsWith("displayName");
                            HashSet<String> retrievedPaths = new HashSet<String>();
                            this.getResolvedCldrFileToCheck().getPathsWithValue(value, calendarPrefix, null, retrievedPaths);
                            if (retrievedPaths.size() >= 2) {
                                DayPeriodInfo.Type type = null;
                                DayPeriodInfo.DayPeriod dayPeriod = null;
                                boolean isDayPeriod = path.contains("dayPeriod");
                                if (isDayPeriod) {
                                    type = DayPeriodInfo.Type.fromString(parts.getAttributeValue(5, "type"));
                                    dayPeriod = DayPeriodInfo.DayPeriod.valueOf(parts.getAttributeValue(-1, "type"));
                                }
                                HashSet<String> filteredPaths = new HashSet<String>();
                                Output<Integer> sampleError = new Output<Integer>();
                                for (String string : retrievedPaths) {
                                    DayPeriodInfo.DayPeriod itemDayPeriod;
                                    DayPeriodInfo.Type itemType;
                                    String mainType;
                                    String otherType;
                                    XPathParts xPathParts = XPathParts.getFrozenInstance(string);
                                    if (string.equals(path) || this.skipPath(string) || endsWithDisplayName != string.endsWith("displayName") || xPathParts.containsElement("alias") || myType.equals(otherType = this.getLastType(string)) || !myMainType.equals(mainType = this.getMainType(string)) || isDayPeriod && !this.dateFormatInfoFormat.collisionIsError(type, dayPeriod, itemType = DayPeriodInfo.Type.fromString(xPathParts.getAttributeValue(5, "type")), itemDayPeriod = DayPeriodInfo.DayPeriod.valueOf(xPathParts.getAttributeValue(-1, "type")), sampleError)) continue;
                                    filteredPaths.add(string);
                                }
                                if (!filteredPaths.isEmpty()) {
                                    TreeSet<String> others = new TreeSet<String>();
                                    for (String string : filteredPaths) {
                                        PathHeader pathHeader = this.getPathHeaderFactory().fromPath(string);
                                        others.add(pathHeader.getHeaderCode());
                                    }
                                    CheckCLDR.CheckStatus.Type type3 = this.getPhase() == CheckCLDR.Phase.SUBMISSION || this.getPhase() == CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.warningType : CheckCLDR.CheckStatus.errorType;
                                    CheckCLDR.CheckStatus checkStatus = new CheckCLDR.CheckStatus().setCause(this).setMainType(type3).setSubtype(CheckCLDR.CheckStatus.Subtype.dateSymbolCollision);
                                    if (sampleError.value == null) {
                                        checkStatus.setMessage("The date value \u201c{0}\u201d is the same as what is used for a different item: {1}", value, ((Object)others).toString());
                                    } else {
                                        checkStatus.setMessage("The date value \u201c{0}\u201d is the same as what is used for a different item: {1}. Sample problem: {2}", value, ((Object)others).toString(), (Integer)sampleError.value / 3600000);
                                    }
                                    result.add(checkStatus);
                                }
                            }
                        }
                    }
                }
                if (DateTimeCanonicalizer.DateTimePatternType.STOCK_AVAILABLE_INTERVAL_PATTERNS.contains((Object)(dateTypePatternType = DateTimeCanonicalizer.DateTimePatternType.fromPath(path)))) {
                    boolean patternBasicallyOk = false;
                    try {
                        this.formatParser.set(value);
                        patternBasicallyOk = true;
                    }
                    catch (RuntimeException e) {
                        String message = e.getMessage();
                        CheckCLDR.CheckStatus item6 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern);
                        if (message.contains("Illegal datetime field:")) {
                            item6.setMessage(message);
                        } else {
                            item6.setMessage("Illegal date format pattern {0}", e);
                        }
                        result.add(item6);
                    }
                    if (patternBasicallyOk) {
                        this.checkPattern(dateTypePatternType, path, value, result);
                    }
                    break block58;
                }
                if (path.contains("datetimeSkeleton") && !path.contains("[@alt=")) {
                    int startIndex = path.indexOf(CALENDAR_ID_PREFIX);
                    if (startIndex > 0) {
                        int endIndex = path.indexOf(AVAILABLE_SUFFIX, startIndex += CALENDAR_ID_PREFIX.length());
                        String calendarType = path.substring(startIndex, endIndex);
                        DateTimePatternGenerator dtpg = this.getDTPGForCalendarType(calendarType);
                        String patternFromSkeleton = dtpg.getBestPattern(value);
                        String patternPath = path.replace("/datetimeSkeleton", "/pattern[@type=\"standard\"]");
                        String patternStock = this.getCldrFileToCheck().getWinningValue(patternPath);
                        if (!patternFromSkeleton.equals(patternStock)) {
                            CheckCLDR.CheckStatus item7 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentDatePattern).setMessage("Pattern \"{0}\" from datetimeSkeleton should match corresponding standard pattern \"{1}\", adjust availableFormats to fix.", patternFromSkeleton, patternStock);
                            result.add(item7);
                        }
                    }
                } else if (path.contains("hourFormat")) {
                    int semicolonPos = value.indexOf(59);
                    if (semicolonPos < 0) {
                        CheckCLDR.CheckStatus item8 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("Value should contain a positive hour format and a negative hour format separated by a semicolon.");
                        result.add(item8);
                    } else {
                        String[] formats = value.split(";");
                        if (formats[0].equals(formats[1])) {
                            CheckCLDR.CheckStatus item9 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("The hour formats should not be the same.");
                            result.add(item9);
                        } else {
                            this.checkHasHourMinuteSymbols(formats[0], result);
                            this.checkHasHourMinuteSymbols(formats[1], result);
                        }
                    }
                }
            }
            catch (ParseException e) {
                CheckCLDR.CheckStatus item10 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("ParseException in creating date format {0}", e);
                result.add(item10);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg != null && HACK_CONFLICTING.matcher(msg).find()) break block58;
                CheckCLDR.CheckStatus item11 = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("Error in creating date format {0}", e);
                result.add(item11);
            }
        }
        return this;
    }

    private void checkDateTimeFormats(String path, XPathParts parts, String value, List<CheckCLDR.CheckStatus> result) {
        XPathParts currentDateParts;
        if (!value.contains("}{")) {
            return;
        }
        if ("relative".equals(parts.getAttributeValue(dateFormatIndex, "type"))) {
            return;
        }
        String length = parts.getAttributeValue(dateFormatLengthIndex, "type");
        String calendar = parts.getAttributeValue(calendarIndex, "type");
        CLDRFile resolvedCldrFile = this.getResolvedCldrFileToCheck();
        String dateValue = resolvedCldrFile.getStringValue((currentDateParts = dateParts.cloneAsThawed().setAttribute(calendarIndex, "type", calendar).setAttribute(dateFormatLengthIndex, "type", length)).toString());
        if (dateValue == null) {
            throw new IllegalArgumentException("Missing value: " + String.valueOf(currentDateParts));
        }
        String mergedPattern = value.replace("{1}", dateValue).replace("{0}", "HH\u2026");
        CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("The date and time must not have adjacent integers. This pattern could produce {0}", mergedPattern);
        result.add(item);
    }

    private void checkTimeFormatMatchesRegion(String value, List<CheckCLDR.CheckStatus> result) {
        char[] timeCycleChars;
        Map<String, String> likelySubtags;
        String localeID = this.getResolvedCldrFileToCheck().getLocaleID();
        if ("root".equals(localeID)) {
            return;
        }
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getEmptyInstance();
        Map<String, PreferredAndAllowedHour> timeData = this.sdi.getTimeData();
        String jPattern = this.getRegionHourFormat(timeData, localeID, likelySubtags = this.sdi.getLikelySubtags());
        if (jPattern == null) {
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentTimePattern).setMessage("No hour format found");
            result.add(item);
            return;
        }
        String shortPatSkeleton = dtpg.getBaseSkeleton(value);
        String jPatSkeleton = dtpg.getBaseSkeleton(jPattern);
        for (char timeCycleChar : timeCycleChars = new char[]{'H', 'h', 'K', 'k'}) {
            if (jPatSkeleton.indexOf(timeCycleChar) < 0 || shortPatSkeleton.indexOf(timeCycleChar) >= 0) continue;
            String message = "Time format does not match region; expected " + timeCycleChar + " in the value " + value;
            CheckCLDR.CheckStatus item = new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentTimePattern).setMessage(message);
            result.add(item);
            return;
        }
    }

    private String getRegionHourFormat(Map<String, PreferredAndAllowedHour> timeData, String localeID, Map<String, String> likelySubtags) {
        PreferredAndAllowedHour prefAndAllowedHr = timeData.get(localeID);
        if (prefAndAllowedHr == null) {
            LocaleIDParser lp = new LocaleIDParser();
            String region = lp.set(localeID).getRegion();
            if (region == null || region.isEmpty()) {
                String loc2 = likelySubtags.get(localeID);
                if (loc2 != null && !loc2.isEmpty()) {
                    region = lp.set(loc2).getRegion();
                }
                if (region == null || region.isEmpty()) {
                    String locMax = new LikelySubtags().maximize(localeID);
                    region = lp.set(locMax).getRegion();
                }
            }
            if ((prefAndAllowedHr = timeData.get(region)) == null && (prefAndAllowedHr = timeData.get("001")) == null) {
                return null;
            }
        }
        return prefAndAllowedHr.preferred.base.name();
    }

    public static String checkIso8601(String path, String value) {
        XPathParts parts = XPathParts.getFrozenInstance(path);
        if (!"iso8601".equals(parts.getAttributeValue(3, "type"))) {
            return null;
        }
        String key = parts.getElement(5);
        boolean isInterval = false;
        switch (key) {
            case "dateTimeFormatLength": {
                int index0 = value.indexOf("{0}");
                int index1 = value.indexOf("{1}");
                if (index0 < index1) {
                    return "Put the {1} field (the date) before the {1} field (the time), in a YMD (Year-First) calendar.";
                }
                return null;
            }
            case "appendItem": 
            case "dateFormatLength": 
            case "timeFormatLength": 
            case "availableFormats": {
                break;
            }
            case "intervalFormats": {
                isInterval = true;
                break;
            }
            default: {
                return null;
            }
        }
        String intervalPosition = "1st";
        DateTimePatternGenerator.FormatParser parser = new DateTimePatternGenerator.FormatParser();
        DateTimePatternGenerator.VariableField lastField = null;
        LinkedHashSet<Integer> fieldTypesSoFar = new LinkedHashSet<Integer>();
        for (Object p : parser.set(value).getItems()) {
            int lastType;
            if (!(p instanceof DateTimePatternGenerator.VariableField)) continue;
            DateTimePatternGenerator.VariableField field = (DateTimePatternGenerator.VariableField)p;
            int type = field.getType();
            if (!expectedField.contains(type)) {
                return "Field " + String.valueOf(field) + " is not allowed in a YMD (Year-First) calendar.";
            }
            if (fieldTypesSoFar.contains(type)) {
                if (isInterval && intervalPosition.equals("1st")) {
                    intervalPosition = "2nd";
                    fieldTypesSoFar.clear();
                    lastField = null;
                } else {
                    return "Field " + String.valueOf(field) + " is the same type as a previous field.";
                }
            }
            if (type == 1 && field.toString().length() == 2) {
                return "Field " + String.valueOf(field) + " is incorrect. For a YMD (Year-First) calendar, the year field cannot be truncated to 2 digits.";
            }
            if (lastField != null && toOrder.indexOf(lastType = lastField.getType()) < toOrder.indexOf(type)) {
                return "Field " + String.valueOf(lastField) + " cannot come before field " + String.valueOf(field) + (String)(isInterval ? " in the " + intervalPosition + " part of the range" : "") + ". A YMD (Year-First) calendar is special: bigger fields must come before smaller ones even when it feels unnatural in your language.  Change the text separating the fields as best you can.";
            }
            fieldTypesSoFar.add(type);
            lastField = field;
        }
        return null;
    }

    public CheckCLDR.CheckStatus.Type errorOrIfBuildWarning() {
        return this.getPhase() != CheckCLDR.Phase.BUILD ? CheckCLDR.CheckStatus.errorType : CheckCLDR.CheckStatus.warningType;
    }

    private boolean isTooMuchWiderThan(String shortString, String longString) {
        return ApproximateWidth.getWidth(shortString) > ApproximateWidth.getWidth(longString) + REFCHAR / 3;
    }

    private void checkHasHourMinuteSymbols(String value, List<CheckCLDR.CheckStatus> result) {
        boolean hasHourSymbol = HOUR_SYMBOL.matcher(value).find();
        boolean hasMinuteSymbol = MINUTE_SYMBOL.matcher(value).find();
        if (!hasHourSymbol && !hasMinuteSymbol) {
            result.add(this.createErrorCheckStatus().setMessage("The hour and minute symbols are missing from {0}.", value));
        } else if (!hasHourSymbol) {
            result.add(this.createErrorCheckStatus().setMessage("The hour symbol (H or HH) should be present in {0}.", value));
        } else if (!hasMinuteSymbol) {
            result.add(this.createErrorCheckStatus().setMessage("The minute symbol (mm) should be present in {0}.", value));
        }
    }

    private CheckCLDR.CheckStatus createErrorCheckStatus() {
        return new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern);
    }

    public boolean skipPath(String path) {
        return path.contains("arrow") || path.contains("/availableFormats") || path.contains("/interval") || path.contains("/dateTimeFormat");
    }

    public String getLastType(String path) {
        int secondType = path.lastIndexOf("[@type=\"");
        if (secondType < 0) {
            return null;
        }
        int secondEnd = path.indexOf(AVAILABLE_SUFFIX, secondType += 8);
        if (secondEnd < 0) {
            return null;
        }
        return path.substring(secondType, secondEnd);
    }

    public String getMainType(String path) {
        int secondType = path.indexOf("\"]/");
        if (secondType < 0) {
            return null;
        }
        int secondEnd = path.indexOf("/", secondType += 3);
        if (secondEnd < 0) {
            return null;
        }
        return path.substring(secondType, secondEnd);
    }

    private String getValues(CLDRFile resolvedCldrFileToCheck, Collection<String> values) {
        TreeSet<String> results = new TreeSet<String>();
        for (String path : values) {
            String stringValue = resolvedCldrFileToCheck.getStringValue(path);
            if (stringValue == null) continue;
            results.add(stringValue);
        }
        return "{" + Joiner.on("},{").join(results) + "}";
    }

    @Override
    public CheckCLDR handleGetExamples(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (!path.contains("/dates") || !path.contains("gregorian")) {
            return this;
        }
        try {
            if (path.contains("/pattern") && !path.contains("/dateTimeFormat") || path.contains("/dateFormatItem")) {
                this.checkPattern2(path, value, result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private List<Object> updateVariableFieldInList(List<Object> items) {
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            Object object = items.get(itemIndex);
            if (!(object instanceof DateTimePatternGenerator.VariableField)) continue;
            items.set(itemIndex, new MyVariableField(object.toString()));
        }
        return items;
    }

    private void checkPattern(DateTimeCanonicalizer.DateTimePatternType dateTypePatternType, String path, String value, List<CheckCLDR.CheckStatus> result) throws ParseException {
        GyState expected;
        GyState actual;
        String id;
        String skeleton = this.dateTimePatternGenerator.getSkeletonAllowingDuplicates(value);
        String skeletonCanonical = this.dateTimePatternGenerator.getCanonicalSkeletonAllowingDuplicates(value);
        if (value.contains("MMM.") || value.contains("LLL.") || value.contains("E.") || value.contains("eee.") || value.contains("ccc.") || value.contains("QQQ.") || value.contains("qqq.")) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("Your pattern ({0}) is probably incorrect; abbreviated month/weekday/quarter names that need a period should include it in the name, rather than adding it to the pattern.", value));
        }
        XPathParts pathParts = XPathParts.getFrozenInstance(path);
        String calendar = pathParts.findAttributeValue("calendar", "type");
        switch (dateTypePatternType) {
            case AVAILABLE: {
                id = pathParts.getAttributeValue(-1, "id");
                break;
            }
            case INTERVAL: {
                id = pathParts.getAttributeValue(-2, "id");
                break;
            }
            case STOCK: {
                id = pathParts.getAttributeValue(-3, "type");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (dateTypePatternType == DateTimeCanonicalizer.DateTimePatternType.AVAILABLE || dateTypePatternType == DateTimeCanonicalizer.DateTimePatternType.INTERVAL) {
            String failureMessage;
            String idCanonical = this.dateTimePatternGenerator.getCanonicalSkeletonAllowingDuplicates(id);
            if (skeleton.isEmpty()) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("Your pattern ({1}) is incorrect for ID ({0}). You need to supply a pattern according to https://cldr.unicode.org/translation/date-time/date-time-patterns.", id, value));
            } else if (!this.dateTimePatternGenerator.skeletonsAreSimilar(idCanonical, skeletonCanonical)) {
                String fixedValue = this.dateTimePatternGenerator.replaceFieldTypes(value, id);
                String fixedValueCanonical = this.dateTimePatternGenerator.getCanonicalSkeletonAllowingDuplicates(fixedValue);
                String valueFromId = null;
                if (!this.dateTimePatternGenerator.skeletonsAreSimilar(idCanonical, fixedValueCanonical)) {
                    String availableFormatPath = "//ldml/dates/calendars/calendar[@type=\"" + calendar + "\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"" + id + AVAILABLE_SUFFIX;
                    valueFromId = this.getCldrFileToCheck().getWinningValueWithBailey(availableFormatPath);
                    if (valueFromId != null && (valueFromId.equals(value) || valueFromId.equals(fixedValue))) {
                        valueFromId = null;
                    }
                    DateTimePatternGenerator.FormatParser idCanonFormat = new DateTimePatternGenerator.FormatParser();
                    idCanonFormat.set(idCanonical);
                    List<Object> idCanonItems = this.updateVariableFieldInList(idCanonFormat.getItems());
                    DateTimePatternGenerator.FormatParser fixedValueCanonFormat = new DateTimePatternGenerator.FormatParser();
                    fixedValueCanonFormat.set(fixedValueCanonical);
                    List<Object> fixedValueCanonItems = this.updateVariableFieldInList(fixedValueCanonFormat.getItems());
                    DateTimePatternGenerator.FormatParser fixedValueFormat = new DateTimePatternGenerator.FormatParser();
                    fixedValueFormat.set(fixedValue);
                    List<Object> fixedValueItems = this.updateVariableFieldInList(fixedValueFormat.getItems());
                    int itemIndex = idCanonItems.size();
                    while (--itemIndex >= 0) {
                        Object idCanonItem = idCanonItems.get(itemIndex);
                        if (!fixedValueCanonItems.remove(idCanonItem)) continue;
                        idCanonItems.remove(itemIndex);
                    }
                    if (idCanonItems.size() == 1 && fixedValueCanonItems.size() == 1) {
                        Object fixedValueCanonItem = fixedValueCanonItems.get(0);
                        Object idCanonItem = idCanonItems.get(0);
                        boolean didUpdate = false;
                        while ((itemIndex = fixedValueItems.indexOf(fixedValueCanonItem)) >= 0) {
                            fixedValueItems.set(itemIndex, idCanonItem);
                            didUpdate = true;
                        }
                        if (didUpdate) {
                            fixedValue = fixedValueFormat.toString();
                            fixedValueCanonical = this.dateTimePatternGenerator.getCanonicalSkeletonAllowingDuplicates(fixedValue);
                        }
                    }
                    if (!this.dateTimePatternGenerator.skeletonsAreSimilar(idCanonical, fixedValueCanonical)) {
                        fixedValue = null;
                    }
                }
                Object suggestion = "(no suggestion)";
                if (fixedValue != null) {
                    suggestion = "(" + fixedValue + ")";
                    if (valueFromId != null && !valueFromId.equals(fixedValue)) {
                        suggestion = suggestion + " or (" + valueFromId + ")";
                    }
                } else if (valueFromId != null) {
                    suggestion = "(" + valueFromId + ")";
                }
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("Your pattern ({2}) doesn't correspond to what is asked for. Yours would be right for an ID ({1}) but not for the ID ({0}). Please change your pattern to match what was asked, such as {3}, with the right punctuation and/or ordering for your language. See https://cldr.unicode.org/translation/date-time/date-time-patterns.", id, skeletonCanonical, value, suggestion));
            }
            if (dateTypePatternType == DateTimeCanonicalizer.DateTimePatternType.AVAILABLE) {
                Set<String> coreSkeletons;
                if (idCanonical.matches("y+w+") && !skeleton.matches("Y+w+") && !skeleton.matches("w+Y+")) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("For id {0}, the pattern ({1}) must contain fields Y and w, and no others.", id, value));
                }
                if (idCanonical.matches("M+W") && !skeletonCanonical.matches("M+W") && !skeletonCanonical.matches("WM+")) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("For id {0}, the pattern ({1}) must contain fields M or L, plus W, and no others.", id, value));
                }
                if (CALENDARS_FOR_CORES.contains(calendar) && !(coreSkeletons = RelatedDatePathValues.getCores(id)).isEmpty()) {
                    XPathParts parts = XPathParts.getFrozenInstance(path);
                    XPathParts coreParts = parts.cloneAsThawed();
                    for (String coreSkeleton : coreSkeletons) {
                        coreParts.putAttributeValue(-1, "id", coreSkeleton);
                        String coreValue = this.getResolvedCldrFileToCheck().getStringValue(coreParts.toString());
                        if (coreValue == null || RelatedDatePathValues.contains(value, coreValue)) continue;
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentCoreDatePattern).setMessage("\u201c{0}\u201d \u2285 \u201c{1}\u201d: the pattern for {2} should contain the pattern for {3}", value, coreValue, id, coreSkeleton));
                    }
                }
            }
            if ((failureMessage = (String)this.flexInfo.getFailurePath(path)) != null) {
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.illegalDatePattern).setMessage("{0}", failureMessage));
            }
        }
        if (dateTypePatternType == DateTimeCanonicalizer.DateTimePatternType.STOCK) {
            int style = 0;
            String len = pathParts.findAttributeValue("timeFormatLength", "type");
            DateOrTime dateOrTime = DateOrTime.time;
            if (len == null) {
                dateOrTime = DateOrTime.date;
                style += 4;
                len = pathParts.findAttributeValue("dateFormatLength", "type");
                if (len == null) {
                    len = pathParts.findAttributeValue("dateTimeFormatLength", "type");
                    dateOrTime = DateOrTime.dateTime;
                }
            }
            DateTimeLengths dateTimeLength = DateTimeLengths.valueOf(len != null ? len.toUpperCase(Locale.ENGLISH) : null);
            if ("gregorian".equals(calendar) && !"root".equals(this.getCldrFileToCheck().getLocaleID())) {
                this.checkValue(dateTimeLength, dateOrTime, value, result);
            }
            if (dateOrTime == DateOrTime.dateTime) {
                return;
            }
            if (!(dateTimePatterns[style += dateTimeLength.ordinal()].matcher(skeletonCanonical).matches() || "chinese".equals(calendar) || "hebrew".equals(calendar))) {
                int i = RegexUtilities.findMismatch(dateTimePatterns[style], (CharSequence)skeletonCanonical);
                String skeletonPosition = skeleton.substring(0, i) + "\u2639" + skeleton.substring(i);
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingOrExtraDateField).setMessage("Field is missing, extra, or the wrong length. Expected {0} [Internal: {1} / {2}]", dateTimeMessage[style], skeletonPosition, dateTimePatterns[style].pattern()));
            }
        } else if (dateTypePatternType == DateTimeCanonicalizer.DateTimePatternType.INTERVAL) {
            if (id.contains("y")) {
                String greatestDifference = pathParts.findAttributeValue("greatestDifference", "id");
                int requiredYearFieldCount = 1;
                if ("y".equals(greatestDifference)) {
                    requiredYearFieldCount = 2;
                }
                int yearFieldCount = 0;
                Matcher yearFieldMatcher = YEAR_FIELDS.matcher(value);
                while (yearFieldMatcher.find()) {
                    ++yearFieldCount;
                }
                if (yearFieldCount < requiredYearFieldCount) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingOrExtraDateField).setMessage("Not enough year fields in interval pattern. Must have {0} but only found {1}", requiredYearFieldCount, yearFieldCount));
                }
            }
            if (!value.contains("LLL") || !value.contains("MMM")) {
                DateIntervalInfo.PatternInfo pattern = DateIntervalInfo.genPatternInfo(value, false);
                try {
                    String first = pattern.getFirstPart();
                    String second = pattern.getSecondPart();
                    if (first == null || second == null) {
                        result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("DateIntervalInfo.PatternInfo returns null for first or second part"));
                    }
                }
                catch (Exception e) {
                    result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.incorrectDatePattern).setMessage("DateIntervalInfo.PatternInfo exception {0}", e));
                }
            }
        }
        if (value.contains("G") && "gregorian".equals(calendar) && (actual = GyState.forPattern(value)) != (expected = this.getExpectedGy(this.getCldrFileToCheck().getLocaleID()))) {
            result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.unexpectedOrderOfEraYear).setMessage("Unexpected order of era/year. Expected {0}, but got {1} in \u3008{2}\u3009 for {3}/{4}", new Object[]{expected, actual, value, calendar, id}));
        }
    }

    private static void add(DateOrTime dateOrTime, DateTimeLengths dateTimeLength, String ... keys) {
        Relation<DateTimeLengths, String> rel = STOCK_PATTERNS.get((Object)dateOrTime);
        if (rel == null) {
            rel = Relation.of(new EnumMap(DateTimeLengths.class), LinkedHashSet.class);
            STOCK_PATTERNS.put(dateOrTime, rel);
        }
        rel.putAll(dateTimeLength, Arrays.asList(keys));
    }

    private void checkValue(DateTimeLengths dateTimeLength, DateOrTime dateOrTime, String value, List<CheckCLDR.CheckStatus> result) {
        if (dateOrTime == DateOrTime.time) {
            String clockType;
            String checkForHour;
            PreferredAndAllowedHour pref = this.sdi.getTimeData().get(this.territory);
            if (pref == null) {
                pref = this.sdi.getTimeData().get("001");
            }
            if (pref.preferred.equals((Object)PreferredAndAllowedHour.HourStyle.h)) {
                checkForHour = "h";
                clockType = "12";
            } else {
                checkForHour = "H";
                clockType = "24";
            }
            if (!value.contains(checkForHour)) {
                CheckCLDR.CheckStatus.Type errType = CheckCLDR.CheckStatus.errorType;
                if (this.language.equals("fr") && this.territory.equals("CA")) {
                    errType = CheckCLDR.CheckStatus.warningType;
                }
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(errType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentTimePattern).setMessage("Time format inconsistent with supplemental time data for territory \"" + this.territory + "\". Use '" + checkForHour + "' for " + clockType + " hour clock."));
            }
        }
        if (dateOrTime == DateOrTime.dateTime) {
            boolean inQuotes = false;
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\'') {
                    boolean bl = inQuotes = !inQuotes;
                }
                if ((inQuotes || ch < 'a' || ch > 'z') && (ch < 'A' || ch > 'Z')) continue;
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.errorType).setSubtype(CheckCLDR.CheckStatus.Subtype.patternContainsInvalidCharacters).setMessage("Unquoted letter \"{0}\" in dateTime format.", Character.valueOf(ch)));
            }
        } else {
            String msg;
            Set<String> keys = STOCK_PATTERNS.get((Object)dateOrTime).get((Object)dateTimeLength);
            StringBuilder b = new StringBuilder();
            boolean onlyNulls = true;
            int countMismatches = 0;
            boolean errorOnMissing = false;
            String timezonePattern = null;
            LinkedHashSet<String> bases = new LinkedHashSet<String>();
            for (String key : keys) {
                int star = key.indexOf(42);
                boolean hasStar = star >= 0;
                String base = !hasStar ? key : key.substring(0, star);
                bases.add(base);
                String xpath = AVAILABLE_PREFIX + base + AVAILABLE_SUFFIX;
                String value1 = this.getCldrFileToCheck().getStringValue(xpath);
                if (value1 != null) {
                    onlyNulls = false;
                    if (hasStar) {
                        String zone = key.substring(star + 1);
                        timezonePattern = this.getResolvedCldrFileToCheck().getStringValue(APPEND_TIMEZONE);
                        value1 = MessageFormat.format(timezonePattern, value1, zone);
                    }
                    if (this.equalsExceptWidth(value, value1)) {
                        return;
                    }
                } else {
                    Level pathLevel = this.coverageLevel.getLevel(xpath);
                    if (this.requiredLevel.compareTo(pathLevel) >= 0) {
                        errorOnMissing = true;
                    }
                }
                this.add(b, base, value1);
                ++countMismatches;
            }
            if (!onlyNulls) {
                if (timezonePattern != null) {
                    b.append(" (with appendZonePattern: \u201c").append(timezonePattern).append("\u201d)");
                }
                msg = countMismatches != 1 ? "{1}-{0} \u2192 \u201c{2}\u201d didn't match any of the corresponding flexible skeletons: [{3}]. This or the flexible patterns needs to be changed." : "{1}-{0} \u2192 \u201c{2}\u201d didn't match the corresponding flexible skeleton: {3}. This or the flexible pattern needs to be changed.";
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.inconsistentDatePattern).setMessage(msg, new Object[]{dateTimeLength, dateOrTime, value, b}));
            } else if (errorOnMissing) {
                msg = countMismatches != 1 ? "{1}-{0} \u2192 \u201c{2}\u201d doesn't have at least one value for a corresponding flexible skeleton {3}, which needs to be added." : "{1}-{0} \u2192 \u201c{2}\u201d doesn't have a value for the corresponding flexible skeleton {3}, which needs to be added.";
                result.add(new CheckCLDR.CheckStatus().setCause(this).setMainType(CheckCLDR.CheckStatus.warningType).setSubtype(CheckCLDR.CheckStatus.Subtype.missingDatePattern).setMessage(msg, new Object[]{dateTimeLength, dateOrTime, value, Joiner.on(", ").join(bases)}));
            }
        }
    }

    private void add(StringBuilder b, String key, String value1) {
        if (value1 == null) {
            return;
        }
        if (b.length() != 0) {
            b.append(" or ");
        }
        b.append(key).append(" \u2192 \u201c").append(value1).append("\u201d");
    }

    private boolean equalsExceptWidth(String value1, String value2) {
        if (value1.equals(value2)) {
            return true;
        }
        if (value2 == null) {
            return false;
        }
        ArrayList<Object> items1 = new ArrayList<Object>(this.formatParser.set(value1).getItems());
        List<Object> items2 = this.formatParser.set(value2).getItems();
        if (items1.size() != items2.size()) {
            return false;
        }
        Iterator<Object> it2 = items2.iterator();
        for (Object e : items1) {
            Object item2;
            if (e.equals(item2 = it2.next()) || e instanceof DateTimePatternGenerator.VariableField && item2 instanceof DateTimePatternGenerator.VariableField && e.toString().charAt(0) == item2.toString().charAt(0)) continue;
            return false;
        }
        return true;
    }

    private GyState getExpectedGy(String localeID) {
        int firstBar = localeID.indexOf(95);
        String lang = firstBar < 0 ? localeID : localeID.substring(0, firstBar);
        return YgLanguages.contains(lang) ? GyState.YEAR_ERA : GyState.ERA_YEAR;
    }

    public String toString(DateTimePatternGenerator.FormatParser formatParser) {
        StringBuilder result = new StringBuilder();
        for (Object x : formatParser.getItems()) {
            if (x instanceof DateTimePatternGenerator.VariableField) {
                result.append(x);
                continue;
            }
            result.append(formatParser.quoteLiteral(x.toString()));
        }
        return result.toString();
    }

    private void checkPattern2(String path, String value, List<CheckCLDR.CheckStatus> result) {
        XPathParts pathParts = XPathParts.getFrozenInstance(path);
        String calendar = pathParts.findAttributeValue("calendar", "type");
        SimpleDateFormat x = this.icuServiceBuilder.getDateFormat(calendar, value);
        x.setTimeZone(ExampleGenerator.ZONE_SAMPLE);
        result.add(new MyCheckStatus().setFormat(x).setCause(this).setMainType(CheckCLDR.CheckStatus.demoType));
    }

    private DateTimePatternGenerator getDTPGForCalendarType(String calendarType) {
        DateTimePatternGenerator dtpg = this.dtpgForType.get(calendarType);
        if (dtpg == null) {
            dtpg = this.flexInfo.getDTPGForCalendarType(calendarType, this.parentCLDRFiles);
            this.dtpgForType.put(calendarType, dtpg);
        }
        return dtpg;
    }

    static {
        neutralFormat.setTimeZone(ExampleGenerator.ZONE_SAMPLE);
        STOCK_PATTERNS = new EnumMap<DateOrTime, Relation<DateTimeLengths, String>>(DateOrTime.class);
        CheckDates.add(DateOrTime.time, DateTimeLengths.SHORT, "hm", "Hm");
        CheckDates.add(DateOrTime.time, DateTimeLengths.MEDIUM, "hms", "Hms");
        CheckDates.add(DateOrTime.time, DateTimeLengths.LONG, "hms*z", "Hms*z");
        CheckDates.add(DateOrTime.time, DateTimeLengths.FULL, "hms*zzzz", "Hms*zzzz");
        CheckDates.add(DateOrTime.date, DateTimeLengths.SHORT, "yMd");
        CheckDates.add(DateOrTime.date, DateTimeLengths.MEDIUM, "yMMMd");
        CheckDates.add(DateOrTime.date, DateTimeLengths.LONG, "yMMMMd", "yMMMd");
        CheckDates.add(DateOrTime.date, DateTimeLengths.FULL, "yMMMMEd", "yMMMEd");
        YgLanguages = new HashSet<String>(Arrays.asList("ar", "cs", "da", "de", "en", "es", "fa", "fi", "fr", "he", "hr", "id", "it", "nl", "no", "pt", "ru", "sv", "tr"));
        dateTimePatterns = new Pattern[]{PatternCache.get("a*(h|hh|H|HH)(m|mm)"), PatternCache.get("a*(h|hh|H|HH)(m|mm)(s|ss)"), PatternCache.get("a*(h|hh|H|HH)(m|mm)(s|ss)(v+)"), PatternCache.get("a*(h|hh|H|HH)(m|mm)(s|ss)(v+)"), PatternCache.get("G*y{1,4}M{1,2}(d|dd)"), PatternCache.get("G*y(yyy)?M{1,3}(d|dd)"), PatternCache.get("G*y(yyy)?M{1,4}(d|dd)"), PatternCache.get("G*y(yyy)?M{1,4}E*(d|dd)"), PatternCache.get(".*"), PatternCache.get(".*"), PatternCache.get(".*"), PatternCache.get(".*")};
        dateTimeMessage = new String[]{"hours (H, HH, h, or hh), and minutes (m or mm)", "hours (H, HH, h, or hh), minutes (m or mm), and seconds (s or ss)", "hours (H, HH, h, or hh), minutes (m or mm), and seconds (s or ss); optionally timezone (z, zzzz, v, vvvv)", "hours (H, HH, h, or hh), minutes (m or mm), seconds (s or ss), and timezone (z, zzzz, v, vvvv)", "year (y, yy, yyyy), month (M or MM), and day (d or dd); optionally era (G)", "year (y), month (M, MM, or MMM), and day (d or dd); optionally era (G)", "year (y), month (M, ... MMMM), and day (d or dd); optionally era (G)", "year (y), month (M, ... MMMM), and day (d or dd); optionally day of week (EEEE or cccc) or era (G)"};
    }

    static class MyDemo
    extends CheckCLDR.FormatDemo {
        private SimpleDateFormat df;

        MyDemo() {
        }

        @Override
        protected String getPattern() {
            return this.df.toPattern();
        }

        @Override
        protected String getSampleInput() {
            return neutralFormat.format(ExampleGenerator.DATE_SAMPLE);
        }

        public MyDemo setFormat(SimpleDateFormat df) {
            this.df = df;
            return this;
        }

        @Override
        protected void getArguments(Map<String, String> inout) {
            Date d;
            this.currentReparsed = "?";
            this.currentFormatted = "?";
            this.currentInput = "?";
            this.currentPattern = "?";
            try {
                this.currentPattern = inout.get("pattern");
                if (this.currentPattern != null) {
                    this.df.applyPattern(this.currentPattern);
                } else {
                    this.currentPattern = this.getPattern();
                }
            }
            catch (Exception e) {
                this.currentPattern = "Use format like: ##,###.##";
                return;
            }
            try {
                this.currentInput = inout.get("input");
                if (this.currentInput == null) {
                    this.currentInput = this.getSampleInput();
                }
                d = neutralFormat.parse(this.currentInput);
            }
            catch (Exception e) {
                this.currentInput = "Use neutral format like: 1993-11-31 13:49:02";
                return;
            }
            try {
                this.currentFormatted = this.df.format(d);
            }
            catch (Exception e) {
                this.currentFormatted = "Can't format: " + e.getMessage();
                return;
            }
            try {
                this.parsePosition.setIndex(0);
                Date n = this.df.parse(this.currentFormatted, this.parsePosition);
                this.currentReparsed = this.parsePosition.getIndex() != this.currentFormatted.length() ? "Couldn't parse past: \u200e" + this.currentFormatted.substring(0, this.parsePosition.getIndex()) + "\u200e" : neutralFormat.format(n);
            }
            catch (Exception e) {
                this.currentReparsed = "Can't parse: " + e.getMessage();
            }
        }
    }

    public static class MyCheckStatus
    extends CheckCLDR.CheckStatus {
        private SimpleDateFormat df;

        public MyCheckStatus setFormat(SimpleDateFormat df) {
            this.df = df;
            return this;
        }

        @Override
        public CheckCLDR.SimpleDemo getDemo() {
            return new MyDemo().setFormat(this.df);
        }
    }

    static enum DateTimeLengths {
        SHORT,
        MEDIUM,
        LONG,
        FULL;

    }

    static enum GyState {
        YEAR_ERA,
        ERA_YEAR,
        OTHER;

        static DateTimePatternGenerator.FormatParser formatParser;

        static synchronized GyState forPattern(String value) {
            formatParser.set(value);
            int last = -1;
            for (Object x : formatParser.getItems()) {
                if (!(x instanceof DateTimePatternGenerator.VariableField)) continue;
                int type = ((DateTimePatternGenerator.VariableField)x).getType();
                if (type == 0 && last == 1) {
                    return YEAR_ERA;
                }
                if (type == 1 && last == 0) {
                    return ERA_YEAR;
                }
                last = type;
            }
            return OTHER;
        }

        static {
            formatParser = new DateTimePatternGenerator.FormatParser();
        }
    }

    static enum DateOrTime {
        date,
        time,
        dateTime;

    }

    private static class MyVariableField
    extends DateTimePatternGenerator.VariableField {
        public MyVariableField(String string) {
            super(string);
        }

        public boolean equals(Object object) {
            if (!(object instanceof DateTimePatternGenerator.VariableField)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

