/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.ibm.icu.impl.UnicodeMap;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.test.CheckCLDR;
import org.unicode.cldr.test.FactoryCheckCLDR;
import org.unicode.cldr.test.LogicalGroupChecker;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.LogicalGrouping;
import org.unicode.cldr.util.With;

public class CheckLogicalGroupings
extends FactoryCheckCLDR {
    static final CLDRFile.DraftStatus MIMIMUM_DRAFT_STATUS = CLDRFile.DraftStatus.contributed;
    static final Set<CheckCLDR.Phase> PHASES_CAUSE_ERROR = ImmutableSet.of(CheckCLDR.Phase.FINAL_TESTING, CheckCLDR.Phase.VETTING);
    static final Transliterator SHOW_INVISIBLES = Transliterator.createFromRules("show", "([[:C:][:Z:][:whitespace:][:Default_Ignorable_Code_Point:]-[\\u0020]]) > &hex/perl($1);", 0);
    private static final UnicodeMap<String> OTHER_SPACES = new UnicodeMap<String>().putAll(new UnicodeSet("[[:Z:][:S:][:whitespace:]]"), " ").freeze();
    private static final ConcurrentHashMap<String, Fingerprint> FINGERPRINT_CACHE = new ConcurrentHashMap();

    public CheckLogicalGroupings(Factory factory) {
        super(factory);
    }

    @Override
    public CheckCLDR handleSetCldrFileToCheck(CLDRFile cldrFileToCheck, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> possibleErrors) {
        super.handleSetCldrFileToCheck(cldrFileToCheck, options, possibleErrors);
        String parent = LocaleIDParser.getParent(cldrFileToCheck.getLocaleID());
        boolean isTopLevel = parent == null || parent.equals("root");
        this.setSkipTest(!isTopLevel);
        return this;
    }

    @Override
    public CheckCLDR handleCheck(String path, String fullPath, String value, CheckCLDR.Options options, List<CheckCLDR.CheckStatus> result) {
        if (LogicalGrouping.isOptional(this.getCldrFileToCheck(), path)) {
            return this;
        }
        if (!this.accept(result)) {
            return this;
        }
        new LogicalGroupChecker(this, path, value, result).run();
        return this;
    }

    public static String showInvisibles(String value) {
        return SHOW_INVISIBLES.transform(value);
    }

    public static String showInvisibles(int codePoint) {
        return CheckLogicalGroupings.showInvisibles(With.fromCodePoint(codePoint));
    }

    public static String showInvisibles(Multiset<?> codePointCounts) {
        StringBuilder b = new StringBuilder().append('{');
        for (Multiset.Entry<?> entry : codePointCounts.entrySet()) {
            Object element;
            if (b.length() > 1) {
                b.append(", ");
            }
            b.append((element = entry.getElement()) instanceof Integer ? CheckLogicalGroupings.showInvisibles((Integer)element) : CheckLogicalGroupings.showInvisibles(element.toString()));
            if (entry.getCount() <= 1) continue;
            b.append('\u2a31').append(entry.getCount());
        }
        return b.append('}').toString();
    }

    public static String cleanSpaces(String pathValue) {
        return OTHER_SPACES.transform(pathValue);
    }

    public static class Fingerprint {
        private final Multiset<Integer> codePointCounts;

        private Fingerprint(String value) {
            TreeMultiset<Integer> result = TreeMultiset.create();
            for (int cp : With.codePointArray(value)) {
                result.add(cp);
            }
            this.codePointCounts = ImmutableMultiset.copyOf(result);
        }

        public static int maxDistanceBetween(Set<Fingerprint> fingerprintsIn) {
            int distance = 0;
            ImmutableList<Fingerprint> fingerprints = ImmutableList.copyOf(fingerprintsIn);
            for (int i = fingerprints.size() - 1; i > 0; --i) {
                Fingerprint fingerprint_i = (Fingerprint)fingerprints.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    Fingerprint fingerprints_j = (Fingerprint)fingerprints.get(j);
                    int currentDistance = fingerprint_i.getDistanceTo(fingerprints_j);
                    distance = Math.max(distance, currentDistance);
                }
            }
            return distance;
        }

        public int getDistanceTo(Fingerprint that) {
            int distance = 0;
            HashSet<Integer> allChars = new HashSet<Integer>(that.codePointCounts.elementSet());
            allChars.addAll(this.codePointCounts.elementSet());
            for (Integer element : allChars) {
                int count = this.codePointCounts.count(element);
                int otherCount = that.codePointCounts.count(element);
                distance += Math.abs(count - otherCount);
            }
            return distance;
        }

        public int size() {
            return this.codePointCounts.size();
        }

        public static Fingerprint make(String value) {
            return FINGERPRINT_CACHE.computeIfAbsent(value, Fingerprint::new);
        }

        public String toString() {
            return CheckLogicalGroupings.showInvisibles(this.codePointCounts);
        }
    }
}

