/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.TreeMultimap;
import com.google.myanmartools.ZawgyiDetector;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateIntervalInfo;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transform;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.Output;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.test.CheckExemplars;
import org.unicode.cldr.util.AnnotationUtil;
import org.unicode.cldr.util.Builder;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.ComparatorUtilities;
import org.unicode.cldr.util.DateTimeCanonicalizer;
import org.unicode.cldr.util.PatternCache;
import org.unicode.cldr.util.SimpleUnicodeSetFormatter;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.UnicodeSetPrettyPrinter;
import org.unicode.cldr.util.XPathParts;

public class DisplayAndInputProcessor {
    public static final String NOL_START_PATH = "//ldml/personNames/nameOrderLocales";
    public static final String FSR_START_PATH = "//ldml/personNames/foreignSpaceReplacement";
    public static final String NSR_START_PATH = "//ldml/personNames/nativeSpaceReplacement";
    public static final String EMPTY_ELEMENT_VALUE = "\u276eEMPTY\u276f";
    private static final boolean FIX_YEARS = true;
    public static final boolean DEBUG_DAIP = CldrUtility.getProperty("DEBUG_DAIP", false);
    public static final UnicodeSet RTL = new UnicodeSet("[[:Bidi_Class=Arabic_Letter:][:Bidi_Class=Right_To_Left:]]").freeze();
    public static final Pattern NUMBER_SEPARATOR_PATTERN = Pattern.compile("//ldml/numbers/symbols.*/(decimal|group)");
    private static final Pattern APOSTROPHE_SKIP_PATHS = PatternCache.get("//ldml/(localeDisplayNames/languages/language\\[@type=\"mic\"].*|characters/.*|delimiters/.*|dates/.+/(pattern|intervalFormatItem|dateFormatItem).*|units/.+/unitPattern.*|units/.+/durationUnitPattern.*|numbers/symbols.*|numbers/miscPatterns.*|numbers/(decimal|currency|percent|scientific)Formats.+/(decimal|currency|percent|scientific)Format.*)");
    private static final Pattern INTERVAL_FORMAT_PATHS = PatternCache.get("//ldml/dates/.+/intervalFormat(Item.*|Fallback)");
    private static final Pattern NON_DECIMAL_PERIOD = PatternCache.get("(?<![0#'])\\.(?![0#'])");
    private static final Pattern HOUR_FORMAT_XPATHS = PatternCache.get("//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/(timeFormats/timeFormatLength\\[@type=\"[^\"]*\"]/timeFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"].*|dateTimeFormats/availableFormats/dateFormatItem\\[@id=\"[A-GL-Ma-gl-m]*[hK][A-Za-z]*\"].*|dateTimeFormats/intervalFormats/intervalFormatItem\\[@id=\"[A-GL-Ma-gl-m]*[hK][A-Za-z]*\"].*)");
    private static final Pattern AMPM_SPACE_BEFORE = PatternCache.get("([Khms])([ \\u00A0\\u202F]+)(a+)");
    private static final Pattern AMPM_SPACE_AFTER = PatternCache.get("(a+)([ \\u00A0\\u202F]+)([Kh])");
    private static final Pattern YEAR_FORMAT_XPATHS = PatternCache.get("//ldml/dates/calendars/calendar\\[@type=\"[^\"]*\"]/(dateFormats/dateFormatLength\\[@type=\"[^\"]*\"]/dateFormat\\[@type=\"standard\"]/pattern\\[@type=\"standard\"].*|dateTimeFormats/availableFormats/dateFormatItem\\[@id=\"[A-XZa-xz]*y[A-Za-z]*\"].*|dateTimeFormats/intervalFormats/intervalFormatItem\\[@id=\"[A-XZa-xz]*y[A-Za-z]*\"].*)");
    private static final Pattern YEAR_SPACE_YEARMARKER = PatternCache.get("y[ \\u00A0]+('?[\u0430\u0433\u0435\u0436\u043e\u0440\u0441])");
    public static final Pattern UNIT_NARROW_XPATHS = PatternCache.get("//ldml/units/unitLength\\[@type=\"narrow\"]unit\\[@type=\"[^\"]*\"]/unitPattern.*");
    public static final Pattern UNIT_SHORT_XPATHS = PatternCache.get("//ldml/units/unitLength\\[@type=\"short\"]unit\\[@type=\"[^\"]*\"]/unitPattern.*");
    private static final Pattern PLACEHOLDER_SPACE_AFTER = PatternCache.get("\\}[ \\u00A0\\u202F]+");
    private static final Pattern PLACEHOLDER_SPACE_BEFORE = PatternCache.get("[ \\u00A0\\u202F]+\\{");
    private static final Pattern INTERVAL_FALLBACK_RANGE = PatternCache.get("\\} [\\u2013-] \\{");
    private static final Pattern WHITESPACE_NO_NBSP_TO_NORMALIZE = PatternCache.get("\\s+");
    private static final Pattern WHITESPACE_AND_NBSP_TO_NORMALIZE = PatternCache.get("[\\s\\u00A0]+");
    private static final Pattern NBSP_PLUS_SPACE_TO_NORMALIZE = PatternCache.get("\\u00A0+\\u0020+");
    private static final Pattern SPACE_PLUS_NBSP_TO_NORMALIZE = PatternCache.get("\\u0020+\\u00A0+");
    private static final Pattern NNBSP_AMONG_OTHER_SPACES = PatternCache.get("[\\h&&[^\\u202F]]+\\u202F\\h*|\\u202F\\h+");
    private static final Pattern NBSP_AMONG_OTHER_SPACES = PatternCache.get("[\\h&&[^\\u00A0]]+\\u00A0\\h*|\\u00A0\\h+");
    private static final Pattern THIN_SPACE_AMONG_OTHER_SPACES = PatternCache.get("[\\h&&[^\\u2009]]+\\u2009\\h*|\\u2009\\h+");
    private static final Pattern INITIAL_NBSP = PatternCache.get("^[\\u00A0\\u202F]+");
    private static final Pattern FINAL_NBSP = PatternCache.get("[\\u00A0\\u202F]+$");
    private static final Pattern MULTIPLE_NBSP = PatternCache.get("\\u00A0\\u00A0+");
    private static final UnicodeSet UNICODE_WHITESPACE = new UnicodeSet("[:whitespace:]").freeze();
    private static final CLDRLocale MALAYALAM = CLDRLocale.getInstance("ml");
    private static final CLDRLocale ROMANIAN = CLDRLocale.getInstance("ro");
    private static final CLDRLocale CATALAN = CLDRLocale.getInstance("ca");
    private static final CLDRLocale NGOMBA = CLDRLocale.getInstance("jgo");
    private static final CLDRLocale KWASIO = CLDRLocale.getInstance("nmg");
    private static final CLDRLocale HEBREW = CLDRLocale.getInstance("he");
    private static final CLDRLocale MYANMAR = CLDRLocale.getInstance("my");
    private static final CLDRLocale KYRGYZ = CLDRLocale.getInstance("ky");
    private static final CLDRLocale URDU = CLDRLocale.getInstance("ur");
    private static final CLDRLocale PASHTO = CLDRLocale.getInstance("ps");
    private static final CLDRLocale FARSI = CLDRLocale.getInstance("fa");
    private static final CLDRLocale GERMAN_SWITZERLAND = CLDRLocale.getInstance("de_CH");
    private static final CLDRLocale SWISS_GERMAN = CLDRLocale.getInstance("gsw");
    private static final CLDRLocale FF_ADLAM = CLDRLocale.getInstance("ff_Adlm");
    private static final CLDRLocale KASHMIRI = CLDRLocale.getInstance("ks");
    public static final Set<String> LANGUAGES_USING_MODIFIER_APOSTROPHE = new HashSet<String>(Arrays.asList("br", "bss", "cad", "cic", "cch", "gn", "ha", "ha_Latn", "kek", "lkt", "mgo", "mic", "moh", "mus", "nnh", "qu", "quc", "uk", "uz", "uz_Latn"));
    private static final char[][] ROMANIAN_CONVERSIONS = new char[][]{{'\u015e', '\u0218'}, {'\u015f', '\u0219'}, {'\u0162', '\u021a'}, {'\u0163', '\u021b'}};
    private static final char[][] CATALAN_CONVERSIONS = new char[][]{{'\u013f', 'L', '\u00b7'}, {'\u0140', 'l', '\u00b7'}};
    private static final char[][] NGOMBA_CONVERSIONS = new char[][]{{'\u0251', 'a'}, {'\u0261', 'g'}, {'\u2019', '\ua78c'}, {'\u02bc', '\ua78c'}};
    private static final char[][] KWASIO_CONVERSIONS = new char[][]{{'\u0306', '\u030c'}, {'\u0103', '\u01ce'}, {'\u0102', '\u01cd'}, {'\u0115', '\u011b'}, {'\u011a', '\u01cd'}, {'\u012d', '\u01d0'}, {'\u012c', '\u01cf'}, {'\u014f', '\u01d2'}, {'\u014e', '\u01d1'}, {'\u016d', '\u01d4'}, {'\u016c', '\u01d3'}};
    private static final char[][] HEBREW_CONVERSIONS = new char[][]{{'\'', '\u05f3'}, {'\"', '\u05f4'}};
    private static final char[][] KYRGYZ_CONVERSIONS = new char[][]{{'\u04ca', '\u04a3'}, {'\u04c9', '\u04a2'}};
    private static final char[][] URDU_PLUS_CONVERSIONS = new char[][]{{'\u0643', '\u06a9'}};
    private static final char[][] KASHMIRI_CONVERSIONS = new char[][]{{'\u06cd', '\u0620'}};
    private static final ZawgyiDetector detector = new ZawgyiDetector();
    private static final Transliterator zawgyiUnicodeTransliterator = Transliterator.getInstance("Zawgyi-my");
    private SimpleUnicodeSetFormatter pp = new SimpleUnicodeSetFormatter();
    private UnicodeSetPrettyPrinter rawFormatter = new UnicodeSetPrettyPrinter();
    private final CLDRLocale locale;
    private String scriptCode;
    private boolean isPosix;
    private CLDRFile cldrFileForBailey = null;
    static final DateTimeCanonicalizer dtc = new DateTimeCanonicalizer(true);
    private static final String BAR_VL = "\\|";
    private static final String BAR_EL = "\\s+l\\s+";
    private static final String BAR_REGEX = "(\\s+l\\s+|[\ufe33\ufe31\u0964|\uff5c\u23b8\u23b9\u23d0\uffe8\u2758])";
    public static final Splitter SPLIT_BAR = Splitter.on(Pattern.compile("(\\s+l\\s+|[\ufe33\ufe31\u0964|\uff5c\u23b8\u23b9\u23d0\uffe8\u2758])")).trimResults().omitEmptyStrings();
    static final Splitter SPLIT_SPACE = Splitter.on(' ').trimResults().omitEmptyStrings();
    static final Joiner JOIN_BAR = Joiner.on(" | ");
    static final Joiner JOIN_SPACE = Joiner.on(' ');
    private static final boolean REMOVE_COVERED_KEYWORDS = true;
    private static final Pattern UNNORMALIZED_MALAYALAM = PatternCache.get("(\u0d23|\u0d28|\u0d30|\u0d32|\u0d33|\u0d15)\u0d4d\u200d");
    private static final Map<Character, Character> NORMALIZING_MAP = Builder.with(new HashMap()).put(Character.valueOf('\u0d23'), Character.valueOf('\u0d7a')).put(Character.valueOf('\u0d28'), Character.valueOf('\u0d7b')).put(Character.valueOf('\u0d30'), Character.valueOf('\u0d7c')).put(Character.valueOf('\u0d32'), Character.valueOf('\u0d7d')).put(Character.valueOf('\u0d33'), Character.valueOf('\u0d7e')).put(Character.valueOf('\u0d15'), Character.valueOf('\u0d7f')).get();
    static final Transform<String, String> fixArabicPresentation = Transliterator.getInstance("[[:block=Arabic_Presentation_Forms_A:][:block=Arabic_Presentation_Forms_B:]] nfkc");
    static Pattern ADLAM_MISNASALIZED = PatternCache.get("([\ud83a\udd32\ud83a\udd10])['\u2019\u2018]([\ud83a\udd01\ud83a\udd14\ud83a\udd18\ud83a\udd04\ud83a\udd23\ud83a\udd26\ud83a\udd36\ud83a\udd3a])");
    public static String ADLAM_NASALIZATION = "\ud83a\udd4b";
    static final Splitter SEMI_SPLITTER = Splitter.on(';').trimResults();
    private static final Pattern ZERO_WIDTH_SPACES = PatternCache.get("\\u200B+");
    private static final Set<String> LOCALES_NOT_ALLOWING_ZWS = new HashSet<String>(Arrays.asList("da", "fr"));

    public DisplayAndInputProcessor(CLDRFile cldrFileToCheck, boolean needsCollator) {
        this.locale = CLDRLocale.getInstance(cldrFileToCheck.getLocaleID());
        this.init(this.locale, needsCollator);
    }

    public DisplayAndInputProcessor(CLDRFile cldrFileToCheck) {
        this.locale = CLDRLocale.getInstance(cldrFileToCheck.getLocaleID());
        this.init(this.locale, true);
    }

    void init(CLDRLocale locale, boolean needsCollator) {
        this.isPosix = locale.toString().contains("POSIX");
        if (needsCollator) {
            Collator col = ComparatorUtilities.getCldrCollator(locale.toString(), 15);
            Collator spaceCol = ComparatorUtilities.getCldrCollator(locale.toString(), 0);
            this.pp = new SimpleUnicodeSetFormatter(col);
            this.rawFormatter = UnicodeSetPrettyPrinter.from(col, spaceCol);
        } else {
            this.pp = new SimpleUnicodeSetFormatter();
            this.rawFormatter = new UnicodeSetPrettyPrinter();
        }
        String script = locale.getScript();
        if (script == null || script.length() < 4) {
            SupplementalDataInfo sdi = CLDRConfig.getInstance().getSupplementalDataInfo();
            script = sdi.getDefaultScript(locale.getBaseName());
            if (script == null || script.length() < 4 || script.equals("Zzzz")) {
                script = sdi.getDefaultScript(locale.getLanguage());
            }
            if (script == null || script.length() < 4) {
                script = "Zzzz";
            }
        }
        this.scriptCode = script;
    }

    public SimpleUnicodeSetFormatter getPrettyPrinter() {
        return this.pp;
    }

    public DisplayAndInputProcessor(ULocale locale, boolean needsCollator) {
        this.locale = CLDRLocale.getInstance(locale);
        this.init(this.locale, needsCollator);
    }

    public DisplayAndInputProcessor(ULocale locale) {
        this.locale = CLDRLocale.getInstance(locale);
        this.init(this.locale, true);
    }

    public DisplayAndInputProcessor(CLDRLocale locale, boolean needsCollator) {
        this.locale = locale;
        this.init(this.locale, needsCollator);
    }

    public DisplayAndInputProcessor(CLDRLocale locale) {
        this.locale = locale;
        this.init(this.locale, true);
    }

    public synchronized String processForDisplay(String path, String value) {
        if (value == null) {
            return null;
        }
        if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
            return value;
        }
        value = Normalizer.compose(value, false);
        if (DisplayAndInputProcessor.hasUnicodeSetValue(path)) {
            return this.displayUnicodeSet(value);
        }
        if (path.contains("stopword")) {
            return value.trim().isEmpty() ? "NONE" : value;
        }
        NumericType numericType = NumericType.getNumericType(path);
        if (numericType != NumericType.NOT_NUMERIC) {
            block10: {
                try {
                    value = DisplayAndInputProcessor.getCanonicalPattern(value, numericType, this.isPosix);
                }
                catch (IllegalArgumentException e) {
                    if (!DEBUG_DAIP) break block10;
                    System.err.println("Illegal pattern: " + value);
                }
            }
            if (numericType != NumericType.CURRENCY && numericType != NumericType.CURRENCY_ABBREVIATED) {
                value = value.replace("'", "");
            }
        }
        if (!APOSTROPHE_SKIP_PATHS.matcher(path).matches()) {
            value = this.normalizeApostrophes(value);
        }
        if ((value = INTERVAL_FORMAT_PATHS.matcher(path).matches() ? this.normalizeIntervalHyphensAndSpaces(value) : this.normalizeHyphens(value)).isEmpty() && (path.startsWith(FSR_START_PATH) || path.startsWith(NSR_START_PATH) || path.startsWith(NOL_START_PATH))) {
            value = EMPTY_ELEMENT_VALUE;
        }
        return value;
    }

    public static boolean hasUnicodeSetValue(String path) {
        return path.startsWith("//ldml/characters/exemplarCharacters") || path.startsWith("//ldml/characters/parseLenients");
    }

    public synchronized String processInput(String path, String value, Exception[] internalException) {
        if (CldrUtility.INHERITANCE_MARKER.equals(value)) {
            return value;
        }
        String original = value;
        value = this.stripProblematicControlCharacters(value);
        value = Normalizer.compose(value, false);
        value = value.replace('\u00b5', '\u03bc');
        if (internalException != null) {
            internalException[0] = null;
        }
        if (CLDRLocale.ROOT.equals(this.locale) && path.contains("/annotations")) {
            return value;
        }
        try {
            value = this.processInputMore(path, value);
        }
        catch (RuntimeException e) {
            if (internalException != null) {
                internalException[0] = e;
            }
            return original;
        }
        return value;
    }

    private String processInputMore(String path, String value) {
        NumericType numericType;
        DateTimeCanonicalizer.DateTimePatternType datetimePatternType;
        boolean isUnicodeSet = DisplayAndInputProcessor.hasUnicodeSetValue(path);
        if (isUnicodeSet) {
            return this.inputUnicodeSet(path, value);
        }
        if (UNICODE_WHITESPACE.containsSome(value = this.processLocaleSpecificInput(path, value, isUnicodeSet))) {
            value = this.normalizeWhitespace(path, value);
        }
        value = value.replace(EMPTY_ELEMENT_VALUE, "");
        if (!(path.contains("/insertBetween") || path.contains("/foreignSpaceReplacement") || path.contains("/nativeSpaceReplacement") || path.contains("[@xml:space=\"preserve\"]") || isUnicodeSet)) {
            value = value.trim();
        }
        if (path.startsWith("//ldml/numbers/symbols") && !path.contains("/alias")) {
            if (value.isEmpty()) {
                value = "\u00a0";
            }
            value = value.replace(' ', '\u00a0');
        }
        if (DateTimeCanonicalizer.DateTimePatternType.STOCK_AVAILABLE_INTERVAL_PATTERNS.contains((Object)(datetimePatternType = DateTimeCanonicalizer.DateTimePatternType.fromPath(path)))) {
            try {
                value = dtc.getCanonicalDatePattern(path, value, datetimePatternType);
            }
            catch (IllegalArgumentException ex) {
                return value;
            }
        }
        if (path.startsWith("//ldml/numbers/currencies/currency") && path.contains("displayName")) {
            value = this.normalizeCurrencyDisplayName(value);
        }
        if ((numericType = NumericType.getNumericType(path)) != NumericType.NOT_NUMERIC) {
            if (numericType == NumericType.CURRENCY) {
                value = value.replaceAll(" ", "\u00a0");
            } else {
                value = value.replaceAll("([%\u00a4]) ", "$1\u00a0").replaceAll(" ([%\u00a4])", "\u00a0$1");
                value = this.replace(NON_DECIMAL_PERIOD, value, "'.'");
                if (numericType == NumericType.DECIMAL_ABBREVIATED) {
                    value = value.replaceAll("0\\.0+", "0");
                }
            }
            value = DisplayAndInputProcessor.getCanonicalPattern(value, numericType, this.isPosix);
        }
        if (path.startsWith("//ldml/localeDisplayNames/languages/language") || path.startsWith("//ldml/localeDisplayNames/scripts/script") || path.startsWith("//ldml/localeDisplayNames/territories/territory") || path.startsWith("//ldml/localeDisplayNames/variants/variant") || path.startsWith("//ldml/localeDisplayNames/keys/key") || path.startsWith("//ldml/localeDisplayNames/types/type")) {
            value = value.replace('[', '(').replace(']', ')').replace('\uff3b', '\uff08').replace('\uff3d', '\uff09');
        }
        if (path.contains("/units")) {
            value = value.replace("''", "\u2033");
        }
        if (path.contains("stopword") && value.equals("NONE")) {
            value = "";
        }
        if (path.startsWith("//ldml/characters/ellipsis")) {
            value = value.replace("...", "\u2026");
        }
        if (path.startsWith(NOL_START_PATH)) {
            value = this.normalizeNameOrderLocales(value);
        }
        value = this.replaceArabicPresentationForms(value);
        if (!APOSTROPHE_SKIP_PATHS.matcher(path).matches()) {
            value = this.normalizeApostrophes(value);
        }
        if (INTERVAL_FORMAT_PATHS.matcher(path).matches()) {
            value = this.normalizeIntervalHyphensAndSpaces(value);
        } else if (!isUnicodeSet) {
            value = this.normalizeHyphens(value);
        }
        value = this.processAnnotations(path, value);
        value = this.normalizeZeroWidthSpace(value);
        value = this.replaceBaileyWithInheritanceMarker(path, value);
        return value;
    }

    private String processLocaleSpecificInput(String path, String value, boolean isUnicodeSet) {
        if (this.locale.childOf(MALAYALAM)) {
            String newvalue = this.normalizeMalayalam(value);
            if (DEBUG_DAIP) {
                System.out.println("DAIP: Normalized Malayalam '" + value + "' to '" + newvalue + "'");
            }
            value = newvalue;
        } else if (this.locale.childOf(ROMANIAN) && !isUnicodeSet) {
            value = this.standardizeRomanian(value);
        } else if (this.locale.childOf(CATALAN) && !isUnicodeSet) {
            value = this.standardizeCatalan(value);
        } else if (this.locale.childOf(NGOMBA) && !isUnicodeSet) {
            value = this.standardizeNgomba(value);
        } else if (this.locale.childOf(KWASIO) && !isUnicodeSet) {
            value = this.standardizeKwasio(value);
        } else if (this.locale.childOf(HEBREW) && !APOSTROPHE_SKIP_PATHS.matcher(path).matches()) {
            value = this.replaceChars(path, value, HEBREW_CONVERSIONS, false);
        } else if ((this.locale.childOf(SWISS_GERMAN) || this.locale.childOf(GERMAN_SWITZERLAND)) && !isUnicodeSet) {
            value = this.standardizeSwissGerman(value);
        } else if (this.locale.childOf(MYANMAR) && !isUnicodeSet) {
            value = this.standardizeMyanmar(value);
        } else if (this.locale.childOf(KYRGYZ)) {
            value = this.replaceChars(path, value, KYRGYZ_CONVERSIONS, false);
        } else if (this.locale.childOf(URDU) || this.locale.childOf(PASHTO) || this.locale.childOf(FARSI)) {
            value = this.replaceChars(path, value, URDU_PLUS_CONVERSIONS, true);
        } else if (this.locale.childOf(FF_ADLAM) && !isUnicodeSet) {
            value = DisplayAndInputProcessor.fixAdlamNasalization(value);
        } else if (this.locale.childOf(KASHMIRI)) {
            value = this.replaceChars(path, value, KASHMIRI_CONVERSIONS, false);
        }
        return value;
    }

    private String processAnnotations(String path, String value) {
        if (AnnotationUtil.pathIsAnnotation(path)) {
            value = path.contains("[@type=\"tts\"]") ? SPLIT_BAR.split(value).iterator().next() : DisplayAndInputProcessor.annotationsForDisplay(value);
        }
        return value;
    }

    private String normalizeNameOrderLocales(String value) {
        value = value.replace(EMPTY_ELEMENT_VALUE, "");
        TreeSet<String> result = new TreeSet<String>(SPLIT_SPACE.splitToList(value));
        result.remove("zxx");
        if (result.remove("und")) {
            if (result.isEmpty()) {
                return "und";
            }
            return "und " + JOIN_SPACE.join(result);
        }
        return JOIN_SPACE.join(result);
    }

    private String stripProblematicControlCharacters(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return s2;
        }
        return s2.codePoints().filter(c -> c >= 32 || c == 9 || c == 10 || c == 13).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static String annotationsForDisplay(String value) {
        TreeSet<Object> sorted = new TreeSet<Object>(Collator.getInstance(ULocale.ROOT));
        sorted.addAll(SPLIT_BAR.splitToList(value));
        DisplayAndInputProcessor.filterCoveredKeywords(sorted);
        value = JOIN_BAR.join(sorted);
        return value;
    }

    public static void filterCoveredKeywords(TreeSet<String> sorted) {
        HashSet<String> toRemove = new HashSet<String>();
        TreeSet<String> sortedLower = new TreeSet<String>();
        for (String item : sorted) {
            sortedLower.add(item.toLowerCase(Locale.ROOT));
        }
        for (String item : sorted) {
            List<String> list = SPLIT_SPACE.splitToList(item);
            if (list.size() < 2) continue;
            if (sorted.containsAll(list)) {
                toRemove.add(item);
                continue;
            }
            ArrayList<String> listLower = new ArrayList<String>();
            for (String s2 : list) {
                listLower.add(s2.toLowerCase(Locale.ROOT));
            }
            if (!sortedLower.containsAll(listLower)) continue;
            toRemove.add(item);
        }
        sorted.removeAll(toRemove);
    }

    public static void filterKeywordsDifferingOnlyInCase(TreeSet<String> sorted) {
        TreeMultimap mapFromLower = TreeMultimap.create();
        for (String item : sorted) {
            mapFromLower.put(item.toLowerCase(), item);
        }
        TreeSet<String> toRetain = new TreeSet<String>();
        for (String lower : mapFromLower.keySet()) {
            SortedSet variants = mapFromLower.get(lower);
            Iterator iterator = variants.iterator();
            if (!iterator.hasNext()) continue;
            String var = (String)iterator.next();
            toRetain.add(var);
        }
        sorted.retainAll(toRetain);
    }

    private String displayUnicodeSet(String value) {
        return this.pp.format(new UnicodeSet(value));
    }

    private String inputUnicodeSet(String path, String value) {
        UnicodeSet exemplar = null;
        if ((value = value.trim()).startsWith("[") && value.endsWith("]")) {
            try {
                exemplar = new UnicodeSet(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (exemplar == null) {
            try {
                exemplar = this.pp.parse(value);
            }
            catch (Exception e) {
                return value;
            }
        }
        XPathParts parts = XPathParts.getFrozenInstance(path);
        String type = parts.getAttributeValue(-1, "type");
        CheckExemplars.ExemplarType exemplarType = !path.contains("exemplarCharacters") ? null : (type == null ? CheckExemplars.ExemplarType.main : CheckExemplars.ExemplarType.from(type));
        value = this.getCleanedUnicodeSet(exemplar, exemplarType);
        return value;
    }

    private String normalizeCurrencyDisplayName(String value) {
        StringBuilder result = new StringBuilder();
        boolean inParentheses = false;
        for (int i = 0; i < value.length(); ++i) {
            int c = value.charAt(i);
            if (c == 40) {
                inParentheses = true;
            } else if (c == 41) {
                inParentheses = false;
            }
            if (inParentheses && c == 45 && Character.isDigit(value.charAt(i - 1))) {
                c = 8211;
            }
            result.append((char)c);
        }
        return result.toString();
    }

    private String normalizeApostrophes(String value) {
        if (LANGUAGES_USING_MODIFIER_APOSTROPHE.contains(this.locale.getLanguage())) {
            return value.replace('\'', '\u02bc');
        }
        char prev = '\u0000';
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\'') {
                if (Character.isLetter(prev)) {
                    builder.append('\u2019');
                } else {
                    builder.append('\u2018');
                }
            } else {
                builder.append(c);
            }
            prev = c;
        }
        return builder.toString();
    }

    private String normalizeIntervalHyphensAndSpaces(String value) {
        if (value.contains("{0}")) {
            if (this.scriptCode.equals("Latn")) {
                value = INTERVAL_FALLBACK_RANGE.matcher(value).replaceAll("}\u2009\u2013\u2009{");
            }
            return value;
        }
        DateTimePatternGenerator.FormatParser fp = new DateTimePatternGenerator.FormatParser();
        fp.set(DateIntervalInfo.genPatternInfo(value, false).getFirstPart());
        List<Object> items = fp.getItems();
        Object last = items.get(items.size() - 1);
        if (last instanceof String) {
            String separator = last.toString();
            Object replacement = separator;
            if (this.scriptCode.equals("Latn") && (separator.endsWith(" - ") || separator.endsWith(" \u2013 "))) {
                replacement = separator.substring(0, separator.length() - 3) + "\u2009\u2013\u2009";
            } else if (separator.contains("-")) {
                replacement = separator.replace("-", "\u2013");
            }
            if (!((String)replacement).equals(separator)) {
                StringBuilder sb = new StringBuilder();
                sb.append(DateIntervalInfo.genPatternInfo(value, false).getFirstPart());
                if (sb.lastIndexOf(separator) >= 0) {
                    sb.delete(sb.lastIndexOf(separator), sb.length());
                    sb.append((String)replacement);
                    sb.append(DateIntervalInfo.genPatternInfo(value, false).getSecondPart());
                    return sb.toString();
                }
            }
        }
        return value;
    }

    private String normalizeHyphens(String value) {
        int hyphenLocation = value.indexOf("-");
        if (hyphenLocation > 0 && Character.isDigit(value.charAt(hyphenLocation - 1)) && hyphenLocation < value.length() - 1 && Character.isDigit(value.charAt(hyphenLocation + 1))) {
            return value.substring(0, hyphenLocation) + "\u2013" + value.substring(hyphenLocation + 1);
        }
        return value;
    }

    private String standardizeRomanian(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            for (char[] pair : ROMANIAN_CONVERSIONS) {
                if (c != pair[0]) continue;
                c = pair[1];
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String standardizeKwasio(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            for (char[] pair : KWASIO_CONVERSIONS) {
                if (c != pair[0]) continue;
                c = pair[1];
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String standardizeMyanmar(String value) {
        if (detector.getZawgyiProbability(value) > 0.9) {
            return zawgyiUnicodeTransliterator.transform(value);
        }
        return value;
    }

    private String standardizeNgomba(String value) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = value.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            int c = charArray[i];
            boolean convertedSaltillo = false;
            for (char[] pair : NGOMBA_CONVERSIONS) {
                if (c != pair[0]) continue;
                c = pair[1];
                if (c != 42892) break;
                convertedSaltillo = true;
                break;
            }
            if (convertedSaltillo && (i > 0 && i < charArray.length - 1 && Character.isUpperCase(charArray[i - 1]) && Character.isUpperCase(charArray[i + 1]) || i > 1 && Character.isUpperCase(charArray[i - 1]) && Character.isUpperCase(charArray[i - 2]))) {
                c = 42891;
            }
            builder.append((char)c);
        }
        return builder.toString();
    }

    private String replaceChars(String path, String value, char[][] charsToReplace, boolean skipAuxExemplars) {
        if (skipAuxExemplars && path.contains("/exemplarCharacters[@type=\"auxiliary\"]")) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            for (char[] pair : charsToReplace) {
                if (c != pair[0]) continue;
                c = pair[1];
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String standardizeSwissGerman(String value) {
        return value.replaceAll("\u00df", "ss");
    }

    private String standardizeCatalan(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            boolean didSubstitute = false;
            for (char[] triple : CATALAN_CONVERSIONS) {
                if (c != triple[0]) continue;
                builder.append(triple[1]);
                builder.append(triple[2]);
                didSubstitute = true;
                break;
            }
            if (didSubstitute) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private String replace(Pattern pattern, String value, String replacement) {
        String value2 = pattern.matcher(value).replaceAll(replacement);
        if (DEBUG_DAIP && !value.equals(value2)) {
            System.out.println("\n" + value + " => " + value2);
        }
        return value2;
    }

    private String normalizeMalayalam(String value) {
        Matcher matcher = UNNORMALIZED_MALAYALAM.matcher(value);
        if (matcher.find()) {
            StringBuffer buffer = new StringBuffer();
            int start = 0;
            do {
                buffer.append(value, start, matcher.start(0));
                char codePoint = matcher.group(1).charAt(0);
                buffer.append(NORMALIZING_MAP.get(Character.valueOf(codePoint)));
                start = matcher.end(0);
            } while (matcher.find());
            buffer.append(value.substring(start));
            value = buffer.toString();
        }
        return value;
    }

    private String replaceArabicPresentationForms(String value) {
        value = fixArabicPresentation.transform(value);
        return value;
    }

    public static String fixAdlamNasalization(String fromString) {
        return ADLAM_MISNASALIZED.matcher(fromString).replaceAll("$1" + ADLAM_NASALIZATION + "$2");
    }

    public String getCleanedUnicodeSet(UnicodeSet exemplar, CheckExemplars.ExemplarType exemplarType) {
        if (this.rawFormatter == null) {
            throw new IllegalArgumentException("Formatter must not be null");
        }
        if (exemplar == null) {
            throw new IllegalArgumentException("set to be cleaned must not be null");
        }
        UnicodeSet toAdd = new UnicodeSet();
        UnicodeSetIterator usi = new UnicodeSetIterator(exemplar);
        while (usi.next()) {
            String string = usi.getString();
            if (string.equals("\u00df") || string.equals("\u0130")) {
                toAdd.add(string);
                continue;
            }
            switch (string) {
                case "\u2011": {
                    toAdd.add("-");
                    break;
                }
                case "-": {
                    toAdd.add("\u2011");
                    break;
                }
                case " ": {
                    toAdd.add("\u00a0");
                    break;
                }
                case "\u00a0": {
                    toAdd.add(" ");
                    break;
                }
                case "\u202f": {
                    toAdd.add("\u2009");
                    break;
                }
                case "\u2009": {
                    toAdd.add("\u202f");
                }
            }
            if (exemplarType != null && exemplarType.convertUppercase) {
                string = UCharacter.toLowerCase(ULocale.ENGLISH, string);
            }
            toAdd.add(string);
            String composed = Normalizer.compose(string, false);
            if (string.equals(composed)) continue;
            toAdd.add(composed);
        }
        if (exemplarType != null) {
            toAdd.removeAll(exemplarType.toRemove);
        }
        String value = this.rawFormatter.format(toAdd);
        return value;
    }

    public static String getCanonicalPattern(String inpattern, NumericType type, boolean isPOSIX) {
        if (type == NumericType.RATIONAL) {
            return inpattern.replace("}{", "}\u202f{").replace("/", "\u2044");
        }
        DecimalFormat df = new DecimalFormat(inpattern);
        if (type == NumericType.DECIMAL_ABBREVIATED || type == NumericType.CURRENCY_ABBREVIATED || CldrUtility.INHERITANCE_MARKER.equals(inpattern)) {
            return inpattern;
        }
        int[] digits = isPOSIX ? type.posixDigitCount : type.digitCount;
        df.setMinimumIntegerDigits(digits[0]);
        df.setMinimumFractionDigits(digits[1]);
        df.setMaximumFractionDigits(digits[2]);
        String pattern = df.toPattern();
        List<String> parts = SEMI_SPLITTER.splitToList(pattern);
        Object pattern2 = parts.get(0);
        if (parts.size() > 1) {
            pattern2 = (String)pattern2 + ";" + parts.get(1);
        }
        if (!((String)pattern2).equals(pattern)) {
            pattern = pattern2;
        }
        return pattern;
    }

    public void enableInheritanceReplacement(CLDRFile cldrFile) {
        this.cldrFileForBailey = cldrFile;
    }

    private String normalizeWhitespace(String path, String value) {
        PathSpaceType pst = PathSpaceType.get(path);
        if (pst == PathSpaceType.allowSp) {
            value = WHITESPACE_AND_NBSP_TO_NORMALIZE.matcher(value).replaceAll(" ");
        } else if (pst == PathSpaceType.allowNbsp) {
            value = WHITESPACE_AND_NBSP_TO_NORMALIZE.matcher(value).replaceAll("\u00a0");
            value = this.trimNBSP(value);
        } else if (pst == PathSpaceType.allowNNbsp) {
            value = WHITESPACE_AND_NBSP_TO_NORMALIZE.matcher(value).replaceAll("\u202f");
            value = this.trimNBSP(value);
        } else if (pst == PathSpaceType.allowSpOrNbsp) {
            value = WHITESPACE_NO_NBSP_TO_NORMALIZE.matcher(value).replaceAll(" ");
            value = NBSP_PLUS_SPACE_TO_NORMALIZE.matcher(value).replaceAll("\u00a0");
            value = SPACE_PLUS_NBSP_TO_NORMALIZE.matcher(value).replaceAll("\u00a0");
            value = MULTIPLE_NBSP.matcher(value).replaceAll("\u00a0");
            value = this.trimNBSP(value);
        } else {
            throw new IllegalArgumentException("Unknown PathSpaceType " + String.valueOf((Object)pst));
        }
        if ((this.scriptCode.equals("Latn") || this.scriptCode.equals("Cyrl") || this.scriptCode.equals("Grek")) && HOUR_FORMAT_XPATHS.matcher(path).matches()) {
            String spaceReplace;
            String test = AMPM_SPACE_BEFORE.matcher(value).replaceAll("$1$2");
            String string = spaceReplace = path.contains("ascii") ? "$1 $3" : "$1\u202f$3";
            if (value.length() - test.length() != 4) {
                value = AMPM_SPACE_BEFORE.matcher(value).replaceAll(spaceReplace);
            }
            test = AMPM_SPACE_AFTER.matcher(value).replaceAll("$2$3");
            if (value.length() - test.length() != 4) {
                value = AMPM_SPACE_AFTER.matcher(value).replaceAll(spaceReplace);
            }
        }
        if (this.scriptCode.equals("Cyrl") && YEAR_FORMAT_XPATHS.matcher(path).matches()) {
            value = YEAR_SPACE_YEARMARKER.matcher(value).replaceAll("y\u202f$1");
        }
        if (UNIT_NARROW_XPATHS.matcher(path).matches()) {
            value = PLACEHOLDER_SPACE_AFTER.matcher(value).replaceAll("}\u202f");
            value = PLACEHOLDER_SPACE_BEFORE.matcher(value).replaceAll("\u202f{");
        }
        if (UNIT_SHORT_XPATHS.matcher(path).matches()) {
            value = PLACEHOLDER_SPACE_AFTER.matcher(value).replaceAll("}\u00a0");
            value = PLACEHOLDER_SPACE_BEFORE.matcher(value).replaceAll("\u00a0{");
        }
        value = NNBSP_AMONG_OTHER_SPACES.matcher(value).replaceAll("\u202f");
        value = NBSP_AMONG_OTHER_SPACES.matcher(value).replaceAll("\u00a0");
        value = THIN_SPACE_AMONG_OTHER_SPACES.matcher(value).replaceAll("\u2009");
        return value;
    }

    private String trimNBSP(String value) {
        if (!value.equals("\u00a0") && !value.equals("\u202f")) {
            value = INITIAL_NBSP.matcher(value).replaceAll("");
            value = FINAL_NBSP.matcher(value).replaceAll("");
        }
        return value;
    }

    private String normalizeZeroWidthSpace(String value) {
        String localeId;
        if (ZERO_WIDTH_SPACES.matcher(value).find() && LOCALES_NOT_ALLOWING_ZWS.contains(localeId = this.locale.getBaseName())) {
            value = ZERO_WIDTH_SPACES.matcher(value).replaceAll("");
        }
        return value;
    }

    public String replaceBaileyWithInheritanceMarker(String path, String value) {
        Output<String> localeWhereFound;
        Output<String> pathWhereFound;
        String baileyValue;
        if (this.cldrFileForBailey != null && !value.isEmpty() && value.equals(baileyValue = this.cldrFileForBailey.getBaileyValue(path, pathWhereFound = new Output<String>(), localeWhereFound = new Output<String>())) && !"root".equals(localeWhereFound.value) && !"code-fallback".equals(localeWhereFound.value)) {
            return CldrUtility.INHERITANCE_MARKER;
        }
        return value;
    }

    public static enum PathSpaceType {
        allowSp,
        allowNbsp,
        allowNNbsp,
        allowSpOrNbsp;


        public static PathSpaceType get(String path) {
            if (PathSpaceType.wantsRegularSpace(path)) {
                return allowSp;
            }
            if (PathSpaceType.wantsNBSP(path)) {
                return allowNbsp;
            }
            if (PathSpaceType.wantsNNBSP(path)) {
                return allowNNbsp;
            }
            return allowSpOrNbsp;
        }

        private static boolean wantsRegularSpace(String path) {
            return path.contains("/dateFormatLength") && path.contains("/pattern") || path.contains("/availableFormats/dateFormatItem") || path.startsWith("//ldml/dates/timeZoneNames/metazone") && path.contains("/long") || path.startsWith("//ldml/dates/timeZoneNames/regionFormat") || path.startsWith("//ldml/localeDisplayNames/codePatterns/codePattern") || path.startsWith("//ldml/localeDisplayNames/languages/language") || path.startsWith("//ldml/localeDisplayNames/territories/territory") || path.startsWith("//ldml/localeDisplayNames/types/type") || path.startsWith("//ldml/numbers/currencies/currency") && path.contains("/displayName") || path.contains("/decimalFormatLength[@type=\"long\"]") && path.contains("/pattern") || path.startsWith("//ldml/posix/messages") || path.startsWith("//ldml/units/uni") && path.contains("/unitPattern ");
        }

        private static boolean wantsNBSP(String path) {
            return path.contains("/currencies/currency") && (path.contains("/group") || path.contains("/pattern")) || path.contains("/currencyFormatLength") && path.contains("/pattern") || path.contains("/currencySpacing") && path.contains("/insertBetween") || path.contains("/decimalFormatLength") && path.contains("/pattern") || path.contains("/percentFormatLength") && path.contains("/pattern") || path.startsWith("//ldml/numbers/symbols") && (path.contains("/group") || path.contains("/nan"));
        }

        private static boolean wantsNNBSP(String path) {
            return !(!path.contains("/dayPeriodWidth[@type=\"abbreviated\"]") && !path.contains("/dayPeriodWidth[@type=\"narrow\"]") || !path.contains("/dayPeriod[@type=\"am\"]") && !path.contains("/dayPeriod[@type=\"pm\"]"));
        }
    }

    public static enum NumericType {
        CURRENCY(new int[]{1, 2, 2}, new int[]{1, 2, 2}),
        CURRENCY_ABBREVIATED,
        DECIMAL(new int[]{1, 0, 3}, new int[]{1, 0, 6}),
        DECIMAL_ABBREVIATED,
        PERCENT(new int[]{1, 0, 0}, new int[]{1, 0, 0}),
        SCIENTIFIC(new int[]{0, 0, 0}, new int[]{1, 6, 6}),
        RATIONAL,
        NOT_NUMERIC;

        private static final Pattern NUMBER_PATH;
        private int[] digitCount;
        private int[] posixDigitCount;

        private NumericType() {
        }

        private NumericType(int[] digitCount, int[] posixDigitCount) {
            this.digitCount = digitCount;
            this.posixDigitCount = posixDigitCount;
        }

        public static NumericType getNumericType(String xpath) {
            Matcher matcher = NUMBER_PATH.matcher(xpath);
            if (xpath.contains("rational")) {
                return RATIONAL;
            }
            if (!xpath.contains("/pattern")) {
                return NOT_NUMERIC;
            }
            if (matcher.matches()) {
                if (matcher.group(1).equals("currencies/currency")) {
                    return CURRENCY;
                }
                NumericType type = NumericType.valueOf(matcher.group(2).toUpperCase());
                if (xpath.contains("=\"1000")) {
                    if (type == DECIMAL) {
                        type = DECIMAL_ABBREVIATED;
                    } else if (type == CURRENCY) {
                        type = CURRENCY_ABBREVIATED;
                    } else {
                        throw new IllegalArgumentException("Internal Error");
                    }
                }
                return type;
            }
            return NOT_NUMERIC;
        }

        public int[] getDigitCount() {
            return this.digitCount;
        }

        public int[] getPosixDigitCount() {
            return this.posixDigitCount;
        }

        static {
            NUMBER_PATH = Pattern.compile("//ldml/numbers/((currency|decimal|percent|scientific|rational)Formats|currencies/currency).*");
        }
    }
}

