/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.test;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.ibm.icu.text.UnicodeSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrIntervalFormat;
import org.unicode.cldr.util.XPathParts;

public class RelatedDatePathValues {
    public static final int calendarElement = 3;
    public static final int dateTypeElement = 5;
    public static final int idElement = 6;
    static final XPathParts available = XPathParts.getFrozenInstance("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/availableFormats/dateFormatItem[@id=\"MMMd\"]");
    static final XPathParts interval = XPathParts.getFrozenInstance("//ldml/dates/calendars/calendar[@type=\"gregorian\"]/dateTimeFormats/intervalFormats/intervalFormatItem[@id=\"Bhm\"]/greatestDifference[@id=\"B\"]");
    private static LoadingCache<String, Set<String>> skeletonToCores = CacheBuilder.newBuilder().build(new CacheLoader<String, Set<String>>(){

        @Override
        public Set<String> load(String skeleton) throws ExecutionException {
            TreeSet<String> cores = new TreeSet<String>(SKELETON_COMPARE);
            RelatedDatePathValues.addCore(skeleton, "G", cores);
            RelatedDatePathValues.addCore(skeleton, "E", cores);
            RelatedDatePathValues.addCore(skeleton, "v", cores);
            return ImmutableSet.copyOf(cores);
        }
    });
    public static Comparator<String> SKELETON_COMPARE = new Comparator<String>(){
        final UnicodeSet ODD_DATE_FIELDS = new UnicodeSet("[UQWw]").freeze();
        final UnicodeSet DATE_FIELDS = new UnicodeSet("[d G M Q U wW y]").freeze();
        final UnicodeSet YEAR_FIELDS = new UnicodeSet("[yU]").freeze();
        final UnicodeSet HOUR_FIELDS = new UnicodeSet("[Hh]").freeze();
        final UnicodeSet TIME_FIELDS = new UnicodeSet("[B hH m s v]").freeze();

        @Override
        public int compare(String o1, String o2) {
            return ComparisonChain.start().compare(this.DATE_FIELDS.containsSome(o2), this.DATE_FIELDS.containsSome(o1)).compare(this.ODD_DATE_FIELDS.containsSome(o1), this.ODD_DATE_FIELDS.containsSome(o2)).compare(this.YEAR_FIELDS.containsSome(o2), this.YEAR_FIELDS.containsSome(o1)).compare(o1.contains("U"), o2.contains("U")).compare(o1.contains("M"), o2.contains("M")).compare(o1.contains("d"), o2.contains("d")).compare(this.HOUR_FIELDS.containsSome(o2), this.HOUR_FIELDS.containsSome(o1)).compare(o1.contains("m"), o2.contains("m")).compare(o1.contains("s"), o2.contains("s")).compare(o1.length(), o2.length()).compare((Comparable<?>)((Object)o1), (Comparable<?>)((Object)o2)).result();
        }
    };

    public static Set<String> getRelatedPathValues(CLDRFile cldrFile, XPathParts xparts) {
        if (xparts.size() <= 6) {
            return Set.of();
        }
        switch (xparts.getElement(5)) {
            case "availableFormats": {
                return RelatedDatePathValues.forAvailable(cldrFile, xparts);
            }
            case "intervalFormats": {
                return RelatedDatePathValues.forInterval(cldrFile, xparts);
            }
        }
        return Set.of();
    }

    private static Set<String> forAvailable(CLDRFile cldrFile, XPathParts xparts) {
        LinkedHashSet<String> skeletons = new LinkedHashSet<String>();
        String skeleton = xparts.getAttributeValue(6, "id");
        boolean added = RelatedDatePathValues.addRelated(skeleton, "G", skeletons);
        added |= RelatedDatePathValues.addRelated(skeleton, "E", skeletons);
        if (!(added |= RelatedDatePathValues.addRelated(skeleton, "v", skeletons))) {
            added = RelatedDatePathValues.addRelated(skeleton, "y", skeletons);
        }
        if (!added) {
            RelatedDatePathValues.addRelated(skeleton, "M", skeletons);
        }
        if (!added) {
            return Set.of();
        }
        XPathParts newPath = xparts.cloneAsThawed();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String item : skeletons) {
            RelatedDatePathValues.addAvailable(cldrFile, newPath, item, result);
        }
        return result;
    }

    private static boolean addRelated(String skeleton, String typeToRemove, Set<String> skeletons) {
        String newItem;
        if (skeleton.contains(typeToRemove) && (newItem = skeleton.replace(typeToRemove, "")).length() > 1 && !newItem.equals(skeleton)) {
            return skeletons.add(newItem);
        }
        return false;
    }

    private static Set<String> forInterval(CLDRFile cldrFile, XPathParts xparts) {
        XPathParts newAvailableParts = available.cloneAsThawed();
        String calendar = xparts.getAttributeValue(3, "type");
        newAvailableParts.putAttributeValue(3, "type", calendar);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String intervalId = xparts.getAttributeValue(6, "id");
        RelatedDatePathValues.addAvailable(cldrFile, newAvailableParts, intervalId, result);
        String intervalPattern = cldrFile.getStringValue(xparts.toString());
        if (intervalPattern != null) {
            CldrIntervalFormat intervalFormat = CldrIntervalFormat.getInstance(calendar, intervalPattern);
            String intervalId2 = CldrIntervalFormat.removeMissingFieldsFromSkeleton(intervalId, intervalFormat.firstFields);
            RelatedDatePathValues.addAvailable(cldrFile, newAvailableParts, intervalId2, result);
            String intervalId3 = CldrIntervalFormat.removeMissingFieldsFromSkeleton(intervalId, intervalFormat.secondFields);
            RelatedDatePathValues.addAvailable(cldrFile, newAvailableParts, intervalId3, result);
        }
        return ImmutableSet.copyOf(result);
    }

    private static void addAvailable(CLDRFile cldrFile, XPathParts newPath, String intervalId, Set<String> result) {
        newPath.putAttributeValue(6, "id", intervalId);
        String pattern = cldrFile.getStringValue(newPath.toString());
        if (pattern != null) {
            result.add(pattern);
        }
    }

    public static Set<String> getCores(String skeleton) {
        try {
            return skeletonToCores.get(skeleton);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void addCore(String skeleton, String letter, Collection<String> cores) {
        String skeleton2;
        if (skeleton.contains(letter) && !(skeleton2 = skeleton.replace(letter, "")).equals(skeleton) && RelatedDatePathValues.hasMoreThanOneField(skeleton2)) {
            cores.add(skeleton2);
        }
    }

    private static boolean hasMoreThanOneField(String skeleton) {
        return !skeleton.isEmpty() && skeleton.charAt(0) != skeleton.charAt(skeleton.length() - 1);
    }

    public static boolean contains(String value, String coreValue) {
        int pos = value.indexOf(coreValue);
        int posEnd = pos + coreValue.length();
        return !(pos < 0 || pos != 0 && value.charAt(pos - 1) == coreValue.charAt(0) || posEnd != value.length() && value.charAt(posEnd) == coreValue.charAt(coreValue.length() - 1));
    }

    public static enum Goal {
        example,
        test;

    }

    public static enum SkeletonPathType {
        na,
        available,
        interval,
        datetime;


        public static SkeletonPathType fromParts(XPathParts xparts) {
            if (xparts.size() >= 6) {
                switch (xparts.getElement(5)) {
                    case "availableFormats": {
                        return xparts.getAttributeValue(6, "id") == null ? na : available;
                    }
                    case "intervalFormats": {
                        return xparts.getAttributeValue(6, "id") == null ? na : interval;
                    }
                    case "dateFormatLength": 
                    case "timeFormatLength": {
                        return "datetimeSkeleton".equals(xparts.getElement(-1)) ? datetime : na;
                    }
                }
            }
            return na;
        }
    }
}

