/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.File;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathUtilities;
import org.unicode.cldr.util.PatternCache;

public class CLDRCompare {
    public static void main(String[] args) throws Exception {
        String filter = CldrUtility.getProperty("filter", ".*");
        Matcher matcher = PatternCache.get(filter).matcher("");
        File oldVersion = new File(CldrUtility.getProperty("old", PathUtilities.getNormalizedPathString(CLDRPaths.COMMON_DIRECTORY + "../../../common-cldr1.6", new String[0])));
        if (!oldVersion.exists()) {
            throw new IllegalArgumentException("Directory not found");
        }
        File newVersion = new File(CldrUtility.getProperty("new", CLDRPaths.COMMON_DIRECTORY));
        if (!newVersion.exists()) {
            throw new IllegalArgumentException("Directory not found");
        }
        CLDRCompare.printLine("Dir", "File", "Same", "New", "Deleted", "\u2260Value", "\u2260Path\u2260Value", "\u2260Path");
        System.out.println("Directory\tFile\tNew\tDeleted\tSameValue\tDifferentValue");
        for (String subDir : newVersion.list()) {
            String newSubDir;
            File srcDir;
            if (subDir.equals("CVS") || subDir.equals("posix") || subDir.equals("test") || !(srcDir = new File(newSubDir = PathUtilities.getNormalizedPathString(newVersion) + "/" + subDir)).isDirectory()) continue;
            String oldSubDir = PathUtilities.getNormalizedPathString(oldVersion) + "/" + subDir;
            TreeSet<String> files = new TreeSet<String>();
            Factory cldrFactory = Factory.make(newSubDir, ".*");
            files.addAll(cldrFactory.getAvailable());
            Factory oldFactory = null;
            try {
                oldFactory = Factory.make(oldSubDir, ".*");
                files.addAll(oldFactory.getAvailable());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String file : files) {
                String subDirKey = subDir + "/" + file;
                if (!matcher.reset(subDirKey).find()) continue;
                HashSet paths = new HashSet();
                CLDRFile newCldrFile = null;
                try {
                    newCldrFile = cldrFactory.make(file, false);
                    newCldrFile.forEach(paths::add);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CLDRFile oldCldrFile = null;
                try {
                    oldCldrFile = oldFactory.make(file, false);
                    oldCldrFile.forEach(paths::add);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int sameCount = 0;
                int diffBothCount = 0;
                int deletedCount = 0;
                int newCount = 0;
                int diffValueCount = 0;
                int diffPathCount = 0;
                for (String path : paths) {
                    String oldValue;
                    String newValue = newCldrFile == null ? null : newCldrFile.getStringValue(path);
                    String string = oldValue = oldCldrFile == null ? null : oldCldrFile.getStringValue(path);
                    if (newValue == null) {
                        if (oldValue != null) {
                            ++deletedCount;
                            continue;
                        }
                        throw new IllegalArgumentException("Should never happen");
                    }
                    if (oldValue == null) {
                        ++newCount;
                        continue;
                    }
                    String newFullPath = newCldrFile.getFullXPath(path);
                    String oldFullPath = oldCldrFile.getFullXPath(path);
                    boolean valuesSame = newValue.equals(oldValue);
                    boolean pathsSame = newFullPath.equals(oldFullPath);
                    if (valuesSame && pathsSame) {
                        ++sameCount;
                        continue;
                    }
                    if (valuesSame) {
                        ++diffValueCount;
                        continue;
                    }
                    if (pathsSame) {
                        ++diffPathCount;
                        continue;
                    }
                    ++diffBothCount;
                }
                CLDRCompare.printLine(subDir, file, sameCount, newCount, deletedCount, diffValueCount, diffBothCount, diffPathCount);
            }
        }
    }

    private static void printLine(String subDir, String file, Object sameCount, Object newCount, Object deletedCount, Object diffValueCount, Object diffBothCount, Object diffPathCount) {
        System.out.println(subDir + "\t" + file + "\t" + String.valueOf(sameCount) + "\t" + String.valueOf(newCount) + "\t" + String.valueOf(deletedCount) + "\t" + String.valueOf(diffValueCount) + "\t" + String.valueOf(diffPathCount) + "\t" + String.valueOf(diffBothCount));
    }
}

