/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.tool.Option;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.PathHeader;

public class CompareLocales {
    public static void main(String[] args) {
        AbstractCollection locales;
        MyOptions.parse(args);
        Matcher pathMatcher = !MyOptions.pathFilter.option.doesOccur() ? null : Pattern.compile(MyOptions.pathFilter.option.getValue()).matcher("");
        Matcher fileMatcher = !MyOptions.fileFilter.option.doesOccur() ? null : Pattern.compile(MyOptions.fileFilter.option.getValue()).matcher("");
        Factory factory = CLDRConfig.getInstance().getMainAndAnnotationsFactory();
        if (args.length != 0) {
            Arrays.sort(args);
            locales = ImmutableList.copyOf(Arrays.asList(args));
        } else {
            locales = new ArrayList();
            for (String locale : factory.getAvailable()) {
                if (fileMatcher != null && !pathMatcher.reset(locale).matches()) continue;
                locales.add(locale);
            }
            locales = ImmutableList.copyOf(locales);
        }
        ArrayList<CLDRFile> files = new ArrayList<CLDRFile>();
        HashSet<String> paths = new HashSet<String>();
        String prefix = "No\tSection\tPage\tHeader\tCode\t";
        for (Object locale : locales) {
            System.out.print(prefix + (String)locale);
            prefix = "\t";
            CLDRFile cldrFile = factory.make((String)locale, true);
            files.add(cldrFile);
            for (String path : cldrFile) {
                paths.add(path);
            }
        }
        CompareLocales.showDiff((List<String>)((Object)locales), (vi, vj) -> vi + " \u225f " + vj);
        System.out.println("\tConfig (2nd to last locale gets last value)");
        TreeSet<PathHeader> sorted = new TreeSet<PathHeader>();
        for (String path : paths) {
            if (pathMatcher != null && !pathMatcher.reset(path).matches()) continue;
            sorted.add(PathHeader.getFactory().fromPath(path));
        }
        ArrayList<String> tempList = new ArrayList<String>();
        CLDRFile.Status status = new CLDRFile.Status();
        int count = 0;
        for (PathHeader ph : sorted) {
            if (ph.getSectionId() == PathHeader.SectionId.Special) continue;
            tempList.clear();
            boolean atLocation = false;
            boolean someDifferent = false;
            String last = null;
            boolean isFirst = true;
            String originalPath = ph.getOriginalPath();
            for (CLDRFile cldrFile : files) {
                String stringValue = cldrFile.getStringValue(originalPath);
                tempList.add(stringValue);
                cldrFile.getSourceLocaleID(originalPath, status);
                if (status.pathWhereFound.equals(originalPath)) {
                    atLocation |= true;
                }
                if (!isFirst) {
                    someDifferent |= !Objects.equals(stringValue, last);
                }
                last = stringValue;
                isFirst = false;
            }
            if (!atLocation || !someDifferent) continue;
            System.out.print(++count + "\t" + String.valueOf(ph));
            for (String value : tempList) {
                System.out.print("\t" + value);
            }
            CompareLocales.showDiff(tempList, (vi, vj) -> Objects.equals(vi, vj) ? "\uff1d" : "\u2260");
            String penultimateLocale = (String)locales.get(locales.size() - 2);
            String ultimateValue = (String)tempList.get(tempList.size() - 1);
            System.out.println("\tlocale=" + penultimateLocale + "; action=addNew; new_path=" + originalPath + "; new_value=" + ultimateValue);
        }
    }

    private static void showDiff(List<String> list, BiFunction<String, String, String> func) {
        for (int i = 0; i < list.size() - 1; ++i) {
            String vi = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                String vj = list.get(j);
                System.out.print("\t" + func.apply(vi, vj));
            }
        }
    }

    private static enum MyOptions {
        fileFilter(new Option.Params().setHelp("filter paths").setMatch(".*")),
        pathFilter(new Option.Params().setHelp("filter paths").setMatch(".*")),
        verbose(new Option.Params().setHelp("verbose debugging messages"));

        final Option option;
        private static Option.Options myOptions;

        private MyOptions(Option.Params params) {
            this.option = new Option(this, params);
        }

        private static Set<String> parse(String[] args) {
            return myOptions.parse(MyOptions.values()[0], args, true);
        }

        static {
            myOptions = new Option.Options();
            for (MyOptions option : MyOptions.values()) {
                myOptions.add(option, option.option);
            }
        }
    }
}

