/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRLocale;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CLDRTool;
import org.unicode.cldr.util.CLDRTreeWriter;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SimpleXMLSource;

@CLDRTool(alias="copy-main-to-subdivisions", description="Copy from common/main to common/subdivisions")
public class CopyMainToSubdivisions {
    static void copyCommonToSubdivisions() throws IOException {
        CLDRConfig config = CLDRConfig.getInstance();
        Factory subFactory = config.getSubdivisionFactory();
        Factory mainFactory = config.getFullCldrFactory();
        Set<CLDRLocale> subLocales = subFactory.getAvailableCLDRLocales();
        Set<CLDRLocale> mainLocales = mainFactory.getAvailableCLDRLocales();
        System.out.println("# Copying from common/main to common/subdivisions");
        int totalChanges = 0;
        try (CLDRTreeWriter treeWriter = new CLDRTreeWriter(CLDRPaths.SUBDIVISIONS_DIRECTORY);){
            for (CLDRLocale l : mainLocales) {
                CLDRFile outSubFile = null;
                CLDRFile mainF = mainFactory.make(l.getBaseName(), false);
                int changes = 0;
                outSubFile = subLocales.contains(l) ? subFactory.make(l.getBaseName(), false).cloneAsThawed() : new CLDRFile(new SimpleXMLSource(l.getBaseName()));
                Iterator<String> it = mainF.iterator("//ldml/localeDisplayNames/subdivisions/subdivision");
                while (it.hasNext()) {
                    String subFullPath;
                    String p = it.next();
                    String commonValue = mainF.getStringValue(p);
                    String subValue = outSubFile.getStringValue(p);
                    if (commonValue == null || !mainF.isHere(p)) continue;
                    String mainFullPath = mainF.getFullXPath(p);
                    String string = subFullPath = subValue == null ? null : outSubFile.getFullXPath(p);
                    if (subValue != null && subValue.equals(commonValue) && mainFullPath.equals(subFullPath)) continue;
                    ++changes;
                    outSubFile.remove(p);
                    outSubFile.add(mainFullPath, commonValue);
                }
                if (changes <= 0) continue;
                treeWriter.write(outSubFile);
                totalChanges += changes;
            }
        }
        System.out.println(totalChanges + " total paths changed");
    }

    public static void main(String[] args) throws IOException {
        CopyMainToSubdivisions.copyCommonToSubdivisions();
    }
}

