/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.TempPrintWriter;
import org.unicode.cldr.util.personname.PersonNameFormatter;
import org.unicode.cldr.util.personname.SimpleNameObject;

public class GeneratePersonNameTestData {
    private static final Joiner COMMA_JOINER = Joiner.on(", ");
    private static final CLDRConfig CLDR_CONFIG = CLDRConfig.getInstance();
    private static final CLDRFile ENGLISH = CLDR_CONFIG.getEnglish();
    static final Comparator<String> LENGTH_FIRST = Comparator.comparingInt(String::length).reversed().thenComparing(Collator.getInstance(Locale.ROOT)).thenComparing(Comparator.naturalOrder());
    static File dir = new File(CLDRPaths.TEST_DATA, "personNameTest");
    static final Set<String> REQUIRED_PATHS = ImmutableSet.of("//ldml/personNames/nameOrderLocales[@order=\"givenFirst\"]", "//ldml/personNames/nameOrderLocales[@order=\"surnameFirst\"]", "//ldml/personNames/parameterDefault[@parameter=\"formality\"]", "//ldml/personNames/parameterDefault[@parameter=\"length\"]", "//ldml/personNames/foreignSpaceReplacement", "//ldml/personNames/nativeSpaceReplacement", new String[]{"//ldml/personNames/initialPattern[@type=\"initial\"]", "//ldml/personNames/initialPattern[@type=\"initialSequence\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"given\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"given2\"]", "//ldml/personNames/sampleName[@item=\"nativeGGS\"]/nameField[@type=\"surname\"]", "//ldml/personNames/personName[@order=\"givenFirst\"][@length=\"long\"][@usage=\"referring\"][@formality=\"formal\"]/namePattern"});

    public static void main(String[] args) {
        Factory factory = CLDR_CONFIG.getCldrFactory();
        Matcher localeMatcher = null;
        if (args.length >= 1) {
            localeMatcher = Pattern.compile(args[0]).matcher("");
        }
        ULocale undLocale = new ULocale("und");
        block9: for (String locale : factory.getAvailableLanguages()) {
            if (localeMatcher != null && !localeMatcher.reset(locale).lookingAt()) continue;
            try {
                Object tryLocale2;
                PersonNameFormatter formatter;
                Map<PersonNameFormatter.SampleType, SimpleNameObject> names;
                CLDRFile cldrFile = factory.make(locale, true, CLDRFile.DraftStatus.contributed);
                CLDRFile unresolved = cldrFile.getUnresolved();
                if (!locale.equals("en")) {
                    for (String path : REQUIRED_PATHS) {
                        String value = unresolved.getStringValue(path);
                        if (value != null) continue;
                        GeneratePersonNameTestData.removeTestFile(locale);
                        continue block9;
                    }
                }
                try {
                    names = PersonNameFormatter.loadSampleNames(cldrFile);
                    formatter = new PersonNameFormatter(cldrFile);
                }
                catch (Exception e) {
                    GeneratePersonNameTestData.removeTestFile(locale);
                    continue;
                }
                if (names.isEmpty()) {
                    GeneratePersonNameTestData.removeTestFile(locale);
                    continue;
                }
                ULocale myLocale = new ULocale(locale);
                PersonNameFormatter.Order myOrder = formatter.getOrderFromLocale(myLocale);
                if (myOrder == null) {
                    formatter.getOrderFromLocale(myLocale);
                    throw new IllegalArgumentException("Missing order for: " + locale);
                }
                PersonNameFormatter.Order otherOrder = myOrder == PersonNameFormatter.Order.givenFirst ? PersonNameFormatter.Order.surnameFirst : PersonNameFormatter.Order.givenFirst;
                Map<ULocale, PersonNameFormatter.Order> localeToOrder = formatter.getNamePatternData().getLocaleToOrder();
                TreeMultimap orderToLocale = Multimaps.invertFrom(Multimaps.forMap(localeToOrder), TreeMultimap.create());
                ULocale otherLocale = null;
                for (Object tryLocale2 : orderToLocale.get(otherOrder)) {
                    if (undLocale.equals(tryLocale2)) continue;
                    otherLocale = tryLocale2;
                    break;
                }
                if (otherLocale == null) {
                    otherLocale = myLocale.equals(ULocale.FRENCH) ? ULocale.GERMAN : ULocale.FRENCH;
                }
                myLocale = GeneratePersonNameTestData.addRegionIfMissing(myLocale, "AQ");
                otherLocale = GeneratePersonNameTestData.addRegionIfMissing(otherLocale, "AQ");
                StringWriter output = new StringWriter();
                output.write("\n");
                GeneratePersonNameTestData.writeChoices("field", PersonNameFormatter.Field.ALL, output);
                GeneratePersonNameTestData.writeChoices("modifiers", PersonNameFormatter.Modifier.ALL, output);
                GeneratePersonNameTestData.writeChoices("order", PersonNameFormatter.Order.ALL, output);
                GeneratePersonNameTestData.writeChoices("length", PersonNameFormatter.Length.ALL, output);
                GeneratePersonNameTestData.writeChoices("usage", PersonNameFormatter.Usage.ALL, output);
                GeneratePersonNameTestData.writeChoices("formality", PersonNameFormatter.Formality.ALL, output);
                tryLocale2 = names.entrySet().iterator();
                while (tryLocale2.hasNext()) {
                    PersonNameFormatter.Order nameOrder;
                    Map.Entry entry = (Map.Entry)tryLocale2.next();
                    PersonNameFormatter.SampleType sampleType = (PersonNameFormatter.SampleType)((Object)entry.getKey());
                    if (!sampleType.isNative() && otherLocale == null) continue;
                    SimpleNameObject nameObject = (SimpleNameObject)entry.getValue();
                    output.write("\n");
                    output.write("# " + String.valueOf((Object)sampleType) + "\n");
                    for (Map.Entry x2 : nameObject.getModifiedFieldToValue().entrySet()) {
                        output.write("name ; " + String.valueOf(x2.getKey()) + "; " + (String)x2.getValue() + "\n");
                    }
                    if (sampleType.isNative()) {
                        output.write("name ; locale; " + String.valueOf(myLocale) + "\n");
                        nameOrder = myOrder;
                    } else {
                        output.write("name ; locale; " + String.valueOf(otherLocale) + "\n");
                        nameOrder = otherOrder;
                    }
                    TreeMultimap valueToSources = TreeMultimap.create(LENGTH_FIRST, Comparator.naturalOrder());
                    for (PersonNameFormatter.FormatParameters parameters : PersonNameFormatter.FormatParameters.allCldr()) {
                        String formatted = formatter.formatWithoutSuperscripts(nameObject, parameters);
                        if (formatted.isEmpty()) continue;
                        valueToSources.put(formatted, parameters);
                    }
                    for (Map.Entry entry2 : valueToSources.asMap().entrySet()) {
                        String expectedResult = (String)entry2.getKey();
                        output.write("\nexpectedResult; " + expectedResult + "\n\n");
                        entry2.getValue().forEach(x -> output.write("parameters; " + String.valueOf((Object)x.getOrder()) + "; " + String.valueOf((Object)x.getLength()) + "; " + String.valueOf((Object)x.getUsage()) + "; " + String.valueOf((Object)x.getFormality()) + "\n"));
                    }
                    output.write("\nendName\n");
                }
                TempPrintWriter output2 = TempPrintWriter.openUTF8Writer(dir.toString(), locale + ".txt");
                try {
                    output2.write("# Test data for Person Name Data\n" + CldrUtility.getCopyrightString("#  ") + "\n# CLDR person name formatting test data for: " + locale + "\n#\n# Test lines have the following structure:\n#\n# enum ; <type> ; <value>(', ' <value)\n#   For all the elements in <\u2026> below, the possible choices that could appear in the file.\n#   For example, <field> could be any of title, given, \u2026 credentials.\n#   Verify that all of these values work with the implementation.\n#\n# name ; <field>('-'<modifier>) ; <value>\n#   A sequence of these is to be used to build a person name object with the given field values.\n#   If the <field> is 'locale', then the value is the locale of the name.\n#     That will always be the last field in the name.\n#     NOTE: the locale for the name (where different than the test file's locale) will generally not match the text.\n#     It is chosen to exercise the person name formatting, by having a different given-surname order than the file's locale.\n#\n# expectedResult; <value>\n#   This line follows a sequence of name lines, and indicates the that all the following parameter lines have this expected value.\n#\n# parameters; <options>; <length>; <usage>; <formality>\n#   Each of these parameter lines should be tested to see that when formatting the current name with these parameters, \n#   the expected value is produced.\n#\n# endName\n#   Indicates the end of the values to be tested with the current name.\n#\n# =====\n# Example:\n#     enum ; field ; title, given, given2, surname, surname2, generation, credentials\n#     \u2026\n#\n#     name ; given; Iris\n#     name ; surname; Falke\n#     name ; locale; de\n#\n#     expectedResult; Falke, Iris\n#\n#     parameters; sorting; long; referring; formal\n#     parameters; sorting; medium; referring; informal\n#\n#     endName\n#\n#     name ; given; Max\n#     name ; given2; Ben\n#     name ; surname; Mustermann\n#     \u2026\n# =====\n");
                    output2.write(output.toString());
                }
                finally {
                    if (output2 == null) continue;
                    output2.close();
                }
            }
            catch (Exception e) {
                System.out.println("Skipping " + locale);
                e.printStackTrace();
                GeneratePersonNameTestData.removeTestFile(locale);
            }
        }
    }

    private static void removeTestFile(String locale) {
        File file = new File(dir.toString(), locale + ".txt");
        if (file.exists()) {
            System.out.println("Removing " + String.valueOf(file));
            file.delete();
        }
    }

    public static ULocale addRegionIfMissing(ULocale myLocale, String region) {
        return !myLocale.getCountry().isEmpty() ? myLocale : new ULocale.Builder().setLocale(myLocale).setRegion(region).build();
    }

    public static <T> void writeChoices(String kind, Collection<T> choices, StringWriter output) {
        output.write("enum ; " + kind + " ; " + COMMA_JOINER.join(choices) + "\n");
    }

    static enum Options {
        none,
        sorting;

    }
}

