/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import org.unicode.cldr.icu.dev.util.UOption;
import org.unicode.cldr.tool.KeyboardFlatten;
import org.unicode.cldr.util.CLDRTool;

@CLDRTool(alias="kbd", description="Tool for working with CLDR Keyboard files")
public class KeyboardTool {
    private static final UOption[] options = new UOption[]{UOption.HELP_H(), UOption.HELP_QUESTION_MARK(), UOption.create("flatten", 'F', 1)};

    public static void help() {
        System.out.println("CLDR Keyboard Tool\n----\nUsage:\n -h | --help | -?                          print this help\n -F infile.xml | --flatten infile.xml > outfile.xml      print a flattened xml to stdout, without imports\n");
    }

    public static void main(String[] args) throws Throwable {
        UOption.parseArgs(args, options);
        if (KeyboardTool.options[0].doesOccur || KeyboardTool.options[1].doesOccur) {
            KeyboardTool.help();
        } else if (KeyboardTool.options[2].doesOccur) {
            System.err.println("Flatten: " + KeyboardTool.options[2].value);
            KeyboardFlatten.flatten(KeyboardTool.options[2].value, System.out);
        } else {
            KeyboardTool.help();
        }
    }
}

