/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unicode.cldr.util.RbnfData;

public class ListRbnf {
    public static void main(String[] args) {
        ListRbnf.listRbnf();
    }

    public static void listRbnf() {
        Joiner joinTab = Joiner.on('\t');
        Joiner joinCommaSpace = Joiner.on(", ");
        Splitter splitDash = Splitter.on('-');
        System.out.println("\nLocale to type to subtype");
        Set<String> keys = RbnfData.INSTANCE.getRbnfTypeToLocales().keySet();
        System.out.println("locale\t" + joinTab.join(keys));
        TreeMultimap<String, String> typeToSubtype = TreeMultimap.create();
        for (Map.Entry<String, Multimap<String, String>> entry : RbnfData.INSTANCE.getLocaleToTypesToSubtypes().entrySet()) {
            String locale = entry.getKey();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(locale);
            for (String key : keys) {
                Collection<String> values = entry.getValue().get(key);
                arrayList.add(values == null ? "" : joinCommaSpace.join(values));
                typeToSubtype.putAll(key, values);
            }
            System.out.println(joinTab.join(arrayList));
        }
        System.out.println("\nType to subtype");
        TreeSet allPieces = new TreeSet();
        TreeSet allSubtypes = new TreeSet();
        for (Map.Entry entry : typeToSubtype.asMap().entrySet()) {
            Collection values = entry.getValue();
            allSubtypes.addAll(values);
            TreeSet pieces = new TreeSet();
            values.stream().forEach(x -> pieces.addAll(splitDash.splitToList((CharSequence)x)));
            System.out.println(joinTab.join(entry.getKey(), joinCommaSpace.join(values), joinCommaSpace.join(pieces)));
            allPieces.addAll(pieces);
        }
        System.out.println("\nAll subtypes");
        System.out.println(joinCommaSpace.join(allSubtypes));
        System.out.println("\nAll pieces");
        System.out.println(joinCommaSpace.join(allPieces));
        System.out.println("\nSubtype to locale");
        for (Map.Entry<Object, Collection<Object>> entry : RbnfData.INSTANCE.getRbnfTypeToLocales().asMap().entrySet()) {
            System.out.println((String)entry.getKey() + "\t" + joinCommaSpace.join((Iterable<? extends Object>)entry.getValue()));
        }
    }
}

