/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.ibm.icu.text.PluralRules;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.SupplementalDataInfo;
import org.unicode.cldr.util.XPathParts;

public class PluralMinimalPairs {
    private Map<PluralRules.PluralType, Map<SupplementalDataInfo.PluralInfo.Count, String>> typeToCountToSample = new EnumMap<PluralRules.PluralType, Map<SupplementalDataInfo.PluralInfo.Count, String>>(PluralRules.PluralType.class);
    private static Map<String, PluralMinimalPairs> cache = new ConcurrentHashMap<String, PluralMinimalPairs>();
    public static PluralMinimalPairs EMPTY = new PluralMinimalPairs().freeze();

    private PluralMinimalPairs() {
    }

    public static PluralMinimalPairs getInstance(String ulocale) {
        PluralMinimalPairs samplePatterns = cache.get(ulocale);
        if (samplePatterns != null) {
            return samplePatterns;
        }
        Factory factory = CLDRConfig.getInstance().getFullCldrFactory();
        try {
            samplePatterns = new PluralMinimalPairs();
            CLDRFile cldrFile = factory.make(ulocale, true);
            Iterator<String> it = cldrFile.iterator("//ldml/numbers/minimalPairs/");
            block10: while (it.hasNext()) {
                PluralRules.PluralType type;
                String element;
                String path = it.next();
                String foundLocale = cldrFile.getSourceLocaleID(path, null);
                if (foundLocale.equals("root")) continue;
                XPathParts parts = XPathParts.getFrozenInstance(path);
                String sample = cldrFile.getStringValue(path);
                switch (element = parts.getElement(-1)) {
                    case "pluralMinimalPairs": {
                        type = PluralRules.PluralType.CARDINAL;
                        break;
                    }
                    case "ordinalMinimalPairs": {
                        type = PluralRules.PluralType.ORDINAL;
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                SupplementalDataInfo.PluralInfo.Count category = SupplementalDataInfo.PluralInfo.Count.valueOf(parts.getAttributeValue(-1, type == PluralRules.PluralType.CARDINAL ? "count" : "ordinal"));
                if (category == null || type == null) {
                    throw new IllegalArgumentException("Bad plural info");
                }
                samplePatterns.put(ulocale, type, category, sample);
            }
            if (samplePatterns.typeToCountToSample.isEmpty()) {
                samplePatterns = EMPTY;
            } else {
                samplePatterns.freeze();
            }
        }
        catch (Exception e) {
            samplePatterns = EMPTY;
        }
        cache.put(ulocale, samplePatterns);
        return samplePatterns;
    }

    public void put(String locale, PluralRules.PluralType type, SupplementalDataInfo.PluralInfo.Count count, String sample) {
        Map<SupplementalDataInfo.PluralInfo.Count, String> countToSample = this.typeToCountToSample.get((Object)type);
        if (countToSample == null) {
            countToSample = new EnumMap<SupplementalDataInfo.PluralInfo.Count, String>(SupplementalDataInfo.PluralInfo.Count.class);
            this.typeToCountToSample.put(type, countToSample);
        }
        countToSample.put(count, sample);
    }

    public String get(PluralRules.PluralType type, SupplementalDataInfo.PluralInfo.Count count) {
        Map<SupplementalDataInfo.PluralInfo.Count, String> countToSample = this.typeToCountToSample.get((Object)type);
        return countToSample == null ? null : countToSample.get((Object)count);
    }

    public Set<SupplementalDataInfo.PluralInfo.Count> getCounts(PluralRules.PluralType type) {
        Map<SupplementalDataInfo.PluralInfo.Count, String> countToSample = this.typeToCountToSample.get((Object)type);
        return countToSample == null ? null : this.typeToCountToSample.get((Object)type).keySet();
    }

    public PluralMinimalPairs freeze() {
        this.typeToCountToSample = CldrUtility.protectCollection(this.typeToCountToSample);
        return this;
    }

    public String toString() {
        return this.typeToCountToSample.toString();
    }

    public boolean isEmpty(PluralRules.PluralType type) {
        return !this.typeToCountToSample.containsKey((Object)type);
    }
}

