/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.tool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.unicode.cldr.util.CLDRConfig;
import org.unicode.cldr.util.CLDRPaths;
import org.unicode.cldr.util.CldrUtility;
import org.unicode.cldr.util.Factory;
import org.unicode.cldr.util.LocaleIDParser;
import org.unicode.cldr.util.Pair;
import org.unicode.cldr.util.XMLFileReader;
import org.unicode.cldr.util.XPathParts;

public class SubdivisionNames {
    public static final String SUBDIVISION_PATH_PREFIX = "//ldml/localeDisplayNames/subdivisions/subdivision";
    private final Map<String, String> subdivisionToName;
    static final Pattern OLD_SUBDIVISION = Pattern.compile("[a-zA-Z]{2}[-_][a-zA-Z0-9]{1,4}");

    public SubdivisionNames(String locale) {
        this(locale, "subdivisions");
    }

    public SubdivisionNames(String locale, String ... dirs) {
        TreeMap<String, String> builder = new TreeMap<String, String>();
        while (true) {
            this.addSubdivisionNames(locale, builder, dirs);
            String parent = LocaleIDParser.getParent(locale);
            if (parent == null || parent.equals("root")) break;
            locale = parent;
        }
        this.subdivisionToName = ImmutableMap.copyOf(builder);
    }

    private void addSubdivisionNames(String locale, Map<String, String> builder, String ... dirs) {
        ArrayList<Pair<String, String>> data = new ArrayList<Pair<String, String>>();
        for (String dir : dirs) {
            try {
                XMLFileReader.loadPathValues(CLDRPaths.COMMON_DIRECTORY + dir + "/" + locale + ".xml", data, true);
                for (Pair pair : data) {
                    String type;
                    String rawPath;
                    XPathParts path;
                    String name = (String)pair.getSecond();
                    if (CldrUtility.INHERITANCE_MARKER.contentEquals(name) || !"subdivision".equals((path = XPathParts.getFrozenInstance(rawPath = (String)pair.getFirst())).getElement(-1)) || builder.containsKey(type = path.getAttributeValue(-1, "type"))) continue;
                    builder.put(type, name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Set<String> getAvailableLocales() {
        return SubdivisionNames.getAvailableLocales("subdivisions");
    }

    public static Set<String> getAvailableLocales(String ... dirs) {
        TreeSet<String> result = new TreeSet<String>();
        for (String dir : dirs) {
            File baseDir = new File(CLDRPaths.COMMON_DIRECTORY + dir + "/");
            for (String file : baseDir.list()) {
                if (!file.endsWith(".xml")) continue;
                result.add(file.substring(0, file.length() - 4));
            }
        }
        return ImmutableSortedSet.copyOf(result);
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.subdivisionToName.entrySet();
    }

    public String get(String subdivision) {
        return this.subdivisionToName.get(subdivision);
    }

    public Set<String> keySet() {
        return this.subdivisionToName.keySet();
    }

    public static String getPathFromCode(String code) {
        return "//ldml/localeDisplayNames/subdivisions/subdivision[@type=\"" + code + "\"]";
    }

    public static String getRegionFromSubdivision(String sdCode) {
        return sdCode.compareTo("A") < 0 ? sdCode.substring(0, 3) : sdCode.substring(0, 2).toUpperCase(Locale.ENGLISH);
    }

    public static String getSubregion(String sdCode) {
        return sdCode.compareTo("A") < 0 ? sdCode.substring(3) : sdCode.substring(2).toUpperCase(Locale.ENGLISH);
    }

    public static boolean isRegionCode(String regionOrSubdivision) {
        return regionOrSubdivision.length() == 2 || regionOrSubdivision.length() == 3 && regionOrSubdivision.compareTo("A") < 0;
    }

    public static String toIsoFormat(String sdCode) {
        int insertion = (sdCode = sdCode.toUpperCase(Locale.ENGLISH)).compareTo("A") < 0 ? 3 : 2;
        return sdCode.substring(0, insertion) + "-" + sdCode.substring(insertion);
    }

    public static boolean isOldSubdivisionCode(String item) {
        return item.length() > 4 && item.length() < 7 && OLD_SUBDIVISION.matcher(item).matches();
    }

    public static void main(String[] args) {
        Factory annotations = CLDRConfig.getInstance().getAnnotationsFactory();
        for (String locale : annotations.getAvailable()) {
            SubdivisionNames sd = new SubdivisionNames(locale, "main", "subdivisions");
            System.out.println(locale + " gbeng=" + sd.get("gbeng") + " gbsct=" + sd.get("gbsct") + " gbwls=" + sd.get("gbwls"));
        }
    }
}

