/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;

public final class CollatorHelper {
    public static final RuleBasedCollator EMOJI_COLLATOR = CollatorHelper.makeEmojiCollator();
    public static final RuleBasedCollator ROOT_COLLATOR = CollatorHelper.makeRootCollator();
    public static final RuleBasedCollator ROOT_IDENTICAL = CollatorHelper.makeRootIdentical();
    public static final RuleBasedCollator ROOT_NUMERIC = CollatorHelper.makeRootNumeric();
    public static final RuleBasedCollator ROOT_NUMERIC_IDENTICAL = CollatorHelper.makeRootNumericIdentical();
    public static final RuleBasedCollator ROOT_PRIMARY = CollatorHelper.makeRootPrimary();
    public static final RuleBasedCollator ROOT_PRIMARY_SHIFTED = CollatorHelper.makeRootPrimaryShifted();
    public static final RuleBasedCollator ROOT_SECONDARY = CollatorHelper.makeRootSecondary();

    private static RuleBasedCollator makeEmojiCollator() {
        ULocale uLocale = ULocale.forLanguageTag("en-u-co-emoji");
        RuleBasedCollator col = (RuleBasedCollator)RuleBasedCollator.getInstance(uLocale);
        col.setStrength(15);
        col.setNumericCollation(true);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootCollator() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootIdentical() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        col.setStrength(15);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootNumeric() {
        RuleBasedCollator col = (RuleBasedCollator)RuleBasedCollator.getInstance(ULocale.ROOT);
        col.setNumericCollation(true);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootNumericIdentical() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        col.setStrength(15);
        col.setNumericCollation(true);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootPrimary() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        col.setStrength(0);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootPrimaryShifted() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        col.setStrength(0);
        col.setAlternateHandlingShifted(true);
        return (RuleBasedCollator)col.freeze();
    }

    private static RuleBasedCollator makeRootSecondary() {
        RuleBasedCollator col = (RuleBasedCollator)Collator.getInstance(ULocale.ROOT);
        col.setStrength(1);
        return (RuleBasedCollator)col.freeze();
    }
}

