/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DayPeriods {
    public static final int HOUR = 3600000;
    private final ULocale locale;
    private final DayPeriod[] timeMap;
    private final Map<DayPeriod, String> samples;
    private static final Map<ULocale, DayPeriods> DATA = new LinkedHashMap<ULocale, DayPeriods>();

    public DayPeriod get(long millisInDay) {
        long hours = millisInDay / 3600000L;
        int hoursInDay = (int)(hours % 24L);
        if (hoursInDay < 0) {
            hoursInDay += 24;
        }
        return this.timeMap[hoursInDay];
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getSample(DayPeriod dayPeriod) {
        return this.samples.get((Object)dayPeriod);
    }

    public Set<DayPeriod> getDayPeriods() {
        return this.samples.keySet();
    }

    public static DayPeriods getInstance(ULocale loc) {
        ULocale base = new ULocale(loc.getLanguage());
        DayPeriods result = DATA.get(base);
        return result;
    }

    public static Set<ULocale> getAvailable() {
        return DATA.keySet();
    }

    private DayPeriods(ULocale base, DayPeriod[] map, EnumMap<DayPeriod, String> samples2) {
        this.locale = base;
        this.fix(map, samples2, DayPeriod.MORNING2, DayPeriod.MORNING1);
        this.fix(map, samples2, DayPeriod.AFTERNOON2, DayPeriod.AFTERNOON1);
        this.fix(map, samples2, DayPeriod.EVENING2, DayPeriod.EVENING1);
        this.fix(map, samples2, DayPeriod.NIGHT2, DayPeriod.NIGHT1);
        this.timeMap = map;
        this.samples = Collections.unmodifiableMap(samples2);
    }

    private void fix(DayPeriod[] map, EnumMap<DayPeriod, String> samples2, DayPeriod dayPeriod2, DayPeriod dayPeriod1) {
        if (samples2.containsKey((Object)dayPeriod2) && !samples2.containsKey((Object)dayPeriod1)) {
            samples2.put(dayPeriod1, samples2.get((Object)dayPeriod2));
            samples2.remove((Object)dayPeriod2);
            for (int i = 0; i < map.length; ++i) {
                if (map[i] != dayPeriod2) continue;
                map[i] = dayPeriod1;
            }
        }
    }

    private static DayPeriodBuilder make(String locale) {
        return new DayPeriodBuilder(locale);
    }

    static {
        DayPeriods.make("en").add("NIGHT1", "night", 0, 1, 2, 3).add("MORNING1", "morning", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "afternoon", 12, 13, 14, 15, 16, 17).add("EVENING1", "evening", 18, 19, 20).add("NIGHT1", "night", 21, 22, 23).build();
        DayPeriods.make("af").add("NIGHT1", "nag", 0, 1, 2, 3, 4).add("MORNING1", "oggend", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "middag", 12, 13, 14, 15, 16, 17).add("EVENING1", "aand", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("nl").add("NIGHT1", "nacht", 0, 1, 2, 3, 4, 5).add("MORNING1", "ochtend", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "middag", 12, 13, 14, 15, 16, 17).add("EVENING1", "avond", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("de").add("NIGHT1", "Nacht", 0, 1, 2, 3, 4).add("MORNING1", "Morgen", 5, 6, 7, 8, 9).add("MORNING2", "Vormittag", 10, 11).add("AFTERNOON1", "Mittag", 12).add("AFTERNOON2", "Nachmittag", 13, 14, 15, 16, 17).add("EVENING1", "Abend", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("da").add("NIGHT1", "nat", 0, 1, 2, 3, 4).add("MORNING1", "morgen", 5, 6, 7, 8, 9).add("MORNING2", "formiddag", 10, 11).add("AFTERNOON1", "eftermiddag", 12, 13, 14, 15, 16, 17).add("EVENING1", "aften", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("no").add("NIGHT1", "natt", 0, 1, 2, 3, 4, 5).add("MORNING1", "morgen", 6, 7, 8, 9).add("MORNING2", "formiddag", 10, 11).add("AFTERNOON1", "ettermiddag", 12, 13, 14, 15, 16, 17).add("EVENING1", "kveld", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("sv").add("NIGHT1", "natt", 0, 1, 2, 3, 4).add("MORNING1", "morgon", 5, 6, 7, 8, 9).add("MORNING2", "f\u00f6rmiddag", 10, 11).add("AFTERNOON1", "eftermiddag", 12, 13, 14, 15, 16, 17).add("EVENING1", "kv\u00e4ll", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("is").add("NIGHT1", "n\u00f3tt", 0, 1, 2, 3, 4, 5).add("MORNING1", "morgunn", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "eftir h\u00e1degi", 12, 13, 14, 15, 16, 17).add("EVENING1", "kv\u00f6ld", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("pt").add("NIGHT1", "madrugada", 0, 1, 2, 3, 4, 5).add("MORNING1", "manh\u00e3", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "tarde", 12, 13, 14, 15, 16, 17, 18).add("EVENING1", "noite", 19, 20, 21, 22, 23).build();
        DayPeriods.make("gl").add("MORNING1", "madrugada", 0, 1, 2, 3, 4, 5).add("MORNING2", "ma\u00f1\u00e1", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "mediod\u00eda", 12).add("EVENING1", "tarde", 13, 14, 15, 16, 17, 18, 19, 20).add("NIGHT1", "noite", 21, 22, 23).build();
        DayPeriods.make("es").add("MORNING1", "madrugada", 0, 1, 2, 3, 4, 5).add("MORNING2", "ma\u00f1ana", 6, 7, 8, 9, 10, 11).add("EVENING1", "tarde", 12, 13, 14, 15, 16, 17, 18, 19).add("NIGHT1", "noche", 20, 21, 22, 23).build();
        DayPeriods.make("ca").add("MORNING1", "matinada", 0, 1, 2, 3, 4, 5).add("MORNING2", "mat\u00ed", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "migdia", 12).add("AFTERNOON2", "tarda", 13, 14, 15, 16, 17, 18).add("EVENING1", "vespre", 19, 20).add("NIGHT1", "nit", 21, 22, 23).build();
        DayPeriods.make("it").add("NIGHT1", "notte", 0, 1, 2, 3, 4, 5).add("MORNING1", "mattina", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "pomeriggio", 12, 13, 14, 15, 16, 17).add("EVENING1", "sera", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ro").add("NIGHT1", "noapte", 0, 1, 2, 3, 4).add("MORNING1", "diminea\u021b\u0103", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "dup\u0103-amiaz\u0103", 12, 13, 14, 15, 16, 17).add("EVENING1", "sear\u0103", 18, 19, 20, 21).add("NIGHT1", "noapte", 22, 23).build();
        DayPeriods.make("fr").add("NIGHT1", "nuit", 0, 1, 2, 3).add("MORNING1", "matin", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "apr\u00e8s-midi", 12, 13, 14, 15, 16, 17).add("EVENING1", "soir", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("hr").add("NIGHT1", "no\u0107", 0, 1, 2, 3).add("MORNING1", "jutro", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "popodne", 12, 13, 14, 15, 16, 17).add("EVENING1", "ve\u010der", 18, 19, 20).add("NIGHT1", "no\u0107", 21, 22, 23).build();
        DayPeriods.make("bs").add("NIGHT1", "no\u0107", 0, 1, 2, 3).add("MORNING1", "jutro", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "popodne", 12, 13, 14, 15, 16, 17).add("EVENING1", "ve\u010de", 18, 19, 20).add("NIGHT1", "no\u0107", 21, 22, 23).build();
        DayPeriods.make("sr").add("NIGHT1", "\u043d\u043e\u045b", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0458\u0443\u0442\u0440\u043e", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u043f\u043e\u043f\u043e\u0434\u043d\u0435", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0432\u0435\u0447\u0435", 18, 19, 20).add("NIGHT1", "\u043d\u043e\u045b", 21, 22, 23).build();
        DayPeriods.make("sl").add("NIGHT1", "no\u010d", 0, 1, 2, 3, 4, 5).add("MORNING1", "jutro", 6, 7, 8, 9).add("MORNING2", "dopoldne", 10, 11).add("AFTERNOON1", "popoldne", 12, 13, 14, 15, 16, 17).add("EVENING1", "ve\u010der", 18, 19, 20, 21).add("NIGHT1", "no\u010d", 22, 23).build();
        DayPeriods.make("cs").add("NIGHT1", "noc", 0, 1, 2, 3).add("MORNING1", "r\u00e1no", 4, 5, 6, 7, 8).add("MORNING2", "dopoledne", 9, 10, 11).add("AFTERNOON1", "odpoledne", 12, 13, 14, 15, 16, 17).add("EVENING1", "ve\u010der", 18, 19, 20, 21).add("NIGHT1", "noc", 22, 23).build();
        DayPeriods.make("sk").add("NIGHT1", "noc", 0, 1, 2, 3).add("MORNING1", "r\u00e1no", 4, 5, 6, 7, 8).add("MORNING2", "dopoludnie", 9, 10, 11).add("AFTERNOON1", "popoludnie", 12, 13, 14, 15, 16, 17).add("EVENING1", "ve\u010der", 18, 19, 20, 21).add("NIGHT1", "noc", 22, 23).build();
        DayPeriods.make("pl").add("NIGHT1", "noc", 0, 1, 2, 3, 4, 5).add("MORNING1", "rano", 6, 7, 8, 9).add("MORNING2", "przedpo\u0142udnie", 10, 11).add("AFTERNOON1", "popo\u0142udnie", 12, 13, 14, 15, 16, 17).add("EVENING1", "wiecz\u00f3r", 18, 19, 20).add("NIGHT1", "noc", 21, 22, 23).build();
        DayPeriods.make("bg").add("NIGHT1", "\u043d\u043e\u0449", 0, 1, 2, 3).add("MORNING1", "\u0441\u0443\u0442\u0440\u0438\u043d\u0442\u0430", 4, 5, 6, 7, 8, 9, 10).add("MORNING2", "\u043d\u0430 \u043e\u0431\u044f\u0434", 11, 12, 13).add("AFTERNOON1", "\u0441\u043b\u0435\u0434\u043e\u0431\u044f\u0434", 14, 15, 16, 17).add("EVENING1", "\u0432\u0435\u0447\u0435\u0440\u0442\u0430", 18, 19, 20, 21).add("NIGHT1", "\u043d\u043e\u0449", 22, 23).build();
        DayPeriods.make("mk").add("NIGHT1", "\u043f\u043e \u043f\u043e\u043b\u043d\u043e\u045c", 0, 1, 2, 3).add("MORNING1", "\u043d\u0430\u0443\u0442\u0440\u043e", 4, 5, 6, 7, 8, 9).add("MORNING2", "\u043f\u0440\u0435\u0442\u043f\u043b\u0430\u0434\u043d\u0435", 10, 11).add("AFTERNOON1", "\u043f\u043e\u043f\u043b\u0430\u0434\u043d\u0435", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u043d\u0430\u0432\u0435\u0447\u0435\u0440", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ru").add("NIGHT1", "\u043d\u043e\u0447\u044c", 0, 1, 2, 3).add("MORNING1", "\u0443\u0442\u0440\u043e", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0434\u0435\u043d\u044c", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0432\u0435\u0447\u0435\u0440", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("uk").add("NIGHT1", "\u043d\u0456\u0447", 0, 1, 2, 3).add("MORNING1", "\u0440\u0430\u043d\u043e\u043a", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0434\u0435\u043d\u044c", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0432\u0435\u0447\u0456\u0440", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("lt").add("NIGHT1", "naktis", 0, 1, 2, 3, 4, 5).add("MORNING1", "rytas", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "diena", 12, 13, 14, 15, 16, 17).add("EVENING1", "vakaras", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("lv").add("NIGHT1", "nakts", 0, 1, 2, 3, 4, 5).add("MORNING1", "r\u012bts", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "p\u0113cpusdiena", 12, 13, 14, 15, 16, 17).add("EVENING1", "vakars", 18, 19, 20, 21, 22).add("NIGHT1", "nakts", 23).build();
        DayPeriods.make("el").add("NIGHT1", "\u03b2\u03c1\u03ac\u03b4\u03c5", 0, 1, 2, 3).add("MORNING1", "\u03c0\u03c1\u03c9\u03af", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u03bc\u03b5\u03c3\u03b7\u03bc\u03ad\u03c1\u03b9", 12, 13, 14, 15, 16).add("EVENING1", "\u03b1\u03c0\u03cc\u03b3\u03b5\u03c5\u03bc\u03b1", 17, 18, 19).add("NIGHT1", "\u03b2\u03c1\u03ac\u03b4\u03c5", 20, 21, 22, 23).build();
        DayPeriods.make("fa").add("NIGHT1", "\u0634\u0628", 0, 1, 2, 3).add("MORNING1", "\u0635\u0628\u062d", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0628\u0639\u062f \u0627\u0632 \u0638\u0647\u0631", 12, 13, 14, 15, 16).add("EVENING1", "\u0639\u0635\u0631", 17, 18).add("NIGHT1", "\u0634\u0628", 19, 20, 21, 22, 23).build();
        DayPeriods.make("hy").add("NIGHT1", "\u0563\u056b\u0577\u0565\u0580", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0561\u057c\u0561\u057e\u0578\u057f", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0581\u0565\u0580\u0565\u056f", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0565\u0580\u0565\u056f\u0578", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ka").add("NIGHT1", "\u10e6\u10d0\u10db\u10d4", 0, 1, 2, 3, 4).add("MORNING1", "\u10d3\u10d8\u10da\u10d0", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u10dc\u10d0\u10e8\u10e3\u10d0\u10d3\u10e6\u10d4\u10d5\u10d8", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u10e1\u10d0\u10e6\u10d0\u10db\u10dd", 18, 19, 20).add("NIGHT1", "\u10e6\u10d0\u10db\u10d4", 21, 22, 23).build();
        DayPeriods.make("sq").add("NIGHT1", "nat\u00eb", 0, 1, 2, 3).add("MORNING1", "m\u00ebngjes", 4, 5, 6, 7, 8).add("MORNING2", "paradite", 9, 10, 11).add("AFTERNOON1", "pasdite", 12, 13, 14, 15, 16, 17).add("EVENING1", "mbr\u00ebmje", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ur").add("NIGHT1", "\u0631\u0627\u062a", 0, 1, 2, 3).add("MORNING1", "\u0635\u0628\u062d", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u062f\u0648\u067e\u06c1\u0631", 12, 13, 14, 15).add("AFTERNOON2", "\u0633\u06c1 \u067e\u06c1\u0631", 16, 17).add("EVENING1", "\u0634\u0627\u0645", 18, 19).add("NIGHT1", "\u0631\u0627\u062a", 20, 21, 22, 23).build();
        DayPeriods.make("hi").add("NIGHT1", "\u0930\u093e\u0924", 0, 1, 2, 3).add("MORNING1", "\u0938\u0941\u092c\u0939", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0926\u094b\u092a\u0939\u0930", 12, 13, 14, 15).add("EVENING1", "\u0936\u093e\u092e", 16, 17, 18, 19).add("NIGHT1", "\u0930\u093e\u0924", 20, 21, 22, 23).build();
        DayPeriods.make("bn").add("NIGHT1", "\u09b0\u09be\u09a4\u09cd\u09b0\u09bf", 0, 1, 2, 3).add("MORNING1", "\u09ad\u09cb\u09b0", 4, 5).add("MORNING2", "\u09b8\u0995\u09be\u09b2", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u09a6\u09c1\u09aa\u09c1\u09b0", 12, 13, 14, 15).add("AFTERNOON2", "\u09ac\u09bf\u0995\u09be\u09b2", 16, 17).add("EVENING1", "\u09b8\u09a8\u09cd\u09a7\u09cd\u09af\u09be", 18, 19).add("NIGHT1", "\u09b0\u09be\u09a4\u09cd\u09b0\u09bf", 20, 21, 22, 23).build();
        DayPeriods.make("gu").add("NIGHT1", "\u0ab0\u0abe\u0aa4", 0, 1, 2, 3).add("MORNING1", "\u0ab8\u0ab5\u0abe\u0ab0", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0aac\u0aaa\u0acb\u0ab0", 12, 13, 14, 15).add("EVENING1", "\u0ab8\u0abe\u0a82\u0a9c", 16, 17, 18, 19).add("NIGHT1", "\u0ab0\u0abe\u0aa4", 20, 21, 22, 23).build();
        DayPeriods.make("mr").add("NIGHT1", "\u0930\u093e\u0924\u094d\u0930\u0940", 0, 1, 2).add("NIGHT2", "\u0930\u093e\u0924\u094d\u0930", 3).add("MORNING1", "\u092a\u0939\u093e\u091f\u0947", 4, 5).add("MORNING2", "\u0938\u0915\u093e\u0933\u0940", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0926\u0941\u092a\u093e\u0930\u0940", 12, 13, 14, 15).add("EVENING1", "\u0938\u0902\u0927\u094d\u092f\u093e\u0915\u093e\u0933\u0940", 16, 17, 18, 19).add("NIGHT1", "\u0930\u093e\u0924\u094d\u0930\u0940", 20, 21, 22, 23).build();
        DayPeriods.make("ne").add("NIGHT1", "\u0930\u093e\u0924", 0, 1, 2, 3).add("MORNING1", "\u0935\u093f\u0939\u093e\u0928", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0905\u092a\u0930\u093e\u0928\u094d\u0939", 12, 13, 14, 15).add("AFTERNOON2", "\u0938\u093e\u0901\u091d", 16, 17, 18).add("EVENING1", "\u092c\u0947\u0932\u0941\u0915\u093e", 19, 20, 21).add("NIGHT1", "\u0930\u093e\u0924", 22, 23).build();
        DayPeriods.make("pa").add("NIGHT1", "\u0a30\u0a3e\u0a24", 0, 1, 2, 3).add("MORNING1", "\u0a38\u0a35\u0a47\u0a30", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0a26\u0a41\u0a2a\u0a39\u0a3f\u0a30", 12, 13, 14, 15).add("EVENING1", "\u0a36\u0a3e\u0a2e", 16, 17, 18, 19, 20).add("NIGHT1", "\u0a30\u0a3e\u0a24", 21, 22, 23).build();
        DayPeriods.make("si").add("NIGHT2", "\u0db8\u0dd0\u0daf\u0dd2\u0dba\u0db8\u0da7 \u0db4\u0dc3\u0dd4", 0).add("MORNING1", "\u0db4\u0dcf\u0db1\u0dca\u0daf\u0dbb", 1, 2, 3, 4, 5).add("MORNING2", "\u0d8b\u0daf\u0dda", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0daf\u0dc0\u0dbd\u0dca", 12, 13).add("EVENING1", "\u0dc4\u0dc0\u0dc3", 14, 15, 16, 17).add("NIGHT1", "\u0dbb\u0dd1", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ta").add("NIGHT1", "\u0b87\u0bb0\u0bb5\u0bc1", 0, 1, 2).add("MORNING1", "\u0b85\u0ba4\u0bbf\u0b95\u0bbe\u0bb2\u0bc8", 3, 4).add("MORNING2", "\u0b95\u0bbe\u0bb2\u0bc8", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0bae\u0ba4\u0bbf\u0baf\u0bae\u0bcd", 12, 13).add("AFTERNOON2", "\u0baa\u0bbf\u0bb1\u0bcd\u0baa\u0b95\u0bb2\u0bcd", 14, 15).add("EVENING1", "\u0bae\u0bbe\u0bb2\u0bc8", 16, 17).add("EVENING2", "\u0b85\u0ba8\u0bcd\u0ba4\u0bbf \u0bae\u0bbe\u0bb2\u0bc8", 18, 19, 20).add("NIGHT1", "\u0b87\u0bb0\u0bb5\u0bc1", 21, 22, 23).build();
        DayPeriods.make("te").add("NIGHT1", "\u0c30\u0c3e\u0c24\u0c4d\u0c30\u0c3f", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0c09\u0c26\u0c2f\u0c02", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0c2e\u0c27\u0c4d\u0c2f\u0c3e\u0c39\u0c4d\u0c28\u0c02", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0c38\u0c3e\u0c2f\u0c02\u0c24\u0c4d\u0c30\u0c02", 18, 19, 20).add("NIGHT1", "\u0c30\u0c3e\u0c24\u0c4d\u0c30\u0c3f", 21, 22, 23).build();
        DayPeriods.make("ml").add("NIGHT1", "\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f", 0, 1, 2).add("MORNING1", "\u0d2a\u0d41\u0d32\u0d7c\u0d1a\u0d4d\u0d1a\u0d46", 3, 4, 5).add("MORNING2", "\u0d30\u0d3e\u0d35\u0d3f\u0d32\u0d46", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0d09\u0d1a\u0d4d\u0d1a\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d", 12, 13).add("AFTERNOON2", "\u0d09\u0d1a\u0d4d\u0d1a\u0d24\u0d3f\u0d30\u0d3f\u0d1e\u0d4d\u0d1e\u0d4d", 14).add("EVENING1", "\u0d35\u0d48\u0d15\u0d41\u0d28\u0d4d\u0d28\u0d47\u0d30\u0d02", 15, 16, 17).add("EVENING2", "\u0d38\u0d28\u0d4d\u0d27\u0d4d\u0d2f\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d", 18).add("NIGHT1", "\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f", 19, 20, 21, 22, 23).build();
        DayPeriods.make("kn").add("NIGHT1", "\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0cac\u0cc6\u0cb3\u0c97\u0ccd\u0c97\u0cc6", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0cae\u0ca7\u0ccd\u0caf\u0cbe\u0cb9\u0ccd\u0ca8", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u0cb8\u0c82\u0c9c\u0cc6", 18, 19, 20).add("NIGHT1", "\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf", 21, 22, 23).build();
        DayPeriods.make("zh").add("NIGHT1", "\u51cc\u6668", 0, 1, 2, 3, 4).add("MORNING1", "\u65e9\u4e0a", 5, 6, 7).add("MORNING2", "\u4e0a\u5348", 8, 9, 10, 11).add("AFTERNOON1", "\u4e2d\u5348", 12).add("AFTERNOON2", "\u4e0b\u5348", 13, 14, 15, 16, 17, 18).add("EVENING1", "\u665a\u4e0a", 19, 20, 21, 22, 23).build();
        DayPeriods.make("ja").add("NIGHT2", "\u591c\u4e2d", 0, 1, 2, 3).add("MORNING1", "\u671d", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u663c", 12, 13, 14, 15).add("EVENING1", "\u5915\u65b9", 16, 17, 18).add("NIGHT1", "\u591c", 19, 20, 21, 22).add("NIGHT2", "\u591c\u4e2d", 23).build();
        DayPeriods.make("ko").add("NIGHT1", "\ubc24", 0, 1, 2).add("MORNING1", "\uc0c8\ubcbd", 3, 4, 5).add("MORNING2", "\uc624\uc804", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\uc624\ud6c4", 12, 13, 14, 15, 16, 17).add("EVENING1", "\uc800\ub141", 18, 19, 20).add("NIGHT1", "\ubc24", 21, 22, 23).build();
        DayPeriods.make("tr").add("NIGHT1", "gece", 0, 1, 2, 3, 4, 5).add("MORNING1", "sabah", 6, 7, 8, 9, 10).add("MORNING2", "\u00f6\u011fleden \u00f6nce", 11).add("AFTERNOON1", "\u00f6\u011fleden sonra", 12, 13, 14, 15, 16, 17).add("AFTERNOON2", "ak\u015fam\u00fcst\u00fc", 18).add("EVENING1", "ak\u015fam", 19, 20).add("NIGHT1", "gece", 21, 22, 23).build();
        DayPeriods.make("az").add("NIGHT2", "gec\u0259", 0, 1, 2, 3).add("MORNING1", "s\u00fcbh", 4, 5).add("MORNING2", "s\u0259h\u0259r", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "g\u00fcnd\u00fcz", 12, 13, 14, 15, 16).add("EVENING1", "ax\u015fam\u00fcst\u00fc", 17, 18).add("NIGHT1", "ax\u015fam", 19, 20, 21, 22, 23).build();
        DayPeriods.make("kk").add("NIGHT1", "\u0442\u04af\u043d", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0442\u0430\u04a3", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0442\u04af\u0441", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u043a\u0435\u0448", 18, 19, 20).add("NIGHT1", "\u0442\u04af\u043d", 21, 22, 23).build();
        DayPeriods.make("ky").add("NIGHT1", "\u0442\u04af\u043d", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u044d\u0440\u0442\u0435\u04a3 \u043c\u0435\u043d\u0435\u043d", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0442\u04af\u0448\u0442\u04e9\u043d \u043a\u0438\u0439\u0438\u043d", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u043a\u0435\u0447\u043a\u0443\u0440\u0443\u043d", 18, 19, 20).add("NIGHT1", "\u0442\u04af\u043d", 21, 22, 23).build();
        DayPeriods.make("uz").add("NIGHT1", "tun", 0, 1, 2, 3, 4, 5).add("MORNING1", "ertalab", 6, 7, 8, 9, 10).add("AFTERNOON1", "kunduzi", 11, 12, 13, 14, 15, 16, 17).add("EVENING1", "kechqurun", 18, 19, 20, 21).add("NIGHT1", "tun", 22, 23).build();
        DayPeriods.make("et").add("NIGHT1", "\u00f6\u00f6", 0, 1, 2, 3, 4).add("MORNING1", "hommik", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "p\u00e4rastl\u00f5una", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u00f5htu", 18, 19, 20, 21, 22).add("NIGHT1", "\u00f6\u00f6", 23).build();
        DayPeriods.make("fi").add("NIGHT1", "y\u00f6", 0, 1, 2, 3, 4).add("MORNING1", "aamu", 5, 6, 7, 8, 9).add("MORNING2", "aamup\u00e4iv\u00e4", 10, 11).add("AFTERNOON1", "iltap\u00e4iv\u00e4", 12, 13, 14, 15, 16, 17).add("EVENING1", "ilta", 18, 19, 20, 21, 22).add("NIGHT1", "y\u00f6", 23).build();
        DayPeriods.make("hu").add("NIGHT1", "\u00e9jjel", 0, 1, 2, 3).add("NIGHT2", "hajnal", 4, 5).add("MORNING1", "reggel", 6, 7, 8).add("MORNING2", "d\u00e9lel\u0151tt", 9, 10, 11).add("AFTERNOON1", "d\u00e9lut\u00e1n", 12, 13, 14, 15, 16, 17).add("EVENING1", "este", 18, 19, 20).add("NIGHT1", "\u00e9jjel", 21, 22, 23).build();
        DayPeriods.make("th").add("NIGHT1", "\u0e01\u0e25\u0e32\u0e07\u0e04\u0e37\u0e19", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u0e40\u0e0a\u0e49\u0e32", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0e40\u0e17\u0e35\u0e48\u0e22\u0e07", 12).add("AFTERNOON2", "\u0e1a\u0e48\u0e32\u0e22", 13, 14, 15).add("EVENING1", "\u0e40\u0e22\u0e47\u0e19", 16, 17).add("EVENING2", "\u0e04\u0e48\u0e33", 18, 19, 20).add("NIGHT1", "\u0e01\u0e25\u0e32\u0e07\u0e04\u0e37\u0e19", 21, 22, 23).build();
        DayPeriods.make("lo").add("NIGHT1", "\u200b\u0e81\u0eb2\u0e87\u200b\u0e84\u0eb7\u0e99", 0, 1, 2, 3, 4).add("MORNING1", "\u200b\u0ec0\u0e8a\u0ebb\u0ec9\u0eb2", 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0eaa\u0ea7\u0e8d", 12, 13, 14, 15).add("EVENING1", "\u0ec1\u0ea5\u0e87", 16).add("EVENING2", "\u200b\u0ec1\u0ea5\u0e87", 17, 18, 19).add("NIGHT1", "\u200b\u0e81\u0eb2\u0e87\u200b\u0e84\u0eb7\u0e99", 20, 21, 22, 23).build();
        DayPeriods.make("ar").add("NIGHT1", "\u0645\u0646\u062a\u0635\u0641 \u0627\u0644\u0644\u064a\u0644", 0).add("NIGHT2", "\u0644\u064a\u0644\u0627", 1, 2).add("MORNING1", "\u0641\u062c\u0631\u0627", 3, 4, 5).add("MORNING2", "\u0635\u0628\u0627\u062d\u0627", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u0638\u0647\u0631\u0627", 12).add("AFTERNOON2", "\u0628\u0639\u062f \u0627\u0644\u0638\u0647\u0631", 13, 14, 15, 16, 17).add("EVENING1", "\u0645\u0633\u0627\u0621", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("he").add("NIGHT1", "\u05dc\u05d9\u05dc\u05d4", 0, 1, 2, 3, 4).add("MORNING1", "\u05d1\u05d5\u05e7\u05e8", 5, 6, 7, 8, 9, 10).add("AFTERNOON1", "\u05e6\u05d4\u05e8\u05d9\u05d9\u05dd", 11, 12, 13, 14).add("AFTERNOON2", "\u05d0\u05d7\u05e8 \u05d4\u05e6\u05d4\u05e8\u05d9\u05d9\u05dd", 15, 16, 17).add("EVENING1", "\u05e2\u05e8\u05d1", 18, 19, 20, 21).add("NIGHT1", "\u05dc\u05d9\u05dc\u05d4", 22, 23).build();
        DayPeriods.make("id").add("MORNING1", "pagi", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9).add("AFTERNOON1", "siang", 10, 11, 12, 13, 14).add("EVENING1", "sore", 15, 16, 17).add("NIGHT1", "malam", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("ms").add("MORNING1", "tengah malam", 0).add("MORNING2", "pagi", 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "tengah hari", 12, 13).add("EVENING1", "petang", 14, 15, 16, 17, 18).add("NIGHT1", "malam", 19, 20, 21, 22, 23).build();
        DayPeriods.make("fil").add("MORNING1", "madaling-araw", 0, 1, 2, 3, 4, 5).add("MORNING2", "umaga", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "tanghali", 12, 13, 14, 15).add("EVENING1", "hapon", 16, 17).add("NIGHT1", "gabi", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("vi").add("NIGHT1", "\u0111\u00eam", 0, 1, 2, 3).add("MORNING1", "s\u00e1ng", 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "chi\u1ec1u", 12, 13, 14, 15, 16, 17).add("EVENING1", "t\u1ed1i", 18, 19, 20).add("NIGHT1", "\u0111\u00eam", 21, 22, 23).build();
        DayPeriods.make("km").add("MORNING1", "\u1796\u17d2\u179a\u17b9\u1780", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u179a\u179f\u17c0\u179b", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u179b\u17d2\u1784\u17b6\u1785", 18, 19, 20).add("NIGHT1", "\u1799\u1794\u17cb", 21, 22, 23).build();
        DayPeriods.make("sw").add("NIGHT1", "usiku", 0, 1, 2, 3).add("MORNING1", "alfajiri", 4, 5, 6).add("MORNING2", "asubuhi", 7, 8, 9, 10, 11).add("AFTERNOON1", "mchana", 12, 13, 14, 15).add("EVENING1", "jioni", 16, 17, 18).add("NIGHT1", "usiku", 19, 20, 21, 22, 23).build();
        DayPeriods.make("zu").add("MORNING1", "ntathakusa", 0, 1, 2, 3, 4, 5).add("MORNING2", "ekuseni", 6, 7, 8, 9).add("AFTERNOON1", "emini", 10, 11, 12).add("EVENING1", "ntambama", 13, 14, 15, 16, 17, 18).add("NIGHT1", "ebusuku", 19, 20, 21, 22, 23).build();
        DayPeriods.make("am").add("NIGHT1", "\u120c\u120a\u1275", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u1325\u12cb\u1275", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u12a8\u1230\u12d3\u1275 \u1260\u128b\u120b", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u121b\u1273", 18, 19, 20, 21, 22, 23).build();
        DayPeriods.make("eu").add("MORNING1", "goizaldea", 0, 1, 2, 3, 4, 5).add("MORNING2", "goiza", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "eguerdia", 12, 13).add("AFTERNOON2", "arratsaldea", 14, 15, 16, 17, 18).add("EVENING1", "iluntzea", 19, 20).add("NIGHT1", "gaua", 21, 22, 23).build();
        DayPeriods.make("mn").add("NIGHT1", "\u0448\u04e9\u043d\u04e9", 0, 1, 2, 3, 4, 5).add("MORNING1", "\u04e9\u0433\u043b\u04e9\u04e9", 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u04e9\u0434\u04e9\u0440", 12, 13, 14, 15, 16, 17).add("EVENING1", "\u043e\u0440\u043e\u0439", 18, 19, 20).add("NIGHT1", "\u0448\u04e9\u043d\u04e9", 21, 22, 23).build();
        DayPeriods.make("my").add("MORNING1", "\u1014\u1036\u1014\u1000\u103a", 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11).add("AFTERNOON1", "\u1014\u1031\u1037\u101c\u100a\u103a", 12, 13, 14, 15).add("EVENING1", "\u100a\u1014\u1031", 16, 17, 18).add("NIGHT1", "\u100a", 19, 20, 21, 22, 23).build();
    }

    private static class DayPeriodBuilder {
        private final ULocale locale;
        private final DayPeriod[] timeMap = new DayPeriod[24];
        private final EnumMap<DayPeriod, String> samples = new EnumMap(DayPeriod.class);

        DayPeriodBuilder(String locale) {
            this.locale = new ULocale(locale);
        }

        public DayPeriodBuilder add(String dayPeriod, String localeName, int ... hours) {
            DayPeriod dayPeriodEnum = DayPeriod.get(dayPeriod);
            String previous = this.samples.put(dayPeriodEnum, localeName);
            for (int i : hours) {
                if (this.timeMap[i] != null) {
                    throw new IllegalArgumentException(String.valueOf(this.locale) + " Collision " + i + ", " + String.valueOf((Object)this.timeMap[i]) + ", " + String.valueOf((Object)dayPeriodEnum));
                }
                this.timeMap[i] = dayPeriodEnum;
            }
            return this;
        }

        public DayPeriods build() {
            for (int i = 0; i < this.timeMap.length; ++i) {
                DayPeriod dp = this.timeMap[i];
                if (dp != null) continue;
                throw new IllegalArgumentException(String.valueOf(this.locale) + " Missing item: " + i);
            }
            DayPeriods item = new DayPeriods(this.locale, this.timeMap, this.samples);
            DATA.put(this.locale, item);
            return item;
        }
    }

    public static enum DayPeriod {
        MORNING1("EARLY_MORNING"),
        MORNING2("MORNING"),
        AFTERNOON1("EARLY_AFTERNOON"),
        AFTERNOON2("AFTERNOON"),
        EVENING1("EARLY_EVENING"),
        EVENING2("EVENING"),
        NIGHT1("NIGHT"),
        NIGHT2("LATE_NIGHT");

        public final String name;

        private DayPeriod(String name) {
            this.name = name;
        }

        public static DayPeriod get(String dayPeriod) {
            for (DayPeriod d : DayPeriod.values()) {
                if (!dayPeriod.equals(d.name)) continue;
                return d;
            }
            return DayPeriod.valueOf(dayPeriod);
        }
    }
}

