/*
 * Decompiled with CFR 0.152.
 */
package org.unicode.cldr.util;

import com.ibm.icu.util.Output;
import java.util.Set;
import org.unicode.cldr.util.CLDRFile;
import org.unicode.cldr.util.NameGetter;
import org.unicode.cldr.util.RegexUtilities;
import org.unicode.cldr.util.XPathParts;

public class GlossonymConstructor {
    public static final String PATH_PREFIX = "//ldml/localeDisplayNames/languages/language[@type=\"";
    private static final String CODE_SEPARATOR = "_";
    public static final String PSEUDO_PATH = "constructed";
    private final CLDRFile cldrFile;

    public static boolean pathIsEligible(String xpath) {
        return xpath.startsWith(PATH_PREFIX) && xpath.contains(CODE_SEPARATOR);
    }

    public static boolean valueIsBogus(String value) {
        return value == null || value.contains(CODE_SEPARATOR) || RegexUtilities.PATTERN_3_OR_4_DIGITS.matcher(value).find();
    }

    public GlossonymConstructor(CLDRFile cldrFile) {
        this.cldrFile = cldrFile;
        if (!cldrFile.isResolved()) {
            throw new IllegalArgumentException("Unresolved CLDRFile in GlossonymConstructor constructor");
        }
    }

    public String getValueAndTrack(String xpath, Output<String> pathWhereFound, Output<String> localeWhereFound) {
        String constructedValue = this.getValue(xpath);
        if (constructedValue != null) {
            if (localeWhereFound != null) {
                localeWhereFound.value = this.cldrFile.getLocaleID();
            }
            if (pathWhereFound != null) {
                pathWhereFound.value = PSEUDO_PATH;
            }
            return constructedValue;
        }
        return null;
    }

    public String getValue(String xpath) {
        if (GlossonymConstructor.pathIsEligible(xpath)) {
            return this.reallyGetValue(xpath);
        }
        return null;
    }

    private synchronized String reallyGetValue(String xpath) {
        XPathParts parts = XPathParts.getFrozenInstance(xpath);
        String type = parts.getAttributeValue(-1, "type");
        if (type.contains(CODE_SEPARATOR)) {
            String alt = parts.getAttributeValue(-1, "alt");
            CLDRFile.SimpleAltPicker altPicker = alt == null ? null : new CLDRFile.SimpleAltPicker(alt);
            String value = this.cldrFile.nameGetter().getNameFromIdentifierOptAlt(type, NameGetter.NameOpt.COMPOUND_ONLY, altPicker);
            if (!GlossonymConstructor.valueIsBogus(value)) {
                return value;
            }
        }
        return null;
    }

    public Set<String> getPathsWhereFound(String xpath, Set<String> paths) {
        XPathParts parts = XPathParts.getFrozenInstance(xpath);
        String type = parts.getAttributeValue(-1, "type");
        if (type.contains(CODE_SEPARATOR)) {
            String alt = parts.getAttributeValue(-1, "alt");
            CLDRFile.SimpleAltPicker altPicker = alt == null ? null : new CLDRFile.SimpleAltPicker(alt);
            String value = this.cldrFile.nameGetter().getNameFromIdentifierOptAltPaths(type, NameGetter.NameOpt.COMPOUND_ONLY, altPicker, paths);
            if (!GlossonymConstructor.valueIsBogus(value)) {
                return paths;
            }
        }
        return null;
    }
}

